/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.mocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.entityprovider.CoreEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.BrowseSearchable;
import org.sakaiproject.entitybroker.entityprovider.extension.EntityData;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.entitybroker.mocks.CRUDableEntityProviderMock;
import org.sakaiproject.entitybroker.mocks.data.MyEntity;
import org.sakaiproject.entitybroker.mocks.data.TestData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowseSearchableEntityProviderMock
extends CRUDableEntityProviderMock
implements CoreEntityProvider,
BrowseSearchable {
    public BrowseSearchableEntityProviderMock(String prefix, String[] ids) {
        super(prefix, ids);
    }

    public List<EntityData> browseEntities(Search search, String userReference, String associatedReference, Map<String, Object> params) {
        ArrayList<EntityData> entities = new ArrayList<EntityData>();
        if (search.isEmpty()) {
            for (MyEntity myEntity : this.myEntities.values()) {
                EntityData ed = this.makeEntityData(myEntity);
                entities.add(ed);
            }
        } else if (search.getRestrictionByProperty("stuff") != null) {
            for (MyEntity me : this.myEntities.values()) {
                String sMatch = search.getRestrictionByProperty((String)"stuff").value.toString();
                if (!sMatch.equals(me.getStuff())) continue;
                EntityData ed = this.makeEntityData(me);
                entities.add(ed);
            }
        }
        if (userReference != null || associatedReference != null) {
            EntityData ed;
            MyEntity me;
            entities.clear();
            if ("/user/aaronz".equals(userReference)) {
                me = (MyEntity)this.myEntities.get(TestData.IDSB2[1]);
                ed = this.makeEntityData(me);
                entities.add(ed);
            }
            if ("/site/siteAZ".equals(associatedReference)) {
                me = (MyEntity)this.myEntities.get(TestData.IDSB2[2]);
                ed = this.makeEntityData(me);
                entities.add(ed);
            }
        }
        return entities;
    }

    private EntityData makeEntityData(MyEntity myEntity) {
        EntityReference ref = new EntityReference(this.getEntityPrefix(), myEntity.getId());
        EntityData ed = new EntityData(ref, myEntity.getStuff(), (Object)myEntity);
        return ed;
    }
}

