/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.mocks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sakaiproject.entitybroker.entityprovider.capabilities.TagProvideable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Taggable;
import org.sakaiproject.entitybroker.entityprovider.extension.EntityData;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.entitybroker.mocks.EntityProviderMock;

public class TaggableEntityProviderMock
extends EntityProviderMock
implements Taggable,
TagProvideable {
    public Map<String, Set<String>> entityTags = new HashMap<String, Set<String>>();

    public TaggableEntityProviderMock(String prefix) {
        super(prefix);
    }

    public TaggableEntityProviderMock(String prefix, String reference, String[] tags) {
        super(prefix);
        this.setTagsForEntity(reference, tags);
    }

    public void addTagsToEntity(String reference, String[] tags) {
        if (this.entityTags.containsKey(reference)) {
            for (String tag : tags) {
                this.entityTags.get(reference).add(tag);
            }
        } else {
            this.setTagsForEntity(reference, tags);
        }
    }

    public List<String> getTagsForEntity(String reference) {
        if (!this.entityTags.containsKey(reference)) {
            return new ArrayList<String>();
        }
        ArrayList<String> tags = new ArrayList<String>((Collection)this.entityTags.get(reference));
        Collections.sort(tags);
        return tags;
    }

    public void removeTagsFromEntity(String reference, String[] tags) {
        if (this.entityTags.containsKey(reference)) {
            for (String tag : tags) {
                this.entityTags.get(reference).remove(tag);
            }
        }
    }

    public void setTagsForEntity(String reference, String[] tags) {
        if (tags.length == 0) {
            this.entityTags.remove(reference);
        } else {
            HashSet<String> s = new HashSet<String>();
            for (int i = 0; i < tags.length; ++i) {
                s.add(tags[i]);
            }
            this.entityTags.put(reference, s);
        }
    }

    public List<EntityData> findEntitesByTags(String[] tags, boolean matchAll, Search search) {
        HashSet<String> refs = new HashSet<String>();
        if (matchAll) {
            HashSet<String> allTags = new HashSet<String>();
            for (int i = 0; i < tags.length; ++i) {
                allTags.add(tags[i]);
            }
            for (Map.Entry<String, Set<String>> entry : this.entityTags.entrySet()) {
                if (!entry.getValue().containsAll(allTags)) continue;
                refs.add(entry.getKey());
            }
        } else {
            for (String key : this.entityTags.keySet()) {
                Set<String> s = this.entityTags.get(key);
                for (int i = 0; i < tags.length; ++i) {
                    if (!s.contains(tags[i])) continue;
                    refs.add(key);
                }
            }
        }
        ArrayList<EntityData> results = new ArrayList<EntityData>();
        for (String ref : refs) {
            results.add(new EntityData(ref, (String)null));
        }
        Collections.sort(results, new EntityData.ReferenceComparator());
        return results;
    }
}

