/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.mocks;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sakaiproject.entitybroker.EntityView;
import org.sakaiproject.entitybroker.access.AccessFormats;
import org.sakaiproject.entitybroker.access.EntityViewAccessProvider;
import org.sakaiproject.entitybroker.exception.FormatUnsupportedException;
import org.sakaiproject.entitybroker.util.http.EntityHttpServletResponse;

public class EntityViewAccessProviderMock
implements EntityViewAccessProvider,
AccessFormats {
    private String prefix = null;

    public EntityViewAccessProviderMock(String prefix) {
        this.prefix = prefix;
    }

    public void handleAccess(EntityView view, HttpServletRequest req, HttpServletResponse res) {
        String format = view.getFormat();
        if (format.equals("html") || format.equals("rss")) {
            try {
                res.getWriter().print(this.prefix + ": EntityViewAccessProviderMock");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            throw new FormatUnsupportedException("No support for format: " + format, view.getEntityReference() + "", format);
        }
        ((EntityHttpServletResponse)res).setStatus(200);
    }

    public String[] getHandledAccessFormats() {
        return new String[]{"html", "rss", "atom"};
    }
}

