/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.mocks;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.entityprovider.CoreEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.CRUDable;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.entitybroker.mocks.EntityProviderMock;
import org.sakaiproject.entitybroker.mocks.data.MyEntity;

public class CRUDableEntityProviderMock
extends EntityProviderMock
implements CoreEntityProvider,
CRUDable {
    public Map<String, MyEntity> myEntities = new LinkedHashMap<String, MyEntity>(4);

    public CRUDableEntityProviderMock(String prefix, String[] ids) {
        super(prefix);
        for (int i = 0; i < ids.length; ++i) {
            this.myEntities.put(ids[i], new MyEntity(ids[i], "aaron" + i, i));
        }
    }

    public boolean entityExists(String id) {
        return this.myEntities.containsKey(id);
    }

    public Object getEntity(EntityReference reference) {
        if (reference.getId() == null) {
            return new MyEntity();
        }
        if (this.myEntities.containsKey(reference.getId())) {
            return this.myEntities.get(reference.getId());
        }
        throw new IllegalArgumentException("Invalid id:" + reference.getId());
    }

    public List<?> getEntities(EntityReference ref, Search search) {
        ArrayList<MyEntity> entities;
        block3: {
            block2: {
                entities = new ArrayList<MyEntity>();
                if (!search.isEmpty()) break block2;
                for (MyEntity myEntity : this.myEntities.values()) {
                    entities.add(myEntity);
                }
                break block3;
            }
            if (search.getRestrictionByProperty("stuff") == null) break block3;
            for (MyEntity me : this.myEntities.values()) {
                String sMatch = search.getRestrictionByProperty((String)"stuff").value.toString();
                if (!sMatch.equals(me.getStuff())) continue;
                entities.add(me);
            }
        }
        return entities;
    }

    public Object getSampleEntity() {
        return new MyEntity(null, 10);
    }

    public String createEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        MyEntity me = (MyEntity)entity;
        if (me.getStuff() == null) {
            throw new IllegalArgumentException("stuff is not set, it is required");
        }
        Object newId = me.getId();
        int counter = 0;
        if (newId == null || "".equals(newId)) {
            while (newId == null) {
                String id;
                if (this.myEntities.containsKey(id = "my" + counter++)) continue;
                newId = id;
            }
            me.setId((String)newId);
        }
        this.myEntities.put((String)newId, me);
        return newId;
    }

    public void updateEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        MyEntity me = (MyEntity)entity;
        if (me.getStuff() == null) {
            throw new IllegalArgumentException("stuff is not set, it is required");
        }
        MyEntity current = this.myEntities.get(ref.getId());
        if (current == null) {
            throw new IllegalArgumentException("Invalid update, cannot find entity");
        }
        current.setStuff(me.getStuff());
        current.setNumber(me.getNumber());
        current.extra = me.extra;
    }

    public void deleteEntity(EntityReference ref, Map<String, Object> params) {
        if (this.myEntities.remove(ref.getId()) == null) {
            throw new IllegalArgumentException("Invalid entity id, cannot find entity to remove: " + ref);
        }
    }
}

