/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.rest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.EntityView;
import org.sakaiproject.entitybroker.entityprovider.EntityProviderMethodStore;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutionControllable;
import org.sakaiproject.entitybroker.entityprovider.extension.ActionReturn;
import org.sakaiproject.entitybroker.entityprovider.extension.CustomAction;
import org.sakaiproject.entitybroker.entityprovider.extension.EntityData;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.entitybroker.exception.EntityException;
import org.sakaiproject.entitybroker.exception.EntityNotFoundException;
import org.sakaiproject.entitybroker.exception.FormatUnsupportedException;
import org.sakaiproject.entitybroker.util.EntityDataUtils;
import org.sakaiproject.entitybroker.util.http.LazyResponseOutputStream;
import org.sakaiproject.entitybroker.util.request.RequestStorageImpl;
import org.sakaiproject.entitybroker.util.request.RequestUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityActionsManager {
    private EntityProviderMethodStore entityProviderMethodStore;

    protected EntityActionsManager() {
    }

    public EntityActionsManager(EntityProviderMethodStore entityProviderMethodStore) {
        this.entityProviderMethodStore = entityProviderMethodStore;
    }

    public void setEntityProviderMethodStore(EntityProviderMethodStore entityProviderMethodStore) {
        this.entityProviderMethodStore = entityProviderMethodStore;
    }

    public ActionReturn handleCustomActionRequest(ActionsExecutable actionProvider, EntityView entityView, String action, HttpServletRequest request, HttpServletResponse response, Map<String, Object> searchParams) {
        LazyResponseOutputStream outputStream;
        if (actionProvider == null || entityView == null || action == null || request == null || response == null) {
            throw new IllegalArgumentException("actionProvider and view and action and request and response must not be null");
        }
        Map actionParams = RequestStorageImpl.getRequestValues((HttpServletRequest)request, (boolean)true, (boolean)true, (boolean)true);
        EntityReference ref = entityView.getEntityReference();
        ActionReturn actionReturn = this.handleCustomActionExecution(actionProvider, ref, action, actionParams, (OutputStream)(outputStream = new LazyResponseOutputStream(response)), entityView, searchParams);
        if (actionReturn != null) {
            if (actionReturn.output != null || actionReturn.outputString != null) {
                if (actionReturn.output == null) {
                    try {
                        outputStream.write(actionReturn.outputString.getBytes());
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed encoding for outputstring: " + actionReturn.outputString);
                    }
                    actionReturn.output = outputStream;
                }
                actionReturn.format = entityView.getExtension();
                if (actionReturn.encoding == null || actionReturn.mimeType == null) {
                    if (actionReturn.format == null) {
                        actionReturn.format = "txt";
                    }
                    RequestUtils.setResponseEncoding((String)actionReturn.format, (HttpServletResponse)response);
                } else {
                    response.setCharacterEncoding(actionReturn.encoding);
                    response.setContentType(actionReturn.mimeType);
                }
            }
            if (actionReturn.responseCode > 0) {
                response.setStatus(actionReturn.responseCode);
            } else {
                response.setStatus(200);
            }
        } else {
            response.setStatus(200);
        }
        return actionReturn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ActionReturn handleCustomActionExecution(ActionsExecutable actionProvider, EntityReference ref, String action, Map<String, Object> actionParams, OutputStream outputStream, EntityView view, Map<String, Object> searchParams) {
        String prefix;
        CustomAction customAction;
        if (actionProvider == null) throw new IllegalArgumentException("actionProvider and ref and action must not be null");
        if (ref == null) throw new IllegalArgumentException("actionProvider and ref and action must not be null");
        if (action == null) throw new IllegalArgumentException("actionProvider and ref and action must not be null");
        if ("".equals(action)) {
            throw new IllegalArgumentException("actionProvider and ref and action must not be null");
        }
        if (outputStream == null) {
            outputStream = new ByteArrayOutputStream();
        }
        if ((customAction = this.entityProviderMethodStore.getCustomAction(prefix = ref.getPrefix(), action)) == null) {
            throw new UnsupportedOperationException("Invalid action (" + action + "), this action is not a supported custom action for prefix (" + prefix + ")");
        }
        ActionReturn actionReturn = null;
        Object result = null;
        if (ActionsExecutionControllable.class.isAssignableFrom(actionProvider.getClass())) {
            result = ((ActionsExecutionControllable)actionProvider).executeActions(new EntityView(ref, null, null), action, actionParams, outputStream);
        } else {
            if (customAction.methodName == null) {
                throw new IllegalStateException("The custom action must have the method name set, null is not allowed: " + customAction);
            }
            Method method = customAction.getMethod();
            if (method == null) {
                try {
                    method = actionProvider.getClass().getMethod(customAction.methodName, customAction.methodArgTypes);
                }
                catch (SecurityException e1) {
                    throw new RuntimeException("Fatal error trying to get custom action method: " + customAction, e1);
                }
                catch (NoSuchMethodException e1) {
                    throw new RuntimeException("Fatal error trying to get custom action method: " + customAction, e1);
                }
                customAction.setMethod(method);
            }
            Object[] args = new Object[customAction.methodArgTypes.length];
            for (int i = 0; i < customAction.methodArgTypes.length; ++i) {
                Class argType = customAction.methodArgTypes[i];
                if (EntityReference.class.equals((Object)argType)) {
                    args[i] = ref;
                    continue;
                }
                if (EntityView.class.equals((Object)argType)) {
                    if (view == null) {
                        view = new EntityView(ref, customAction.viewKey, null);
                    }
                    args[i] = view;
                    continue;
                }
                if (String.class.equals((Object)argType)) {
                    args[i] = actionProvider.getEntityPrefix();
                    continue;
                }
                if (Search.class.equals((Object)argType)) {
                    Search search = null;
                    search = searchParams == null || searchParams.isEmpty() ? new Search() : RequestUtils.makeSearchFromRequestParams(searchParams);
                    args[i] = search;
                    continue;
                }
                if (OutputStream.class.equals((Object)argType)) {
                    args[i] = outputStream;
                    continue;
                }
                if (!Map.class.equals((Object)argType)) throw new IllegalStateException("custom action (" + customAction + ") contains an invalid methodArgTypes, " + "only valid types allowed: EntityReference, EntityView, Search, String, OutputStream, Map");
                args[i] = actionParams;
            }
            try {
                result = method.invoke((Object)actionProvider, args);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Fatal error trying to execute custom action method: " + customAction, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Fatal error trying to execute custom action method: " + customAction, e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() == null) throw new RuntimeException("Fatal error trying to execute custom action method: " + customAction, e);
                if (e.getCause().getClass().isAssignableFrom(IllegalArgumentException.class)) {
                    throw new IllegalArgumentException(e.getCause().getMessage() + " (rethrown)", e.getCause());
                }
                if (e.getCause().getClass().isAssignableFrom(EntityNotFoundException.class)) {
                    throw new EntityNotFoundException(e.getCause().getMessage() + " (rethrown)", ref + "", e.getCause());
                }
                if (e.getCause().getClass().isAssignableFrom(FormatUnsupportedException.class)) {
                    String format = ((FormatUnsupportedException)e.getCause()).format;
                    throw new FormatUnsupportedException(e.getCause().getMessage() + " (rethrown)", e.getCause(), ref + "", format);
                }
                if (e.getCause().getClass().isAssignableFrom(UnsupportedOperationException.class)) {
                    throw new UnsupportedOperationException(e.getCause().getMessage() + " (rethrown)", e.getCause());
                }
                if (e.getCause().getClass().isAssignableFrom(EntityException.class)) {
                    int code = ((EntityException)e.getCause()).responseCode;
                    throw new EntityException(e.getCause().getMessage() + " (rethrown)", ref + "", code);
                }
                if (e.getCause().getClass().isAssignableFrom(IllegalStateException.class)) {
                    throw new IllegalStateException(e.getCause().getMessage() + " (rethrown)", e.getCause());
                }
                if (!e.getCause().getClass().isAssignableFrom(SecurityException.class)) throw new RuntimeException("Fatal error trying to execute custom action method: " + customAction, e);
                throw new SecurityException(e.getCause().getMessage() + " (rethrown)", e.getCause());
            }
        }
        if (result == null) return actionReturn;
        Class<?> resultClass = result.getClass();
        if (Boolean.class.isAssignableFrom(resultClass)) {
            boolean bool = (Boolean)result;
            if (!bool) throw new EntityNotFoundException("Could not find data for ref (" + ref + ") from custom action (" + action + "), (returned boolean false)", ref + "");
            return actionReturn;
        }
        if (ActionReturn.class.isAssignableFrom(resultClass)) {
            return (ActionReturn)result;
        }
        if (OutputStream.class.isAssignableFrom(resultClass)) {
            return new ActionReturn(outputStream);
        }
        if (String.class.isAssignableFrom(resultClass)) {
            return new ActionReturn((String)result);
        }
        if (List.class.isAssignableFrom(resultClass)) {
            List data = EntityDataUtils.convertToEntityData((List)((List)result), (EntityReference)ref);
            return new ActionReturn(data, (String)null);
        }
        if (EntityData.class.isAssignableFrom(resultClass)) {
            return new ActionReturn((EntityData)result, (String)null);
        }
        EntityData ed = EntityDataUtils.makeEntityData((EntityReference)ref, (Object)result);
        return new ActionReturn(ed, (String)null);
    }

    public CustomAction getCustomAction(String prefix, String action) {
        return this.entityProviderMethodStore.getCustomAction(prefix, action);
    }
}

