/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.azeckoski.reflectutils.ArrayUtils;
import org.azeckoski.reflectutils.ClassFields;
import org.azeckoski.reflectutils.ConstructorUtils;
import org.azeckoski.reflectutils.ReflectUtils;
import org.sakaiproject.entitybroker.EntityBrokerManager;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.EntityView;
import org.sakaiproject.entitybroker.access.AccessFormats;
import org.sakaiproject.entitybroker.access.EntityViewAccessProvider;
import org.sakaiproject.entitybroker.access.EntityViewAccessProviderManager;
import org.sakaiproject.entitybroker.access.HttpServletAccessProvider;
import org.sakaiproject.entitybroker.access.HttpServletAccessProviderManager;
import org.sakaiproject.entitybroker.entityprovider.CoreEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.EntityProvider;
import org.sakaiproject.entitybroker.entityprovider.EntityProviderManager;
import org.sakaiproject.entitybroker.entityprovider.EntityProviderMethodStore;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityFieldRequired;
import org.sakaiproject.entitybroker.entityprovider.capabilities.CollectionResolvable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Createable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Deleteable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.DescribeDefineable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.DescribePropertiesable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Inputable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Outputable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Resolvable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Updateable;
import org.sakaiproject.entitybroker.entityprovider.extension.CustomAction;
import org.sakaiproject.entitybroker.entityprovider.extension.URLRedirect;
import org.sakaiproject.entitybroker.providers.EntityPropertiesService;
import org.sakaiproject.entitybroker.rest.EntityEncodingManager;
import org.sakaiproject.entitybroker.rest.EntityHandlerImpl;
import org.sakaiproject.entitybroker.rest.caps.BatchProvider;

public class EntityDescriptionManager {
    private static final String INPUT_DESCRIBE_KEY = "input";
    private static final String OUTPUT_DESCRIBE_KEY = "output";
    private static final String VIEW_KEY_PREFIX = "view.";
    private static final String FIELD_KEY_PREFIX = "field.";
    private static final String REDIRECT_KEY_PREFIX = "redirect.";
    protected static final String ACTION_KEY_PREFIX = "action.";
    protected static String DESCRIBE = "describe";
    protected static String SLASH_DESCRIBE = "/describe";
    protected static String FAKE_ID = ":ID:";
    protected static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
    protected static final String XHTML_HEADER = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n  <title>Describe Entities</title>\n</head>\n<body>\n";
    protected static final String XHTML_FOOTER = "<br/>\n<div style='width:100%;text-align:center;font-style:italic;font-size:0.9em;'>REST:: <b>" + EntityHandlerImpl.APP_VERSION + "</b> SVN: " + EntityHandlerImpl.SVN_REVISION + " : " + EntityHandlerImpl.SVN_LAST_UPDATE + "</div>\n" + "</body>\n</html>\n";
    private EntityProvider describeEP = null;
    private EntityProvider batchEP = null;
    private EntityViewAccessProviderManager entityViewAccessProviderManager;
    private HttpServletAccessProviderManager httpServletAccessProviderManager;
    private EntityProviderManager entityProviderManager;
    private EntityPropertiesService entityProperties;
    private EntityBrokerManager entityBrokerManager;
    private EntityProviderMethodStore entityProviderMethodStore;

    protected EntityDescriptionManager() {
    }

    public EntityDescriptionManager(EntityViewAccessProviderManager entityViewAccessProviderManager, HttpServletAccessProviderManager httpServletAccessProviderManager, EntityProviderManager entityProviderManager, EntityPropertiesService entityProperties, EntityBrokerManager entityBrokerManager, EntityProviderMethodStore entityProviderMethodStore) {
        this.entityViewAccessProviderManager = entityViewAccessProviderManager;
        this.httpServletAccessProviderManager = httpServletAccessProviderManager;
        this.entityProviderManager = entityProviderManager;
        this.entityProperties = entityProperties;
        this.entityBrokerManager = entityBrokerManager;
        this.entityProviderMethodStore = entityProviderMethodStore;
        this.init();
    }

    public void init() {
        System.out.println("INFO: EntityDescriptionManager: init()");
        this.describeEP = new DescribePropertiesable(){

            public String getEntityPrefix() {
                return "describe";
            }

            public String getBaseName() {
                return this.getEntityPrefix();
            }

            public ClassLoader getResourceClassLoader() {
                return EntityDescriptionManager.class.getClassLoader();
            }
        };
        this.entityProviderManager.registerEntityProvider(this.describeEP);
        this.batchEP = new BatchProvider(){

            public String getEntityPrefix() {
                return "batch";
            }

            public String getBaseName() {
                return this.getEntityPrefix();
            }

            public ClassLoader getResourceClassLoader() {
                return EntityDescriptionManager.class.getClassLoader();
            }

            public String[] getHandledOutputFormats() {
                return EntityEncodingManager.HANDLED_OUTPUT_FORMATS;
            }
        };
        this.entityProviderManager.registerEntityProvider(this.batchEP);
    }

    public void destroy() {
        System.out.println("INFO: EntityDescriptionManager: destroy()");
        if (this.batchEP != null) {
            try {
                this.entityProviderManager.unregisterEntityProvider(this.batchEP);
            }
            catch (RuntimeException e) {
                System.out.println("WARN: EntityDescriptionManager: Unable to unregister the batch description provider: " + e);
            }
        }
    }

    public void setEntityViewAccessProviderManager(EntityViewAccessProviderManager entityViewAccessProviderManager) {
        this.entityViewAccessProviderManager = entityViewAccessProviderManager;
    }

    public void setHttpServletAccessProviderManager(HttpServletAccessProviderManager httpServletAccessProviderManager) {
        this.httpServletAccessProviderManager = httpServletAccessProviderManager;
    }

    public void setEntityProviderManager(EntityProviderManager entityProviderManager) {
        this.entityProviderManager = entityProviderManager;
    }

    public void setEntityProperties(EntityPropertiesService entityProperties) {
        this.entityProperties = entityProperties;
    }

    public void setEntityBrokerManager(EntityBrokerManager entityBrokerManager) {
        this.entityBrokerManager = entityBrokerManager;
    }

    public void setEntityProviderMethodStore(EntityProviderMethodStore entityProviderMethodStore) {
        this.entityProviderMethodStore = entityProviderMethodStore;
    }

    public String makeDescribeAll(String format, Locale locale) {
        if (locale == null) {
            locale = this.entityProperties.getLocale();
        }
        Map map = this.entityProviderManager.getRegisteredEntityCapabilities();
        map.remove(DESCRIBE);
        String describeURL = this.entityBrokerManager.getServletContext() + SLASH_DESCRIBE;
        String output = "";
        if ("xml".equals(format)) {
            StringBuilder sb = new StringBuilder(200);
            sb.append(XML_HEADER);
            sb.append("<describe>\n");
            sb.append("  <describeURL>" + describeURL + "</describeURL>\n");
            sb.append(this.makeXMLVersion());
            sb.append("  <prefixes>\n");
            ArrayList prefixes = new ArrayList(map.keySet());
            Collections.sort(prefixes);
            for (int i = 0; i < prefixes.size(); ++i) {
                String prefix = (String)prefixes.get(i);
                this.describeEntity(sb, prefix, FAKE_ID, format, false, (List)map.get(prefix), locale);
            }
            sb.append("  </prefixes>\n");
            sb.append("</describe>\n");
            output = sb.toString();
        } else {
            StringBuilder sb = new StringBuilder(300);
            sb.append(XML_HEADER);
            sb.append(XHTML_HEADER);
            sb.append("<h1><a href='" + describeURL + "'>" + this.entityProperties.getProperty(DESCRIBE, "describe.all", locale) + "</a> " + this.entityProperties.getProperty(DESCRIBE, "describe.registered.entities", locale) + this.makeFormatUrlHtml(describeURL, "xml") + "</h1>\n");
            sb.append("  <i>RESTful URLs: <a href='http://microformats.org/wiki/rest/urls'>http://microformats.org/wiki/rest/urls</a></i><br/>\n");
            sb.append("  <h2>" + this.entityProperties.getProperty(DESCRIBE, "describe.all", locale) + " (" + this.entityProperties.getProperty(DESCRIBE, "describe.registered.entities", locale) + "): " + map.size() + "</h2>\n");
            sb.append("  <div style='font-style:italic;padding-bottom:0.5em;'>" + this.entityProperties.getProperty(DESCRIBE, "describe.general.notes", locale) + "</div>\n");
            sb.append("  <div style='font-style:italic;'>" + this.entityProperties.getProperty(DESCRIBE, "describe.searching", locale) + "</div>\n");
            ArrayList prefixes = new ArrayList(map.keySet());
            Collections.sort(prefixes);
            for (int i = 0; i < prefixes.size(); ++i) {
                String prefix = (String)prefixes.get(i);
                this.describeEntity(sb, prefix, FAKE_ID, format, false, (List)map.get(prefix), locale);
            }
            sb.append(XHTML_FOOTER);
            output = sb.toString();
        }
        return output;
    }

    private String makeXMLVersion() {
        StringBuilder sb = new StringBuilder();
        sb.append("  <version>" + EntityHandlerImpl.APP_VERSION + "</version>\n");
        sb.append("  <svn>\n");
        sb.append("    <revision>" + EntityHandlerImpl.SVN_REVISION + "</revision>\n");
        sb.append("    <last-update>" + EntityHandlerImpl.SVN_LAST_UPDATE + "</last-update>\n");
        sb.append("  </svn>\n");
        return sb.toString();
    }

    public String makeDescribeEntity(String prefix, String id, String format, Locale locale) {
        if (locale == null) {
            locale = this.entityProperties.getLocale();
        }
        if (this.entityProviderManager.getProviderByPrefix(prefix) == null) {
            throw new IllegalArgumentException("Invalid prefix (" + prefix + "), entity with that prefix does not exist");
        }
        StringBuilder sb = new StringBuilder(250);
        if ("xml".equals(format)) {
            sb.append(XML_HEADER);
            this.describeEntity(sb, prefix, id, format, true, null, locale);
        } else {
            sb.append(XML_HEADER);
            sb.append(XHTML_HEADER);
            this.describeEntity(sb, prefix, id, format, true, null, locale);
            sb.append(XHTML_FOOTER);
        }
        return sb.toString();
    }

    protected String describeEntity(StringBuilder sb, String prefix, String id, String format, boolean extra, List<Class<? extends EntityProvider>> caps, Locale locale) {
        if (caps == null) {
            caps = this.entityProviderManager.getPrefixCapabilities(prefix);
        }
        if (locale == null) {
            locale = this.entityProperties.getLocale();
        }
        String servletUrl = this.entityBrokerManager.getServletContext();
        if ("xml".equals(format)) {
            String description;
            String describePrefixUrl = servletUrl + "/" + prefix + SLASH_DESCRIBE;
            sb.append("    <prefix>\n");
            sb.append("      <prefix>" + prefix + "</prefix>\n");
            sb.append("      <describeURL>" + describePrefixUrl + "</describeURL>\n");
            String summary = this.getEntityDescription(prefix, null, locale);
            if (summary != null) {
                sb.append("      <summary>" + summary + "</summary>\n");
            }
            if ((description = this.getEntityDescription(prefix, "description", locale)) != null) {
                sb.append("      <description>" + description + "</description>\n");
            }
            if (extra) {
                List redirects;
                Object entity;
                HttpServletAccessProvider hsap;
                String intputDesc;
                String outputDesc;
                List customActions;
                String viewDesc;
                EntityView ev = this.entityBrokerManager.makeEntityView(new EntityReference(prefix, id), null, null);
                if (caps.contains(CollectionResolvable.class)) {
                    sb.append("      <collectionURL>" + ev.getEntityURL("list", null) + "</collectionURL>\n");
                    viewDesc = this.getEntityDescription(prefix, "view.list", locale);
                    if (viewDesc != null) {
                        sb.append("      <collectionDescription>" + viewDesc + "</collectionDescription>\n");
                    }
                }
                if (caps.contains(Createable.class)) {
                    sb.append("      <createURL>" + ev.getEntityURL("new", null) + "</createURL>\n");
                    viewDesc = this.getEntityDescription(prefix, "view.new", locale);
                    if (viewDesc != null) {
                        sb.append("      <createDescription>" + viewDesc + "</createDescription>\n");
                    }
                }
                if (caps.contains(CoreEntityProvider.class) || caps.contains(Resolvable.class)) {
                    sb.append("      <showURL>" + ev.getEntityURL("show", null) + "</showURL>\n");
                    viewDesc = this.getEntityDescription(prefix, "view.show", locale);
                    if (viewDesc != null) {
                        sb.append("      <showDescription>" + viewDesc + "</showDescription>\n");
                    }
                }
                if (caps.contains(Updateable.class)) {
                    sb.append("      <updateURL>" + ev.getEntityURL("edit", null) + "</updateURL>\n");
                    viewDesc = this.getEntityDescription(prefix, "view.edit", locale);
                    if (viewDesc != null) {
                        sb.append("      <updateDescription>" + viewDesc + "</updateDescription>\n");
                    }
                }
                if (caps.contains(Deleteable.class)) {
                    sb.append("      <deleteURL>" + ev.getEntityURL("delete", null) + "</deleteURL>\n");
                    viewDesc = this.getEntityDescription(prefix, "view.delete", locale);
                    if (viewDesc != null) {
                        sb.append("      <deleteDescription>" + viewDesc + "</deleteDescription>\n");
                    }
                }
                if (!(customActions = this.entityProviderMethodStore.getCustomActions(prefix)).isEmpty()) {
                    for (CustomAction customAction : customActions) {
                        sb.append("      <customActions>\n");
                        sb.append("        <customAction>\n");
                        sb.append("          <action>" + customAction.action + "</action>\n");
                        sb.append("          <url>" + servletUrl + this.makeActionURL(ev, customAction) + "</url>\n");
                        if (customAction.viewKey == null || "".equals(customAction.viewKey)) {
                            sb.append("          <method/>\n");
                            sb.append("          <viewKey/>\n");
                        } else {
                            sb.append("          <method>" + EntityView.translateViewKeyToMethod((String)customAction.viewKey) + "</method>\n");
                            sb.append("          <viewKey>" + customAction.viewKey + "</viewKey>\n");
                        }
                        String actionDesc = this.getEntityDescription(prefix, ACTION_KEY_PREFIX + customAction.action, locale);
                        if (actionDesc != null) {
                            sb.append("          <description>" + actionDesc + "</description>\n");
                        }
                        sb.append("        </customAction>\n");
                        sb.append("      </customActions>\n");
                    }
                }
                String[] outputFormats = this.getFormats(prefix, true);
                sb.append("      <outputFormats>\n");
                if (outputFormats != null) {
                    if (outputFormats.length == 0) {
                        sb.append("        <format>*</format>\n");
                    } else {
                        for (int i = 0; i < outputFormats.length; ++i) {
                            sb.append("        <format>" + outputFormats[i] + "</format>\n");
                        }
                    }
                }
                if ((outputDesc = this.getEntityDescription(prefix, OUTPUT_DESCRIBE_KEY, locale)) != null) {
                    sb.append("          <description>" + outputDesc + "</description>\n");
                }
                sb.append("       </outputFormats>\n");
                String[] inputFormats = this.getFormats(prefix, false);
                sb.append("      <inputFormats>\n");
                if (inputFormats != null) {
                    if (inputFormats.length == 0) {
                        sb.append("        <format>*</format>\n");
                    } else {
                        for (int i = 0; i < inputFormats.length; ++i) {
                            sb.append("        <format>" + inputFormats[i] + "</format>\n");
                        }
                    }
                }
                if ((intputDesc = this.getEntityDescription(prefix, INPUT_DESCRIBE_KEY, locale)) != null) {
                    sb.append("          <description>" + intputDesc + "</description>\n");
                }
                sb.append("       </inputFormats>\n");
                EntityViewAccessProvider evap = this.entityViewAccessProviderManager.getProvider(prefix);
                HttpServletAccessProvider httpServletAccessProvider = hsap = this.httpServletAccessProviderManager == null ? null : this.httpServletAccessProviderManager.getProvider(prefix);
                if (evap != null || hsap != null) {
                    sb.append("      <accessProvider>\n");
                    if (evap != null) {
                        sb.append("        <type>" + EntityViewAccessProvider.class.getSimpleName() + "</type>\n");
                        sb.append("        <implementor>" + evap.getClass().getName() + "</implementor>\n");
                        if (AccessFormats.class.isAssignableFrom(evap.getClass())) {
                            String[] accessFormats = ((AccessFormats)evap).getHandledAccessFormats();
                            sb.append("        <accessFormats>\n");
                            if (accessFormats != null) {
                                if (accessFormats.length == 0) {
                                    sb.append("          <format>*</format>\n");
                                } else {
                                    for (int i = 0; i < accessFormats.length; ++i) {
                                        sb.append("          <format>" + accessFormats[i] + "</format>\n");
                                    }
                                }
                            }
                            sb.append("        </accessFormats>\n");
                        }
                    } else {
                        sb.append("        <type>" + HttpServletAccessProvider.class.getSimpleName() + "</type>\n");
                        sb.append("        <implementor>" + hsap.getClass().getName() + "</implementor>\n");
                    }
                    sb.append("      </accessProvider>\n");
                }
                if ((entity = this.entityBrokerManager.getSampleEntityObject(prefix, null)) != null) {
                    Class<?> entityType = entity.getClass();
                    sb.append("      <entityClass>\n");
                    sb.append("        <class>" + entityType.getName() + "</class>\n");
                    if (ConstructorUtils.isClassSimple(entityType)) {
                        sb.append("        <type>simple</type>\n");
                    } else if (ConstructorUtils.isClassCollection(entityType)) {
                        sb.append("        <type>collection</type>\n");
                    } else if (ConstructorUtils.isClassArray(entityType)) {
                        sb.append("        <type>array</type>\n");
                        sb.append("        <componentType>" + ArrayUtils.type((Object[])((Object[])entity)).getName() + "</componentType>\n");
                    } else if (ConstructorUtils.isClassMap(entityType)) {
                        sb.append("        <type>map</type>\n");
                        Map m = (Map)entity;
                        if (m.size() > 0) {
                            Map.Entry entry = m.entrySet().iterator().next();
                            sb.append("        <keyType>" + (entry.getKey() == null ? Object.class.getName() : entry.getKey().getClass().getName()) + "</keyType>\n");
                            sb.append("        <valueType>" + (entry.getValue() == null ? Object.class.getName() : entry.getValue().getClass().getName()) + "</valueType>\n");
                        }
                    } else {
                        sb.append("        <type>bean</type>\n");
                        sb.append("        <fields>\n");
                        Map readTypes = ReflectUtils.getInstance().getFieldTypes(entity.getClass(), ClassFields.FieldsFilter.SERIALIZABLE);
                        Map writeTypes = ReflectUtils.getInstance().getFieldTypes(entity.getClass(), ClassFields.FieldsFilter.WRITEABLE);
                        HashMap entityTypes = new HashMap(readTypes);
                        entityTypes.putAll(writeTypes);
                        ArrayList keys = new ArrayList(entityTypes.keySet());
                        Collections.sort(keys);
                        for (String key : keys) {
                            Class type = (Class)entityTypes.get(key);
                            sb.append("          <field>\n");
                            sb.append("            <name>" + key + "</name>\n");
                            sb.append("            <type>" + type.getName() + "</type>\n");
                            sb.append("            <readable>" + readTypes.containsKey(key) + "</readable>\n");
                            sb.append("            <writeable>" + writeTypes.containsKey(key) + "</writeable>\n");
                            String fieldDesc = this.getEntityDescription(prefix, FIELD_KEY_PREFIX + key, locale);
                            if (fieldDesc != null) {
                                sb.append("            <description>" + fieldDesc + "</description>\n");
                            }
                            sb.append("          </field>\n");
                        }
                        sb.append("        </fields>\n");
                    }
                    sb.append("      </entityClass>\n");
                }
                if (!(redirects = this.entityProviderMethodStore.getURLRedirects(prefix)).isEmpty()) {
                    sb.append("      <redirects>\n");
                    for (int i = 0; i < redirects.size(); ++i) {
                        String redirectDesc;
                        URLRedirect redirect = (URLRedirect)redirects.get(i);
                        sb.append("        <redirect>\n");
                        sb.append("          <template>" + redirect.template + "</template>\n");
                        if (redirect.outgoingTemplate != null) {
                            sb.append("          <outgoingTemplate>" + redirect.outgoingTemplate + "</outgoingTemplate>\n");
                        }
                        if (redirect.methodName != null) {
                            sb.append("          <methodName>" + redirect.methodName + "</methodName>\n");
                        }
                        if ((redirectDesc = this.getEntityDescription(prefix, REDIRECT_KEY_PREFIX + redirect.template, locale)) != null) {
                            sb.append("          <description>" + redirectDesc + "</description>\n");
                        }
                        sb.append("          <controllable>" + redirect.controllable + "</controllable>\n");
                        sb.append("          <order>" + i + "</order>\n");
                        sb.append("        </redirect>\n");
                    }
                    sb.append("      </redirects>\n");
                }
            }
            sb.append("      <capabilities>\n");
            for (Class class1 : caps) {
                String capabilityDescription;
                sb.append("        <capability>\n");
                sb.append("          <name>" + class1.getSimpleName() + "</name>\n");
                sb.append("          <type>" + class1.getName() + "</type>\n");
                if (extra && (capabilityDescription = this.getEntityDescription(prefix, class1.getSimpleName(), locale)) != null) {
                    sb.append("          <description>" + capabilityDescription + "</description>\n");
                }
                sb.append("        </capability>\n");
            }
            sb.append("      </capabilities>\n");
            sb.append("    </prefix>\n");
        } else {
            String describePrefixUrl = servletUrl + "/" + prefix + SLASH_DESCRIBE;
            sb.append("    <h3 style='margin-bottom: 0.3em;'><a href='" + describePrefixUrl + "'>" + prefix + "</a>" + this.makeFormatUrlHtml(describePrefixUrl, "xml") + "</h3>\n");
            String summary = this.getEntityDescription(prefix, null, locale);
            if (summary != null) {
                sb.append("      <div style='padding-left:0.5em; padding-bottom:0.2em; width:90%;'>" + summary + "</div>\n");
            }
            if (extra) {
                EntityViewAccessProvider evap;
                Object entity;
                List redirects;
                List customActions;
                String description = this.getEntityDescription(prefix, "description", locale);
                if (description != null) {
                    sb.append("      <div style='padding-left:1em; padding-bottom:0.4em; width:90%; font-size:0.9em;'>" + description + "</div>\n");
                }
                sb.append("      <div style='font-style: italic; padding-left:1em;'>RESTful URLs: <a href='http://microformats.org/wiki/rest/urls'>http://microformats.org/wiki/rest/urls</a></div>\n");
                sb.append("      <div style='font-style: italic; padding-left:2em; font-size:0.9em;'>" + this.entityProperties.getProperty(DESCRIBE, "describe.response.codes", locale) + "</div>\n");
                String[] outputFormats = this.getFormats(prefix, true);
                EntityView ev = this.entityBrokerManager.makeEntityView(new EntityReference(prefix, id), null, null);
                String url = "";
                if (caps.contains(CollectionResolvable.class) || caps.contains(Createable.class) || caps.contains(CoreEntityProvider.class) || caps.contains(Resolvable.class) || caps.contains(Updateable.class) || caps.contains(Deleteable.class)) {
                    String viewDesc;
                    sb.append("      <h4 style='padding-left:0.5em;margin-bottom:0.2em;'>" + this.entityProperties.getProperty(DESCRIBE, "describe.entity.sample.urls", locale) + " (_id='" + id + "') [" + this.entityProperties.getProperty(DESCRIBE, "describe.entity.may.be.invalid", locale) + "]:</h4>\n");
                    sb.append("      <div style='padding-left:1em;padding-bottom:1em;'>\n");
                    if (caps.contains(CollectionResolvable.class)) {
                        url = this.makeEntityURL(ev, "list");
                        sb.append("        <div>\n");
                        sb.append("          <div>" + this.entityProperties.getProperty(DESCRIBE, "describe.entity.collection.url", locale) + ": GET <a href='" + servletUrl + url + "'>" + url + "</a>" + this.makeFormatsUrlHtml(servletUrl + url, outputFormats) + "</div>\n");
                        sb.append(this.generateMethodDetails("list", locale));
                        viewDesc = this.getEntityDescription(prefix, "view.list", locale);
                        if (viewDesc != null) {
                            sb.append("          <div style='font-style:italic;font-size:0.9em;padding-left:2em;'>" + viewDesc + "</div>\n");
                        }
                        sb.append("        </div>\n");
                    }
                    if (caps.contains(Createable.class)) {
                        url = this.makeEntityURL(ev, "new");
                        sb.append("        <div>\n");
                        sb.append("          <div>" + this.entityProperties.getProperty(DESCRIBE, "describe.entity.create.url", locale) + ": POST <a href='" + servletUrl + url + "'>" + url + "</a>" + this.makeFormUrlHtml(servletUrl + url, outputFormats) + "</div>\n");
                        sb.append(this.generateMethodDetails("new", locale));
                        viewDesc = this.getEntityDescription(prefix, "view.new", locale);
                        if (viewDesc != null) {
                            sb.append("          <div style='font-style:italic;font-size:0.9em;padding-left:2em;'>" + viewDesc + "</div>\n");
                        }
                        sb.append("        </div>\n");
                    }
                    if (caps.contains(CoreEntityProvider.class) || caps.contains(Resolvable.class)) {
                        url = this.makeEntityURL(ev, "show");
                        sb.append("        <div>\n");
                        sb.append("          <div>" + this.entityProperties.getProperty(DESCRIBE, "describe.entity.show.url", locale) + ": GET <a href='" + servletUrl + url + "'>" + url + "</a>" + this.makeFormatsUrlHtml(servletUrl + url, outputFormats) + "</div>\n");
                        sb.append(this.generateMethodDetails("show", locale));
                        viewDesc = this.getEntityDescription(prefix, "view.show", locale);
                        if (viewDesc != null) {
                            sb.append("          <div style='font-style:italic;font-size:0.9em;padding-left:2em;'>" + viewDesc + "</div>\n");
                        }
                        sb.append("        </div>\n");
                    }
                    if (caps.contains(Updateable.class)) {
                        url = this.makeEntityURL(ev, "edit");
                        sb.append("        <div>\n");
                        sb.append("          <div>" + this.entityProperties.getProperty(DESCRIBE, "describe.entity.update.url", locale) + ": PUT <a href='" + servletUrl + url + "'>" + url + "</a>" + this.makeFormUrlHtml(servletUrl + url, outputFormats) + "</div>\n");
                        sb.append(this.generateMethodDetails("edit", locale));
                        viewDesc = this.getEntityDescription(prefix, "view.edit", locale);
                        if (viewDesc != null) {
                            sb.append("          <div style='font-style:italic;font-size:0.9em;padding-left:2em;'>" + viewDesc + "</div>\n");
                        }
                        sb.append("        </div>\n");
                    }
                    if (caps.contains(Deleteable.class)) {
                        url = this.makeEntityURL(ev, "delete");
                        sb.append("        <div>\n");
                        sb.append("          <div>" + this.entityProperties.getProperty(DESCRIBE, "describe.entity.delete.url", locale) + ": DELETE <a href='" + servletUrl + url + "'>" + url + "</a>" + this.makeFormUrlHtml(servletUrl + url, outputFormats) + "</div>\n");
                        sb.append(this.generateMethodDetails("delete", locale));
                        viewDesc = this.getEntityDescription(prefix, "view.delete", locale);
                        if (viewDesc != null) {
                            sb.append("          <div style='font-style:italic;font-size:0.9em;padding-left:2em;'>" + viewDesc + "</div>\n");
                        }
                        sb.append("        </div>\n");
                    }
                    sb.append("      </div>\n");
                }
                if (!(customActions = this.entityProviderMethodStore.getCustomActions(prefix)).isEmpty()) {
                    sb.append("      <h4 style='padding-left:0.5em;margin-bottom:0.2em;'>" + this.entityProperties.getProperty(DESCRIBE, "describe.custom.actions", locale) + "</h4>\n");
                    sb.append("      <div style='padding-left:1em;padding-bottom:1em;'>\n");
                    for (CustomAction customAction : customActions) {
                        sb.append("        <div>\n");
                        String actionURL = this.makeActionURL(ev, customAction);
                        String formatsHtml = "";
                        if (customAction.viewKey == null || "list".equals(customAction.viewKey) || "show".equals(customAction.viewKey)) {
                            formatsHtml = this.makeFormatsUrlHtml(servletUrl + actionURL, outputFormats);
                        }
                        sb.append("          <a style='font-weight:bold;' href='" + servletUrl + actionURL + "'>" + customAction.action + "</a> : " + "<span>" + this.makeCustomActionKeyMethodText(customAction) + "</span> : " + "<span>[" + actionURL + "]</span> " + formatsHtml + "<br/>\n");
                        String actionDesc = this.getEntityDescription(prefix, ACTION_KEY_PREFIX + customAction.action, locale);
                        if (actionDesc != null) {
                            sb.append("          <div style='font-style:italic;font-size:0.9em;padding-left:1.5em;'>" + actionDesc + "</div>\n");
                        }
                        sb.append("        </div>\n");
                    }
                    sb.append("      </div>\n");
                }
                if (!(redirects = this.entityProviderMethodStore.getURLRedirects(prefix)).isEmpty()) {
                    sb.append("      <h4 style='padding-left:0.5em;margin-bottom:0.2em;'>" + this.entityProperties.getProperty(DESCRIBE, "describe.url.redirects", locale) + "</h4>\n");
                    sb.append("      <div style='padding-left:1em;padding-bottom:1em;'>\n");
                    for (int i = 0; i < redirects.size(); ++i) {
                        URLRedirect redirect = (URLRedirect)redirects.get(i);
                        sb.append("        <div>\n");
                        String target = this.replacePrefix(redirect.outgoingTemplate, prefix);
                        if (target == null) {
                            target = "<i>" + this.entityProperties.getProperty(DESCRIBE, "describe.url.redirects.no.outgoing", locale) + "</i>";
                        }
                        sb.append("          <span>" + (i + 1) + ")</span> &nbsp; " + this.makeRedirectLink(this.replacePrefix(redirect.template, prefix), servletUrl) + " ==&gt; <span>" + target + "</span><br/>\n");
                        String redirectDesc = this.getEntityDescription(prefix, REDIRECT_KEY_PREFIX + redirect.template, locale);
                        if (redirectDesc != null) {
                            sb.append("          <div style='font-style:italic;font-size:0.9em;padding-left:1.5em;'>" + redirectDesc + "</div>\n");
                        }
                        sb.append("        </div>\n");
                    }
                    sb.append("      </div>\n");
                }
                if ((entity = this.entityBrokerManager.getSampleEntityObject(prefix, null)) != null) {
                    Class<?> entityType = entity.getClass();
                    sb.append("      <h4 style='padding-left:0.5em;margin-bottom:0.2em;'>" + this.entityProperties.getProperty(DESCRIBE, "describe.entity.class", locale) + " : " + entityType.getName() + "</h4>\n");
                    sb.append("      <div style='padding-left:1em;padding-bottom:1em;'>\n");
                    if (ConstructorUtils.isClassSimple(entityType)) {
                        sb.append(this.makeResolveType("simple", null, locale));
                    } else if (ConstructorUtils.isClassCollection(entityType)) {
                        sb.append(this.makeResolveType("collection", null, locale));
                    } else if (ConstructorUtils.isClassArray(entityType)) {
                        String cType = "Component Class: " + ArrayUtils.type((Object[])((Object[])entity)).getName();
                        sb.append(this.makeResolveType("array", cType, locale));
                    } else if (ConstructorUtils.isClassMap(entityType)) {
                        String mapTypes = null;
                        Map m = (Map)entity;
                        if (m.size() > 0) {
                            Map.Entry entry = m.entrySet().iterator().next();
                            mapTypes = (entry.getKey() == null ? Object.class.getName() : entry.getKey().getClass().getName()) + " => " + (entry.getValue() == null ? Object.class.getName() : entry.getValue().getClass().getName());
                        }
                        sb.append(this.makeResolveType("map", mapTypes, locale));
                    } else {
                        sb.append(this.makeResolveType("bean", null, locale));
                        sb.append("        <table width='80%' cellpadding='0' cellspacing='0'>\n");
                        sb.append("          <thead>\n");
                        sb.append("            <tr>\n");
                        sb.append("              <td width='1%'></td>\n");
                        sb.append("              <td>" + this.entityProperties.getProperty(DESCRIBE, "describe.capabilities.name", locale) + "</td>\n");
                        sb.append("              <td>" + this.entityProperties.getProperty(DESCRIBE, "describe.capabilities.type", locale) + "</td>\n");
                        sb.append("              <td>" + this.entityProperties.getProperty(DESCRIBE, "describe.entity.field.status", locale) + "</td>\n");
                        sb.append("            </tr>\n");
                        sb.append("          </thead>\n");
                        sb.append("          <tbody>\n");
                        ClassFields cf = ReflectUtils.getInstance().analyzeClass(entity.getClass());
                        Map readTypes = cf.getFieldTypes(ClassFields.FieldsFilter.SERIALIZABLE);
                        Map writeTypes = cf.getFieldTypes(ClassFields.FieldsFilter.WRITEABLE);
                        HashSet requiredFieldNames = new HashSet(cf.getFieldNamesWithAnnotation(EntityFieldRequired.class));
                        HashMap entityTypes = new HashMap(readTypes);
                        entityTypes.putAll(writeTypes);
                        ArrayList keys = new ArrayList(entityTypes.keySet());
                        Collections.sort(keys);
                        for (int i = 0; i < keys.size(); ++i) {
                            String fieldName = (String)keys.get(i);
                            Class type = (Class)entityTypes.get(fieldName);
                            String status = null;
                            String trStyle = "";
                            if (!readTypes.containsKey(fieldName)) {
                                status = this.entityProperties.getProperty(DESCRIBE, "describe.entity.field.write.only", locale);
                                trStyle = " style='color:blue;'";
                            } else if (!writeTypes.containsKey(fieldName)) {
                                status = this.entityProperties.getProperty(DESCRIBE, "describe.entity.field.read.only", locale);
                                trStyle = " style='color:red;'";
                            } else {
                                status = this.entityProperties.getProperty(DESCRIBE, "describe.entity.field.read.write", locale);
                            }
                            boolean required = requiredFieldNames.contains(fieldName);
                            if (required) {
                                status = status + " <b style='color:red;'>* " + this.entityProperties.getProperty(DESCRIBE, "describe.entity.field.required", locale) + "</b>";
                            }
                            String typeName = type.getName();
                            if (String.class.getName().equals(typeName)) {
                                typeName = "string";
                            } else if (Boolean.class.getName().equals(typeName)) {
                                typeName = "boolean";
                            } else if (Integer.class.getName().equals(typeName)) {
                                typeName = "int";
                            } else if (Long.class.getName().equals(typeName)) {
                                typeName = "long";
                            }
                            sb.append("            <tr" + trStyle + "><td>" + (i + 1) + ")&nbsp;</td>" + "<td style='font-weight:bold;'>" + fieldName + "</td>" + "<td>" + typeName + "</td>" + "<td style='font-style:italic;'>" + status + "</td></tr>\n");
                            String fieldDesc = this.getEntityDescription(prefix, FIELD_KEY_PREFIX + fieldName, locale);
                            if (fieldDesc == null) continue;
                            sb.append("            <tr><td></td><td colspan='3' style='font-style:italic;font-size:0.9em;'>");
                            sb.append(fieldDesc);
                            sb.append("</td></tr>\n");
                        }
                        sb.append("          </tbody>\n");
                        sb.append("        </table>\n");
                    }
                    sb.append("      </div>\n");
                }
                sb.append("      <h4 style='padding-left:0.5em;margin-bottom:0.2em;'>" + this.entityProperties.getProperty(DESCRIBE, "describe.entity.data.handling", locale) + "</h4>\n");
                sb.append("      <div style='padding-left:1em;padding-bottom:1em;'>\n");
                sb.append("        <div>" + this.entityProperties.getProperty(DESCRIBE, "describe.entity.formats.output", locale) + " : " + this.makeFormatsString(outputFormats, EntityEncodingManager.HANDLED_OUTPUT_FORMATS, locale) + "</div>\n");
                String outputDesc = this.getEntityDescription(prefix, OUTPUT_DESCRIBE_KEY, locale);
                if (outputDesc != null) {
                    sb.append("          <div style='font-style:italic;font-size:0.9em;padding-left:1.5em;'>" + outputDesc + "</div>\n");
                }
                String[] inputFormats = this.getFormats(prefix, false);
                sb.append("        <div>" + this.entityProperties.getProperty(DESCRIBE, "describe.entity.formats.input", locale) + " : " + this.makeFormatsString(inputFormats, EntityEncodingManager.HANDLED_INPUT_FORMATS, locale) + "</div>\n");
                String intputDesc = this.getEntityDescription(prefix, INPUT_DESCRIBE_KEY, locale);
                if (intputDesc != null) {
                    sb.append("          <div style='font-style:italic;font-size:0.9em;padding-left:1.5em;'>" + intputDesc + "</div>\n");
                }
                if ((evap = this.entityViewAccessProviderManager.getProvider(prefix)) != null) {
                    sb.append("        <div>" + this.entityProperties.getProperty(DESCRIBE, "describe.entity.data.access.provider", locale) + " : " + EntityViewAccessProvider.class.getSimpleName() + "</div>\n");
                    if (AccessFormats.class.isAssignableFrom(evap.getClass())) {
                        String[] accessFormats = ((AccessFormats)evap).getHandledAccessFormats();
                        sb.append("        <div>" + this.entityProperties.getProperty(DESCRIBE, "describe.entity.formats.access", locale) + " : " + this.makeFormatsString(accessFormats, null, locale) + "</div>\n");
                    }
                    sb.append("        <div>" + this.entityProperties.getProperty(DESCRIBE, "describe.entity.data.access.provider", locale) + " : " + EntityViewAccessProvider.class.getSimpleName() + "</div>\n");
                } else if (this.httpServletAccessProviderManager != null && this.httpServletAccessProviderManager.getProvider(prefix) != null) {
                    sb.append("        <div>" + this.entityProperties.getProperty(DESCRIBE, "describe.entity.data.access.provider", locale) + " : " + HttpServletAccessProvider.class.getSimpleName() + "</div>\n");
                } else {
                    sb.append("        <div style='font-style:italic;padding-left:1em'>" + this.entityProperties.getProperty(DESCRIBE, "describe.entity.data.access.provider.none", locale) + "</div>\n");
                }
                sb.append("      </div>\n");
            }
            if (extra) {
                sb.append("      <h4 style='padding-left:0.5em;margin-bottom:0.2em;'>" + this.entityProperties.getProperty(DESCRIBE, "describe.capabilities", locale) + "</h4>\n");
                sb.append("      <table width='95%' style='padding-left:1.5em;'>\n");
                sb.append("        <tr style='font-size:0.9em;'><th width='1%'></th><th width='14%'>" + this.entityProperties.getProperty(DESCRIBE, "describe.capabilities.name", locale) + "</th><th width='30%'>" + this.entityProperties.getProperty(DESCRIBE, "describe.capabilities.type", locale) + "</th>");
                if (extra) {
                    sb.append("<th width='55%'>" + this.entityProperties.getProperty(DESCRIBE, "describe.capabilities.description", locale) + "</th>");
                }
                sb.append("</tr>\n");
                int counter = 1;
                for (Class class1 : caps) {
                    String capabilityDescription;
                    sb.append("        <tr style='font-size:0.9em;'><td>");
                    sb.append(counter++);
                    sb.append("</td><td>");
                    sb.append(class1.getSimpleName());
                    sb.append("</td><td>");
                    sb.append(class1.getName());
                    sb.append("</td><td>");
                    if (extra && (capabilityDescription = this.getEntityDescription(prefix, class1.getSimpleName(), locale)) != null) {
                        sb.append(capabilityDescription);
                    }
                    sb.append("</td></tr>\n");
                }
                sb.append("      </table>\n");
            }
        }
        return sb.toString();
    }

    protected String generateMethodDetails(String methodType, Locale locale) {
        return "          <div style='font-style:italic;font-size:0.9em;padding-left:1.5em;'>" + this.entityProperties.getProperty(DESCRIBE, "describe.details.header", locale) + " " + this.entityProperties.getProperty(DESCRIBE, "describe.entity." + methodType + ".details", locale) + "</div>\n";
    }

    protected String replacePrefix(String outgoingTemplate, String prefix) {
        if (outgoingTemplate != null) {
            outgoingTemplate = outgoingTemplate.replace("{prefix}", prefix);
        }
        return outgoingTemplate;
    }

    protected String makeRedirectLink(String redirect, String prefixURL) {
        String html = redirect;
        html = redirect.indexOf("{") > 0 && redirect.indexOf("}") > 0 ? "<span style='font-weight:bold;'>" + redirect + "</span>" : "<a style='font-weight:bold;' href='" + prefixURL + redirect + "'>" + redirect + "</a>";
        return html;
    }

    protected String makeResolveType(String typeName, String extra, Locale locale) {
        StringBuilder sb = new StringBuilder();
        sb.append("        <div><b>");
        sb.append(this.entityProperties.getProperty(DESCRIBE, "describe.capabilities.type", locale));
        sb.append(" :: ");
        sb.append(typeName);
        sb.append("</b>");
        if (extra != null) {
            sb.append(" (");
            sb.append(extra);
            sb.append(") ");
        }
        sb.append("</div>\n");
        return sb.toString();
    }

    protected String makeActionURL(EntityView ev, CustomAction customAction) {
        String URL2 = '/' + ev.getEntityReference().getPrefix() + '/' + customAction.action;
        String viewKey = customAction.viewKey;
        if (viewKey != null && ("show".equals(viewKey) || "edit".equals(viewKey) || "delete".equals(viewKey))) {
            URL2 = ev.getEntityURL("show", null) + '/' + customAction.action;
        }
        return URL2;
    }

    protected String makeEntityURL(EntityView ev, String viewType) {
        if (viewType == null) {
            viewType = "list";
        }
        viewType = !"list".equals(viewType) && !"new".equals(viewType) ? "show" : "list";
        return ev.getEntityURL(viewType, null);
    }

    protected String makeCustomActionKeyMethodText(CustomAction customAction) {
        String togo = "*";
        if (customAction.viewKey != null && !"".equals(customAction.viewKey)) {
            togo = customAction.viewKey + " (" + EntityView.translateViewKeyToMethod((String)customAction.viewKey) + ")";
        }
        return togo;
    }

    protected String[] getFormats(String prefix, boolean output) {
        String[] accessFormats;
        Object[] formats = null;
        try {
            if (output) {
                formats = ((Outputable)this.entityProviderManager.getProviderByPrefixAndCapability(prefix, Outputable.class)).getHandledOutputFormats();
            } else {
                formats = ((Inputable)this.entityProviderManager.getProviderByPrefixAndCapability(prefix, Inputable.class)).getHandledInputFormats();
                if (formats != null && ArrayUtils.contains((Object[])formats, (Object)"form")) {
                    ArrayList<Object> l = new ArrayList<Object>();
                    for (Object format : formats) {
                        if ("form".equals(format)) continue;
                        l.add(format);
                    }
                    formats = l.toArray(new String[l.size()]);
                }
            }
        }
        catch (NullPointerException e) {
            formats = null;
        }
        EntityViewAccessProvider evap = this.entityViewAccessProviderManager.getProvider(prefix);
        if (evap != null && AccessFormats.class.isAssignableFrom(evap.getClass()) && (accessFormats = ((AccessFormats)evap).getHandledAccessFormats()) != null && accessFormats.length > 0) {
            if (formats == null) {
                formats = accessFormats;
            } else {
                for (int i = 0; i < accessFormats.length; ++i) {
                    if (ReflectUtils.contains((Object[])formats, (Object)accessFormats[i])) continue;
                    ReflectUtils.appendArray((Object[])formats, (Object)accessFormats[i]);
                }
            }
        }
        return formats;
    }

    protected String makeFormatsUrlHtml(String url, String[] formats) {
        StringBuilder sb = new StringBuilder();
        if (formats != null) {
            for (String format : formats) {
                sb.append(this.makeFormatUrlHtml(url, format));
            }
        }
        return sb.toString();
    }

    protected String makeFormatsString(String[] formats, String[] extraFormats, Locale locale) {
        String s = "";
        if (locale == null) {
            locale = this.entityProperties.getLocale();
        }
        if (formats == null) {
            s = "<i>" + this.entityProperties.getProperty(DESCRIBE, "describe.entity.formats.none", locale) + "</i>";
        } else if (formats.length == 0) {
            String all = "*";
            if (extraFormats != null && extraFormats.length > 0) {
                all = this.makeArrayIntoString(formats) + ",*";
            }
            s = "<i>" + this.entityProperties.getProperty(DESCRIBE, "describe.entity.formats.all", locale) + " (" + all + ")</i>";
        } else {
            s = this.makeArrayIntoString(formats);
        }
        return s;
    }

    protected String makeFormUrlHtml(String url, String[] formats) {
        String form = "";
        if (formats != null && ArrayUtils.contains((Object[])formats, (Object)"form")) {
            form = this.makeFormatUrlHtml(url, "form");
        }
        return form;
    }

    protected String makeFormatUrlHtml(String url, String format) {
        return " (<a href='" + url + "." + format + "'>" + format + "</a>)";
    }

    protected String makeArrayIntoString(Object[] array) {
        StringBuilder result = new StringBuilder();
        if (array != null && array.length > 0) {
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                if (array[i] == null) continue;
                result.append(array[i].toString());
            }
        }
        return result.toString();
    }

    protected String getEntityDescription(String prefix, String descriptionkey, Locale locale) {
        DescribeDefineable describer;
        String value = null;
        if (locale == null) {
            locale = this.entityProperties.getLocale();
        }
        if ((describer = (DescribeDefineable)this.entityProviderManager.getProviderByPrefixAndCapability(prefix, DescribeDefineable.class)) != null) {
            value = describer.getDescription(locale, descriptionkey);
        }
        if (value == null) {
            String key = prefix;
            if (descriptionkey != null) {
                key = key + "." + descriptionkey;
            }
            value = this.entityProperties.getProperty(prefix, key, locale);
        }
        if ("".equals(value)) {
            value = null;
        }
        return value;
    }
}

