/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.rest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.azeckoski.reflectutils.ReflectUtils;
import org.azeckoski.reflectutils.exceptions.FieldnameNotFoundException;
import org.sakaiproject.entitybroker.EntityBroker;
import org.sakaiproject.entitybroker.EntityBrokerManager;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.EntityView;
import org.sakaiproject.entitybroker.access.AccessFormats;
import org.sakaiproject.entitybroker.access.AccessViews;
import org.sakaiproject.entitybroker.access.EntityViewAccessProvider;
import org.sakaiproject.entitybroker.access.EntityViewAccessProviderManager;
import org.sakaiproject.entitybroker.access.HttpServletAccessProvider;
import org.sakaiproject.entitybroker.access.HttpServletAccessProviderManager;
import org.sakaiproject.entitybroker.entityprovider.EntityProvider;
import org.sakaiproject.entitybroker.entityprovider.EntityProviderManager;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityLastModified;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Createable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Deleteable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.InputTranslatable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Inputable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.OutputFormattable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Outputable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Redirectable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RequestHandler;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RequestInterceptor;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Updateable;
import org.sakaiproject.entitybroker.entityprovider.extension.ActionReturn;
import org.sakaiproject.entitybroker.entityprovider.extension.CustomAction;
import org.sakaiproject.entitybroker.entityprovider.extension.EntityData;
import org.sakaiproject.entitybroker.entityprovider.extension.RequestGetterWrite;
import org.sakaiproject.entitybroker.entityprovider.extension.RequestStorage;
import org.sakaiproject.entitybroker.entityprovider.extension.RequestStorageWrite;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.entitybroker.exception.EntityEncodingException;
import org.sakaiproject.entitybroker.exception.EntityException;
import org.sakaiproject.entitybroker.exception.EntityNotFoundException;
import org.sakaiproject.entitybroker.exception.FormatUnsupportedException;
import org.sakaiproject.entitybroker.providers.EntityRequestHandler;
import org.sakaiproject.entitybroker.rest.EntityActionsManager;
import org.sakaiproject.entitybroker.rest.EntityBatchHandler;
import org.sakaiproject.entitybroker.rest.EntityDescriptionManager;
import org.sakaiproject.entitybroker.rest.EntityEncodingManager;
import org.sakaiproject.entitybroker.rest.EntityRedirectsManager;
import org.sakaiproject.entitybroker.util.ClassLoaderReporter;
import org.sakaiproject.entitybroker.util.EntityDataUtils;
import org.sakaiproject.entitybroker.util.EntityResponse;
import org.sakaiproject.entitybroker.util.http.HttpRESTUtils;
import org.sakaiproject.entitybroker.util.http.HttpResponse;
import org.sakaiproject.entitybroker.util.http.LazyResponseOutputStream;
import org.sakaiproject.entitybroker.util.request.RequestUtils;

public class EntityHandlerImpl
implements EntityRequestHandler {
    public static String APP_VERSION = "1.0.1";
    public static String SVN_REVISION = "$Revision: 315799 $";
    public static String SVN_LAST_UPDATE = "$Date: 2014-12-01 12:34:05 -0500 (Mon, 01 Dec 2014) $";
    private EntityProviderManager entityProviderManager;
    private EntityBrokerManager entityBrokerManager;
    private EntityEncodingManager entityEncodingManager;
    private EntityDescriptionManager entityDescriptionManager;
    private HttpServletAccessProviderManager accessProviderManager;
    private EntityViewAccessProviderManager entityViewAccessProviderManager;
    private RequestGetterWrite requestGetter;
    private EntityActionsManager entityActionsManager;
    private EntityRedirectsManager entityRedirectsManager;
    private EntityBatchHandler entityBatchHandler;
    private RequestStorageWrite requestStorage;
    private String servletContext;

    protected EntityHandlerImpl() {
    }

    public EntityHandlerImpl(EntityProviderManager entityProviderManager, EntityBrokerManager entityBrokerManager, EntityEncodingManager entityEncodingManager, EntityDescriptionManager entityDescriptionManager, EntityViewAccessProviderManager entityViewAccessProviderManager, RequestGetterWrite requestGetter, EntityActionsManager entityActionsManager, EntityRedirectsManager entityRedirectsManager, EntityBatchHandler entityBatchHandler, RequestStorageWrite requestStorage) {
        this.entityProviderManager = entityProviderManager;
        this.entityBrokerManager = entityBrokerManager;
        this.entityEncodingManager = entityEncodingManager;
        this.entityDescriptionManager = entityDescriptionManager;
        this.entityViewAccessProviderManager = entityViewAccessProviderManager;
        this.requestGetter = requestGetter;
        this.entityActionsManager = entityActionsManager;
        this.entityRedirectsManager = entityRedirectsManager;
        this.requestStorage = requestStorage;
        this.setEntityBatchHandler(entityBatchHandler);
        this.init();
    }

    public void init() {
        System.out.println("INFO EntityRequestHandler init complete");
    }

    public void setEntityProviderManager(EntityProviderManager entityProviderManager) {
        this.entityProviderManager = entityProviderManager;
    }

    public void setEntityBrokerManager(EntityBrokerManager entityBrokerManager) {
        this.entityBrokerManager = entityBrokerManager;
    }

    public void setEntityEncodingManager(EntityEncodingManager entityEncodingManager) {
        this.entityEncodingManager = entityEncodingManager;
    }

    public void setEntityDescriptionManager(EntityDescriptionManager entityDescriptionManager) {
        this.entityDescriptionManager = entityDescriptionManager;
    }

    public void setAccessProviderManager(HttpServletAccessProviderManager accessProviderManager) {
        this.accessProviderManager = accessProviderManager;
    }

    public void setEntityViewAccessProviderManager(EntityViewAccessProviderManager entityViewAccessProviderManager) {
        this.entityViewAccessProviderManager = entityViewAccessProviderManager;
    }

    public void setRequestGetter(RequestGetterWrite requestGetter) {
        this.requestGetter = requestGetter;
    }

    public void setEntityActionsManager(EntityActionsManager entityActionsManager) {
        this.entityActionsManager = entityActionsManager;
    }

    public void setEntityRedirectsManager(EntityRedirectsManager entityRedirectsManager) {
        this.entityRedirectsManager = entityRedirectsManager;
    }

    public void setEntityBatchHandler(EntityBatchHandler entityBatchHandler) {
        this.entityBatchHandler = entityBatchHandler;
        this.entityBatchHandler.setEntityRequestHandler(this);
    }

    public void setRequestStorage(RequestStorageWrite requestStorage) {
        this.requestStorage = requestStorage;
    }

    public String getServletContext() {
        if (this.servletContext == null) {
            return RequestUtils.getServletContext(null);
        }
        return this.servletContext;
    }

    public void setServletContext(String servletContext) {
        if (servletContext != null) {
            this.servletContext = servletContext;
            this.entityBrokerManager.setServletContext(servletContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String handleEntityAccess(HttpServletRequest req, HttpServletResponse res, String path) {
        if (this.servletContext == null || req != null) {
            this.setServletContext(RequestUtils.getServletContext((HttpServletRequest)req));
        }
        if (req != null && path == null) {
            path = req.getPathInfo();
        }
        String handledReference = null;
        if (this.entityBrokerManager.getExternalIntegrationProvider() != null) {
            try {
                this.entityBrokerManager.getExternalIntegrationProvider().handleUserSessionKey(req);
            }
            catch (SecurityException se) {
                throw new EntityException(se.getMessage(), path, 401);
            }
            catch (Exception e) {
                System.out.println("WARN: EntityRequestHandler: External handleUserSessionKey method failed, continuing...: " + e);
            }
        }
        if (path == null || "".equals(path) || "/".equals(path)) {
            res.setStatus(301);
            try {
                res.sendRedirect(res.encodeRedirectURL(this.getServletContext() + "/describe"));
            }
            catch (IOException e) {
                throw new RuntimeException("Could not encode the redirect URL");
            }
            return "/";
        }
        if ("/describe".equals(path) || path.startsWith("/describe.")) {
            String format = RequestUtils.findAndHandleFormat((HttpServletRequest)req, (HttpServletResponse)res, (String)"html");
            String output = this.entityDescriptionManager.makeDescribeAll(format, req.getLocale());
            res.setContentLength(output.getBytes().length);
            try {
                res.getWriter().write(output);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to put output into the response writer: " + e.getMessage(), e);
            }
            res.setStatus(200);
            handledReference = "/";
        } else {
            EntityView view;
            try {
                view = this.entityBrokerManager.parseEntityURL(path);
            }
            catch (IllegalArgumentException e) {
                throw new EntityException("Could not parse entity path (" + path + "): " + e.getMessage(), path, 400);
            }
            if (view == null) {
                throw new EntityException("Could not parse the incoming path (" + path + ") and no entity provider could be found to handle the prefix", path, 501);
            }
            if ("describe".equals(view.getEntityReference().getId())) {
                String format = RequestUtils.findAndHandleFormat((HttpServletRequest)req, (HttpServletResponse)res, (String)"html");
                String entityId = req.getParameter("_id");
                if (entityId == null || "".equals(entityId)) {
                    entityId = ":ID:";
                }
                String output = this.entityDescriptionManager.makeDescribeEntity(view.getEntityReference().getPrefix(), entityId, format, req.getLocale());
                res.setContentLength(output.getBytes().length);
                try {
                    res.getWriter().write(output);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to put output into the response writer: " + e.getMessage(), e);
                }
                res.setStatus(200);
                handledReference = view.getEntityReference().getSpaceReference() + "/describe";
            } else {
                String redirectURL;
                String prefix = view.getEntityReference().getPrefix();
                Redirectable urlConfigurable = (Redirectable)this.entityProviderManager.getProviderByPrefixAndCapability(prefix, Redirectable.class);
                if (urlConfigurable != null && (redirectURL = this.entityRedirectsManager.checkForTemplateMatch((EntityProvider)urlConfigurable, path, req.getQueryString())) != null) {
                    if ("".equals(redirectURL)) {
                        res.setStatus(200);
                    } else {
                        System.out.println("INFO: EntityRequestHandler: Entity Redirect: redirecting from (" + path + ") to (" + redirectURL + ")");
                        RequestUtils.handleURLRedirect((String)redirectURL, (boolean)true, (HttpServletRequest)req, (HttpServletResponse)res);
                    }
                    return '/' + prefix;
                }
                CustomAction customAction = this.entityActionsManager.getCustomAction(prefix, view.getPathSegment(1));
                if (customAction == null) {
                    customAction = this.entityActionsManager.getCustomAction(prefix, view.getPathSegment(2));
                }
                if (customAction == null) {
                    if (!this.entityBrokerManager.entityExists(view.getEntityReference())) {
                        throw new EntityException("Attempted to access an entity URL path (" + path + ") for an entity (" + view.getEntityReference() + ") that does not exist", view.getEntityReference() + "", 404);
                    }
                } else {
                    EntityReference cRef = view.getEntityReference();
                    if (cRef.getId() != null && cRef.getId().equalsIgnoreCase(customAction.action)) {
                        view.setEntityReference(new EntityReference(prefix, ""));
                    }
                }
                res.setStatus(200);
                req.setAttribute("entity-format", (Object)view.getFormat());
                try {
                    this.requestGetter.setRequest(req);
                    this.requestGetter.setResponse(res);
                    this.requestStorage.setRequestValue(RequestStorage.ReservedKeys._requestEntityReference.name(), (Object)view.getEntityReference().toString());
                    this.requestStorage.setRequestValue(RequestStorage.ReservedKeys._requestOrigin.name(), (Object)RequestStorage.RequestOrigin.REST.name());
                    this.requestStorage.setRequestValue(RequestStorage.ReservedKeys._requestActive.name(), (Object)true);
                    RequestInterceptor interceptor = (RequestInterceptor)this.entityProviderManager.getProviderByPrefixAndCapability(prefix, RequestInterceptor.class);
                    if (interceptor != null) {
                        interceptor.before(view, req, res);
                    }
                    if ("batch".equals(prefix)) {
                        view.setExtension(RequestUtils.findAndHandleFormat((HttpServletRequest)req, (HttpServletResponse)res, (String)"json"));
                        this.entityBatchHandler.handleBatch(view, req, res);
                    } else {
                        String format = RequestUtils.findAndHandleFormat((HttpServletRequest)req, (HttpServletResponse)res, (String)"html");
                        view.setExtension(format);
                        RequestHandler handler = (RequestHandler)this.entityProviderManager.getProviderByPrefixAndCapability(prefix, RequestHandler.class);
                        if (handler != null) {
                            this.handleClassLoaderAccess((EntityViewAccessProvider)handler, req, res, view);
                        } else {
                            boolean formatInvalidFailure;
                            boolean handled;
                            boolean output;
                            block111: {
                                output = RequestUtils.isRequestOutput((HttpServletRequest)req, (EntityView)view);
                                this.setResponseHeaders(view, res, this.requestStorage.getStorageMapCopy(), null);
                                handled = false;
                                ActionReturn actionReturn = null;
                                if (customAction != null) {
                                    ActionsExecutable actionProvider = (ActionsExecutable)this.entityProviderManager.getProviderByPrefixAndCapability(prefix, ActionsExecutable.class);
                                    if (actionProvider == null) {
                                        throw new EntityException("The provider for prefix (" + prefix + ") cannot handle custom actions", view.getEntityReference() + "", 400);
                                    }
                                    if (customAction.viewKey != null && !view.getViewKey().equals(customAction.viewKey)) {
                                        throw new EntityException("Cannot execute custom action (" + customAction.action + ") for request method " + req.getMethod() + ", The custom action view key (" + customAction.viewKey + ") must match the request view key (" + view.getViewKey() + ")", view.getEntityReference() + "", 400);
                                    }
                                    try {
                                        actionReturn = this.entityActionsManager.handleCustomActionRequest(actionProvider, view, customAction.action, req, res, this.requestStorage.getStorageMapCopy(true, false, true, true));
                                    }
                                    catch (SecurityException se) {
                                        throw new EntityException("Security exception handling request for view (" + view + "), " + "this is typically caused by the current user not having access to the " + "data requested or the user not being logged in at all :: message=" + se.getMessage(), view.getEntityReference() + "", 403);
                                    }
                                    catch (EntityNotFoundException e) {
                                        throw new EntityException("Cannot execute custom action (" + customAction.action + "): Could not find entity (" + e.entityReference + "): " + e.getMessage(), view.getEntityReference() + "", 404);
                                    }
                                    catch (FormatUnsupportedException e) {
                                        throw new EntityException("Cannot execute custom action (" + customAction.action + "): Format not supported (" + e.format + "): " + e.getMessage(), view.getEntityReference() + "", 406);
                                    }
                                    catch (IllegalArgumentException e) {
                                        throw new EntityException("Cannot execute custom action (" + customAction.action + "): Illegal arguments: " + e.getMessage(), view.getEntityReference() + "", 400);
                                    }
                                    catch (UnsupportedOperationException e) {
                                        throw new EntityException("Cannot execute custom action (" + customAction.action + "): Could not execute action: " + e.getMessage(), view.getEntityReference() + "", 400);
                                    }
                                    if (actionReturn == null || actionReturn.output != null) {
                                        handled = true;
                                    } else {
                                        this.addResponseHeaders(res, actionReturn.getHeaders());
                                        if (actionReturn.entitiesList == null && actionReturn.entityData == null) {
                                            handled = true;
                                        } else {
                                            output = true;
                                            handled = false;
                                            if (actionReturn.entitiesList != null) {
                                                if (actionReturn.entitiesList.size() > 1) {
                                                    view.setViewKey("list");
                                                }
                                                this.entityBrokerManager.populateEntityData(actionReturn.entitiesList);
                                            } else if (actionReturn.entityData != null) {
                                                view.setViewKey("show");
                                                this.entityBrokerManager.populateEntityData(new EntityData[]{actionReturn.entityData});
                                            }
                                        }
                                    }
                                }
                                formatInvalidFailure = false;
                                if (!handled) {
                                    try {
                                        if (output) {
                                            Object[] outputFormats;
                                            Outputable outputable;
                                            String viewKey = view.getViewKey();
                                            if ("new".equals(viewKey) || "edit".equals(viewKey) || "delete".equals(viewKey)) {
                                                handled = false;
                                                if (!"form".equals(format) || (outputable = (Outputable)this.entityProviderManager.getProviderByPrefixAndCapability(prefix, Outputable.class)) == null) break block111;
                                                Object[] outputFormats2 = outputable.getHandledOutputFormats();
                                                if (outputFormats2 != null && ReflectUtils.contains((Object[])outputFormats2, (Object)"form")) {
                                                    RequestUtils.setResponseEncoding((String)format, (HttpServletResponse)res);
                                                    if (EntityView.Method.HEAD.name().equals(view.getMethod())) {
                                                        res.setStatus(204);
                                                        handled = true;
                                                        break block111;
                                                    }
                                                    String form = this.entityEncodingManager.encodeEntity(prefix, format, null, view);
                                                    if (form == null || form.length() <= 0) break block111;
                                                    try {
                                                        res.getWriter().print(form);
                                                    }
                                                    catch (IOException e) {
                                                        throw new RuntimeException("Failed to get writer from response: " + view, e);
                                                    }
                                                    handled = true;
                                                    this.setNoCacheHeaders(res);
                                                    res.setStatus(200);
                                                    break block111;
                                                }
                                                throw new FormatUnsupportedException("Outputable restriction (formats list) for " + prefix + " does not allow form generation, add the FORM format (" + "form" + ") to the list of allowed output formats to enable this", view.getEntityReference() + "", format);
                                            }
                                            outputable = (Outputable)this.entityProviderManager.getProviderByPrefixAndCapability(prefix, Outputable.class);
                                            if (outputable == null) break block111;
                                            if (customAction != null && actionReturn != null && actionReturn.format != null) {
                                                format = actionReturn.format;
                                            }
                                            if ((outputFormats = outputable.getHandledOutputFormats()) == null || ReflectUtils.contains((Object[])outputFormats, (Object)format)) {
                                                RequestUtils.setResponseEncoding((String)format, (HttpServletResponse)res);
                                                EntityReference ref = view.getEntityReference();
                                                ArrayList<EntityData> entities = null;
                                                if (customAction != null && actionReturn != null) {
                                                    entities = actionReturn.entitiesList;
                                                    if (entities != null) {
                                                        if (entities.size() > 0) {
                                                            EntityData ed = (EntityData)entities.get(0);
                                                            ref = new EntityReference(ed.getEntityRef().getPrefix(), "");
                                                            view.setEntityReference(ref);
                                                            view.setViewKey("list");
                                                        }
                                                    } else if (actionReturn.entityData != null) {
                                                        ArrayList<EntityData> eList = new ArrayList<EntityData>();
                                                        EntityData ed = actionReturn.entityData;
                                                        if (!ed.isDisplayTitleSet()) {
                                                            ed.setDisplayTitle(customAction.action);
                                                        }
                                                        eList.add(ed);
                                                        entities = eList;
                                                        ref = ed.getEntityRef();
                                                        if (ref == null) {
                                                            ref = new EntityReference(prefix, customAction.action);
                                                        } else if (ref.getId() == null) {
                                                            ref = new EntityReference(ref.getPrefix(), customAction.action);
                                                        }
                                                        view.setEntityReference(ref);
                                                        view.setViewKey("show");
                                                    }
                                                } else {
                                                    Search search = RequestUtils.makeSearchFromRequestParams((Map)this.requestStorage.getStorageMapCopy(true, false, true, true));
                                                    entities = this.entityBrokerManager.getEntitiesData(ref, search, this.requestStorage.getStorageMapCopy());
                                                }
                                                this.setLastModifiedHeaders(res, entities != null && entities.size() == 1 ? (EntityData)entities.get(0) : null, System.currentTimeMillis());
                                                if (EntityView.Method.HEAD.name().equals(view.getMethod())) {
                                                    res.setStatus(204);
                                                    break block111;
                                                }
                                                LazyResponseOutputStream outputStream = new LazyResponseOutputStream(res);
                                                try {
                                                    OutputFormattable formattable = (OutputFormattable)this.entityProviderManager.getProviderByPrefixAndCapability(prefix, OutputFormattable.class);
                                                    if (formattable != null) {
                                                        formattable.formatOutput(ref, format, entities, this.requestStorage.getStorageMapCopy(), (OutputStream)outputStream);
                                                        handled = true;
                                                    }
                                                }
                                                catch (FormatUnsupportedException e) {
                                                    handled = false;
                                                }
                                                if (!handled) {
                                                    this.entityEncodingManager.internalOutputFormatter(ref, format, entities, this.requestStorage.getStorageMapCopy(), (OutputStream)outputStream, view);
                                                    if ("form".equals(format)) {
                                                        this.setNoCacheHeaders(res);
                                                    }
                                                }
                                                handled = true;
                                                res.setStatus(200);
                                                break block111;
                                            }
                                            throw new FormatUnsupportedException("Outputable restriction (formats list) for " + prefix + " blocked handling this format (" + format + ")", view.getEntityReference() + "", format);
                                        }
                                        if ("delete".equals(view.getViewKey())) {
                                            Deleteable deleteable = (Deleteable)this.entityProviderManager.getProviderByPrefixAndCapability(prefix, Deleteable.class);
                                            if (deleteable != null) {
                                                deleteable.deleteEntity(view.getEntityReference(), this.requestStorage.getStorageMapCopy());
                                                res.setStatus(204);
                                                handled = true;
                                            }
                                            break block111;
                                        }
                                        Inputable inputable = (Inputable)this.entityProviderManager.getProviderByPrefixAndCapability(prefix, Inputable.class);
                                        if (inputable == null) break block111;
                                        Object[] inputFormats = inputable.getHandledInputFormats();
                                        if (inputFormats == null || ReflectUtils.contains((Object[])inputFormats, (Object)format)) {
                                            Object entity = null;
                                            ServletInputStream inputStream = null;
                                            try {
                                                inputStream = req.getInputStream();
                                            }
                                            catch (IOException e) {
                                                throw new RuntimeException("Failed to get output stream from response: " + view.getEntityReference(), e);
                                            }
                                            try {
                                                InputTranslatable translatable = (InputTranslatable)this.entityProviderManager.getProviderByPrefixAndCapability(prefix, InputTranslatable.class);
                                                if (translatable != null) {
                                                    entity = translatable.translateFormattedData(view.getEntityReference(), format, (InputStream)inputStream, this.requestStorage.getStorageMapCopy());
                                                    handled = true;
                                                }
                                            }
                                            catch (FormatUnsupportedException e) {
                                                handled = false;
                                            }
                                            if (!handled) {
                                                entity = this.entityEncodingManager.internalInputTranslator(view.getEntityReference(), format, (InputStream)inputStream, req);
                                            }
                                            if (entity == null) {
                                                handled = false;
                                                throw new EntityException("Unable to save entity (" + view.getEntityReference() + ") with format (" + format + "), translated entity object was null", view.toString(), 400);
                                            }
                                            if ("new".equals(view.getViewKey())) {
                                                Createable createable = (Createable)this.entityProviderManager.getProviderByPrefixAndCapability(prefix, Createable.class);
                                                if (createable == null) {
                                                    throw new EntityException("Unable to create new entity (" + view + "), " + Createable.class.getName() + " is not implemented for this entity type (" + prefix + ")", view + "", 501);
                                                }
                                                String createdId = createable.createEntity(view.getEntityReference(), entity, this.requestStorage.getStorageMapCopy());
                                                if (createdId == null || "".equals(createdId)) {
                                                    throw new IllegalStateException("Could not get the createdId from the newly created entity for (" + view + "), please ensure the provider is returning a non-null and non-empty value from the create method, if the item was not created then an exception should have been thrown");
                                                }
                                                view.setEntityReference(new EntityReference(prefix, createdId));
                                                res.setHeader("EntityId", createdId);
                                                res.setStatus(201);
                                                try {
                                                    ServletOutputStream outputStream = res.getOutputStream();
                                                    outputStream.write(createdId.getBytes());
                                                }
                                                catch (IOException e) {
                                                }
                                                catch (RuntimeException e) {}
                                            } else if ("edit".equals(view.getViewKey())) {
                                                Updateable updateable = (Updateable)this.entityProviderManager.getProviderByPrefixAndCapability(prefix, Updateable.class);
                                                if (updateable == null) {
                                                    throw new EntityException("Unable to create new entity (" + view + "), " + Updateable.class.getName() + " is not implemented for this entity type (" + prefix + ")", view + "", 501);
                                                }
                                                updateable.updateEntity(view.getEntityReference(), entity, this.requestStorage.getStorageMapCopy());
                                                res.setStatus(204);
                                            } else {
                                                throw new EntityException("Unable to handle entity input (" + view.getEntityReference() + "), " + "action was not understood: " + view.getViewKey(), view.getEntityReference() + "", 400);
                                            }
                                            res.setHeader("Location", view.getEntityURL());
                                            res.setHeader("EntityReference", view.getEntityReference().toString());
                                            handled = true;
                                            break block111;
                                        }
                                        throw new FormatUnsupportedException("Inputable restriction for " + prefix + " blocked handling this format (" + format + ")", view.getEntityReference() + "", format);
                                    }
                                    catch (FormatUnsupportedException e) {
                                        formatInvalidFailure = true;
                                        handled = false;
                                    }
                                    catch (SecurityException se) {
                                        throw new EntityException("Security exception handling request for view (" + view + "), " + "this is typically caused by the current user not having access to the " + "data requested or the user not being logged in at all :: message=" + se.getMessage(), view.getEntityReference() + "", 403);
                                    }
                                    catch (EntityEncodingException e) {
                                        throw new EntityException("EntityEncodingException: Unable to handle " + (output ? "output" : "input") + " request for format  " + view.getFormat() + " for this path (" + path + ") for prefix (" + prefix + ") for entity (" + view.getEntityReference() + "), request url (" + view.getOriginalEntityUrl() + "): " + e.getMessage(), view.getEntityReference() + "", 500);
                                    }
                                    catch (IllegalArgumentException e) {
                                        throw new EntityException("IllegalArgumentException: Unable to handle " + (output ? "output" : "input") + " request for format  " + view.getFormat() + " for this path (" + path + ") for prefix (" + prefix + ") for entity (" + view.getEntityReference() + "), request url (" + view.getOriginalEntityUrl() + "): " + e.getMessage(), view.getEntityReference() + "", 400);
                                    }
                                    catch (IllegalStateException e) {
                                        throw new EntityException("IllegalStateException: Unable to handle " + (output ? "output" : "input") + " request for format  " + view.getFormat() + " for this path (" + path + ") for prefix (" + prefix + ") for entity (" + view.getEntityReference() + "), request url (" + view.getOriginalEntityUrl() + "): " + e.getMessage(), view.getEntityReference() + "", 500);
                                    }
                                }
                            }
                            if (!handled) {
                                try {
                                    boolean accessProviderExists = this.handleAccessProvider(view, req, res);
                                    if (!accessProviderExists) {
                                        if (formatInvalidFailure) {
                                            throw new FormatUnsupportedException("Nothing (AP and internal) available to handle the requested format", view.getEntityReference() + "", view.getFormat());
                                        }
                                        String message = "Access Provider: Attempted to access an entity URL path (" + view + ") using method (" + view.getMethod() + ") for an entity (" + view.getEntityReference() + ") and view (" + view.getViewKey() + ") when there is no " + "access provider to handle the request for prefix (" + view.getEntityReference().getPrefix() + ")";
                                        throw new EntityException(message, view.toString(), 405);
                                    }
                                }
                                catch (FormatUnsupportedException e) {
                                    throw new EntityException("AccessProvider: Method/Format unsupported: Will not handle " + (output ? "output" : "input") + " request for format  " + view.getFormat() + " for this path (" + path + ") for prefix (" + prefix + ") for entity (" + view.getEntityReference() + "), request url (" + view.getOriginalEntityUrl() + ")", view.getEntityReference() + "", 406);
                                }
                            }
                        }
                    }
                    handledReference = view.getEntityReference().toString();
                    this.requestStorage.setRequestValue(RequestStorage.ReservedKeys._requestEntityReference.name(), (Object)handledReference);
                    if (interceptor != null) {
                        interceptor.after(view, req, res);
                    }
                }
                finally {
                    this.requestStorage.reset();
                    this.requestGetter.setRequest(null);
                    this.requestGetter.setResponse(null);
                }
            }
        }
        return handledReference;
    }

    public EntityResponse fireEntityRequestInternal(String reference, String viewKey, String format, Map<String, String> params, Object entity) {
        if (reference == null) {
            throw new IllegalArgumentException("reference must not be null");
        }
        EntityReference ref = new EntityReference(reference);
        EntityView ev = new EntityView();
        ev.setEntityReference(ref);
        if (viewKey != null && !"".equals(viewKey)) {
            ev.setViewKey(viewKey);
        }
        if (format != null && !"".equals(format)) {
            ev.setExtension(format);
        }
        String URL2 = ev.toString();
        HttpRESTUtils.Method method = HttpRESTUtils.Method.GET;
        method = "delete".equals(ev.getViewKey()) ? HttpRESTUtils.Method.DELETE : ("edit".equals(ev.getViewKey()) ? HttpRESTUtils.Method.PUT : ("new".equals(ev.getViewKey()) ? HttpRESTUtils.Method.POST : HttpRESTUtils.Method.GET));
        ByteArrayInputStream data = null;
        if (entity != null) {
            String prefix = ref.getPrefix();
            Inputable inputable = (Inputable)this.entityProviderManager.getProviderByPrefixAndCapability(prefix, Inputable.class);
            if (inputable == null) {
                throw new IllegalArgumentException("This entity (" + ref + ") is not Inputable so there is no reason to provide " + "a non-null entity, you should leave the entity null when firing requests to this entity");
            }
            Outputable outputable = (Outputable)this.entityProviderManager.getProviderByPrefixAndCapability(prefix, Outputable.class);
            if (outputable == null) {
                throw new IllegalArgumentException("This entity (" + ref + ") is not AccessFormats so there is no reason to provide " + "a non-null entity, you should leave the entity null when firing requests to this entity");
            }
            ArrayList<EntityData> entities = new ArrayList<EntityData>();
            entities.add(EntityDataUtils.makeEntityData((EntityReference)ref, (Object)entity));
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            this.entityEncodingManager.formatAndOutputEntity(ref, format, entities, output, null);
            data = new ByteArrayInputStream(output.toByteArray());
        }
        HttpResponse httpResponse = HttpRESTUtils.fireRequest((String)URL2, (HttpRESTUtils.Method)method, params, data, (boolean)true);
        EntityResponse response = new EntityResponse(httpResponse.getResponseCode(), httpResponse.getResponseMessage(), httpResponse.getResponseBody(), httpResponse.getResponseHeaders());
        return response;
    }

    public String handleEntityError(HttpServletRequest req, Throwable error) {
        String msg = "Failure processing entity request (" + req.getPathInfo() + "): " + error.getMessage();
        if (this.entityBrokerManager.getExternalIntegrationProvider() != null) {
            try {
                msg = this.entityBrokerManager.getExternalIntegrationProvider().handleEntityError(req, error);
            }
            catch (UnsupportedOperationException e) {
            }
            catch (Exception e) {
                System.out.println("WARN: EntityRequestHandler: External handleEntityError method failed, using default instead: " + e);
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleAccessProvider(EntityView view, HttpServletRequest req, HttpServletResponse res) {
        EntityViewAccessProvider evAccessProvider = this.entityViewAccessProviderManager.getProvider(view.getEntityReference().getPrefix());
        if (evAccessProvider == null) {
            if (this.accessProviderManager != null) {
                HttpServletAccessProvider httpAccessProvider = this.accessProviderManager.getProvider(view.getEntityReference().getPrefix());
                if (httpAccessProvider == null) {
                    return false;
                }
                ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    HttpServletAccessProvider thing = httpAccessProvider;
                    ClassLoader newClassLoader = thing.getClass().getClassLoader();
                    if (thing instanceof ClassLoaderReporter) {
                        newClassLoader = ((ClassLoaderReporter)thing).getSuitableClassLoader();
                    }
                    Thread.currentThread().setContextClassLoader(newClassLoader);
                    httpAccessProvider.handleAccess(req, res, view.getEntityReference());
                }
                finally {
                    Thread.currentThread().setContextClassLoader(currentClassLoader);
                }
            }
        } else {
            Object[] accessFormats;
            Object[] entityViewKeys;
            if (AccessViews.class.isAssignableFrom(evAccessProvider.getClass()) && (entityViewKeys = ((AccessViews)evAccessProvider).getHandledEntityViews()) != null && !ReflectUtils.contains((Object[])entityViewKeys, (Object)view.getViewKey())) {
                throw new EntityException("Access provider for " + view.getEntityReference().getPrefix() + " will not handle this view (" + view.getViewKey() + "): " + view, view.getEntityReference() + "", 400);
            }
            if (AccessFormats.class.isAssignableFrom(evAccessProvider.getClass()) && (accessFormats = ((AccessFormats)evAccessProvider).getHandledAccessFormats()) != null && !ReflectUtils.contains((Object[])accessFormats, (Object)view.getFormat())) {
                throw new FormatUnsupportedException("Access provider for " + view.getEntityReference().getPrefix() + " will not handle this format (" + view.getFormat() + ")", view.getEntityReference() + "", view.getFormat());
            }
            this.handleClassLoaderAccess(evAccessProvider, req, res, view);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClassLoaderAccess(EntityViewAccessProvider accessProvider, HttpServletRequest req, HttpServletResponse res, EntityView view) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            EntityViewAccessProvider classloaderIndicator = accessProvider;
            ClassLoader newClassLoader = classloaderIndicator.getClass().getClassLoader();
            if (classloaderIndicator instanceof ClassLoaderReporter) {
                newClassLoader = ((ClassLoaderReporter)classloaderIndicator).getSuitableClassLoader();
            }
            Thread.currentThread().setContextClassLoader(newClassLoader);
            accessProvider.handleAccess(view, req, res);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    protected void setNoCacheHeaders(HttpServletResponse res) {
        long currentTime = System.currentTimeMillis();
        res.setDateHeader(ActionReturn.Header.DATE.toString(), currentTime);
        res.setDateHeader(ActionReturn.Header.EXPIRES.toString(), currentTime + 1000L);
        res.setHeader(ActionReturn.Header.CACHE_CONTROL.toString(), "must-revalidate");
        res.addHeader(ActionReturn.Header.CACHE_CONTROL.toString(), "private");
        res.addHeader(ActionReturn.Header.CACHE_CONTROL.toString(), "no-store");
        res.addHeader(ActionReturn.Header.CACHE_CONTROL.toString(), "max-age=0");
        res.addHeader(ActionReturn.Header.CACHE_CONTROL.toString(), "s-maxage=0");
    }

    protected void setResponseHeaders(EntityView view, HttpServletResponse res, Map<String, Object> params, Map<String, String> headers) {
        long currentTime;
        boolean noCache = false;
        long lastModified = currentTime = System.currentTimeMillis();
        if (params != null) {
            String key;
            if (params.containsKey("no-cache") || params.containsKey("nocache")) {
                noCache = true;
            }
            if (params.containsKey(key = "last-modified")) {
                try {
                    lastModified = (Long)params.get(key);
                }
                catch (Exception e) {
                    lastModified = currentTime;
                }
            }
        }
        this.setLastModifiedHeaders(res, null, lastModified);
        res.setDateHeader(ActionReturn.Header.DATE.toString(), currentTime);
        res.setDateHeader(ActionReturn.Header.EXPIRES.toString(), currentTime + 600000L);
        if (noCache) {
            res.setHeader(ActionReturn.Header.CACHE_CONTROL.toString(), "must-revalidate");
            res.addHeader(ActionReturn.Header.CACHE_CONTROL.toString(), "private");
            res.addHeader(ActionReturn.Header.CACHE_CONTROL.toString(), "no-store");
            res.setDateHeader(ActionReturn.Header.EXPIRES.toString(), currentTime + 1000L);
            res.addHeader(ActionReturn.Header.CACHE_CONTROL.toString(), "max-age=0");
            res.addHeader(ActionReturn.Header.CACHE_CONTROL.toString(), "s-maxage=0");
        } else {
            res.setHeader(ActionReturn.Header.CACHE_CONTROL.toString(), "public");
            res.addHeader(ActionReturn.Header.CACHE_CONTROL.toString(), "max-age=600");
            res.addHeader(ActionReturn.Header.CACHE_CONTROL.toString(), "s-maxage=600");
        }
        String prefix = view.getEntityReference().getPrefix();
        EntityProvider provider = this.entityProviderManager.getProviderByPrefix(prefix);
        res.setHeader("x-entity-prefix", prefix);
        res.setHeader("x-entity-reference", view.getEntityReference().toString());
        res.setHeader("x-entity-url", view.getEntityURL());
        res.setHeader("x-entity-format", view.getFormat());
        res.setHeader("x-sdata-handler", provider == null ? EntityBroker.class.getName() : provider.getClass().getName());
        res.setHeader("x-sdata-url", view.getOriginalEntityUrl());
        this.addResponseHeaders(res, headers);
    }

    protected void addResponseHeaders(HttpServletResponse res, Map<String, String> headers) {
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                res.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void setLastModifiedHeaders(HttpServletResponse res, EntityData ed, long lastModifiedTime) {
        long lastModified = System.currentTimeMillis();
        if (ed != null) {
            Long l;
            boolean found = false;
            Object lm = ed.getEntityProperties().get("lastModified");
            if (lm != null && (l = this.makeLastModified(lm)) != null) {
                lastModified = l;
                found = true;
            }
            if (!found && ed.getData() != null) {
                try {
                    lm = ReflectUtils.getInstance().getFieldValue(ed.getData(), "lastModified", EntityLastModified.class);
                    l = this.makeLastModified(lm);
                    if (l != null) {
                        lastModified = l;
                        found = true;
                    }
                }
                catch (FieldnameNotFoundException e1) {}
            }
        } else {
            lastModified = lastModifiedTime;
        }
        res.setDateHeader(ActionReturn.Header.LAST_MODIFIED.toString(), lastModified);
        String currentEtag = String.valueOf(lastModified);
        res.setHeader(ActionReturn.Header.ETAG.toString(), currentEtag);
    }

    private Long makeLastModified(Object lm) {
        Long lastModified = null;
        if (lm != null) {
            Class<?> c = lm.getClass();
            if (Date.class.isAssignableFrom(c)) {
                lastModified = ((Date)lm).getTime();
            } else if (Long.class.isAssignableFrom(c)) {
                lastModified = (Long)lm;
            } else if (String.class.isAssignableFrom(c)) {
                try {
                    lastModified = new Long((String)lm);
                }
                catch (NumberFormatException e) {}
            } else {
                System.out.println("WARN: EntityRequestHandler: Unknown type returned for 'lastModified' (not Date, Long, String): " + lm.getClass() + ", using the default value of current time instead");
            }
        }
        return lastModified;
    }
}

