/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.rest;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.sakaiproject.entitybroker.EntityBrokerManager;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.EntityView;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.extension.ActionReturn;
import org.sakaiproject.entitybroker.entityprovider.extension.EntityData;
import org.sakaiproject.entitybroker.providers.EntityRESTProvider;
import org.sakaiproject.entitybroker.rest.EntityActionsManager;
import org.sakaiproject.entitybroker.rest.EntityEncodingManager;
import org.sakaiproject.entitybroker.rest.EntityHandlerImpl;
import org.sakaiproject.entitybroker.util.EntityResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityRESTProviderBase
implements EntityRESTProvider {
    private static final Logger log = LoggerFactory.getLogger(EntityRESTProviderBase.class);
    private EntityBrokerManager entityBrokerManager;
    private EntityActionsManager entityActionsManager;
    private EntityEncodingManager entityEncodingManager;
    private EntityHandlerImpl entityRequestHandler;

    protected EntityRESTProviderBase() {
    }

    public EntityRESTProviderBase(EntityBrokerManager entityBrokerManager, EntityActionsManager entityActionsManager, EntityEncodingManager entityEncodingManager, EntityHandlerImpl entityRequestHandler) {
        this.entityBrokerManager = entityBrokerManager;
        this.entityActionsManager = entityActionsManager;
        this.entityEncodingManager = entityEncodingManager;
        this.entityRequestHandler = entityRequestHandler;
        this.init();
    }

    public void setEntityBrokerManager(EntityBrokerManager entityBrokerManager) {
        this.entityBrokerManager = entityBrokerManager;
    }

    public void setEntityActionsManager(EntityActionsManager entityActionsManager) {
        this.entityActionsManager = entityActionsManager;
    }

    public void setEntityEncodingManager(EntityEncodingManager entityEncodingManager) {
        this.entityEncodingManager = entityEncodingManager;
    }

    public void setEntityRequestHandler(EntityHandlerImpl entityRequestHandler) {
        this.entityRequestHandler = entityRequestHandler;
    }

    public void init() {
        log.info("EntityRESTProviderBase init");
        this.entityBrokerManager.setEntityRESTProvider((EntityRESTProvider)this);
    }

    public void destroy() {
        log.info("EntityRESTProviderBase destroy");
        this.entityBrokerManager.setEntityRESTProvider(null);
    }

    public Map<String, Object> decodeData(String data, String format) {
        return this.entityEncodingManager.decodeData(data, format);
    }

    public String encodeData(Object data, String format, String name, Map<String, Object> properties) {
        return this.entityEncodingManager.encodeData(data, format, name, properties);
    }

    public void formatAndOutputEntity(EntityReference ref, String format, List<EntityData> entities, OutputStream outputStream, Map<String, Object> params) {
        this.entityEncodingManager.formatAndOutputEntity(ref, format, entities, outputStream, params);
    }

    public ActionReturn handleCustomActionExecution(ActionsExecutable actionProvider, EntityReference ref, String action, Map<String, Object> actionParams, OutputStream outputStream, EntityView view, Map<String, Object> searchParams) {
        return this.entityActionsManager.handleCustomActionExecution(actionProvider, ref, action, actionParams, outputStream, view, searchParams);
    }

    public Object translateInputToEntity(EntityReference ref, String format, InputStream inputStream, Map<String, Object> params) {
        return this.entityEncodingManager.translateInputToEntity(ref, format, inputStream, params);
    }

    public EntityResponse handleEntityRequest(String reference, String viewKey, String format, Map<String, String> params, Object entity) {
        return this.entityRequestHandler.fireEntityRequestInternal(reference, viewKey, format, params, entity);
    }
}

