/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.rest;

import org.sakaiproject.entitybroker.EntityBrokerManager;
import org.sakaiproject.entitybroker.access.EntityViewAccessProviderManager;
import org.sakaiproject.entitybroker.access.HttpServletAccessProviderManager;
import org.sakaiproject.entitybroker.entityprovider.EntityProviderManager;
import org.sakaiproject.entitybroker.entityprovider.EntityProviderMethodStore;
import org.sakaiproject.entitybroker.entityprovider.extension.RequestGetterWrite;
import org.sakaiproject.entitybroker.entityprovider.extension.RequestStorageWrite;
import org.sakaiproject.entitybroker.providers.EntityPropertiesService;
import org.sakaiproject.entitybroker.providers.ExternalIntegrationProvider;
import org.sakaiproject.entitybroker.rest.EntityActionsManager;
import org.sakaiproject.entitybroker.rest.EntityBatchHandler;
import org.sakaiproject.entitybroker.rest.EntityDescriptionManager;
import org.sakaiproject.entitybroker.rest.EntityEncodingManager;
import org.sakaiproject.entitybroker.rest.EntityHandlerImpl;
import org.sakaiproject.entitybroker.rest.EntityRESTProviderBase;
import org.sakaiproject.entitybroker.rest.EntityRedirectsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityBrokerRESTServiceManager {
    private static final Logger log = LoggerFactory.getLogger(EntityBrokerRESTServiceManager.class);
    private static volatile EntityBrokerRESTServiceManager instance;
    private RequestStorageWrite requestStorage;
    private RequestGetterWrite requestGetter;
    private EntityPropertiesService entityPropertiesService;
    private EntityBrokerManager entityBrokerManager;
    private EntityProviderManager entityProviderManager;
    private EntityProviderMethodStore entityProviderMethodStore;
    private HttpServletAccessProviderManager httpServletAccessProviderManager;
    private EntityViewAccessProviderManager entityViewAccessProviderManager;
    private ExternalIntegrationProvider externalIntegrationProvider;
    private EntityActionsManager entityActionsManager;
    private EntityDescriptionManager entityDescriptionManager;
    private EntityEncodingManager entityEncodingManager;
    private EntityRedirectsManager entityRedirectsManager;
    private EntityHandlerImpl entityRequestHandler;
    private EntityBatchHandler entityBatchHandler;
    private EntityRESTProviderBase entityRESTProvider;

    public static EntityBrokerRESTServiceManager getInstance() {
        if (instance == null) {
            instance = new EntityBrokerRESTServiceManager();
        }
        return instance;
    }

    public static void setInstance(EntityBrokerRESTServiceManager ersm) {
        instance = ersm;
    }

    public void setEntityBrokerManager(EntityBrokerManager entityBrokerManager) {
        this.entityBrokerManager = entityBrokerManager;
        this.requestStorage = entityBrokerManager.getRequestStorage();
        this.requestGetter = entityBrokerManager.getRequestGetter();
        this.entityPropertiesService = entityBrokerManager.getEntityPropertiesService();
        this.entityProviderManager = entityBrokerManager.getEntityProviderManager();
        this.entityProviderMethodStore = entityBrokerManager.getEntityProviderMethodStore();
        this.entityViewAccessProviderManager = entityBrokerManager.getEntityViewAccessProviderManager();
        this.externalIntegrationProvider = entityBrokerManager.getExternalIntegrationProvider();
    }

    protected EntityBrokerRESTServiceManager() {
    }

    public EntityBrokerRESTServiceManager(EntityBrokerManager entityBrokerManager) {
        this(entityBrokerManager, null);
    }

    public EntityBrokerRESTServiceManager(EntityBrokerManager entityBrokerManager, HttpServletAccessProviderManager httpServletAccessProviderManager) {
        if (entityBrokerManager == null) {
            throw new IllegalArgumentException("entityBrokerManager cannot be null");
        }
        this.setEntityBrokerManager(entityBrokerManager);
        this.httpServletAccessProviderManager = httpServletAccessProviderManager;
        this.init();
    }

    public void init() {
        log.info("EntityBrokerRESTServiceManager: init()");
        if (this.entityBrokerManager == null || this.requestGetter == null || this.requestStorage == null || this.entityPropertiesService == null || this.entityProviderManager == null || this.entityProviderMethodStore == null || this.externalIntegrationProvider == null || this.entityViewAccessProviderManager == null) {
            throw new IllegalArgumentException("Main services must all be set and non-null!");
        }
        this.entityActionsManager = new EntityActionsManager(this.entityProviderMethodStore);
        this.entityRedirectsManager = new EntityRedirectsManager(this.entityBrokerManager, this.entityProviderMethodStore, this.requestStorage);
        this.entityDescriptionManager = new EntityDescriptionManager(this.entityViewAccessProviderManager, this.httpServletAccessProviderManager, this.entityProviderManager, this.entityPropertiesService, this.entityBrokerManager, this.entityProviderMethodStore);
        this.entityEncodingManager = new EntityEncodingManager(this.entityProviderManager, this.entityBrokerManager);
        this.entityBatchHandler = new EntityBatchHandler(this.entityBrokerManager, this.entityEncodingManager, this.externalIntegrationProvider);
        this.entityRequestHandler = new EntityHandlerImpl(this.entityProviderManager, this.entityBrokerManager, this.entityEncodingManager, this.entityDescriptionManager, this.entityViewAccessProviderManager, this.requestGetter, this.entityActionsManager, this.entityRedirectsManager, this.entityBatchHandler, this.requestStorage);
        this.entityRequestHandler.setAccessProviderManager(this.httpServletAccessProviderManager);
        this.entityRESTProvider = new EntityRESTProviderBase(this.entityBrokerManager, this.entityActionsManager, this.entityEncodingManager, this.entityRequestHandler);
        EntityBrokerRESTServiceManager.setInstance(this);
    }

    public void shutdown() {
        this.destroy();
    }

    public void destroy() {
        log.info("EntityBrokerRESTServiceManager: destroy()");
        EntityBrokerRESTServiceManager.setInstance(null);
        this.entityRESTProvider.destroy();
        this.entityRESTProvider = null;
        this.entityRequestHandler = null;
        this.entityBatchHandler.destroy();
        this.entityBatchHandler = null;
        this.entityEncodingManager = null;
        this.entityDescriptionManager.destroy();
        this.entityDescriptionManager = null;
        this.entityRedirectsManager = null;
        this.entityActionsManager = null;
    }

    public EntityActionsManager getEntityActionsManager() {
        return this.entityActionsManager;
    }

    public EntityDescriptionManager getEntityDescriptionManager() {
        return this.entityDescriptionManager;
    }

    public EntityEncodingManager getEntityEncodingManager() {
        return this.entityEncodingManager;
    }

    public EntityRedirectsManager getEntityRedirectsManager() {
        return this.entityRedirectsManager;
    }

    public EntityHandlerImpl getEntityRequestHandler() {
        return this.entityRequestHandler;
    }

    public EntityBatchHandler getEntityBatchHandler() {
        return this.entityBatchHandler;
    }

    public EntityRESTProviderBase getEntityRESTProvider() {
        return this.entityRESTProvider;
    }
}

