/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.rest;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sakaiproject.entitybroker.EntityBrokerManager;
import org.sakaiproject.entitybroker.entityprovider.EntityProvider;
import org.sakaiproject.entitybroker.entityprovider.EntityProviderMethodStore;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RedirectControllable;
import org.sakaiproject.entitybroker.entityprovider.extension.RequestStorageWrite;
import org.sakaiproject.entitybroker.entityprovider.extension.URLRedirect;
import org.sakaiproject.entitybroker.exception.EntityException;
import org.sakaiproject.entitybroker.exception.EntityNotFoundException;
import org.sakaiproject.entitybroker.exception.FormatUnsupportedException;
import org.sakaiproject.entitybroker.util.TemplateParseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityRedirectsManager {
    private static final Logger log = LoggerFactory.getLogger(EntityRedirectsManager.class);
    private EntityBrokerManager entityBrokerManager;
    private EntityProviderMethodStore entityProviderMethodStore;
    private RequestStorageWrite requestStorage;

    protected EntityRedirectsManager() {
    }

    public EntityRedirectsManager(EntityBrokerManager entityBrokerManager, EntityProviderMethodStore entityProviderMethodStore, RequestStorageWrite requestStorage) {
        this.entityBrokerManager = entityBrokerManager;
        this.entityProviderMethodStore = entityProviderMethodStore;
        this.requestStorage = requestStorage;
    }

    public void setEntityBrokerManager(EntityBrokerManager entityBrokerManager) {
        this.entityBrokerManager = entityBrokerManager;
    }

    public void setEntityProviderMethodStore(EntityProviderMethodStore entityProviderMethodStore) {
        this.entityProviderMethodStore = entityProviderMethodStore;
    }

    public void setRequestStorage(RequestStorageWrite requestStorage) {
        this.requestStorage = requestStorage;
    }

    private String getServletContext() {
        return this.entityBrokerManager.getServletContext();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String checkForTemplateMatch(EntityProvider entityProvider, String incomingURL, String queryString) {
        String prefix = entityProvider.getEntityPrefix();
        String targetURL = null;
        List redirects = this.entityProviderMethodStore.getURLRedirects(prefix);
        if (redirects.size() > 0) {
            TemplateParseUtil.ProcessedTemplate processedTemplate;
            ArrayList<TemplateParseUtil.PreProcessedTemplate> preprocessed = new ArrayList<TemplateParseUtil.PreProcessedTemplate>();
            for (URLRedirect redirect : redirects) {
                preprocessed.add(redirect.preProcessedTemplate);
            }
            try {
                processedTemplate = TemplateParseUtil.parseTemplate((String)incomingURL, preprocessed);
            }
            catch (IllegalArgumentException e) {
                processedTemplate = null;
            }
            if (processedTemplate != null) {
                URLRedirect redirect;
                redirect = null;
                for (Object urlRedirect : redirects) {
                    if (!processedTemplate.template.equals(((URLRedirect)urlRedirect).template)) continue;
                    redirect = urlRedirect;
                    break;
                }
                if (redirect == null) {
                    throw new IllegalStateException("Failed to find a matching redirect for the matched template (" + processedTemplate.template + ") for the incoming URL (" + incomingURL + ")");
                }
                HashMap<String, String> segmentValues = new HashMap<String, String>(processedTemplate.segmentValues);
                segmentValues.put("prefix", prefix);
                if (processedTemplate.extension == null || "".equals(processedTemplate.extension)) {
                    segmentValues.put("extension", "");
                    segmentValues.put("dot-extension", "");
                } else {
                    segmentValues.put("extension", processedTemplate.extension);
                    segmentValues.put("dot-extension", '.' + processedTemplate.extension);
                }
                if (queryString != null && queryString.length() > 2) {
                    segmentValues.put("query-string", queryString);
                    segmentValues.put("question-query-string", '?' + queryString);
                } else {
                    segmentValues.put("query-string", "");
                    segmentValues.put("question-query-string", "");
                }
                for (Map.Entry entry : segmentValues.entrySet()) {
                    try {
                        this.requestStorage.setStoredValue((String)entry.getKey(), entry.getValue());
                    }
                    catch (IllegalArgumentException e) {
                        log.warn("EntityRedirectsManager: Had to skip key (" + (String)entry.getKey() + ") while adding keys to request storage: " + e);
                    }
                }
                if (redirect.controllable) {
                    if (!RedirectControllable.class.isAssignableFrom(entityProvider.getClass())) throw new IllegalStateException("Invalid URL Redirect Object, marked as controllable when this entity broker does not have the capability: " + RedirectControllable.class);
                    targetURL = ((RedirectControllable)entityProvider).handleRedirects(processedTemplate.template, incomingURL, processedTemplate.variableNames.toArray(new String[processedTemplate.variableNames.size()]), segmentValues);
                } else if (redirect.methodName != null) {
                    Object result = null;
                    Method method = redirect.getMethod();
                    if (method == null) {
                        Method method2;
                        try {
                            method2 = entityProvider.getClass().getMethod(redirect.methodName, redirect.methodArgTypes);
                        }
                        catch (SecurityException e1) {
                            throw new RuntimeException("Fatal error trying to get URL redirect method: " + redirect, e1);
                        }
                        catch (NoSuchMethodException e1) {
                            throw new RuntimeException("Fatal error trying to get URL redirect method: " + redirect, e1);
                        }
                        redirect.setMethod(method2);
                    }
                    Object[] args = new Object[redirect.methodArgTypes.length];
                    for (int i = 0; i < redirect.methodArgTypes.length; ++i) {
                        Class argType = redirect.methodArgTypes[i];
                        if (String.class.equals((Object)argType)) {
                            args[i] = incomingURL;
                            continue;
                        }
                        if (String[].class.equals((Object)argType)) {
                            args[i] = processedTemplate.variableNames.toArray(new String[processedTemplate.variableNames.size()]);
                            continue;
                        }
                        if (!Map.class.equals((Object)argType)) throw new IllegalStateException("URL redirect method (" + redirect + ") contains an invalid methodArgTypes, only valid types allowed: String, String[], Map");
                        args[i] = segmentValues;
                    }
                    try {
                        void var12_17;
                        result = var12_17.invoke((Object)entityProvider, args);
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException("Fatal error trying to execute URL redirect method: " + redirect, e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Fatal error trying to execute URL redirect method: " + redirect, e);
                    }
                    catch (InvocationTargetException e) {
                        String reference = incomingURL;
                        if (e.getCause() == null) throw new RuntimeException("Fatal error trying to execute URL redirect method: " + redirect, e);
                        if (e.getCause().getClass().isAssignableFrom(IllegalArgumentException.class)) {
                            throw new IllegalArgumentException(e.getCause().getMessage() + " (rethrown)", e.getCause());
                        }
                        if (e.getCause().getClass().isAssignableFrom(EntityNotFoundException.class)) {
                            throw new EntityNotFoundException(e.getCause().getMessage() + " (rethrown)", reference, e.getCause());
                        }
                        if (e.getCause().getClass().isAssignableFrom(FormatUnsupportedException.class)) {
                            String format = ((FormatUnsupportedException)e.getCause()).format;
                            throw new FormatUnsupportedException(e.getCause().getMessage() + " (rethrown)", e.getCause(), reference, format);
                        }
                        if (e.getCause().getClass().isAssignableFrom(UnsupportedOperationException.class)) {
                            throw new UnsupportedOperationException(e.getCause().getMessage() + " (rethrown)", e.getCause());
                        }
                        if (e.getCause().getClass().isAssignableFrom(EntityException.class)) {
                            int code = ((EntityException)e.getCause()).responseCode;
                            throw new EntityException(e.getCause().getMessage() + " (rethrown)", reference, code);
                        }
                        if (e.getCause().getClass().isAssignableFrom(IllegalStateException.class)) {
                            throw new IllegalStateException(e.getCause().getMessage() + " (rethrown)", e.getCause());
                        }
                        if (!e.getCause().getClass().isAssignableFrom(SecurityException.class)) throw new RuntimeException("Fatal error trying to execute URL redirect method: " + redirect, e);
                        throw new SecurityException(e.getCause().getMessage() + " (rethrown)", e.getCause());
                    }
                    if (result == null) return null;
                    targetURL = result.toString();
                } else {
                    if (redirect.outgoingTemplate == null) throw new IllegalStateException("Invalid URL Redirect Object, could not determine operation: " + redirect);
                    try {
                        targetURL = TemplateParseUtil.mergeTemplate((String)redirect.outgoingTemplate, segmentValues);
                    }
                    catch (IllegalArgumentException e) {
                        targetURL = null;
                        log.warn("EntityRedirectsManager: Unable to merge target template (" + redirect.outgoingTemplate + ") with available variables: " + e);
                    }
                }
            }
        }
        if (targetURL == null) return targetURL;
        if (targetURL.length() <= 0) return targetURL;
        if (targetURL.charAt(0) == '/') return targetURL;
        if (targetURL.startsWith("http:")) return targetURL;
        if (!targetURL.startsWith("https:")) return this.getServletContext() + '/' + targetURL;
        return targetURL;
    }
}

