/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.text.StringEscapeUtils;
import org.azeckoski.reflectutils.ClassFields;
import org.azeckoski.reflectutils.ConstructorUtils;
import org.azeckoski.reflectutils.ReflectUtils;
import org.azeckoski.reflectutils.StringUtils;
import org.azeckoski.reflectutils.map.ArrayOrderedMap;
import org.azeckoski.reflectutils.transcoders.HTMLTranscoder;
import org.azeckoski.reflectutils.transcoders.JSONTranscoder;
import org.azeckoski.reflectutils.transcoders.Transcoder;
import org.azeckoski.reflectutils.transcoders.XMLTranscoder;
import org.sakaiproject.entitybroker.EntityBrokerManager;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.EntityView;
import org.sakaiproject.entitybroker.entityprovider.EntityProviderManager;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityFieldRequired;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Createable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Deleteable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.DepthLimitable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.InputTranslatable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Inputable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.OutputFormattable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.OutputSerializable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Outputable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Updateable;
import org.sakaiproject.entitybroker.entityprovider.extension.EntityData;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.entitybroker.exception.EntityEncodingException;
import org.sakaiproject.entitybroker.exception.EntityException;
import org.sakaiproject.entitybroker.exception.FormatUnsupportedException;
import org.sakaiproject.entitybroker.util.EntityDataUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityEncodingManager {
    private static final Logger log = LoggerFactory.getLogger(EntityEncodingManager.class);
    public static final String ENTITY_REFERENCE = "entityReference";
    public static final String ENTITY_ID = "entityId";
    public static final String ENTITY_URL = "entityURL";
    public static final String ENTITY_TITLE = "entityTitle";
    public static final String ENTITY_PREFIX = "entityPrefix";
    public static final String COLLECTION = "_collection";
    public static final String BATCH_PREFIX = "/batch?_refs=";
    public static final String[] HANDLED_INPUT_FORMATS = new String[]{"xml", "json", "html"};
    public static final String[] HANDLED_OUTPUT_FORMATS = new String[]{"xml", "json", "jsonp", "html", "form"};
    public static final String JSON_CALLBACK_PARAM = "jsonCallback";
    public static final String JSON_DEFAULT_CALLBACK = "jsonEntityFeed";
    protected static final String XML_HEADER_PREFIX = "<?";
    protected static final String XML_HEADER_SUFFIX = "?>";
    protected static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
    protected static final String XHTML_HEADER = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n  <title>{title}</title>\n</head>\n<body>\n";
    protected static final String XHTML_FOOTER = "</body>\n</html>\n";
    private EntityProviderManager entityProviderManager;
    private EntityBrokerManager entityBrokerManager;
    protected static final String DATA_KEY = "data";
    private Map<String, Transcoder> transcoders;

    protected EntityEncodingManager() {
    }

    public EntityEncodingManager(EntityProviderManager entityProviderManager, EntityBrokerManager entityBrokerManager) {
        this.entityProviderManager = entityProviderManager;
        this.entityBrokerManager = entityBrokerManager;
    }

    public void setEntityProviderManager(EntityProviderManager entityProviderManager) {
        this.entityProviderManager = entityProviderManager;
    }

    public void setEntityBrokerManager(EntityBrokerManager entityBrokerManager) {
        this.entityBrokerManager = entityBrokerManager;
    }

    public void formatAndOutputEntity(EntityReference ref, String format, List<EntityData> entities, OutputStream outputStream, Map<String, Object> params) {
        if (ref == null || format == null || outputStream == null) {
            throw new IllegalArgumentException("ref, format, and output cannot be null");
        }
        String prefix = ref.getPrefix();
        Outputable outputable = (Outputable)this.entityProviderManager.getProviderByPrefixAndCapability(prefix, Outputable.class);
        if (outputable != null) {
            Object[] outputFormats = outputable.getHandledOutputFormats();
            if (outputFormats == null || ReflectUtils.contains((Object[])outputFormats, (Object)format)) {
                boolean handled = false;
                OutputSerializable serializable = (OutputSerializable)this.entityProviderManager.getProviderByPrefixAndCapability(prefix, OutputSerializable.class);
                if (serializable != null) {
                    if (entities == null) {
                        entities = this.entityBrokerManager.getEntitiesData(ref, new Search(), params);
                    }
                    if (!entities.isEmpty()) {
                        Object sample = this.entityBrokerManager.getSampleEntityObject(prefix, null);
                        Class entityType = Object.class;
                        if (sample != null) {
                            entityType = sample.getClass();
                        }
                        for (EntityData entityData : entities) {
                            Object entity = entityData.getData();
                            if (entity == null || !entityType.isAssignableFrom(entity.getClass())) continue;
                            try {
                                entity = serializable.makeSerializableObject(ref, entity);
                                entityData.setData(entity);
                            }
                            catch (Exception e) {
                                throw new RuntimeException("Failure while attempting to serialize the object from (" + entity + ") for ref(" + ref + "): " + e.getMessage(), e);
                            }
                        }
                    }
                }
                try {
                    OutputFormattable formattable = (OutputFormattable)this.entityProviderManager.getProviderByPrefixAndCapability(prefix, OutputFormattable.class);
                    if (formattable != null) {
                        formattable.formatOutput(ref, format, entities, params, outputStream);
                        handled = true;
                    }
                }
                catch (FormatUnsupportedException e) {
                    handled = false;
                }
                if (!handled) {
                    this.internalOutputFormatter(ref, format, entities, params, outputStream, null);
                }
            } else {
                throw new FormatUnsupportedException("Outputable restriction for " + prefix + " blocked handling this format (" + format + ")", ref + "", format);
            }
        }
    }

    public Object translateInputToEntity(EntityReference ref, String format, InputStream inputStream, Map<String, Object> params) {
        if (ref == null || format == null || inputStream == null) {
            throw new IllegalArgumentException("ref, format, and inputStream cannot be null");
        }
        Object entity = null;
        String prefix = ref.getPrefix();
        Inputable inputable = (Inputable)this.entityProviderManager.getProviderByPrefixAndCapability(prefix, Inputable.class);
        if (inputable != null) {
            Object[] inputFormats = inputable.getHandledInputFormats();
            if (inputFormats == null || ReflectUtils.contains((Object[])inputFormats, (Object)format)) {
                boolean handled = false;
                try {
                    InputTranslatable translatable = (InputTranslatable)this.entityProviderManager.getProviderByPrefixAndCapability(prefix, InputTranslatable.class);
                    if (translatable != null) {
                        entity = translatable.translateFormattedData(ref, format, inputStream, params);
                        handled = true;
                    }
                }
                catch (FormatUnsupportedException e) {
                    handled = false;
                }
                if (!handled) {
                    entity = this.internalInputTranslator(ref, format, inputStream, null);
                }
                if (entity == null) {
                    throw new EntityEncodingException("Unable to translate entity (" + ref + ") with format (" + format + "), translated entity object was null", ref + "");
                }
            } else {
                throw new FormatUnsupportedException("Inputable restriction for " + prefix + " blocked handling this format (" + format + ")", ref + "", format);
            }
        }
        return entity;
    }

    public boolean validateFormat(String data, String format) {
        boolean valid = false;
        if (data == null || format == null) {
            throw new IllegalArgumentException("Cannot validate format when the data (" + data + ") OR the format (" + format + ") are null");
        }
        data = data.trim();
        if ("xml".equals(format)) {
            if (data.startsWith("<") && data.endsWith(">")) {
                valid = true;
            }
        } else if ("json".equals(format)) {
            if (data.startsWith("{") && data.endsWith("}")) {
                valid = true;
            }
        } else if ("html".equals(format)) {
            if (data.startsWith("<") && data.endsWith(">")) {
                valid = true;
            }
        } else {
            valid = true;
        }
        return valid;
    }

    public Object internalInputTranslator(EntityReference ref, String format, InputStream input, HttpServletRequest req) {
        Object entity = null;
        Inputable inputable = (Inputable)this.entityProviderManager.getProviderByPrefixAndCapability(ref.getPrefix(), Inputable.class);
        if (inputable != null) {
            Object current = this.entityBrokerManager.getSampleEntityObject(ref.getPrefix(), ref.getId());
            if (current != null) {
                if ("html".equals(format) || format == null || "".equals(format)) {
                    if (req != null) {
                        Map params = req.getParameterMap();
                        if (params != null && params.size() > 0) {
                            entity = current;
                            try {
                                ReflectUtils.getInstance().populateFromParams(entity, params);
                            }
                            catch (RuntimeException e) {
                                throw new EntityEncodingException("Unable to populate bean for ref (" + ref + ") from request: " + e.getMessage(), ref + "", (Throwable)e);
                            }
                        }
                        throw new EntityException("No request params for html input request (there must be at least one) for reference: " + ref, ref.toString(), 400);
                    }
                } else {
                    Object o;
                    if (input == null) {
                        throw new EntityException("No input for input translation (input cannot be null) for reference: " + ref, ref.toString(), 400);
                    }
                    String data = StringUtils.makeStringFromInputStream((InputStream)input);
                    Map decoded = null;
                    try {
                        decoded = this.decodeData(data, format);
                    }
                    catch (IllegalArgumentException iae) {
                        throw new EntityEncodingException("No encoder available for the given format (" + format + "), ref=" + ref + ":" + iae.getMessage(), ref.toString(), (Throwable)iae);
                    }
                    catch (UnsupportedOperationException uoe) {
                        throw new EntityEncodingException("Failure during internal input encoding of entity: " + ref + " to format (" + format + "):" + uoe.getMessage(), ref.toString(), (Throwable)uoe);
                    }
                    entity = current;
                    if (decoded.size() == 1 && decoded.containsKey(ref.getPrefix()) && (o = decoded.get(ref.getPrefix())) instanceof Map) {
                        decoded = (Map)o;
                    }
                    try {
                        ReflectUtils.getInstance().populate(entity, decoded);
                    }
                    catch (RuntimeException e) {
                        throw new EntityEncodingException("Unable to populate bean for ref (" + ref + ") from data: " + decoded + ":" + e.getMessage(), ref + "", (Throwable)e);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("This entity (" + ref + ") does not allow input translation");
        }
        if (entity == null) {
            throw new EntityException("Unable to encode entity from input for reference: " + ref, ref.toString(), 400);
        }
        return entity;
    }

    public void internalOutputFormatter(EntityReference ref, String format, List<EntityData> entities, Map<String, Object> params, OutputStream output, EntityView view) {
        if (format == null) {
            format = "html";
        }
        if (!ReflectUtils.contains((Object[])HANDLED_OUTPUT_FORMATS, (Object)format)) {
            throw new FormatUnsupportedException("Internal output formatter cannot handle format (" + format + ") for ref (" + ref + ")", ref + "", format);
        }
        if (view == null) {
            view = this.entityBrokerManager.makeEntityView(ref, null, null);
        }
        if (entities == null) {
            entities = this.entityBrokerManager.getEntitiesData(ref, new Search(), params);
        }
        if (entities.isEmpty()) {
            log.debug("EntityEncodingManager: No entities to format (" + format + ") and output for ref (" + ref + ")");
        }
        String replacementEncoding = null;
        if ("form".equals(format) && !((Boolean)this.entityBrokerManager.getExternalIntegrationProvider().getConfigurationSetting("entitybroker.batch.enable", (Object)false)).booleanValue()) {
            String msg = "FORM editing is not enabled because the batch provider is disabled by sakai config: entitybroker.batch.enable=false. Enable this config setting with entitybroker.batch.enable=true to enable batch handling. See SAK-22619 for details.";
            replacementEncoding = "<div style=\"font-weight:bold;color:red;\">" + msg + "</div>";
        }
        String encoded = null;
        if ("list".equals(view.getViewKey()) || ref.getId() == null) {
            StringBuilder sb = new StringBuilder(40);
            if ("html".equals(format) || "form".equals(format)) {
                sb.append("<h1>" + ref.getPrefix() + COLLECTION + "</h1>\n");
            } else if ("json".equals(format) || "jsonp".equals(format)) {
                sb.append("{\"entityPrefix\": \"" + ref.getPrefix() + "\", \"" + ref.getPrefix() + COLLECTION + "\": [\n");
            } else if ("xml".equals(format)) {
                sb.append("<" + ref.getPrefix() + COLLECTION + " " + ENTITY_PREFIX + "=\"" + ref.getPrefix() + "\">\n");
            } else {
                sb.append(ref.getPrefix() + COLLECTION + "\n");
            }
            int encodedEntities = 0;
            if (replacementEncoding != null) {
                sb.append(replacementEncoding);
            } else {
                for (EntityData entity : entities) {
                    try {
                        String encode = this.encodeEntity(ref.getPrefix(), format, entity, view);
                        if (encode.length() <= 3) continue;
                        if (("json".equals(format) || "jsonp".equals(format)) && encodedEntities > 0) {
                            sb.append(",");
                        }
                        sb.append(encode);
                        ++encodedEntities;
                    }
                    catch (RuntimeException e) {
                        throw new EntityEncodingException("Failure during internal output encoding of entity set on entity: " + ref, ref.toString(), (Throwable)e);
                    }
                }
            }
            if ("html".equals(format) || "form".equals(format)) {
                sb.append("\n<b>Collection size:</b> " + encodedEntities + "\n");
            } else if ("json".equals(format) || "jsonp".equals(format)) {
                sb.append("\n]}");
            } else if ("xml".equals(format)) {
                sb.append("</" + ref.getPrefix() + COLLECTION + ">");
            } else {
                sb.append("\nSize: " + encodedEntities + "\n");
            }
            encoded = sb.toString();
        } else {
            EntityData toEncode = (EntityData)entities.get(0);
            if (replacementEncoding != null) {
                encoded = replacementEncoding;
            } else {
                if (toEncode == null) {
                    throw new EntityEncodingException("Failed to encode data for entity (" + ref + "), entity object to encode could not be found (null object in list)", ref.toString());
                }
                try {
                    encoded = this.encodeEntity(ref.getPrefix(), format, toEncode, view);
                }
                catch (RuntimeException e) {
                    throw new EntityEncodingException("Failure during internal output encoding of entity: " + ref, ref.toString(), (Throwable)e);
                }
            }
        }
        if ("form".equals(format)) {
            String title = view.getViewKey() + ":" + ref;
            encoded = XML_HEADER + XHTML_HEADER.replace("{title}", title) + encoded + XHTML_FOOTER;
        } else if ("xml".equals(format)) {
            encoded = XML_HEADER + encoded;
        } else if ("jsonp".equals(format)) {
            String callback = JSON_DEFAULT_CALLBACK;
            if (params != null && params.containsKey(JSON_CALLBACK_PARAM)) {
                callback = this.sanitizeJsonCallback(params.get(JSON_CALLBACK_PARAM));
            }
            encoded = callback + "(" + encoded + ")";
        }
        try {
            byte[] b = encoded.getBytes("UTF-8");
            output.write(b);
        }
        catch (UnsupportedEncodingException e) {
            throw new EntityEncodingException("Failed to encode UTF-8: " + ref, ref.toString(), (Throwable)e);
        }
        catch (IOException e) {
            throw new EntityEncodingException("Failed to encode into output stream: " + ref, ref.toString(), (Throwable)e);
        }
    }

    public String encodeEntity(String prefix, String format, EntityData entityData, EntityView view) {
        if (prefix == null || format == null) {
            throw new IllegalArgumentException("prefix and format must not be null");
        }
        if (entityData == null && !"form".equals(format)) {
            throw new IllegalArgumentException("entityData to encode must not be null for prefix (" + prefix + ") and format (" + format + ")");
        }
        String encoded = "";
        if ("html".equals(format)) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("  <div style='padding-left:1em;'>\n");
            if (entityData == null) {
                sb.append("NO DATA to encode");
            } else {
                sb.append("    <div style='font-weight:bold;'>" + StringEscapeUtils.escapeHtml4((String)entityData.getDisplayTitle()) + "</div>\n");
                sb.append("    <table border='1'>\n");
                sb.append("      <caption style='font-weight:bold;'>Entity Data</caption>\n");
                if (!entityData.isDataOnly()) {
                    sb.append("      <tr><td>entityReference</td><td>" + StringEscapeUtils.escapeHtml4((String)entityData.getEntityReference()) + "</td></tr>\n");
                    sb.append("      <tr><td>entityURL</td><td>" + StringEscapeUtils.escapeHtml4((String)entityData.getEntityURL()) + "</td></tr>\n");
                    if (entityData.getEntityRef() != null) {
                        sb.append("      <tr><td>entityPrefix</td><td>" + StringEscapeUtils.escapeHtml4((String)entityData.getEntityRef().getPrefix()) + "</td></tr>\n");
                        if (entityData.getEntityRef().getId() != null) {
                            sb.append("      <tr><td>entityID</td><td>" + StringEscapeUtils.escapeHtml4((String)entityData.getEntityRef().getId()) + "</td></tr>\n");
                        }
                    }
                }
                if (entityData.getData() != null) {
                    sb.append("      <tr><td>entity-type</td><td>" + entityData.getData().getClass().getName() + "</td></tr>\n");
                    sb.append("      <tr><td colspan='2'>Data:<br/>\n");
                    sb.append(this.encodeData(entityData.getData(), "html", null, null));
                    sb.append("      </td></tr>\n");
                } else {
                    sb.append("      <tr><td>entity-object</td><td><i>null</i></td></tr>\n");
                }
                sb.append("    </table>\n");
                Map props = entityData.getEntityProperties();
                if (!props.isEmpty()) {
                    sb.append("    <table border='1'>\n");
                    sb.append("      <caption style='font-weight:bold;'>Properties</caption>\n");
                    for (Map.Entry entry : props.entrySet()) {
                        sb.append("      <tr><td>" + StringEscapeUtils.escapeHtml4((String)((String)entry.getKey())) + "</td><td>" + StringEscapeUtils.escapeHtml4((String)entry.getValue().toString()) + "</td></tr>\n");
                    }
                    sb.append("    </table>\n");
                }
            }
            sb.append("  </div>\n");
            encoded = sb.toString();
        } else if ("form".equals(format)) {
            if (view == null) {
                throw new IllegalArgumentException("the view must be set for FORM handling and generation");
            }
            boolean handle = false;
            boolean createable = this.entityProviderManager.getProviderByPrefixAndCapability(prefix, Createable.class) != null;
            boolean updateable = this.entityProviderManager.getProviderByPrefixAndCapability(prefix, Updateable.class) != null;
            boolean deleteable = this.entityProviderManager.getProviderByPrefixAndCapability(prefix, Deleteable.class) != null;
            String viewKey = view.getViewKey();
            if ("new".equals(viewKey) && createable) {
                handle = true;
            } else if ("edit".equals(viewKey) && updateable) {
                handle = true;
            } else if ("delete".equals(viewKey) && deleteable) {
                handle = true;
            } else if (("list".equals(viewKey) || "show".equals(viewKey)) && (updateable || deleteable)) {
                handle = true;
            }
            if (handle) {
                String prefixUrl = this.entityBrokerManager.getServletContext();
                if ("list".equals(viewKey) && entityData != null && entityData.getEntityId() != null) {
                    view = view.copy();
                    view.setEntityReference(new EntityReference(prefix, entityData.getEntityId()));
                }
                StringBuilder sb = new StringBuilder(300);
                String formName = prefix + "-" + (entityData != null ? entityData.getEntityRef().getId() : "xxx");
                sb.append("  <div style='font-weight:bold;'>");
                sb.append(StringEscapeUtils.escapeHtml4((String)(entityData != null ? entityData.getDisplayTitle() : prefix)));
                if (createable && !"new".equals(viewKey)) {
                    sb.append(" (<a href='" + prefixUrl + view.getEntityURL("new", "form") + "'>NEW</a>) ");
                }
                if (deleteable && !"new".equals(viewKey)) {
                    String formAction = this.makeFormViewUrl(prefixUrl, "delete", view) + "&_method=DELETE";
                    sb.append("\n  <form name='" + formName + "-del' action='" + formAction + "' style='margin:0px; display:inline;' method='post'>\n");
                    sb.append("    <input type='submit' value='DEL' />\n");
                    sb.append("  </form>\n");
                }
                sb.append("</div>\n");
                if (!"delete".equals(viewKey)) {
                    Object entity;
                    if ((entityData == null || entityData.getData() == null) && ("list".equals(viewKey) || "show".equals(viewKey))) {
                        throw new EntityEncodingException("Unable to find an entity to encode into the update form; prefix=" + prefix + ":" + view, prefix);
                    }
                    Object object = entity = entityData != null ? entityData.getData() : null;
                    if (entity == null) {
                        String id;
                        String string = id = view.getEntityReference() != null ? view.getEntityReference().getId() : null;
                        if (id == null) {
                            String string2 = id = entityData != null ? entityData.getEntityId() : null;
                        }
                        if ((entity = this.entityBrokerManager.getSampleEntityObject(prefix, id)) == null) {
                            throw new EntityEncodingException("Unable to find entity data to create form from using prefix=" + prefix + ",id=" + id, prefix);
                        }
                    }
                    Class<?> entityClass = entity.getClass();
                    String formAction = "new".equals(viewKey) ? this.makeFormViewUrl(prefixUrl, "new", view) : this.makeFormViewUrl(prefixUrl, "edit", view) + "&_method=PUT";
                    sb.append("  <form name='" + formName + "-edit' action='" + formAction + "' style='margin:0px;' method='post'>\n");
                    sb.append("    <table border='1'>\n");
                    ClassFields cf = ReflectUtils.getInstance().analyzeClass(entityClass);
                    Map fieldValues = ReflectUtils.getInstance().getObjectValues(entity);
                    Map readTypes = cf.getFieldTypes(ClassFields.FieldsFilter.SERIALIZABLE);
                    Map writeTypes = cf.getFieldTypes(ClassFields.FieldsFilter.WRITEABLE);
                    HashSet requiredFieldNames = new HashSet(cf.getFieldNamesWithAnnotation(EntityFieldRequired.class));
                    String idFieldName = EntityDataUtils.getEntityIdField(entityClass);
                    if (idFieldName != null && !"new".equals(viewKey)) {
                        writeTypes.remove(idFieldName);
                    }
                    HashMap entityTypes = new HashMap(readTypes);
                    entityTypes.putAll(writeTypes);
                    ArrayList keys = new ArrayList(entityTypes.keySet());
                    Collections.sort(keys);
                    for (int i = 0; i < keys.size(); ++i) {
                        String sVal;
                        Object value;
                        String fieldName = (String)keys.get(i);
                        Class type = (Class)entityTypes.get(fieldName);
                        boolean read = true;
                        boolean write = false;
                        if (!readTypes.containsKey(fieldName)) {
                            read = false;
                            write = true;
                        } else {
                            write = writeTypes.containsKey(fieldName);
                        }
                        boolean required = requiredFieldNames.contains(fieldName);
                        String typeName = type.getName();
                        if (String.class.getName().equals(typeName)) {
                            typeName = "string";
                        } else if (Boolean.class.getName().equals(typeName)) {
                            typeName = "boolean";
                        } else if (Integer.class.getName().equals(typeName)) {
                            typeName = "int";
                        } else if (Long.class.getName().equals(typeName)) {
                            typeName = "long";
                        }
                        sb.append("      <tr><td>" + (i + 1) + ")&nbsp;</td><td style='font-weight:bold;'>" + fieldName + "</td><td>" + typeName + "</td><td>");
                        if (read && write) {
                            value = fieldValues.get(fieldName);
                            sVal = "";
                            if (value != null) {
                                sVal = (String)ReflectUtils.getInstance().convert(value, String.class);
                            }
                            sb.append("<input type='text' name=\"" + fieldName + "\" value=\"" + StringEscapeUtils.escapeHtml4((String)sVal) + "\" />");
                        } else if (write) {
                            sb.append("<input type='text' name='" + fieldName + "' />");
                        } else if (read) {
                            value = fieldValues.get(fieldName);
                            sVal = "";
                            if (value != null) {
                                sVal = (String)ReflectUtils.getInstance().convert(value, String.class);
                            }
                            sb.append(StringEscapeUtils.escapeHtml4((String)sVal));
                        }
                        if (required) {
                            sb.append(" <b style='color:red;'>*</b> ");
                        }
                        sb.append("</td></tr>\n");
                    }
                    sb.append("    </table>\n");
                    sb.append("    <input type='submit' value='SAVE' />\n");
                    sb.append("  </form>\n");
                }
                encoded = sb.toString();
            }
        } else {
            Object toEncode = entityData;
            ArrayOrderedMap entityProps = new ArrayOrderedMap();
            if (entityData != null && entityData.getData() != null) {
                if (entityData.isDataOnly()) {
                    toEncode = entityData.getData();
                    entityProps.putAll(entityData.getEntityProperties());
                } else {
                    if (ConstructorUtils.isClassBean(entityData.getData().getClass())) {
                        toEncode = entityData.getData();
                        entityProps.put(ENTITY_REFERENCE, entityData.getEntityReference());
                        entityProps.put(ENTITY_URL, entityData.getEntityURL());
                        if (entityData.getEntityRef().getId() != null) {
                            entityProps.put(ENTITY_ID, entityData.getEntityRef().getId());
                        }
                        if (entityData.isDisplayTitleSet()) {
                            entityProps.put(ENTITY_TITLE, entityData.getDisplayTitle());
                        }
                    }
                    entityProps.putAll(entityData.getEntityProperties());
                }
            }
            try {
                encoded = this.encodeData(toEncode, format, prefix, (Map<String, Object>)entityProps);
            }
            catch (IllegalArgumentException e) {
                encoded = prefix + " : " + entityData;
            }
        }
        return encoded;
    }

    protected String makeFormViewUrl(String contextUrl, String viewKey, EntityView view) {
        if (viewKey == null || "".equals(viewKey)) {
            viewKey = "show";
        }
        return contextUrl + BATCH_PREFIX + contextUrl + view.getEntityURL(viewKey, null);
    }

    public void setTranscoders(Map<String, Transcoder> transcoders) {
        this.transcoders = transcoders;
    }

    public void setTranscoder(Transcoder transcoder) {
        String format;
        if (transcoder == null) {
            throw new IllegalArgumentException("transcoder cannot be null");
        }
        if (this.transcoders == null) {
            this.getTranscoder("xml");
        }
        if ((format = transcoder.getHandledFormat()) != null && transcoder != null) {
            this.transcoders.put(format, transcoder);
        }
    }

    public Transcoder getTranscoder(String format) {
        Transcoder transcoder;
        if (this.transcoders == null) {
            this.transcoders = new HashMap<String, Transcoder>();
            JSONTranscoder jt = new JSONTranscoder(true, true, false);
            jt.setMaxLevel(this.entityBrokerManager.getMaxJSONLevel());
            this.transcoders.put(jt.getHandledFormat(), (Transcoder)jt);
            this.transcoders.put("jsonp", (Transcoder)jt);
            XMLTranscoder xt = new XMLTranscoder(true, true, false, false);
            this.transcoders.put(xt.getHandledFormat(), (Transcoder)xt);
            HTMLTranscoder ht = new HTMLTranscoder();
            this.transcoders.put(ht.getHandledFormat(), (Transcoder)ht);
        }
        if ((transcoder = this.transcoders.get(format)) == null) {
            throw new IllegalArgumentException("Failed to find a transcoder for format, none exists, cannot encode or decode data for format: " + format);
        }
        return transcoder;
    }

    public String encodeData(Object data, String format, String name, Map<String, Object> properties) {
        if (format == null) {
            format = "xml";
        }
        String encoded = "";
        if (data != null) {
            DepthLimitable provider;
            int maxDepth = 0;
            if (name != null && (provider = (DepthLimitable)this.entityProviderManager.getProviderByPrefixAndCapability(name, DepthLimitable.class)) != null) {
                maxDepth = provider.getMaxDepth();
            }
            Transcoder transcoder = this.getTranscoder(format);
            try {
                encoded = maxDepth == 0 ? transcoder.encode(data, name, properties) : transcoder.encode(data, name, properties, maxDepth);
            }
            catch (RuntimeException e) {
                throw new UnsupportedOperationException("Failure encoding data (" + data + ") of type (" + data.getClass() + "): " + e.getMessage(), e);
            }
        }
        return encoded;
    }

    protected String sanitizeJsonCallback(Object param) {
        if (param == null || !(param instanceof String)) {
            return JSON_DEFAULT_CALLBACK;
        }
        return "/**/" + param.toString();
    }

    public Map<String, Object> decodeData(String data, String format) {
        if (format == null) {
            format = "xml";
        }
        Object decoded = new ArrayOrderedMap();
        if (data != null && !"".equals(data)) {
            Map decode = null;
            Transcoder transcoder = this.getTranscoder(format);
            try {
                decode = transcoder.decode(data);
                if (decode instanceof Map) {
                    decoded = decode;
                } else {
                    decoded.put(DATA_KEY, decode);
                }
            }
            catch (RuntimeException e) {
                throw new UnsupportedOperationException("Failure decoding data (" + data + ") for format (" + format + "): " + e.getMessage(), e);
            }
        }
        return decoded;
    }
}

