/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.rest;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.azeckoski.reflectutils.ArrayUtils;
import org.azeckoski.reflectutils.map.ArrayOrderedMap;
import org.sakaiproject.entitybroker.EntityBrokerManager;
import org.sakaiproject.entitybroker.EntityView;
import org.sakaiproject.entitybroker.entityprovider.EntityProvider;
import org.sakaiproject.entitybroker.exception.EntityException;
import org.sakaiproject.entitybroker.providers.ExternalIntegrationProvider;
import org.sakaiproject.entitybroker.rest.EntityDescriptionManager;
import org.sakaiproject.entitybroker.rest.EntityEncodingManager;
import org.sakaiproject.entitybroker.rest.EntityHandlerImpl;
import org.sakaiproject.entitybroker.rest.caps.BatchProvider;
import org.sakaiproject.entitybroker.util.http.EntityHttpServletRequest;
import org.sakaiproject.entitybroker.util.http.EntityHttpServletResponse;
import org.sakaiproject.entitybroker.util.http.HttpClientWrapper;
import org.sakaiproject.entitybroker.util.http.HttpRESTUtils;
import org.sakaiproject.entitybroker.util.http.HttpResponse;
import org.sakaiproject.entitybroker.util.http.URLData;
import org.sakaiproject.entitybroker.util.request.RequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityBatchHandler {
    private static final Logger log = LoggerFactory.getLogger(EntityBatchHandler.class);
    public static final String CONFIG_BATCH_ENABLE = "entitybroker.batch.enable";
    public static final boolean CONFIG_BATCH_DEFAULT = false;
    private static final String HEADER_BATCH_STATUS = "batchStatus";
    private static final String HEADER_BATCH_ERRORS = "batchErrors";
    private static final String HEADER_BATCH_MAPPING = "batchMapping";
    private static final String HEADER_BATCH_URLS = "batchURLs";
    private static final String HEADER_BATCH_REFS = "batchRefs";
    private static final String HEADER_BATCH_KEYS = "batchKeys";
    private static final String HEADER_BATCH_METHOD = "batchMethod";
    private static final String UNREFERENCED_PARAMS = "NoRefs";
    public static final String REFS_PARAM_NAME = "_refs";
    private static final String UNIQUE_DATA_PREFIX = "X-XqReplaceQX-X-";
    private static String INTERNAL_SERVER_ERROR_STATUS_STRING = "500";
    private EntityProvider batchEP = null;
    private EntityBrokerManager entityBrokerManager;
    private EntityEncodingManager entityEncodingManager;
    private ExternalIntegrationProvider externalIntegrationProvider;
    private EntityHandlerImpl entityRequestHandler;

    public EntityBatchHandler() {
    }

    public EntityBatchHandler(EntityBrokerManager entityBrokerManager, EntityEncodingManager entityEncodingManager, ExternalIntegrationProvider externalIntegrationProvider) {
        this.entityBrokerManager = entityBrokerManager;
        this.entityEncodingManager = entityEncodingManager;
        this.externalIntegrationProvider = externalIntegrationProvider;
        this.init();
    }

    public void init() {
        if (((Boolean)this.externalIntegrationProvider.getConfigurationSetting(CONFIG_BATCH_ENABLE, (Object)false)).booleanValue()) {
            this.batchEP = new BatchProvider(){

                public String getEntityPrefix() {
                    return "batch";
                }

                public String getBaseName() {
                    return this.getEntityPrefix();
                }

                public ClassLoader getResourceClassLoader() {
                    return EntityDescriptionManager.class.getClassLoader();
                }

                public String[] getHandledOutputFormats() {
                    return EntityEncodingManager.HANDLED_OUTPUT_FORMATS;
                }
            };
            this.entityBrokerManager.getEntityProviderManager().registerEntityProvider(this.batchEP);
        }
    }

    public void destroy() {
        log.info("EntityBatchHandler: destroy()");
        if (this.batchEP != null) {
            try {
                this.entityBrokerManager.getEntityProviderManager().unregisterEntityProvider(this.batchEP);
            }
            catch (RuntimeException e) {
                log.warn("EntityBatchHandler: Unable to unregister the batch provider: " + e);
            }
        }
    }

    public void setEntityBrokerManager(EntityBrokerManager entityBrokerManager) {
        this.entityBrokerManager = entityBrokerManager;
    }

    public void setEntityEncodingManager(EntityEncodingManager entityEncodingManager) {
        this.entityEncodingManager = entityEncodingManager;
    }

    public void setExternalIntegrationProvider(ExternalIntegrationProvider externalIntegrationProvider) {
        this.externalIntegrationProvider = externalIntegrationProvider;
    }

    public void setEntityRequestHandler(EntityHandlerImpl entityRequestHandler) {
        this.entityRequestHandler = entityRequestHandler;
    }

    private String getServletContext() {
        return this.entityBrokerManager.getServletContext();
    }

    private String getServletBatch() {
        return this.getServletContext() + "/batch";
    }

    public void handleBatch(EntityView view, HttpServletRequest req, HttpServletResponse res) {
        if (view == null || req == null || res == null) {
            throw new IllegalArgumentException("Could not process batch: invalid arguments, no args can be null (view=" + view + ",req=" + req + ",res=" + res + ")");
        }
        if (!((Boolean)this.externalIntegrationProvider.getConfigurationSetting(CONFIG_BATCH_ENABLE, (Object)false)).booleanValue()) {
            try {
                res.sendError(501, "Batch provider is disabled by sakai config: entitybroker.batch.enable=false. Enable this config setting with entitybroker.batch.enable=true to enable batch handling. See SAK-22619 for details.");
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot send error: res.sendError: " + e, e);
            }
            return;
        }
        String reqMethod = req.getMethod() == null ? EntityView.Method.GET.name() : req.getMethod().toUpperCase().trim();
        HttpRESTUtils.Method method = HttpRESTUtils.makeMethodFromString((String)reqMethod);
        if (!(HttpRESTUtils.Method.GET.equals((Object)method) || HttpRESTUtils.Method.POST.equals((Object)method) || HttpRESTUtils.Method.PUT.equals((Object)method) || HttpRESTUtils.Method.DELETE.equals((Object)method))) {
            throw new IllegalArgumentException("Cannot batch " + reqMethod + " request method, cannot continue processing request: " + view);
        }
        res.setHeader(HEADER_BATCH_METHOD, method.name());
        String format = view.getFormat();
        String servletContext = this.getServletContext();
        Object[] refs = this.getRefsOrFail(req);
        Map<String, Map<String, String[]>> referencedParams = this.extractReferenceParams(req, method, (String[])refs);
        HashSet<Object> processedRefsAndURLs = new HashSet<Object>();
        ArrayOrderedMap dataMap = new ArrayOrderedMap();
        ArrayOrderedMap results = new ArrayOrderedMap();
        boolean successOverall = false;
        boolean failure = false;
        for (int i = 0; i < refs.length; ++i) {
            String refKey = "ref" + i;
            String reference = refs[i];
            if (reference == null || "".equals(reference)) continue;
            if (!HttpRESTUtils.Method.POST.equals((Object)method) && processedRefsAndURLs.contains(reference)) {
                log.warn("EntityBatchHandler: Found a duplicate reference, this will not be processed: " + reference);
                continue;
            }
            Object entityURL = reference;
            if (!reference.startsWith("/") && !reference.startsWith("http://")) {
                entityURL = servletContext + "/" + reference;
            }
            if (reference.startsWith("/batch") || reference.startsWith(this.getServletBatch())) {
                throw new EntityException("Failure processing batch request, batch reference (" + reference + ") (" + (String)entityURL + ") appears to be another batch URL (contains /batch), failure in batch request: " + view, "/batch", 400);
            }
            HttpClientWrapper clientWrapper = null;
            ResponseBase result = null;
            URLData ud = new URLData((String)entityURL);
            if (servletContext.equals(ud.contextPath)) {
                if (ud.pathInfo == null || "".equals(ud.pathInfo)) continue;
                boolean success = false;
                try {
                    this.entityBrokerManager.parseReference(ud.pathInfo);
                    success = true;
                }
                catch (IllegalArgumentException e) {
                    String errorMessage = "Failure parsing direct entityURL (" + (String)entityURL + ") from reference (" + reference + ") from path (" + ud.pathInfo + "): " + e.getMessage() + ":" + e.getCause();
                    log.warn("EntityBatchHandler: " + errorMessage);
                    result = new ResponseError(reference, (String)entityURL, errorMessage);
                }
                if (success) {
                    if (HttpRESTUtils.Method.GET.equals((Object)method)) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(servletContext);
                        sb.append(ud.pathInfoNoExtension);
                        sb.append('.');
                        sb.append(format);
                        if (ud.query.length() > 0) {
                            sb.append('?');
                            sb.append(ud.query);
                        }
                        entityURL = sb.toString();
                    }
                    if (!HttpRESTUtils.Method.POST.equals((Object)method) && processedRefsAndURLs.contains(entityURL)) {
                        log.warn("EntityBatchHandler: Found a duplicate entityURL, this will not be processed: " + (String)entityURL);
                        continue;
                    }
                    result = this.generateInternalResult(refKey, reference, (String)entityURL, req, res, method, referencedParams);
                }
            } else {
                entityURL = this.makeFullExternalURL(req, (String)entityURL);
                if (clientWrapper == null) {
                    clientWrapper = HttpRESTUtils.makeReusableHttpClient((boolean)false, (int)0, (Cookie[])req.getCookies());
                }
                result = this.generateExternalResult(refKey, reference, (String)entityURL, method, referencedParams, clientWrapper);
            }
            if (result == null) {
                successOverall = false;
                failure = true;
                throw new IllegalStateException("Somehow the result is null, this should never happen, fatal error");
            }
            if (result instanceof ResponseError) {
                successOverall = false;
                failure = true;
            } else {
                int status = result.getStatus();
                if (status >= 200 && status < 300) {
                    successOverall = true;
                }
                if (status == 204) {
                    ((ResponseResult)result).content = null;
                    ((ResponseResult)result).data = null;
                } else {
                    String content = ((ResponseResult)result).content;
                    String dataKey = this.checkContent(format, content, refKey, (HashMap<String, String>)dataMap);
                    ((ResponseResult)result).setDataKey(dataKey);
                }
            }
            processedRefsAndURLs.add(reference);
            processedRefsAndURLs.add(entityURL);
            results.put(refKey, result);
        }
        int overallStatus = 200;
        if (failure || !successOverall) {
            overallStatus = 500;
        }
        if (results.size() == 0) {
            throw new EntityException("Invalid request which resulted in no valid references to batch process, original _refs=(" + ArrayUtils.arrayToString((Object[])refs) + ")", "/batch", 400);
        }
        Object overallData = this.entityEncodingManager.encodeData(results, format, "refs", null);
        if ("xml".equals(format)) {
            overallData = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n" + (String)overallData;
        }
        overallData = this.reintegrateDataContent(format, (HashMap<String, String>)dataMap, (String)overallData);
        this.applyOverallHeaders(res, (Map<String, ResponseBase>)results);
        try {
            res.getWriter().write((String)overallData);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to encode data for overall response: " + e.getMessage(), e);
        }
        RequestUtils.setResponseEncoding((String)format, (HttpServletResponse)res);
        res.setStatus(overallStatus);
    }

    private Map<String, Map<String, String[]>> extractReferenceParams(HttpServletRequest req, HttpRESTUtils.Method method, String[] refs) {
        ArrayOrderedMap referencedParams = null;
        if (HttpRESTUtils.Method.POST.equals((Object)method) || HttpRESTUtils.Method.PUT.equals((Object)method)) {
            referencedParams = new ArrayOrderedMap();
            Map params = req.getParameterMap();
            referencedParams.put((Object)UNREFERENCED_PARAMS, (Object)new ArrayOrderedMap(params.size()));
            for (int i = 0; i < refs.length; ++i) {
                String refKey = "ref" + i + ".";
                referencedParams.put((Object)refKey, (Object)new ArrayOrderedMap(params.size()));
            }
            for (Map.Entry entry : params.entrySet()) {
                if (REFS_PARAM_NAME.equals(entry.getKey())) continue;
                boolean found = false;
                for (String refKey : referencedParams.keySet()) {
                    if (!((String)entry.getKey()).startsWith(refKey)) continue;
                    String key = (String)entry.getKey();
                    if ((key = key.substring(refKey.length())).length() == 0) {
                        log.warn("EntityBatchHandler: Skipping invalid reference param name (" + (String)entry.getKey() + "), name must start with ref#. but MUST have the actual name of the param after that");
                    } else {
                        ((Map)referencedParams.get((Object)refKey)).put(key, (String[])entry.getValue());
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                ((Map)referencedParams.get((Object)UNREFERENCED_PARAMS)).put((String)entry.getKey(), (String[])entry.getValue());
            }
        }
        return referencedParams;
    }

    private void applyOverallHeaders(HttpServletResponse res, Map<String, ResponseBase> results) {
        int count = 0;
        for (Map.Entry<String, ResponseBase> entry : results.entrySet()) {
            String refKey = entry.getKey();
            ResponseBase refResp = entry.getValue();
            if (count == 0) {
                res.setHeader(HEADER_BATCH_KEYS, refKey);
                res.setHeader(HEADER_BATCH_REFS, refResp.getReference());
                res.setHeader(HEADER_BATCH_URLS, refResp.getEntityURL());
                res.setHeader(HEADER_BATCH_MAPPING, refKey + "=" + refResp.getReference());
            } else {
                res.addHeader(HEADER_BATCH_KEYS, refKey);
                res.addHeader(HEADER_BATCH_REFS, refResp.getReference());
                res.addHeader(HEADER_BATCH_URLS, refResp.getEntityURL());
                res.addHeader(HEADER_BATCH_MAPPING, refKey + "=" + refResp.getReference());
            }
            if (refResp.isFailure()) {
                res.addHeader(HEADER_BATCH_ERRORS, refKey);
                res.addHeader(HEADER_BATCH_STATUS, INTERNAL_SERVER_ERROR_STATUS_STRING);
            } else {
                int status = ((ResponseResult)refResp).getStatus();
                res.addHeader(HEADER_BATCH_STATUS, Integer.toString(status));
            }
            ++count;
        }
    }

    private ResponseBase generateInternalResult(String refKey, String reference, String entityURL, HttpServletRequest req, HttpServletResponse res, HttpRESTUtils.Method method, Map<String, Map<String, String[]>> referencedParams) {
        ResponseBase result = null;
        ResponseError error = null;
        EntityHttpServletRequest entityRequest = new EntityHttpServletRequest(req, entityURL);
        entityRequest.setContextPath("");
        if (HttpRESTUtils.Method.POST.equals((Object)method) || HttpRESTUtils.Method.PUT.equals((Object)method)) {
            entityRequest.clearParameters();
            entityRequest.setParameters(referencedParams.get(UNREFERENCED_PARAMS));
            String key = refKey + ".";
            if (referencedParams.containsKey(key)) {
                entityRequest.setParameters(referencedParams.get(key));
            }
            entityRequest.setParameters(entityRequest.pathQueryParams);
        } else {
            entityRequest.removeParameter(REFS_PARAM_NAME);
        }
        entityRequest.setUseRealDispatcher(false);
        EntityHttpServletResponse entityResponse = new EntityHttpServletResponse(res);
        boolean redirected = false;
        do {
            try {
                this.entityRequestHandler.handleEntityAccess((HttpServletRequest)entityRequest, (HttpServletResponse)entityResponse, null);
                redirected = false;
            }
            catch (Exception e) {
                String errorMessage = "Failure attempting to process reference (" + reference + ") for url (" + entityURL + "): " + e.getMessage() + ":" + e;
                log.warn("EntityBatchHandler: " + errorMessage);
                error = new ResponseError(reference, entityURL, errorMessage);
                break;
            }
            if (!entityResponse.isRedirected()) continue;
            String redirectURL = entityResponse.getRedirectedUrl();
            if (redirectURL == null || redirectURL.length() == 0) {
                throw new EntityException("Failed to find redirect URL when redirect was indicated by status (" + entityResponse.getStatus() + ") for reference (" + reference + ")", reference);
            }
            entityURL = redirectURL;
            if (entityURL.startsWith(this.getServletContext())) {
                entityRequest.setPathString(redirectURL);
                entityResponse.reset();
                redirected = true;
                continue;
            }
            redirected = false;
        } while (redirected);
        if (error == null && entityResponse != null) {
            String cookies;
            for (Cookie cookie : cookies = entityResponse.getCookies()) {
                res.addCookie(cookie);
            }
            int status = entityResponse.getStatus();
            result = new ResponseResult(reference, entityURL, status, entityResponse.getHeaders(), entityResponse.getContentAsString());
        } else {
            result = error;
        }
        return result;
    }

    private ResponseBase generateExternalResult(String refKey, String reference, String entityURL, HttpRESTUtils.Method method, Map<String, Map<String, String[]>> referencedParams, HttpClientWrapper clientWrapper) {
        ResponseBase result = null;
        ResponseError error = null;
        boolean guaranteeSSL = false;
        ArrayOrderedMap params = null;
        if (referencedParams != null && !referencedParams.isEmpty()) {
            String key;
            Map<String, String[]> rp;
            params = new ArrayOrderedMap(referencedParams.size());
            Map<String, String[]> urp = referencedParams.get(UNREFERENCED_PARAMS);
            for (Map.Entry<String, String[]> entry : urp.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue() == null || entry.getValue().length == 0 ? "" : entry.getValue()[0];
                params.put(name, value);
            }
            if ((HttpRESTUtils.Method.POST.equals((Object)method) || HttpRESTUtils.Method.PUT.equals((Object)method)) && (rp = referencedParams.get(key = refKey + ".")) != null) {
                for (Map.Entry<String, String[]> entry : rp.entrySet()) {
                    String name = entry.getKey();
                    String value = entry.getValue() == null || entry.getValue().length == 0 ? "" : entry.getValue()[0];
                    params.put(name, value);
                }
            }
        }
        HttpResponse httpResponse = null;
        try {
            httpResponse = HttpRESTUtils.fireRequest((HttpClientWrapper)clientWrapper, (String)entityURL, (HttpRESTUtils.Method)method, (Map)params, null, (boolean)guaranteeSSL);
        }
        catch (RuntimeException e) {
            String errorMessage = "Failure attempting to process external URL (" + entityURL + ") from reference (" + reference + "): " + e.getMessage() + ":" + e;
            log.warn("EntityBatchHandler: " + errorMessage);
            error = new ResponseError(reference, entityURL, errorMessage);
        }
        result = error == null && httpResponse != null ? new ResponseResult(reference, entityURL, httpResponse.getResponseCode(), httpResponse.getResponseHeaders(), httpResponse.getResponseBody()) : error;
        return result;
    }

    private String makeFullExternalURL(HttpServletRequest req, String entityURL) {
        if (((String)entityURL).startsWith("/")) {
            String serverName = "localhost";
            try {
                InetAddress i4 = Inet4Address.getLocalHost();
                serverName = i4.getHostAddress();
            }
            catch (UnknownHostException e) {
                serverName = "localhost";
            }
            int serverPort = req.getLocalPort();
            String protocol = req.getScheme();
            if (protocol == null || "".equals(protocol)) {
                protocol = "http";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(protocol);
            sb.append("://");
            sb.append(serverName);
            if (serverPort > 0) {
                sb.append(":");
                sb.append(serverPort);
            }
            entityURL = sb.toString() + (String)entityURL;
        }
        return entityURL;
    }

    private String[] getRefsOrFail(HttpServletRequest req) {
        String[] refs = req.getParameterValues(REFS_PARAM_NAME);
        if (refs == null || refs.length == 0) {
            throw new IllegalArgumentException("_refs parameter must be set (e.g. /direct/batch.json?_refs=/sites/popular,/sites/newest)");
        }
        if (refs.length == 1) {
            String presplit;
            String separator = req.getParameter("separator");
            if (separator == null || "".equals(separator)) {
                separator = ",";
            }
            if ((refs = (presplit = refs[0]).split(separator)) == null || refs.length == 0) {
                throw new IllegalStateException("Failure attempting to process the _refs (" + presplit + ") listing, could not get the final list of refs out by splitting using the separator (" + separator + ")");
            }
        }
        if (refs.length <= 0) {
            throw new IllegalArgumentException("_refs parameter must be set and there must be at least 1 reference (e.g. /direct/batch.json?_refs=/sites/popular,/sites/newest)");
        }
        return refs;
    }

    private String reintegrateDataContent(String format, HashMap<String, String> dataMap, String overallData) {
        StringBuilder sb = new StringBuilder();
        int curLoc = 0;
        for (Map.Entry<String, String> entry : dataMap.entrySet()) {
            int keyLoc;
            if (entry.getKey() == null || "".equals(entry.getKey())) continue;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if ("xml".equals(format)) {
                value = "\n" + (String)value;
            } else if ("json".equals(format)) {
                key = "\"" + (String)key + "\"";
            }
            if ((keyLoc = overallData.indexOf((String)key)) <= -1) continue;
            sb.append(overallData.subSequence(curLoc, keyLoc));
            sb.append((String)value);
            curLoc = keyLoc + ((String)key).length();
        }
        sb.append(overallData.subSequence(curLoc, overallData.length()));
        return sb.toString();
    }

    private String checkContent(String format, String content, String refKey, HashMap<String, String> dataMap) {
        String dataKey = null;
        if (content != null && !"".equals(content = content.trim()) && this.entityEncodingManager.validateFormat(content, format)) {
            if ("xml".equals(format) || "html".equals(format)) {
                content = this.stripOutXMLTag(content, "<?", "?>");
                content = this.stripOutXMLTag(content, "<!DOCTYPE", ">");
            }
            dataKey = UNIQUE_DATA_PREFIX + refKey;
            dataMap.put(dataKey, content);
        }
        return dataKey;
    }

    public String stripOutXMLTag(String content, String startTag, String endTag) {
        int end;
        int pos;
        if (startTag != null && !"".equals(startTag) && endTag != null && !"".equals(endTag) && (pos = content.indexOf(startTag)) >= 0 && (end = content.indexOf(endTag, pos)) > 0) {
            StringBuilder sb = new StringBuilder();
            if (pos > 0) {
                sb.append(content.substring(0, pos));
            }
            sb.append(content.substring(end + endTag.length()));
            content = sb.toString().trim();
        }
        return content;
    }

    public static class ResponseResult
    extends ResponseBase {
        public Map<String, String[]> headers;
        public String data;
        public String content;

        public void setDataKey(String dataKey) {
            if (dataKey != null) {
                this.data = dataKey;
                this.content = null;
            }
        }

        public ResponseResult(String reference, String entityURL, int status, Map<String, String[]> headers) {
            this.reference = reference;
            this.entityURL = entityURL;
            this.status = status;
            this.headers = headers;
            this.failure = false;
            this.content = null;
            this.data = null;
        }

        public ResponseResult(String reference, String entityURL, int status, Map<String, String[]> headers, String content) {
            this.reference = reference;
            this.entityURL = entityURL;
            this.status = status;
            this.headers = headers;
            this.content = content;
            this.data = null;
            this.failure = false;
        }
    }

    public static class ResponseError
    extends ResponseBase {
        public String error;

        public ResponseError(String reference, String entityURL, String errorMessage) {
            this.reference = reference;
            this.entityURL = entityURL;
            this.error = errorMessage;
            this.failure = true;
            this.status = 500;
        }
    }

    public static class ResponseBase {
        public String reference;
        public String entityURL;
        public int status;
        public transient boolean failure = false;

        public String getReference() {
            return this.reference;
        }

        public String getEntityURL() {
            return this.entityURL;
        }

        public int getStatus() {
            return this.status;
        }

        public boolean isFailure() {
            return this.failure;
        }
    }
}

