/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.providers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.entityprovider.CoreEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityCustomAction;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.CRUDable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.CollectionResolvable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Describeable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Inputable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Outputable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RedirectDefinable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RequestAware;
import org.sakaiproject.entitybroker.entityprovider.extension.RequestGetter;
import org.sakaiproject.entitybroker.entityprovider.extension.TemplateMap;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.entitybroker.providers.model.EntitySession;
import org.sakaiproject.entitybroker.util.AbstractEntityProvider;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionEntityProvider
extends AbstractEntityProvider
implements CoreEntityProvider,
CRUDable,
CollectionResolvable,
Inputable,
Outputable,
RequestAware,
Describeable,
RedirectDefinable,
ActionsExecutable {
    public static String AUTH_USERNAME = "_username";
    public static String AUTH_PASSWORD = "_password";
    public SessionManager sessionManager;
    public UserDirectoryService userDirectoryService;
    public static String PREFIX = "session";
    private RequestGetter requestGetter;

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public String getEntityPrefix() {
        return PREFIX;
    }

    public TemplateMap[] defineURLMappings() {
        return new TemplateMap[]{new TemplateMap("/{prefix}/{id}/norefresh", "/{prefix}/{id}{dot-extension}?auto=true"), new TemplateMap("/{prefix}/current/norefresh", "/{prefix}/current{dot-extension}?auto=true")};
    }

    @EntityCustomAction(action="current", viewKey="list")
    public Object getCurrentSession() {
        EntitySession es = null;
        Session s = this.sessionManager.getCurrentSession();
        if (s != null) {
            es = new EntitySession(s);
            es.setId(null);
        }
        return es;
    }

    public boolean entityExists(String id) {
        if (id == null) {
            return false;
        }
        if ("".equals(id)) {
            return true;
        }
        Session s = this.sessionManager.getSession(id);
        return s != null;
    }

    public Object getSampleEntity() {
        return new EntitySession();
    }

    public Object getEntity(EntityReference ref) {
        if (ref.getId() == null) {
            return new EntitySession();
        }
        String sessionId = ref.getId();
        Session s = this.sessionManager.getSession(sessionId);
        if (s == null) {
            throw new IllegalArgumentException("Cannot find session with id: " + sessionId);
        }
        EntitySession es = new EntitySession(s);
        return es;
    }

    public String createEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        EntitySession es = (EntitySession)entity;
        String newSessionId = null;
        Session currentSession = null;
        if (this.developerHelperService.isUserAdmin(this.developerHelperService.getCurrentUserReference())) {
            if (es.getUserId() == null || es.getUserId().equals("")) {
                throw new IllegalArgumentException("UserId must be set when creating a session");
            }
            User u = null;
            try {
                u = this.userDirectoryService.getUser(es.getUserId());
            }
            catch (UserNotDefinedException e) {
                throw new IllegalArgumentException("Invalid userId provided in session object, could not find user with that id: " + es.getUserId());
            }
            currentSession = this.sessionManager.startSession(es.getId());
            currentSession.setUserEid(u.getEid());
            currentSession.setUserId(u.getId());
        } else {
            HttpServletRequest req = this.requestGetter.getRequest();
            if (req == null) {
                throw new IllegalStateException("Only super admins can create sessions without using a REST request currently");
            }
            String username = req.getParameter(AUTH_USERNAME);
            String password = req.getParameter(AUTH_PASSWORD);
            if (username == null || username.equals("") || password == null || password.equals("")) {
                throw new IllegalArgumentException("A session entity cannot be created without providing the username and password, the username must be provided as '_username' and the password as '_password' in the POST");
            }
            User u = this.userDirectoryService.authenticate(username, password);
            if (u == null) {
                throw new SecurityException("The username or password provided were invalid, could not authenticate user (" + username + ") to create a session");
            }
            currentSession = this.sessionManager.getCurrentSession();
            if (currentSession == null) {
                currentSession = this.sessionManager.startSession();
            }
            currentSession.setUserId(u.getId());
            currentSession.setUserEid(u.getEid());
        }
        if (es.getMaxInactiveInterval() > 0) {
            currentSession.setMaxInactiveInterval(es.getMaxInactiveInterval());
        }
        newSessionId = currentSession.getId();
        return newSessionId;
    }

    public void updateEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        String sessionId = ref.getId();
        if (sessionId == null) {
            throw new IllegalArgumentException("Cannot update session, No sessionId in provided reference: " + ref);
        }
        Session s = this.sessionManager.getSession(sessionId);
        if (s == null) {
            throw new IllegalArgumentException("Cannot find session to update with id: " + sessionId);
        }
        this.checkSessionOwner(s);
        s.setActive();
    }

    public void deleteEntity(EntityReference ref, Map<String, Object> params) {
        String sessionId = ref.getId();
        if (sessionId == null) {
            throw new IllegalArgumentException("Cannot update session, No sessionId in provided reference: " + ref);
        }
        Session s = this.sessionManager.getSession(sessionId);
        if (s == null) {
            throw new IllegalArgumentException("Cannot find session with id: " + sessionId);
        }
        this.checkSessionOwner(s);
        s.invalidate();
    }

    public List<?> getEntities(EntityReference ref, Search search) {
        ArrayList<EntitySession> sessions = new ArrayList<EntitySession>();
        EntitySession es = (EntitySession)this.getCurrentSession();
        if (es != null) {
            sessions.add(es);
        }
        return sessions;
    }

    public String[] getHandledInputFormats() {
        return new String[]{"html", "xml", "json"};
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"html", "xml", "json", "form"};
    }

    public void setRequestGetter(RequestGetter requestGetter) {
        this.requestGetter = requestGetter;
    }

    private void checkSessionOwner(Session s) {
        String currentUser = this.developerHelperService.getCurrentUserReference();
        String currentUserId = this.developerHelperService.getUserIdFromRef(currentUser);
        if (this.developerHelperService.isUserAdmin(currentUser)) {
            return;
        }
        String userId = s.getUserId();
        if (userId.equals(currentUserId)) {
            return;
        }
        throw new SecurityException("Current user (" + currentUser + ") cannot modify this session: " + s.getId() + ", they are not the owner or not an admin");
    }
}

