/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.providers.model;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.azeckoski.reflectutils.annotations.ReflectIgnoreClassFields;
import org.azeckoski.reflectutils.annotations.ReflectTransient;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.Member;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.authz.api.RoleAlreadyDefinedException;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityFieldRequired;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityId;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityLastModified;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityOwner;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntitySummary;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityTitle;
import org.sakaiproject.entitybroker.providers.model.Owner;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.user.api.User;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ReflectIgnoreClassFields(value={"createdBy", "modifiedBy", "containingSite", "members", "properties", "propertiesEdit", "roles"})
public class EntityGroup
implements Group {
    private static final long serialVersionUID = 7526472295622776147L;
    @EntityId
    private String id;
    @EntityFieldRequired
    private String siteId;
    @EntityFieldRequired
    private String title;
    private String description;
    private String joinerRole;
    private String maintainRole;
    private String providerGroupId;
    private String owner;
    private long lastModified;
    private String[] userRoles;
    public Map<String, String> props;
    private transient Group group;

    public Map<String, String> getProps() {
        if (this.props == null) {
            this.props = new HashMap();
        }
        return this.props;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    public void setProperty(String key, String value) {
        if (this.props == null) {
            this.props = new HashMap();
        }
        this.props.put(key, value);
    }

    public String getProperty(String key) {
        if (this.props == null) {
            return null;
        }
        return (String)this.props.get(key);
    }

    public EntityGroup() {
    }

    public EntityGroup(String siteId, String title, String description, String maintainRole, String providerGroupId, String owner) {
        this.siteId = siteId;
        this.title = title;
        this.description = description;
        this.maintainRole = maintainRole;
        this.providerGroupId = providerGroupId;
        this.owner = owner;
        this.lastModified = System.currentTimeMillis();
        this.getUserRoles();
    }

    public EntityGroup(Group group) {
        this.group = group;
        Site site = group.getContainingSite();
        this.siteId = site.getId();
        this.id = group.getId();
        this.title = group.getTitle();
        this.description = group.getDescription();
        this.joinerRole = site.getJoinerRole();
        this.maintainRole = group.getMaintainRole();
        this.providerGroupId = group.getProviderGroupId();
        this.owner = group.getCreatedBy() == null ? null : group.getCreatedBy().getId();
        this.lastModified = group.getModifiedTime() == null ? System.currentTimeMillis() : group.getModifiedTime().getTime();
        this.getUserRoles();
        ResourceProperties rp = group.getProperties();
        Iterator iterator = rp.getPropertyNames();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            String value = rp.getProperty(name);
            this.setProperty(name, value);
        }
    }

    @EntityId
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @EntityOwner
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Owner getSiteOwner() {
        Owner owner = null;
        if (this.group != null) {
            User user = this.group.getCreatedBy();
            owner = new Owner(user.getId(), user.getDisplayName());
        } else {
            owner = new Owner(this.owner, this.owner);
        }
        return owner;
    }

    @EntityLastModified
    public long getLastModified() {
        if (this.group != null) {
            this.lastModified = this.group.getModifiedTime() == null ? this.lastModified : this.group.getModifiedTime().getTime();
        }
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        throw new UnsupportedOperationException("Cannot set the last modified time manually");
    }

    @EntityTitle
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @EntitySummary
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getJoinerRole() {
        return this.joinerRole;
    }

    public void setJoinerRole(String joinerRole) {
        this.joinerRole = joinerRole;
    }

    public String getMaintainRole() {
        return this.maintainRole;
    }

    public void setMaintainRole(String maintainRole) {
        this.maintainRole = maintainRole;
    }

    public String getProviderGroupId() {
        return this.providerGroupId;
    }

    public void setProviderGroupId(String providerGroupId) {
        this.providerGroupId = providerGroupId;
    }

    public String[] getUserRoles() {
        if (this.userRoles == null) {
            if (this.group == null) {
                this.userRoles = new String[]{this.maintainRole, this.joinerRole};
            } else {
                Set roles = this.group.getRoles();
                this.userRoles = new String[roles.size()];
                int i = 0;
                for (Role role : roles) {
                    this.userRoles[i] = role.getId();
                    ++i;
                }
            }
        }
        return this.userRoles;
    }

    public void setUserRoles(String[] userRoles) {
        this.userRoles = userRoles;
    }

    public User getCreatedBy() {
        if (this.group != null) {
            return this.group.getCreatedBy();
        }
        throw new UnsupportedOperationException();
    }

    public Time getCreatedTime() {
        if (this.group != null) {
            return this.group.getCreatedTime();
        }
        throw new UnsupportedOperationException();
    }

    public Date getCreatedDate() {
        if (this.group != null) {
            return this.group.getCreatedDate();
        }
        throw new UnsupportedOperationException();
    }

    public User getModifiedBy() {
        if (this.group != null) {
            return this.group.getModifiedBy();
        }
        throw new UnsupportedOperationException();
    }

    public Time getModifiedTime() {
        if (this.group != null) {
            return this.group.getModifiedTime();
        }
        throw new UnsupportedOperationException();
    }

    public Date getModifiedDate() {
        if (this.group != null) {
            return this.group.getModifiedDate();
        }
        throw new UnsupportedOperationException();
    }

    public ResourcePropertiesEdit getPropertiesEdit() {
        if (this.group != null) {
            return this.group.getPropertiesEdit();
        }
        throw new UnsupportedOperationException();
    }

    public boolean isActiveEdit() {
        if (this.group != null) {
            return this.group.isActiveEdit();
        }
        throw new UnsupportedOperationException();
    }

    public ResourceProperties getProperties() {
        if (this.group != null) {
            return this.group.getProperties();
        }
        throw new UnsupportedOperationException();
    }

    public String getReference() {
        return "/site/" + this.siteId + "/group/" + this.id;
    }

    public String getReference(String arg0) {
        return this.getReference();
    }

    public String getUrl() {
        if (this.group != null) {
            return this.group.getUrl();
        }
        throw new UnsupportedOperationException();
    }

    public String getUrl(String arg0) {
        if (this.group != null) {
            return this.group.getUrl(arg0);
        }
        throw new UnsupportedOperationException();
    }

    @ReflectTransient
    public Element toXml(Document arg0, Stack arg1) {
        if (this.group != null) {
            return this.group.toXml(arg0, arg1);
        }
        throw new UnsupportedOperationException();
    }

    public int compareTo(Object o) {
        if (this.group != null) {
            return this.group.compareTo(o);
        }
        throw new UnsupportedOperationException();
    }

    public void addMember(String arg0, String arg1, boolean arg2, boolean arg3) {
        if (this.group != null) {
            this.group.addMember(arg0, arg1, arg2, arg3);
        }
        throw new UnsupportedOperationException();
    }

    public Role addRole(String arg0) throws RoleAlreadyDefinedException {
        if (this.group != null) {
            return this.group.addRole(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public Role addRole(String arg0, Role arg1) throws RoleAlreadyDefinedException {
        if (this.group != null) {
            return this.group.addRole(arg0, arg1);
        }
        throw new UnsupportedOperationException();
    }

    public Member getMember(String arg0) {
        if (this.group != null) {
            return this.group.getMember(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public Set getMembers() {
        if (this.group != null) {
            return this.group.getMembers();
        }
        throw new UnsupportedOperationException();
    }

    public Role getRole(String arg0) {
        if (this.group != null) {
            return this.group.getRole(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public Set getRoles() {
        if (this.group != null) {
            return this.group.getRoles();
        }
        throw new UnsupportedOperationException();
    }

    public Set getRolesIsAllowed(String arg0) {
        if (this.group != null) {
            return this.group.getRolesIsAllowed(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public Role getUserRole(String arg0) {
        if (this.group != null) {
            return this.group.getUserRole(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public Set getUsers() {
        if (this.group != null) {
            return this.group.getUsers();
        }
        throw new UnsupportedOperationException();
    }

    public Set getUsersHasRole(String arg0) {
        if (this.group != null) {
            return this.group.getUsersHasRole(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public Set getUsersIsAllowed(String arg0) {
        if (this.group != null) {
            return this.group.getUsersIsAllowed(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public boolean hasRole(String arg0, String arg1) {
        if (this.group != null) {
            return this.group.hasRole(arg0, arg1);
        }
        throw new UnsupportedOperationException();
    }

    public boolean isAllowed(String arg0, String arg1) {
        if (this.group != null) {
            return this.group.isAllowed(arg0, arg1);
        }
        return false;
    }

    public boolean isEmpty() {
        if (this.group != null) {
            return this.group.isEmpty();
        }
        return false;
    }

    public boolean keepIntersection(AuthzGroup arg0) {
        if (this.group != null) {
            return this.group.keepIntersection(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public void removeMember(String arg0) {
        if (this.group != null) {
            this.group.removeMember(arg0);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public void removeMembers() {
        if (this.group != null) {
            this.group.removeMembers();
            return;
        }
        throw new UnsupportedOperationException();
    }

    public void removeRole(String arg0) {
        if (this.group != null) {
            this.group.removeRole(arg0);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public void removeRoles() {
        if (this.group != null) {
            this.group.removeRoles();
            return;
        }
        throw new UnsupportedOperationException();
    }

    public Site getContainingSite() {
        if (this.group != null) {
            return this.group.getContainingSite();
        }
        throw new UnsupportedOperationException();
    }
}

