/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.providers.model;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityDateCreated;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityFieldRequired;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityId;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityLastModified;
import org.sakaiproject.tool.api.ContextSession;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.ToolSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntitySession
implements Session {
    @EntityId
    private String id;
    private long creationTime;
    private long lastAccessedTime;
    private int maxInactiveInterval;
    private String userEid;
    @EntityFieldRequired
    private String userId;
    private boolean active = true;
    private long currentTime = System.currentTimeMillis();
    public Map<String, Object> attributes;
    private transient Session session = null;

    public long getCurrentTime() {
        this.currentTime = System.currentTimeMillis();
        return this.currentTime;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        return this.attributes;
    }

    public void setAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public EntitySession() {
    }

    public EntitySession(Session session) {
        this.session = session;
        this.creationTime = session.getCreationTime();
        this.id = session.getId();
        this.lastAccessedTime = session.getLastAccessedTime();
        this.maxInactiveInterval = session.getMaxInactiveInterval();
        this.userEid = session.getUserEid();
        this.userId = session.getUserId();
        this.active = true;
    }

    @EntityId
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @EntityDateCreated
    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    @EntityLastModified
    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public void setLastAccessedTime(long lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public String getUserEid() {
        return this.userEid;
    }

    public void setUserEid(String userEid) {
        this.userEid = userEid;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public boolean isActive() {
        return this.active;
    }

    public void clear() {
        if (this.session != null) {
            this.session.clear();
        }
        if (this.attributes != null) {
            this.attributes.clear();
        }
    }

    public void clearExcept(Collection arg0) {
        if (this.session != null) {
            this.session.clearExcept(arg0);
        }
        if (this.attributes != null) {
            for (Map.Entry entry : this.attributes.entrySet()) {
                if (arg0.contains(entry.getKey())) continue;
                this.attributes.remove(entry.getKey());
            }
        }
    }

    public Enumeration getAttributeNames() {
        if (this.session != null) {
            return this.session.getAttributeNames();
        }
        throw new UnsupportedOperationException();
    }

    public ContextSession getContextSession(String arg0) {
        if (this.session != null) {
            return this.session.getContextSession(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public ToolSession getToolSession(String arg0) {
        if (this.session != null) {
            return this.session.getToolSession(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public void invalidate() {
        if (this.session != null) {
            this.session.invalidate();
        }
        this.active = false;
    }

    public void removeAttribute(String key) {
        if (this.session != null) {
            this.session.removeAttribute(key);
        }
        if (this.attributes != null) {
            this.attributes.remove(key);
        }
    }

    public void setActive() {
        if (this.session != null) {
            this.session.setActive();
            this.lastAccessedTime = this.session.getLastAccessedTime();
            this.maxInactiveInterval = this.session.getMaxInactiveInterval();
        }
        this.active = true;
    }
}

