/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.azeckoski.reflectutils.ReflectUtils;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.authz.api.AuthzPermissionException;
import org.sakaiproject.authz.api.FunctionManager;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.authz.api.Member;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.authz.api.RoleAlreadyDefinedException;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.EntityView;
import org.sakaiproject.entitybroker.entityprovider.CoreEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityCustomAction;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityParameters;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityURLRedirect;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RESTful;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Redirectable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RequestStorable;
import org.sakaiproject.entitybroker.entityprovider.extension.ActionReturn;
import org.sakaiproject.entitybroker.entityprovider.extension.RequestStorage;
import org.sakaiproject.entitybroker.entityprovider.search.Restriction;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.entitybroker.providers.MembershipEntityProvider;
import org.sakaiproject.entitybroker.providers.UserEntityProvider;
import org.sakaiproject.entitybroker.providers.model.EntityGroup;
import org.sakaiproject.entitybroker.providers.model.EntitySite;
import org.sakaiproject.entitybroker.util.AbstractEntityProvider;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.javax.PagingPosition;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SitePage;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.thread_local.cover.ThreadLocalManager;
import org.sakaiproject.tool.api.Tool;
import org.sakaiproject.util.FormattedText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteEntityProvider
extends AbstractEntityProvider
implements CoreEntityProvider,
RESTful,
ActionsExecutable,
Redirectable,
RequestStorable {
    private static Log log = LogFactory.getLog(SiteEntityProvider.class);
    private SiteService siteService;
    private AuthzGroupService authzGroupService;
    private FunctionManager functionManager;
    private UserEntityProvider userEntityProvider;
    private ServerConfigurationService serverConfigurationService;
    public static String PREFIX = "site";
    private static final String GROUP_PROP_WSETUP_CREATED = "group_prop_wsetup_created";
    public static final String PROP_SITE_PROVIDER_PAGESIZE_DEFAULT = "site.entity.pagesize.default";
    public static final String PROP_SITE_PROVIDER_PAGESIZE_MAXIMUM = "site.entity.pagesize.maximum";
    private int defaultPageSize = 50;
    private int maxPageSize = 500;
    private RequestStorage requestStorage;

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setAuthzGroupService(AuthzGroupService authzGroupService) {
        this.authzGroupService = authzGroupService;
    }

    public void setFunctionManager(FunctionManager functionManager) {
        this.functionManager = functionManager;
    }

    public void setUserEntityProvider(UserEntityProvider userEntityProvider) {
        this.userEntityProvider = userEntityProvider;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public String getEntityPrefix() {
        return PREFIX;
    }

    public void init() {
        int mps;
        int dps = this.serverConfigurationService.getInt(PROP_SITE_PROVIDER_PAGESIZE_DEFAULT, this.defaultPageSize);
        if (dps > 0) {
            this.defaultPageSize = dps;
        }
        this.maxPageSize = (mps = this.serverConfigurationService.getInt(PROP_SITE_PROVIDER_PAGESIZE_MAXIMUM, this.maxPageSize)) >= this.defaultPageSize ? mps : this.defaultPageSize;
    }

    @EntityURLRedirect(value="/{prefix}/{id}/memberships")
    public String redirectMemberships(Map<String, String> vars) {
        return MembershipEntityProvider.PREFIX + "/site/" + vars.get("id") + vars.get("dot-extension");
    }

    @EntityCustomAction(action="exists", viewKey="show")
    public boolean checkSiteExists(EntityView view) {
        String siteId = view.getEntityReference().getId();
        boolean exists = this.entityExists(siteId);
        return exists;
    }

    @EntityCustomAction(action="role", viewKey="")
    public void handleRoles(EntityView view) {
        String siteId = view.getEntityReference().getId();
        String roleId = view.getPathSegment(3);
        if (roleId == null) {
            throw new IllegalArgumentException("No role id specified");
        }
        Site site = this.getSiteById(siteId);
        if (view.getMethod().equals(EntityView.Method.POST.name())) {
            try {
                site.addRole(roleId);
            }
            catch (RoleAlreadyDefinedException e) {}
        } else if (view.getMethod().equals(EntityView.Method.DELETE.name())) {
            site.removeRole(roleId);
        } else {
            throw new IllegalArgumentException("Method " + view.getMethod() + " not supported");
        }
        try {
            this.siteService.save(site);
        }
        catch (IdUnusedException e) {
        }
        catch (PermissionException e) {
            throw new SecurityException("User not allowed to update role " + roleId + " in site " + siteId);
        }
    }

    @EntityCustomAction(action="perms", viewKey="show")
    public Map<String, Set<String>> handlePerms(EntityView view) {
        String prefix = view.getPathSegment(3);
        String userId = this.developerHelperService.getCurrentUserId();
        if (userId == null) {
            throw new SecurityException("This action (perms) is not accessible to anon and there is no current user.");
        }
        String siteId = view.getEntityReference().getId();
        Site site = this.getSiteById(siteId);
        Set roles = site.getRoles();
        HashMap<String, Set<String>> perms = new HashMap<String, Set<String>>();
        for (Role role : roles) {
            Set functions = role.getAllowedFunctions();
            Set<String> filteredFunctions = new TreeSet();
            if (prefix != null) {
                for (String function : functions) {
                    if (!function.startsWith(prefix)) continue;
                    filteredFunctions.add(function);
                }
            } else {
                filteredFunctions = functions;
            }
            perms.put(role.getId(), filteredFunctions);
        }
        return perms;
    }

    @EntityCustomAction(action="setPerms", viewKey="edit")
    public String handleSetPerms(EntityReference ref, Map<String, Object> params) {
        block11: {
            String userId = this.developerHelperService.getCurrentUserId();
            if (userId == null) {
                throw new SecurityException("This action (setPerms) is not accessible to anon and there is no current user.");
            }
            String siteId = ref.getId();
            Site site = this.getSiteById(siteId);
            List userMutableFunctions = this.functionManager.getRegisteredUserMutableFunctions();
            boolean admin = this.developerHelperService.isUserAdmin(this.developerHelperService.getCurrentUserReference());
            try {
                AuthzGroup authzGroup = this.authzGroupService.getAuthzGroup(site.getReference());
                boolean changed = false;
                for (String name : params.keySet()) {
                    if (!name.contains(":")) continue;
                    String value = (String)params.get(name);
                    String roleId = name.substring(0, name.indexOf(":"));
                    Role role = authzGroup.getRole(roleId);
                    if (role == null) {
                        throw new IllegalArgumentException("Invalid role id '" + roleId + "' provided in POST parameters.");
                    }
                    String function = name.substring(name.indexOf(":") + 1);
                    if (admin || userMutableFunctions.contains(function)) {
                        if ("true".equals(value)) {
                            role.allowFunction(function);
                        } else {
                            role.disallowFunction(function);
                        }
                    } else {
                        throw new SecurityException("The function " + function + " cannot be updated by the current user.");
                    }
                    changed = true;
                }
                if (!changed) break block11;
                try {
                    this.authzGroupService.save(authzGroup);
                }
                catch (AuthzPermissionException ape) {
                    throw new SecurityException("The permissions for this site (" + siteId + ") cannot be updated by the current user.");
                }
            }
            catch (GroupNotDefinedException gnde) {
                throw new IllegalArgumentException("No realm defined for site (" + siteId + ").");
            }
        }
        return "SUCCESS";
    }

    @EntityCustomAction(action="group", viewKey="")
    public EntityGroup handleGroups(EntityView view, Map<String, Object> params) {
        String groupDescription;
        String siteId = view.getEntityReference().getId();
        String groupId = view.getPathSegment(3);
        EntityGroup eg = null;
        String groupTitle = params.containsKey("groupTitle") ? params.get("groupTitle").toString() : null;
        String string = groupDescription = params.get("groupDescription") != null ? params.get("groupDescription").toString() : null;
        if ("".equals(groupTitle)) {
            groupTitle = null;
        }
        if ("".equals(groupDescription)) {
            groupDescription = null;
        }
        ArrayList userIds = params.get("userIds") != null ? Arrays.asList(params.get("userIds").toString().split(",")) : new ArrayList();
        Site site = this.getSiteById(siteId);
        this.isAllowedAccessSite(site);
        if (!this.siteService.allowUpdateGroupMembership(site.getId())) {
            throw new SecurityException("This group (" + groupId + ") in site (" + siteId + ") cannot be updated by the current user.");
        }
        Group group = null;
        if (EntityView.Method.GET.name().equals(view.getMethod())) {
            if (groupId == null) {
                throw new IllegalArgumentException("Invalid path provided: expected to receive the groupId");
            }
            group = site.getGroup(groupId);
            eg = new EntityGroup(group);
            return eg;
        }
        if (EntityView.Method.PUT.name().equals(view.getMethod())) {
            if (groupTitle == null) {
                throw new IllegalArgumentException("A title needs to be provided for a new group.");
            }
            group = site.addGroup();
            group.getProperties().addProperty(GROUP_PROP_WSETUP_CREATED, Boolean.TRUE.toString());
            group.setTitle(groupTitle);
            group.setDescription(groupDescription);
            for (String userId : userIds) {
                Role role = site.getUserRole(userId);
                Member m = site.getMember(userId);
                if (group.getUserRole(userId) != null || role == null) continue;
                group.addMember(userId, role.getId(), m != null ? m.isActive() : true, false);
            }
            try {
                this.siteService.save(site);
            }
            catch (IdUnusedException e) {
                throw new IllegalArgumentException("Cannot find site with given id: " + siteId + ":" + e.getMessage(), e);
            }
            catch (PermissionException e) {
                throw new SecurityException("Current user does not have permission to add a group to site:" + siteId);
            }
        }
        if (EntityView.Method.POST.name().equals(view.getMethod())) {
            if (groupTitle == null) {
                throw new IllegalArgumentException("A group title needs to be provided to edit group: " + groupId);
            }
            group = site.getGroup(groupId);
            if (group != null) {
                this.checkGroupType(group);
                if (groupTitle != null) {
                    group.setTitle(groupTitle);
                }
                if (groupDescription != null) {
                    groupDescription = groupDescription.trim();
                }
            } else {
                throw new IllegalArgumentException("Cannot find a group with given id: " + groupId + " in site:" + siteId);
            }
            try {
                this.siteService.save(site);
            }
            catch (IdUnusedException e) {
                throw new IllegalArgumentException("Cannot find site with given id: " + siteId + ":" + e.getMessage(), e);
            }
            catch (PermissionException e) {
                throw new SecurityException("This group: " + groupId + " cannot be edited by the current user.");
            }
        }
        if (EntityView.Method.DELETE.name().equals(view.getMethod())) {
            if (groupId == null) {
                throw new IllegalArgumentException("Invalid path provided: expect to receive the groupId");
            }
            group = site.getGroup(groupId);
            this.checkGroupType(group);
            site.removeGroup(group);
            try {
                this.siteService.save(site);
            }
            catch (IdUnusedException e) {
                throw new IllegalArgumentException("Cannot find site with given id: " + siteId + ":" + e.getMessage(), e);
            }
            catch (PermissionException e) {
                throw new SecurityException("This group: " + groupId + " cannot be deleted by the current user.");
            }
            return null;
        }
        eg = new EntityGroup(group);
        return eg;
    }

    @EntityCustomAction(action="userPerms", viewKey="show")
    public Set<String> handleUserPerms(EntityView view) {
        String prefix = view.getPathSegment(3);
        String userId = this.developerHelperService.getCurrentUserId();
        if (userId == null) {
            throw new SecurityException("This action (userPerms) is not accessible to anon and there is no current user.");
        }
        Set<String> filteredFunctions = new TreeSet<String>();
        if (this.developerHelperService.isUserAdmin("/user/" + userId)) {
            if (prefix != null) {
                filteredFunctions.addAll(this.functionManager.getRegisteredFunctions(prefix));
            } else {
                filteredFunctions.addAll(this.functionManager.getRegisteredFunctions());
            }
        } else {
            String siteId = view.getEntityReference().getId();
            Site site = this.getSiteById(siteId);
            AuthzGroup siteHelperRealm = null;
            try {
                siteHelperRealm = this.authzGroupService.getAuthzGroup("!site.helper");
            }
            catch (GroupNotDefinedException gnde) {
                log.warn((Object)("Failure: could not find !site.helper: " + (Object)((Object)gnde)));
            }
            if (siteHelperRealm != null) {
                Role currentUserRole = site.getUserRole(userId);
                Role siteHelperRole = siteHelperRealm.getRole(currentUserRole.getId());
                Set functions = currentUserRole.getAllowedFunctions();
                if (siteHelperRole != null) {
                    functions.addAll(siteHelperRole.getAllowedFunctions());
                }
                if (prefix != null) {
                    for (String function : functions) {
                        if (!function.startsWith(prefix)) continue;
                        filteredFunctions.add(function);
                    }
                } else {
                    filteredFunctions = functions;
                }
            }
        }
        return filteredFunctions;
    }

    @EntityCustomAction(action="pages", viewKey="show")
    public ActionReturn getPagesAndTools(EntityView view, Search search) {
        String portalBase;
        Member member;
        String userId = this.developerHelperService.getCurrentUserId();
        if (userId == null) {
            throw new SecurityException("This action (userPerms) is not accessible to anon and there is no current user.");
        }
        boolean admin = this.developerHelperService.isUserAdmin(this.developerHelperService.getCurrentUserReference());
        String siteId = view.getEntityReference().getId();
        Site site = this.getSiteById(siteId);
        if (!(admin || (member = site.getMember(userId)) != null && member.isActive())) {
            throw new SecurityException("User (" + userId + ") cannot access the site pages list for site (" + site.getId() + ")");
        }
        boolean includeProps = false;
        boolean includeConfig = false;
        if (search != null) {
            Restriction r2;
            Restriction r = search.getRestrictionByProperty("props");
            if (r != null && r.getBooleanValue()) {
                includeProps = true;
            }
            if ((r2 = search.getRestrictionByProperty("config")) != null && r2.getBooleanValue()) {
                includeConfig = true;
            }
        }
        if ((portalBase = (String)ThreadLocalManager.get((String)"sakai:request.portal.path")) == null || "".equals(portalBase) || "/sakai-entitybroker-direct".equals(portalBase)) {
            ThreadLocalManager.set((String)"sakai:request.portal.path", (Object)"/portal");
        }
        ArrayList data = new ArrayList();
        List pages = site.getOrderedPages();
        for (SitePage page : pages) {
            HashMap<String, Object> pageData = new HashMap<String, Object>();
            pageData.put("id", page.getId());
            pageData.put("layoutTitle", page.getLayoutTitle());
            pageData.put("layout", page.getLayout());
            pageData.put("position", page.getPosition());
            pageData.put("siteId", page.getSiteId());
            pageData.put("skin", page.getSkin());
            pageData.put("title", page.getTitle());
            pageData.put("url", page.getUrl());
            if (includeProps) {
                HashMap<String, String> props = new HashMap<String, String>();
                ResourceProperties rp = page.getProperties();
                Iterator iterator = rp.getPropertyNames();
                while (iterator.hasNext()) {
                    String name = (String)iterator.next();
                    String value = rp.getProperty(name);
                    props.put(name, value);
                }
                pageData.put("properties", page.getProperties());
            }
            ArrayList tools = new ArrayList();
            pageData.put("tools", tools);
            data.add(pageData);
            for (ToolConfiguration tc : page.getTools()) {
                Tool tool = tc.getTool();
                if (tool == null) continue;
                HashMap<String, Object> toolData = new HashMap<String, Object>();
                tools.add(toolData);
                toolData.put("id", tc.getId());
                toolData.put("toolId", tool.getId());
                toolData.put("placementId", tc.getId());
                toolData.put("title", tool.getTitle());
                toolData.put("description", tool.getDescription());
                toolData.put("url", page.getUrl());
                toolData.put("home", tool.getHome());
                toolData.put("context", tc.getContext());
                toolData.put("pageId", tc.getPageId());
                toolData.put("pageOrder", tc.getPageOrder());
                toolData.put("siteId", tc.getSiteId());
                if (!includeConfig || !admin) continue;
                toolData.put("config", tc.getConfig());
                toolData.put("registeredConfig", tool.getRegisteredConfig());
                toolData.put("mutableConfig", tool.getMutableConfig());
            }
        }
        return new ActionReturn(data);
    }

    protected boolean isAllowedAccessMembers(Site site) {
        String userReference = this.developerHelperService.getCurrentUserReference();
        if (userReference == null) {
            throw new SecurityException("Anonymous users may not view memberships in (" + site.getReference() + ")");
        }
        if (!this.siteService.allowViewRoster(site.getId())) {
            throw new SecurityException("Memberships in this site (" + site.getReference() + ") are not accessible for the current user: " + userReference);
        }
        return true;
    }

    public boolean entityExists(String id) {
        if (id == null) {
            return false;
        }
        if ("".equals(id)) {
            return true;
        }
        boolean exists = this.siteService.siteExists(id);
        return exists;
    }

    public String createEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        String siteId = null;
        if (ref.getId() != null && ref.getId().length() > 0) {
            siteId = ref.getId();
        }
        if (entity.getClass().isAssignableFrom(Site.class)) {
            StringBuilder alertMsg;
            String description;
            Site site = (Site)entity;
            if (siteId == null && site.getId() != null) {
                siteId = site.getId();
            }
            if ((description = site.getDescription()) != null && (description = FormattedText.processFormattedText((String)description, (StringBuilder)(alertMsg = new StringBuilder()))) == null) {
                throw new IllegalArgumentException("Site description markup rejected: " + alertMsg.toString());
            }
            Site s = null;
            try {
                s = this.siteService.addSite(siteId, site.getType());
                s.setCustomPageOrdered(site.isCustomPageOrdered());
                s.setDescription(description);
                s.setIconUrl(site.getIconUrl());
                s.setInfoUrl(site.getInfoUrl());
                s.setJoinable(site.isJoinable());
                s.setJoinerRole(site.getJoinerRole());
                s.setMaintainRole(site.getMaintainRole());
                s.setProviderGroupId(site.getProviderGroupId());
                s.setPublished(site.isPublished());
                s.setPubView(site.isPubView());
                s.setShortDescription(site.getShortDescription());
                s.setSkin(site.getSkin());
                s.setTitle(site.getTitle());
                this.siteService.save(s);
                siteId = s.getId();
            }
            catch (IdInvalidException e) {
                try {
                    this.siteService.removeSite(s);
                }
                catch (Exception e1) {
                    log.warn((Object)("Could not cleanup site on create failure: " + e1));
                }
                throw new IllegalArgumentException("Cannot create site with given id: " + siteId + ":" + e.getMessage(), e);
            }
            catch (IdUsedException e) {
                try {
                    this.siteService.removeSite(s);
                }
                catch (Exception e1) {
                    log.warn((Object)("Could not cleanup site on create failure: " + e1));
                }
                throw new IllegalArgumentException("Cannot create site with given id: " + siteId + ":" + e.getMessage(), e);
            }
            catch (PermissionException e) {
                try {
                    this.siteService.removeSite(s);
                }
                catch (Exception e1) {
                    log.warn((Object)("Could not cleanup site on create failure: " + e1));
                }
                throw new SecurityException("Current user does not have permissions to create site: " + ref + ":" + e.getMessage(), e);
            }
            catch (IdUnusedException e) {
                try {
                    this.siteService.removeSite(s);
                }
                catch (Exception e1) {
                    log.warn((Object)("Could not cleanup site on create failure: " + e1));
                }
                throw new IllegalArgumentException("Cannot save new site with given id: " + siteId + ":" + e.getMessage(), e);
            }
        }
        if (entity.getClass().isAssignableFrom(EntitySite.class)) {
            StringBuilder alertMsg;
            String description;
            EntitySite site = (EntitySite)entity;
            if (siteId == null && site.getId() != null) {
                siteId = site.getId();
            }
            if ((description = site.getDescription()) != null && (description = FormattedText.processFormattedText((String)description, (StringBuilder)(alertMsg = new StringBuilder()))) == null) {
                throw new IllegalArgumentException("Site description markup rejected: " + alertMsg.toString());
            }
            Site s = null;
            try {
                s = this.siteService.addSite(siteId, site.getType());
                s.setCustomPageOrdered(site.isCustomPageOrdered());
                s.setDescription(description);
                s.setIconUrl(site.getIconUrl());
                s.setInfoUrl(site.getInfoUrl());
                s.setJoinable(site.isJoinable());
                s.setJoinerRole(site.getJoinerRole());
                s.setMaintainRole(site.getMaintainRole());
                s.setProviderGroupId(site.getProviderGroupId());
                s.setPublished(site.isPublished());
                s.setPubView(site.isPubView());
                s.setShortDescription(site.getShortDescription());
                s.setSkin(site.getSkin());
                s.setTitle(site.getTitle());
                String ownerUserId = site.getOwner();
                if (ownerUserId != null) {
                    if ((ownerUserId = this.userEntityProvider.findAndCheckUserId(ownerUserId, null)) == null) {
                        throw new IllegalArgumentException("Invalid userId supplied for owner of site: " + site.getOwner());
                    }
                    ReflectUtils.getInstance().setFieldValue((Object)s, "m_createdUserId", (Object)ownerUserId);
                }
                this.siteService.save(s);
                siteId = s.getId();
            }
            catch (IdInvalidException e) {
                try {
                    this.siteService.removeSite(s);
                }
                catch (Exception e1) {
                    log.warn((Object)("Could not cleanup site on create failure: " + e1));
                }
                throw new IllegalArgumentException("Cannot create site with given id: " + siteId + ":" + e.getMessage(), e);
            }
            catch (IdUsedException e) {
                try {
                    this.siteService.removeSite(s);
                }
                catch (Exception e1) {
                    log.warn((Object)("Could not cleanup site on create failure: " + e1));
                }
                throw new IllegalArgumentException("Cannot create site with given id: " + siteId + ":" + e.getMessage(), e);
            }
            catch (PermissionException e) {
                try {
                    this.siteService.removeSite(s);
                }
                catch (Exception e1) {
                    log.warn((Object)("Could not cleanup site on create failure: " + e1));
                }
                throw new SecurityException("Current user does not have permissions to create site: " + ref + ":" + e.getMessage(), e);
            }
            catch (IdUnusedException e) {
                try {
                    this.siteService.removeSite(s);
                }
                catch (Exception e1) {
                    log.warn((Object)("Could not cleanup site on create failure: " + e1));
                }
                throw new IllegalArgumentException("Cannot save new site with given id: " + siteId + ":" + e.getMessage(), e);
            }
        }
        throw new IllegalArgumentException("Invalid entity for creation, must be Site or EntitySite object");
        return siteId;
    }

    public Object getSampleEntity() {
        return new EntitySite();
    }

    public void updateEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        Site site;
        String siteId = ref.getId();
        if (siteId == null) {
            throw new IllegalArgumentException("Cannot update, No siteId in provided reference: " + ref);
        }
        Site s = this.getSiteById(siteId);
        if (s == null) {
            throw new IllegalArgumentException("Cannot find site to update with id: " + siteId);
        }
        boolean admin = this.developerHelperService.isUserAdmin(this.developerHelperService.getCurrentUserReference());
        if (entity.getClass().isAssignableFrom(Site.class)) {
            StringBuilder alertMsg;
            site = (Site)entity;
            String description = site.getDescription();
            if (description != null && (description = FormattedText.processFormattedText((String)description, (StringBuilder)(alertMsg = new StringBuilder()))) == null) {
                throw new IllegalArgumentException("Site description markup rejected: " + alertMsg.toString());
            }
            s.setCustomPageOrdered(site.isCustomPageOrdered());
            s.setDescription(description);
            s.setIconUrl(site.getIconUrl());
            s.setInfoUrl(site.getInfoUrl());
            s.setJoinable(site.isJoinable());
            s.setJoinerRole(site.getJoinerRole());
            s.setMaintainRole(site.getMaintainRole());
            s.setProviderGroupId(site.getProviderGroupId());
            s.setPublished(site.isPublished());
            s.setPubView(site.isPubView());
            s.setShortDescription(site.getShortDescription());
            s.setSkin(site.getSkin());
            s.setTitle(site.getTitle());
            if (admin) {
                ResourcePropertiesEdit rpe = s.getPropertiesEdit();
                rpe.set(site.getProperties());
            }
        } else if (entity.getClass().isAssignableFrom(EntitySite.class)) {
            String ownerUserId;
            StringBuilder alertMsg;
            site = (EntitySite)entity;
            String description = site.getDescription();
            if (description != null && (description = FormattedText.processFormattedText((String)description, (StringBuilder)(alertMsg = new StringBuilder()))) == null) {
                throw new IllegalArgumentException("Site description markup rejected: " + alertMsg.toString());
            }
            s.setCustomPageOrdered(site.isCustomPageOrdered());
            if (description != null) {
                s.setDescription(description);
            }
            if (site.getIconUrl() != null) {
                s.setIconUrl(site.getIconUrl());
            }
            s.setJoinable(site.isJoinable());
            if (site.getJoinerRole() != null) {
                s.setJoinerRole(site.getJoinerRole());
            }
            if (site.getMaintainRole() != null) {
                s.setMaintainRole(site.getMaintainRole());
            }
            if (site.getProviderGroupId() != null) {
                s.setProviderGroupId(site.getProviderGroupId());
            }
            s.setPublished(site.isPublished());
            s.setPubView(site.isPubView());
            if (site.getShortDescription() != null) {
                s.setShortDescription(site.getShortDescription());
            }
            if (site.getSkin() != null) {
                s.setSkin(site.getSkin());
            }
            if (site.getTitle() != null) {
                s.setTitle(site.getTitle());
            }
            if (admin) {
                ResourcePropertiesEdit rpe = s.getPropertiesEdit();
                for (String key : site.getProps().keySet()) {
                    String value = (String)site.getProps().get(key);
                    rpe.addProperty(key, value);
                }
            }
            if ((ownerUserId = site.getOwner()) != null) {
                if ((ownerUserId = this.userEntityProvider.findAndCheckUserId(ownerUserId, null)) == null) {
                    throw new IllegalArgumentException("Invalid userId supplied for owner of site: " + site.getOwner());
                }
                ReflectUtils.getInstance().setFieldValue((Object)s, "m_createdUserId", (Object)ownerUserId);
            }
        } else {
            throw new IllegalArgumentException("Invalid entity for update, must be Site or EntitySite object");
        }
        try {
            this.siteService.save(s);
        }
        catch (IdUnusedException e) {
            throw new IllegalArgumentException("Sakai was unable to save a site which it just fetched: " + ref, e);
        }
        catch (PermissionException e) {
            throw new SecurityException("Current user does not have permissions to update site: " + ref + ":" + e.getMessage(), e);
        }
    }

    @EntityParameters(accepted={"includeGroups"})
    public Object getEntity(EntityReference ref) {
        boolean includeGroups = false;
        if (this.requestStorage.getStoredValue("includeGroups") != null) {
            includeGroups = true;
        }
        if (ref.getId() == null) {
            return new EntitySite();
        }
        String siteId = ref.getId();
        Site site = this.getSiteById(siteId);
        this.isAllowedAccessSite(site);
        EntitySite es = new EntitySite(site, includeGroups);
        return es;
    }

    protected boolean isAllowedAccessSite(Site site) {
        String userReference = this.developerHelperService.getCurrentUserReference();
        if (userReference == null) {
            if (!this.siteService.allowAccessSite(site.getId())) {
                throw new SecurityException("This site (" + site.getReference() + ") is not accessible to anon and there is no current user so the site is inaccessible");
            }
        } else if (!site.isPubView() && !this.siteService.allowAccessSite(site.getId())) {
            throw new SecurityException("This site (" + site.getReference() + ") is not public and is not accessible for the current user: " + userReference);
        }
        return true;
    }

    public void deleteEntity(EntityReference ref, Map<String, Object> params) {
        String siteId = ref.getId();
        if (siteId == null || "".equals(siteId)) {
            throw new IllegalArgumentException("Cannot delete site, No siteId in provided reference: " + ref);
        }
        Site site = this.getSiteById(siteId);
        if (site != null) {
            try {
                this.siteService.removeSite(site);
            }
            catch (PermissionException e) {
                throw new SecurityException("Permission denied: Site cannot be removed: " + ref);
            }
            catch (IdUnusedException e) {
                throw new IllegalArgumentException("Cannot delete site, No siteId in provided reference: " + ref);
            }
        }
    }

    @EntityParameters(accepted={"select", "selectionType", "search", "_start", "_limit"})
    public List<?> getEntities(EntityReference ref, Search search) {
        Restriction restrict;
        String criteria = null;
        String selectType = "access";
        Restriction select = search.getRestrictionByProperty("select");
        if (select == null) {
            select = search.getRestrictionByProperty("selectionType");
        }
        if (select != null) {
            selectType = select.value + "";
        }
        SiteService.SelectionType sType = SiteService.SelectionType.ACCESS;
        if ("access".equals(selectType)) {
            sType = SiteService.SelectionType.ACCESS;
        } else if ("update".equals(selectType)) {
            sType = SiteService.SelectionType.UPDATE;
        } else if ("joinable".equals(selectType)) {
            sType = SiteService.SelectionType.JOINABLE;
        } else if ("pubView".equals(selectType)) {
            sType = SiteService.SelectionType.PUBVIEW;
        } else {
            String userReference = this.developerHelperService.getCurrentUserReference();
            if (userReference == null) {
                sType = SiteService.SelectionType.PUBVIEW;
            } else if (this.developerHelperService.isUserAdmin(userReference)) {
                sType = SiteService.SelectionType.ANY;
            }
        }
        int start = 1;
        if (search.getStart() > 0L && search.getStart() < Integer.MAX_VALUE) {
            start = (int)search.getStart() + 1;
        }
        int limit = this.defaultPageSize;
        if (search.getLimit() > 0L && search.getLimit() < Integer.MAX_VALUE) {
            limit = (int)search.getLimit();
        }
        if (limit > this.maxPageSize) {
            limit = this.maxPageSize;
        }
        if ((restrict = search.getRestrictionByProperty("search")) == null) {
            restrict = search.getRestrictionByProperty("criteria");
        }
        if (restrict != null) {
            criteria = restrict.value + "";
        }
        List sites = this.siteService.getSites(sType, null, criteria, null, SiteService.SortType.TITLE_ASC, new PagingPosition(start, limit));
        ArrayList<EntitySite> entitySites = new ArrayList<EntitySite>();
        for (Site site : sites) {
            EntitySite es = new EntitySite(site, false);
            entitySites.add(es);
        }
        return entitySites;
    }

    public String[] getHandledInputFormats() {
        return new String[]{"html", "xml", "json"};
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"xml", "json", "html", "form"};
    }

    private Site getSiteById(String siteId) {
        Site site;
        try {
            site = this.siteService.getSite(siteId);
        }
        catch (IdUnusedException e) {
            throw new IllegalArgumentException("Cannot find site by siteId: " + siteId, e);
        }
        return site;
    }

    public void setRequestStorage(RequestStorage requestStorage) {
        this.requestStorage = requestStorage;
    }

    protected Group trimGroupUsers(Group grp) {
        Group newGrp = grp;
        newGrp.removeMembers();
        return newGrp;
    }

    private void checkGroupType(Group group) {
        if (group != null) {
            try {
                if (!group.getProperties().getBooleanProperty(GROUP_PROP_WSETUP_CREATED)) {
                    throw new IllegalArgumentException("This type of group (Section Info group) should not be edited by this entity provider. Only Site info groups are allowed.");
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("This type of group (Section Info group) should not be edited by this entity provider. Only Site info groups are allowed.");
            }
        }
    }
}

