/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.providers.model;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.azeckoski.reflectutils.annotations.ReflectIgnoreClassFields;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityFieldRequired;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityId;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityLastModified;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityOwner;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityTitle;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.user.api.User;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ReflectIgnoreClassFields(value={"createdBy", "modifiedBy", "properties"})
public class EntityUser
implements User {
    @EntityId
    private String id;
    @EntityFieldRequired
    private String eid;
    private String password;
    private String email;
    private String firstName;
    private String lastName;
    private String displayName;
    private String type;
    private String owner;
    private long lastModified;
    public Map<String, String> props;
    private transient User user;

    public EntityUser() {
    }

    public EntityUser(User user) {
        this.user = user;
        this.id = user.getId();
        this.eid = user.getEid();
        this.email = user.getEmail();
        this.firstName = user.getFirstName();
        this.lastName = user.getLastName();
        this.displayName = user.getDisplayName();
        this.owner = user.getCreatedBy() == null ? null : "/user/" + user.getCreatedBy().getId();
        this.lastModified = user.getModifiedTime() == null ? System.currentTimeMillis() : user.getModifiedTime().getTime();
        ResourceProperties rp = user.getProperties();
        Iterator iterator = rp.getPropertyNames();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            String value = rp.getProperty(name);
            this.setProperty(name, value);
        }
    }

    public EntityUser(String eid, String email, String firstName, String lastName, String displayName, String password, String type) {
        this.eid = eid;
        this.password = password;
        this.email = email;
        this.firstName = firstName;
        this.lastName = lastName;
        this.displayName = displayName;
        this.type = type;
    }

    public void setProperty(String key, String value) {
        if (this.props == null) {
            this.props = new HashMap();
        }
        this.props.put(key, value);
    }

    public String getProperty(String key) {
        if (this.props == null) {
            return null;
        }
        return (String)this.props.get(key);
    }

    @EntityOwner
    public String getOwner() {
        return this.owner;
    }

    @EntityLastModified
    public long getLastModified() {
        return this.lastModified;
    }

    @EntityId
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getEid() {
        return this.eid;
    }

    public void setEid(String eid) {
        this.eid = eid;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @EntityTitle
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Map<String, String> getProps() {
        if (this.props == null) {
            this.props = new HashMap();
        }
        return this.props;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    public boolean checkPassword(String arg0) {
        if (this.user != null) {
            return this.user.checkPassword(arg0);
        }
        return false;
    }

    public User getCreatedBy() {
        if (this.user != null) {
            return this.user.getCreatedBy();
        }
        throw new UnsupportedOperationException();
    }

    public Time getCreatedTime() {
        if (this.user != null) {
            return this.user.getCreatedTime();
        }
        throw new UnsupportedOperationException();
    }

    public Date getCreatedDate() {
        if (this.user != null) {
            return this.user.getCreatedDate();
        }
        throw new UnsupportedOperationException();
    }

    public String getDisplayId() {
        if (this.user != null) {
            return this.user.getDisplayId();
        }
        throw new UnsupportedOperationException();
    }

    public User getModifiedBy() {
        if (this.user != null) {
            return this.user.getModifiedBy();
        }
        throw new UnsupportedOperationException();
    }

    public Time getModifiedTime() {
        if (this.user != null) {
            return this.user.getModifiedTime();
        }
        throw new UnsupportedOperationException();
    }

    public Date getModifiedDate() {
        if (this.user != null) {
            return this.user.getModifiedDate();
        }
        throw new UnsupportedOperationException();
    }

    public String getSortName() {
        String sortName = null;
        if (this.user != null) {
            sortName = this.user.getSortName();
        } else {
            StringBuilder sb = new StringBuilder(128);
            if (this.lastName != null) {
                sb.append(this.lastName);
            }
            if (this.firstName != null) {
                sb.append(", ");
                sb.append(this.firstName);
            }
            if (sb.length() == 0) {
                sb.append(this.email);
            }
            if (sb.length() == 0) {
                sb.append(this.eid);
            }
            sortName = sb.toString();
        }
        return sortName;
    }

    public ResourceProperties getProperties() {
        if (this.user != null) {
            return this.user.getProperties();
        }
        throw new UnsupportedOperationException();
    }

    public String getReference() {
        return "/user/" + this.id;
    }

    public String getReference(String arg0) {
        return this.getReference();
    }

    public String getUrl() {
        if (this.user != null) {
            return this.user.getUrl();
        }
        throw new UnsupportedOperationException();
    }

    public String getUrl(String arg0) {
        if (this.user != null) {
            return this.user.getUrl(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public Element toXml(Document arg0, Stack arg1) {
        if (this.user != null) {
            return this.user.toXml(arg0, arg1);
        }
        throw new UnsupportedOperationException();
    }

    public int compareTo(Object o) {
        if (this.user != null) {
            return this.user.compareTo(o);
        }
        throw new UnsupportedOperationException();
    }
}

