/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.azeckoski.reflectutils.FieldUtils;
import org.azeckoski.reflectutils.ReflectUtils;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.entitybroker.DeveloperHelperService;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.EntityView;
import org.sakaiproject.entitybroker.entityprovider.CoreEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityCustomAction;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Describeable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RESTful;
import org.sakaiproject.entitybroker.entityprovider.search.Restriction;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.entitybroker.providers.model.EntityUser;
import org.sakaiproject.entitybroker.util.AbstractEntityProvider;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserAlreadyDefinedException;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserEdit;
import org.sakaiproject.user.api.UserIdInvalidException;
import org.sakaiproject.user.api.UserLockedException;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.user.api.UserPermissionException;

public class UserEntityProvider
extends AbstractEntityProvider
implements CoreEntityProvider,
RESTful,
Describeable {
    private static Log log = LogFactory.getLog(UserEntityProvider.class);
    private static final String ID_PREFIX = "id=";
    private UserDirectoryService userDirectoryService;
    private DeveloperHelperService developerHelperService;
    private ServerConfigurationService serverConfigurationService;
    public static String PREFIX = "user";
    private Boolean usesSeparateIdEid = null;

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public void setDeveloperHelperService(DeveloperHelperService developerHelperService) {
        this.developerHelperService = developerHelperService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public String getEntityPrefix() {
        return PREFIX;
    }

    @EntityCustomAction(action="current", viewKey="list")
    public EntityUser getCurrentUser(EntityView view) {
        EntityUser eu = new EntityUser(this.userDirectoryService.getCurrentUser());
        return eu;
    }

    @EntityCustomAction(action="exists", viewKey="show")
    public boolean checkUserExists(EntityView view) {
        String userId = view.getEntityReference().getId();
        boolean exists = (userId = this.findAndCheckUserId(userId, null)) != null;
        return exists;
    }

    public boolean entityExists(String id) {
        if (id == null) {
            return false;
        }
        if ("".equals(id)) {
            return true;
        }
        String userId = this.findAndCheckUserId(id, null);
        return userId != null;
    }

    public String createEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        String userId = null;
        if (ref.getId() != null && ref.getId().length() > 0) {
            userId = ref.getId();
        }
        if (entity.getClass().isAssignableFrom(User.class)) {
            User user = (User)entity;
            if (userId == null && user.getId() != null) {
                userId = user.getId();
            }
            if (!this.canAddAccountType(user.getType())) {
                throw new SecurityException("User can't add an account of type: " + user.getType());
            }
            try {
                User newUser = this.userDirectoryService.addUser(userId, user.getEid(), user.getFirstName(), user.getLastName(), user.getEmail(), "", user.getType(), user.getProperties());
                userId = newUser.getId();
            }
            catch (UserIdInvalidException e) {
                throw new IllegalArgumentException("User ID is invalid, id=" + user.getId() + ", eid=" + user.getEid(), e);
            }
            catch (UserAlreadyDefinedException e) {
                throw new IllegalArgumentException("Cannot create user, user already exists: " + ref, e);
            }
            catch (UserPermissionException e) {
                throw new SecurityException("Could not create user, permission denied: " + ref, e);
            }
        } else if (entity.getClass().isAssignableFrom(EntityUser.class)) {
            EntityUser user = (EntityUser)entity;
            if (userId == null && user.getId() != null) {
                userId = user.getId();
            }
            if (!this.canAddAccountType(user.getType())) {
                throw new SecurityException("User can't add an account of type: " + user.getType());
            }
            try {
                UserEdit edit = this.userDirectoryService.addUser(userId, user.getEid());
                edit.setEmail(user.getEmail());
                edit.setFirstName(user.getFirstName());
                edit.setLastName(user.getLastName());
                edit.setPassword(user.getPassword());
                edit.setType(user.getType());
                ResourcePropertiesEdit rpe = edit.getPropertiesEdit();
                for (String key : user.getProps().keySet()) {
                    String value = (String)user.getProps().get(key);
                    rpe.addProperty(key, value);
                }
                this.userDirectoryService.commitEdit(edit);
                userId = edit.getId();
            }
            catch (UserIdInvalidException e) {
                throw new IllegalArgumentException("User ID is invalid: " + user.getId(), e);
            }
            catch (UserAlreadyDefinedException e) {
                throw new IllegalArgumentException("Cannot create user, user already exists: " + ref, e);
            }
            catch (UserPermissionException e) {
                throw new SecurityException("Could not create user, permission denied: " + ref, e);
            }
        } else {
            throw new IllegalArgumentException("Invalid entity for creation, must be User or EntityUser object");
        }
        return userId;
    }

    public Object getSampleEntity() {
        return new EntityUser();
    }

    public void updateEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        User u;
        String userId = ref.getId();
        if (userId == null || "".equals(userId)) {
            throw new IllegalArgumentException("Cannot update, No userId in provided reference: " + ref);
        }
        User user = this.getUserByIdEid(userId);
        UserEdit edit = null;
        try {
            edit = this.userDirectoryService.editUser(user.getId());
        }
        catch (UserNotDefinedException e) {
            throw new IllegalArgumentException("Invalid user: " + ref + ":" + e.getMessage());
        }
        catch (UserPermissionException e) {
            throw new SecurityException("Permission denied: User cannot be updated: " + ref);
        }
        catch (UserLockedException e) {
            throw new RuntimeException("Something strange has failed with Sakai: " + e.getMessage());
        }
        if (entity.getClass().isAssignableFrom(User.class)) {
            u = (User)entity;
            edit.setEmail(u.getEmail());
            edit.setFirstName(u.getFirstName());
            edit.setLastName(u.getLastName());
            edit.setType(u.getType());
            ResourcePropertiesEdit rpe = edit.getPropertiesEdit();
            rpe.set(u.getProperties());
        } else if (entity.getClass().isAssignableFrom(EntityUser.class)) {
            u = (EntityUser)entity;
            edit.setEmail(u.getEmail());
            edit.setFirstName(u.getFirstName());
            edit.setLastName(u.getLastName());
            edit.setPassword(u.getPassword());
            edit.setType(u.getType());
            ResourcePropertiesEdit rpe = edit.getPropertiesEdit();
            for (String key : u.getProps().keySet()) {
                String value = (String)u.getProps().get(key);
                rpe.addProperty(key, value);
            }
        } else {
            throw new IllegalArgumentException("Invalid entity for update, must be User or EntityUser object");
        }
        try {
            this.userDirectoryService.commitEdit(edit);
        }
        catch (UserAlreadyDefinedException e) {
            throw new RuntimeException(ref + ": This exception should not be possible: " + e.getMessage(), e);
        }
    }

    public void deleteEntity(EntityReference ref, Map<String, Object> params) {
        String userId = ref.getId();
        if (userId == null || "".equals(userId)) {
            throw new IllegalArgumentException("Cannot delete, No userId in provided reference: " + ref);
        }
        User user = this.getUserByIdEid(userId);
        if (user != null) {
            try {
                UserEdit edit = this.userDirectoryService.editUser(user.getId());
                this.userDirectoryService.removeUser(edit);
            }
            catch (UserNotDefinedException e) {
                throw new IllegalArgumentException("Invalid user: " + ref + ":" + e.getMessage());
            }
            catch (UserPermissionException e) {
                throw new SecurityException("Permission denied: User cannot be removed: " + ref);
            }
            catch (UserLockedException e) {
                throw new RuntimeException("Something strange has failed with Sakai: " + e.getMessage());
            }
        }
    }

    public Object getEntity(EntityReference ref) {
        if (ref.getId() == null) {
            return new EntityUser();
        }
        String userId = ref.getId();
        User user = this.getUserByIdEid(userId);
        if (!this.developerHelperService.isEntityRequestInternal(ref.toString())) {
            String currentUserId;
            boolean allowed = false;
            String currentUserRef = this.developerHelperService.getCurrentUserReference();
            if (currentUserRef != null && (this.developerHelperService.isUserAdmin(currentUserId = this.developerHelperService.getUserIdFromRef(currentUserRef)) || currentUserId.equals(user.getId()))) {
                allowed = true;
            }
            if (!allowed) {
                throw new SecurityException("Current user (" + currentUserRef + ") cannot access information about user: " + ref);
            }
        }
        EntityUser eu = this.convertUser(user);
        return eu;
    }

    public List<?> getEntities(EntityReference ref, Search search) {
        Restriction restrict;
        Collection users = new ArrayList();
        if (!((Boolean)this.developerHelperService.getConfigurationSetting("entity.users.viewall", (Object)false)).booleanValue() && !this.developerHelperService.isEntityRequestInternal(ref.toString())) {
            String currentUserId;
            boolean allowed = false;
            String currentUserRef = this.developerHelperService.getCurrentUserReference();
            if (currentUserRef != null && this.developerHelperService.isUserAdmin(currentUserId = this.developerHelperService.getUserIdFromRef(currentUserRef))) {
                allowed = true;
            }
            if (!allowed) {
                throw new SecurityException("Only admin can access multiple users, current user (" + currentUserRef + ") cannot access ref: " + ref);
            }
        }
        if (search.getLimit() > 50L || search.getLimit() == 0L) {
            search.setLimit(50L);
        }
        if (search.getStart() == 0L || search.getStart() > 49L) {
            search.setStart(1L);
        }
        if ((restrict = search.getRestrictionByProperty("email")) != null) {
            users = this.userDirectoryService.findUsersByEmail(restrict.value.toString());
        }
        if (restrict == null) {
            restrict = search.getRestrictionByProperty("eid");
            if (restrict == null) {
                restrict = search.getRestrictionByProperty("search");
            }
            if (restrict == null) {
                restrict = search.getRestrictionByProperty("criteria");
            }
            if (restrict != null) {
                users = this.userDirectoryService.searchUsers(restrict.value + "", (int)search.getStart(), (int)search.getLimit());
            }
        }
        if (restrict == null) {
            users = this.userDirectoryService.getUsers((int)search.getStart(), (int)search.getLimit());
        }
        ArrayList<EntityUser> entityUsers = new ArrayList<EntityUser>();
        for (User user : users) {
            entityUsers.add(this.convertUser(user));
        }
        return entityUsers;
    }

    public String[] getHandledInputFormats() {
        return new String[]{"html", "xml", "json"};
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"xml", "json", "form"};
    }

    public EntityUser getUserById(String userId) {
        if ((userId = this.findAndCheckUserId(userId, null)) == null) {
            return null;
        }
        User user = this.getUserByIdEid(ID_PREFIX + userId);
        EntityUser eu = this.convertUser(user);
        return eu;
    }

    private boolean isUsingSameIdEid() {
        if (this.usesSeparateIdEid == null) {
            String config = (String)this.developerHelperService.getConfigurationSetting("separateIdEid@org.sakaiproject.user.api.UserDirectoryService", (Object)null);
            if (config != null) {
                try {
                    this.usesSeparateIdEid = (Boolean)ReflectUtils.getInstance().convert((Object)config, Boolean.class);
                }
                catch (UnsupportedOperationException e) {
                    this.usesSeparateIdEid = null;
                }
            }
            if (this.usesSeparateIdEid == null) {
                try {
                    this.usesSeparateIdEid = (Boolean)FieldUtils.getInstance().getFieldValue((Object)this.userDirectoryService, "m_separateIdEid", Boolean.class);
                }
                catch (RuntimeException e) {
                    this.usesSeparateIdEid = null;
                }
            }
            if (this.usesSeparateIdEid == null) {
                this.usesSeparateIdEid = Boolean.FALSE;
            }
        }
        return this.usesSeparateIdEid == false;
    }

    public String findAndCheckUserId(String currentUserId, String currentUserEid) {
        if (currentUserId == null && currentUserEid == null) {
            throw new IllegalArgumentException("Cannot get user from a null userId and eid, ensure at least userId or userEid are set");
        }
        String userId = null;
        if (currentUserId == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("currentUserId is null, currentUserEid=" + currentUserEid), (Throwable)new Exception());
            }
            if (currentUserEid.startsWith("/user/")) {
                currentUserEid = new EntityReference(currentUserEid).getId();
            }
            if (this.isUsingSameIdEid()) {
                try {
                    User u = this.getUserByIdEid(currentUserEid);
                    if (u != null) {
                        userId = u.getId();
                    }
                }
                catch (IllegalArgumentException e) {
                    userId = null;
                }
            } else if (this.userIdExplicitOnly()) {
                if (currentUserEid.length() > ID_PREFIX.length() && currentUserEid.startsWith(ID_PREFIX)) {
                    currentUserEid = currentUserEid.substring(ID_PREFIX.length());
                    try {
                        userId = this.userDirectoryService.getUserId(currentUserEid);
                    }
                    catch (UserNotDefinedException e2) {
                        userId = null;
                    }
                } else {
                    try {
                        this.userDirectoryService.getUserEid(currentUserEid);
                        userId = currentUserEid;
                    }
                    catch (UserNotDefinedException e2) {
                        userId = null;
                    }
                }
            } else {
                try {
                    userId = this.userDirectoryService.getUserId(currentUserEid);
                }
                catch (UserNotDefinedException e) {
                    try {
                        this.userDirectoryService.getUserEid(currentUserEid);
                        userId = currentUserEid;
                    }
                    catch (UserNotDefinedException e2) {
                        userId = null;
                    }
                }
            }
        } else {
            if (currentUserId.startsWith("/user/")) {
                currentUserId = new EntityReference(currentUserId).getId();
            }
            if (this.isUsingSameIdEid()) {
                try {
                    User u = this.getUserByIdEid(currentUserId);
                    if (u != null) {
                        userId = u.getId();
                    }
                }
                catch (IllegalArgumentException e) {
                    userId = null;
                }
            } else if (this.userIdExplicitOnly()) {
                if (currentUserId.length() > ID_PREFIX.length() && currentUserId.startsWith(ID_PREFIX)) {
                    currentUserId = currentUserId.substring(ID_PREFIX.length());
                }
                try {
                    this.userDirectoryService.getUserEid(currentUserId);
                    userId = currentUserId;
                }
                catch (UserNotDefinedException e2) {
                    userId = null;
                }
            } else {
                try {
                    this.userDirectoryService.getUserEid(currentUserId);
                    userId = currentUserId;
                }
                catch (UserNotDefinedException e) {
                    try {
                        userId = this.userDirectoryService.getUserId(currentUserId);
                    }
                    catch (UserNotDefinedException e2) {
                        userId = null;
                    }
                }
            }
        }
        return userId;
    }

    public EntityUser findUserFromSearchValue(String userSearchValue) {
        Collection users;
        User user;
        try {
            user = this.userDirectoryService.getUser(userSearchValue);
        }
        catch (UserNotDefinedException e) {
            try {
                user = this.userDirectoryService.getUserByEid(userSearchValue);
            }
            catch (UserNotDefinedException e1) {
                user = null;
            }
        }
        if (user == null && (users = this.userDirectoryService.findUsersByEmail(userSearchValue)) != null && users.size() > 0) {
            user = (User)users.iterator().next();
            if (users.size() > 1 && log.isWarnEnabled()) {
                log.warn((Object)("Found multiple users with email " + userSearchValue));
            }
        }
        EntityUser entityUser = user != null ? this.convertUser(user) : null;
        return entityUser;
    }

    public EntityUser convertUser(User user) {
        EntityUser eu = new EntityUser(user);
        return eu;
    }

    private User getUserByIdEid(String userEid) {
        User user = null;
        if (userEid != null) {
            String msg;
            boolean doCheckForId = false;
            boolean doCheckForEid = true;
            String userId = userEid;
            if (userId.length() > ID_PREFIX.length() && userId.startsWith(ID_PREFIX)) {
                userId = userEid.substring(ID_PREFIX.length());
                doCheckForEid = false;
                doCheckForId = true;
            }
            if (doCheckForEid) {
                try {
                    user = this.userDirectoryService.getUserByEid(userEid);
                }
                catch (UserNotDefinedException e) {
                    user = null;
                    msg = "Could not find user with eid=" + userEid;
                    if (!this.userIdExplicitOnly()) {
                        msg = msg + " (attempting check using user id=" + userId + ")";
                        doCheckForId = true;
                    }
                    msg = msg + " :: " + e.getMessage();
                    log.warn((Object)msg);
                }
            }
            if (doCheckForId) {
                try {
                    user = this.userDirectoryService.getUser(userId);
                }
                catch (UserNotDefinedException e) {
                    user = null;
                    msg = "Could not find user with id=" + userId + " :: " + e.getMessage();
                    log.warn((Object)msg);
                }
            }
            if (user == null) {
                throw new IllegalArgumentException("Could not find user with eid=" + userEid + " or id=" + userId);
            }
        }
        return user;
    }

    private boolean canAddAccountType(String type) {
        log.debug((Object)("canAddAccountType(" + type + ")"));
        if (this.developerHelperService.isUserAdmin(this.developerHelperService.getCurrentUserReference())) {
            log.debug((Object)"Admin user is allowed!");
            return true;
        }
        String currentSessionUserId = this.developerHelperService.getCurrentUserId();
        log.debug((Object)("checking if " + currentSessionUserId + " can add account of type: " + type));
        if (currentSessionUserId == null) {
            String regAccountTypes = this.serverConfigurationService.getString("user.registrationTypes", "registered");
            List<String> regTypes = Arrays.asList(regAccountTypes.split(","));
            if (!regTypes.contains(type)) {
                log.warn((Object)("Anonamous user can't create an account of type: " + type + ", allowed types: " + regAccountTypes));
                return false;
            }
        } else {
            String newAccountTypes = this.serverConfigurationService.getString("user.nonAdminTypes", "guest");
            List<String> newTypes = Arrays.asList(newAccountTypes.split(","));
            if (!newTypes.contains(type)) {
                log.warn((Object)("User " + currentSessionUserId + " can't create an account of type: " + type + " with eid , allowed types: " + newAccountTypes));
                return false;
            }
        }
        return true;
    }

    private boolean userIdExplicitOnly() {
        boolean allowed = (Boolean)this.developerHelperService.getConfigurationSetting("user.explicit.id.only", (Object)false);
        return allowed;
    }
}

