/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.providers.model;

import java.util.Date;
import org.azeckoski.reflectutils.annotations.ReflectIgnoreClassFields;
import org.sakaiproject.authz.api.Member;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityFieldRequired;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityId;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityLastModified;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityOwner;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityTitle;
import org.sakaiproject.entitybroker.providers.model.EntityUser;

/*
 * Exception performing whole class analysis ignored.
 */
@ReflectIgnoreClassFields(value={"role"})
public class EntityMember
implements Member {
    public static final long serialVersionUID = 1L;
    @EntityId
    private String id;
    @EntityFieldRequired
    @EntityOwner
    private String userId;
    @EntityFieldRequired
    private String locationReference;
    @EntityFieldRequired
    private String memberRole;
    private String userEid;
    private boolean active = true;
    private boolean provided = false;
    @EntityTitle
    private String userDisplayName;
    private String userSortName;
    private String userEmail;
    @EntityLastModified
    private Date lastLoginTime = new Date();
    private transient Member member;

    public EntityMember() {
    }

    public EntityMember(String userId, String locationReference, String memberRole, boolean active, EntityUser user) {
        this.id = EntityMember.makeId((String)userId, (String)locationReference);
        this.userId = userId;
        this.locationReference = locationReference;
        this.memberRole = memberRole;
        this.active = active;
        if (user != null) {
            this.userDisplayName = user.getDisplayName();
            this.userSortName = user.getSortName();
            this.userEmail = user.getEmail();
        } else {
            this.userDisplayName = userId;
            this.userSortName = userId;
        }
    }

    public EntityMember(Member member, String locationReference, EntityUser user) {
        this.userId = member.getUserId();
        this.id = EntityMember.makeId((String)this.userId, (String)locationReference);
        this.userEid = member.getUserEid();
        this.memberRole = member.getRole() == null ? null : member.getRole().getId();
        this.locationReference = locationReference;
        this.member = member;
        this.active = member.isActive();
        this.provided = member.isProvided();
        if (user != null) {
            this.userDisplayName = user.getDisplayName();
            this.userSortName = user.getSortName();
            this.userEmail = user.getEmail();
        } else {
            this.userDisplayName = member.getUserDisplayId();
            this.userSortName = member.getUserEid();
        }
    }

    public static String makeId(String userId, String locationReference) {
        if (userId == null || locationReference == null || "".equals(locationReference)) {
            throw new IllegalArgumentException("userId (" + userId + ") and locationReference (" + locationReference + ") cannot be null when creating an id for a membership");
        }
        if (locationReference.charAt(0) != '/') {
            throw new IllegalArgumentException("locationReference (" + locationReference + ") must be a reference like '/site/siteId'");
        }
        if (userId.charAt(0) == '/') {
            userId = userId.substring(1);
        }
        if (userId.indexOf(47) > 0) {
            userId = userId.replace('/', ':');
        }
        if (locationReference.charAt(0) == '/') {
            locationReference = locationReference.substring(1);
        }
        if (locationReference.indexOf(47) > 0) {
            locationReference = locationReference.replace('/', ':');
        }
        String id = userId + "::" + locationReference;
        return id;
    }

    public static String[] parseId(String membershipId) {
        String locationRef;
        EntityReference ref;
        if (membershipId == null || "".equals(membershipId)) {
            throw new IllegalArgumentException("membershipId cannot be null");
        }
        int splitter = membershipId.indexOf("::");
        if (splitter == -1 || membershipId.length() < splitter + 3) {
            return null;
        }
        String userId = membershipId.substring(0, splitter);
        if (userId.startsWith("user:")) {
            userId = userId.substring(5);
        }
        if ((ref = new EntityReference(locationRef = '/' + membershipId.substring(splitter + 2).replace(':', '/'))).getId() == null) {
            return null;
        }
        String locType = ref.getPrefix();
        String[] togo = new String[]{userId, locationRef, locType};
        return togo;
    }

    @EntityId
    public String getId() {
        return this.id;
    }

    @EntityOwner
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getLocationReference() {
        return this.locationReference;
    }

    public void setLocationReference(String locationReference) {
        this.locationReference = locationReference;
    }

    public String getMemberRole() {
        return this.memberRole;
    }

    public void setMemberRole(String memberRole) {
        this.memberRole = memberRole;
    }

    public String getUserEid() {
        return this.userEid == null ? this.getUserId() : this.userEid;
    }

    public boolean isProvided() {
        return this.provided;
    }

    public void setProvided(boolean provided) {
        this.provided = provided;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getUserDisplayName() {
        return this.userDisplayName == null ? this.getUserEid() : this.userDisplayName;
    }

    public String getUserSortName() {
        return this.userSortName == null ? this.getUserDisplayName() : this.userSortName;
    }

    public String getUserEmail() {
        return this.userEmail == null ? this.getUserEid() : this.userEmail;
    }

    public Date getLastLoginTime() {
        return this.lastLoginTime;
    }

    public Role getRole() {
        if (this.member != null) {
            return this.member.getRole();
        }
        throw new UnsupportedOperationException();
    }

    public String getUserDisplayId() {
        if (this.member != null) {
            return this.member.getUserDisplayId();
        }
        throw new UnsupportedOperationException();
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof Member)) {
            throw new ClassCastException();
        }
        if (obj == this) {
            return 0;
        }
        int compare = this.getUserId().compareTo(((Member)obj).getUserId());
        return compare;
    }
}

