/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.privacy.PrivacyManager;
import org.sakaiproject.authz.api.Member;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.email.api.EmailService;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.EntityView;
import org.sakaiproject.entitybroker.entityprovider.CoreEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityCustomAction;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RESTful;
import org.sakaiproject.entitybroker.entityprovider.extension.ActionReturn;
import org.sakaiproject.entitybroker.entityprovider.extension.EntityData;
import org.sakaiproject.entitybroker.entityprovider.search.Order;
import org.sakaiproject.entitybroker.entityprovider.search.Restriction;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.entitybroker.exception.EntityNotFoundException;
import org.sakaiproject.entitybroker.providers.MembershipEntityProvider;
import org.sakaiproject.entitybroker.providers.UserEntityProvider;
import org.sakaiproject.entitybroker.providers.model.EntityMember;
import org.sakaiproject.entitybroker.providers.model.EntityUser;
import org.sakaiproject.entitybroker.util.AbstractEntityProvider;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;

public class MembershipEntityProvider
extends AbstractEntityProvider
implements CoreEntityProvider,
RESTful,
ActionsExecutable {
    private static Log log = LogFactory.getLog(MembershipEntityProvider.class);
    private SiteService siteService;
    private UserEntityProvider userEntityProvider;
    private EmailService emailService;
    private PrivacyManager privacyManager;
    private SecurityService securityService;
    public static String PREFIX = "membership";
    private static final String GROUP_PROP_WSETUP_CREATED = "group_prop_wsetup_created";
    private static final String ADMIN_SITE_ID = "!admin";
    private static final String ADMIN_SITE_CHANGE_ALLOWED = "eb.membership.admin.site.changes.allowed";
    private boolean allowAdminSiteChanges = false;

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setUserEntityProvider(UserEntityProvider userEntityProvider) {
        this.userEntityProvider = userEntityProvider;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public void setPrivacyManager(PrivacyManager privacyManager) {
        this.privacyManager = privacyManager;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public String getEntityPrefix() {
        return PREFIX;
    }

    public void init() {
        this.allowAdminSiteChanges = (Boolean)this.developerHelperService.getConfigurationSetting(ADMIN_SITE_CHANGE_ALLOWED, (Object)false);
    }

    @EntityCustomAction(action="join", viewKey="new")
    public boolean joinCurrentUserToSite(EntityView view, Map<String, Object> params) {
        String siteId = view.getPathSegment(2);
        if (siteId == null) {
            siteId = (String)params.get("siteId");
        } else if ("site".equals(siteId)) {
            siteId = view.getPathSegment(3);
        }
        if (siteId == null) {
            throw new IllegalArgumentException("siteId must be set in order join sites, set in params or in the URL /join/site/siteId");
        }
        this.checkSiteSecurity(siteId);
        try {
            this.siteService.join(siteId);
        }
        catch (IdUnusedException e) {
            throw new IllegalArgumentException("The siteId provided (" + siteId + ") could not be found: " + (Object)((Object)e), e);
        }
        catch (PermissionException e) {
            throw new SecurityException("The current user (" + this.developerHelperService.getCurrentUserId() + ") does not have permission to join site (" + siteId + "): " + (Object)((Object)e), e);
        }
        return true;
    }

    @EntityCustomAction(action="unjoin", viewKey="new")
    public boolean unjoinCurrentUserFromSite(EntityView view, Map<String, Object> params) {
        String siteId = view.getPathSegment(2);
        if (siteId == null) {
            siteId = (String)params.get("siteId");
        } else if ("site".equals(siteId)) {
            siteId = view.getPathSegment(3);
        }
        if (siteId == null) {
            throw new IllegalArgumentException("siteId must be set in order to unjoin sites, set in params or in the URL /unjoin/site/siteId");
        }
        this.checkSiteSecurity(siteId);
        try {
            this.siteService.unjoin(siteId);
        }
        catch (IdUnusedException e) {
            throw new IllegalArgumentException("The siteId provided (" + siteId + ") could not be found: " + (Object)((Object)e), e);
        }
        catch (PermissionException e) {
            throw new SecurityException("The current user (" + this.developerHelperService.getCurrentUserId() + ") does not have permission to join site (" + siteId + "): " + (Object)((Object)e), e);
        }
        return true;
    }

    @EntityCustomAction(action="site", viewKey="")
    public ActionReturn handleSiteMemberships(EntityView view, Map<String, Object> params) {
        String siteId;
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleSiteMemberships method=" + view.getMethod() + ", params=" + params));
        }
        if ((siteId = view.getPathSegment(2)) == null && (siteId = (String)params.get("siteId")) == null) {
            throw new IllegalArgumentException("siteId must be set in order to get site memberships, set in params or in the URL /membership/site/siteId");
        }
        String locationReference = "/site/" + siteId;
        Map extraResponseHeaders = null;
        if (EntityView.Method.POST.name().equals(view.getMethod())) {
            extraResponseHeaders = this.createBatchMemberships(view, params, locationReference);
        }
        List l = this.getEntities(new EntityReference(PREFIX, ""), new Search("_locationReference", (Object)locationReference));
        ActionReturn actionReturn = new ActionReturn(l, "json");
        if (extraResponseHeaders != null && !extraResponseHeaders.isEmpty()) {
            actionReturn.setHeaders(extraResponseHeaders);
        }
        return actionReturn;
    }

    public Map<String, String> createBatchMemberships(EntityView view, Map<String, Object> params, String locationReference) {
        StringBuilder listString;
        Iterator listIter;
        SiteGroup sg = this.findLocationByReference(locationReference);
        String roleId = (String)params.get("memberRole");
        String notificationMessage = (String)params.get("notificationMessage");
        if (notificationMessage != null && notificationMessage.trim().length() == 0) {
            notificationMessage = null;
        }
        boolean active = true;
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        HashSet<EntityUser> users = new HashSet<EntityUser>();
        HashSet<String> valuesNotFound = new HashSet<String>();
        HashSet<String> valuesAlreadyMembers = new HashSet<String>();
        List userSearchValues = this.getListFromValue(params.get("userSearchValues"));
        for (String userSearchValue : userSearchValues) {
            EntityUser user = this.userEntityProvider.findUserFromSearchValue(userSearchValue);
            if (user != null) {
                if (sg.site.getUserRole(user.getId()) != null) {
                    valuesAlreadyMembers.add(userSearchValue);
                    continue;
                }
                users.add(user);
                continue;
            }
            valuesNotFound.add(userSearchValue);
        }
        if (!users.isEmpty()) {
            String currentUserEmail = this.userEntityProvider.getCurrentUser(null).getEmail();
            for (EntityUser user : users) {
                sg.site.addMember(user.getId(), roleId, active, false);
                if (notificationMessage == null) continue;
                this.emailService.send(currentUserEmail, user.getEmail(), "New Site Membership Notification", notificationMessage, null, null, null);
            }
            this.saveSiteMembership(sg.site);
            responseHeaders.put("x-success-count", String.valueOf(users.size()));
        }
        if (!valuesNotFound.isEmpty()) {
            listIter = valuesNotFound.iterator();
            listString = new StringBuilder((String)listIter.next());
            while (listIter.hasNext()) {
                listString.append(", ").append((String)listIter.next());
            }
            responseHeaders.put("x-warning-not-found", listString.toString());
        }
        if (!valuesAlreadyMembers.isEmpty()) {
            listIter = valuesAlreadyMembers.iterator();
            listString = new StringBuilder((String)listIter.next());
            while (listIter.hasNext()) {
                listString.append(", ").append((String)listIter.next());
            }
            responseHeaders.put("x-warning-already-members", listString.toString());
        }
        return responseHeaders;
    }

    @EntityCustomAction(action="group", viewKey="")
    public List<EntityData> getGroupMemberships(EntityView view, Map<String, Object> params) {
        String groupId = view.getPathSegment(2);
        List ed = null;
        if (EntityView.Method.GET.name().equals(view.getMethod())) {
            if (groupId == null && (groupId = (String)params.get("groupId")) == null) {
                throw new IllegalArgumentException("groupId must be set in order to get group memberships, set in params or in the URL /membership/group/groupId");
            }
            ed = this.getEntities(new EntityReference(PREFIX, ""), new Search("_locationReference", (Object)("/group/" + groupId)));
        } else if (EntityView.Method.POST.name().equals(view.getMethod())) {
            ArrayList userIds;
            String action;
            String string = action = params.get("action") != null ? params.get("action").toString() : null;
            if (action == null || "".equals(action)) {
                throw new IllegalArgumentException("A parameter named 'action' needs to be specified. 'action' can be update, add or remove. Cannot edit group:" + groupId);
            }
            List<Object> list = userIds = params.get("userIds") != null ? Arrays.asList(params.get("userIds").toString().split(",")) : new ArrayList();
            if (userIds.size() <= 0) {
                throw new IllegalArgumentException("A list of user ids needs to be specified as a parameter named 'userIds'. Cannot edit group:" + groupId);
            }
            SiteGroup siteGroup = this.findLocationByReference("/group/" + groupId);
            Site site = siteGroup.site;
            Group group = siteGroup.group;
            if (site == null) {
                throw new IllegalArgumentException("The site for the group (" + groupId + ") could not be found.");
            }
            if (group == null) {
                throw new IllegalArgumentException("The group provided (" + groupId + ") could not be found.");
            }
            this.checkGroupType(group);
            if (!this.siteService.allowUpdateSite(site.getId())) {
                throw new SecurityException("This site (" + site.getReference() + ") cannot be updated by the current user.");
            }
            if ("add".equals(action)) {
                for (String user : userIds) {
                    String userId = this.userEntityProvider.findAndCheckUserId(null, user.trim());
                    if (userId == null) {
                        log.warn((Object)("Unable to add user (" + user + ") to group (" + group.getId() + ") in site (" + site.getId() + "), could not find user record by id or eid"));
                        continue;
                    }
                    Member m = site.getMember(userId);
                    if (m == null) {
                        log.warn((Object)("Unable to add user (" + user + ") to group (" + group.getId() + ") in site (" + site.getId() + "), user is not a member of the site (and must be)"));
                        continue;
                    }
                    Role role = m.getRole();
                    if (group.getMember(userId) != null || role == null || role.getId() == null) continue;
                    group.addMember(userId, role.getId(), m != null ? m.isActive() : true, false);
                }
            } else if ("update".equals(action)) {
                if (!this.siteService.allowUpdateGroupMembership(site.getId())) {
                    throw new SecurityException("This group (" + groupId + ") in site (" + site.getId() + ") cannot be updated by the current user.");
                }
                group.removeMembers();
                for (String user : userIds) {
                    String userId = this.userEntityProvider.findAndCheckUserId(null, user.trim());
                    if (userId == null) {
                        log.warn((Object)("Unable to update user (" + user + ") in group (" + group.getId() + ") in site (" + site.getId() + "), could not find user record by id or eid"));
                        continue;
                    }
                    Member m = site.getMember(userId);
                    Role role = m.getRole();
                    if (group.getMember(userId) != null || role == null || role.getId() == null) continue;
                    group.addMember(userId, role.getId(), m != null ? m.isActive() : true, false);
                }
            } else if ("remove".equals(action)) {
                for (String userId : userIds) {
                    if ((userId = this.userEntityProvider.findAndCheckUserId(null, userId.trim())) == null) {
                        log.warn((Object)("Unable to remove user (" + userId + ") from group (" + group.getId() + ") in site (" + site.getId() + "), could not find user record by id or eid"));
                        continue;
                    }
                    group.removeMember(userId);
                }
            } else {
                throw new IllegalArgumentException("A valid value for the parameter named 'action' needs to be specified. 'action' can be update, add or remove. Cannot edit group:" + groupId);
            }
            try {
                this.siteService.save(site);
            }
            catch (IdUnusedException e) {
                throw new IllegalArgumentException("Cannot find site with given id: " + site.getId() + ":" + e.getMessage(), e);
            }
            catch (PermissionException e) {
                throw new SecurityException("Current user does not have permission to save this group:" + groupId + " to site:" + site.getId());
            }
            return null;
        }
        return ed;
    }

    public boolean entityExists(String id) {
        if (id == null) {
            return false;
        }
        if ("".equals(id)) {
            return true;
        }
        String[] parts = EntityMember.parseId((String)id);
        return parts != null;
    }

    public Object getEntity(EntityReference ref) {
        if (ref.getId() == null) {
            return new EntityMember();
        }
        String mid = ref.getId();
        String[] parts = EntityMember.parseId((String)mid);
        if (parts == null) {
            throw new IllegalArgumentException("Invalid membership id (" + mid + "), should be formed like so: 'userId::site:siteId' or 'userId::group:groupId");
        }
        EntityMember member = this.getMember(parts[0], parts[1]);
        if (member == null) {
            throw new IllegalArgumentException("Cannot find membership with id: " + mid);
        }
        return member;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EntityData> getEntities(EntityReference ref, Search search) {
        String currentUserId = this.developerHelperService.getCurrentUserId();
        String userId = null;
        String locationReference = null;
        String roleId = null;
        boolean includeSites = true;
        boolean includeGroups = false;
        HashMap<String, String> siteTypes = new HashMap<String, String>();
        if (search == null) {
            search = new Search();
        }
        if (!search.isEmpty()) {
            Restriction incGroups;
            Restriction incSites;
            Restriction locRes;
            roleId = (String)search.getRestrictionValueByProperties(new String[]{"role", "roleId"});
            Restriction userRes = search.getRestrictionByProperty("_userReference");
            if (userRes != null) {
                String userRef = userRes.getStringValue();
                userId = EntityReference.getIdFromRef((String)userRef);
            }
            if ((locRes = search.getRestrictionByProperty("_locationReference")) != null) {
                locationReference = locRes.getStringValue();
            }
            if ((incSites = search.getRestrictionByProperty("includeSites")) != null) {
                includeSites = incSites.getBooleanValue();
            }
            if ((incGroups = search.getRestrictionByProperty("includeGroups")) != null) {
                includeGroups = incGroups.getBooleanValue();
            }
        }
        if (locationReference == null && userId == null && currentUserId != null) {
            userId = currentUserId;
        }
        if (locationReference == null && userId == null) {
            throw new IllegalArgumentException("There must be a current user logged in OR you must provide a search with the following restrictions (getting all is not supported): siteId, locationReference, groupId AND (optionally) roleId OR userReference, userId, user");
        }
        List<EntityMember> members = new ArrayList();
        boolean findByLocation = false;
        if (locationReference != null) {
            findByLocation = true;
            members = this.getMembers(locationReference);
        } else {
            if (!includeGroups && !includeSites) {
                throw new IllegalArgumentException("includesSites and includesGroups cannot both be false");
            }
            if ((userId = this.userEntityProvider.findAndCheckUserId(userId, null)) == null) {
                throw new IllegalArgumentException("unable to find user with id (" + userId + ")");
            }
            boolean userCurrent = userId.equals(currentUserId);
            if (!userCurrent && !this.developerHelperService.isUserAdmin(currentUserId)) {
                throw new SecurityException("Only admin can access other user memberships, current user (" + currentUserId + ") cannot access ref: " + userId);
            }
            try {
                if (!userCurrent) {
                    this.developerHelperService.setCurrentUser("/user/" + userId);
                }
                List sites = this.siteService.getSites(SiteService.SelectionType.ACCESS, null, null, null, null, null);
                for (Site site : sites) {
                    Member sm = site.getMember(userId);
                    if (sm == null) continue;
                    if (includeSites) {
                        EntityMember em = new EntityMember(sm, site.getReference(), null);
                        members.add(em);
                        siteTypes.put(em.getId(), site.getType());
                    }
                    if (!includeGroups) continue;
                    Collection groups = site.getGroups();
                    for (Group group : groups) {
                        Member gm = group.getMember(userId);
                        if (gm == null) continue;
                        members.add(new EntityMember(gm, group.getReference(), null));
                    }
                }
            }
            finally {
                if (!userCurrent) {
                    this.developerHelperService.restoreCurrentUser();
                }
            }
        }
        ArrayList<EntityMember> sortedMembers = new ArrayList<EntityMember>();
        int count = 0;
        for (EntityMember em : members) {
            if ((long)count < search.getStart()) continue;
            if (search.getLimit() > 0L && (long)count > search.getLimit()) break;
            if (roleId != null && !roleId.equals(em.getMemberRole()) || findByLocation && userId != null && !userId.equals(em.getUserId())) continue;
            sortedMembers.add(em);
            ++count;
        }
        EntityMember.MemberSortName memberComparator = new EntityMember.MemberSortName();
        if (search.getOrders().length > 0) {
            Order order = search.getOrders()[0];
            if ("email".equals(order.getProperty())) {
                memberComparator = new EntityMember.MemberEmail();
            } else if ("displayName".equals(order.getProperty())) {
                memberComparator = new EntityMember.MemberDisplayName();
            } else if ("lastLogin".equals(order.getProperty())) {
                memberComparator = new EntityMember.MemberLastLogin();
            }
        }
        Collections.sort(sortedMembers, memberComparator);
        ArrayList<EntityData> l = new ArrayList<EntityData>();
        for (EntityMember em : sortedMembers) {
            HashMap<String, String> props = new HashMap<String, String>();
            String siteType = (String)siteTypes.get(em.getId());
            props.put("siteType", siteType);
            EntityData ed = new EntityData(new EntityReference(PREFIX, em.getId()), null, (Object)em, props);
            l.add(ed);
        }
        return l;
    }

    public String createEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        SiteGroup sg = null;
        String roleId = null;
        String userId = null;
        boolean active = true;
        if (entity.getClass().isAssignableFrom(Member.class)) {
            Member member = (Member)entity;
            String locationReference = (String)params.get("locationReference");
            if (locationReference == null) {
                throw new IllegalArgumentException("Cannot create/update a membership entity from Member without a locationReference in the params");
            }
            sg = this.findLocationByReference(locationReference);
            roleId = member.getRole().getId();
            userId = this.userEntityProvider.findAndCheckUserId(member.getUserId(), member.getUserEid());
            active = member.isActive();
        } else if (entity.getClass().isAssignableFrom(EntityMember.class)) {
            EntityMember em = (EntityMember)entity;
            sg = this.findLocationByReference(em.getLocationReference());
            roleId = em.getMemberRole();
            if (em.getUserId() != null || em.getUserEid() != null) {
                userId = this.userEntityProvider.findAndCheckUserId(em.getUserId(), em.getUserEid());
            }
            active = em.isActive();
        } else {
            throw new IllegalArgumentException("Invalid entity for create/update, must be Member or EntityMember object");
        }
        if (roleId == null || "".equals(roleId)) {
            roleId = sg.site.getJoinerRole();
        }
        this.checkSiteSecurity(sg.site.getId());
        Object[] userIds = this.checkForBatch(params, userId);
        String memberId = "";
        String currentUserId = this.developerHelperService.getCurrentUserId();
        for (int i = 0; i < userIds.length; ++i) {
            if (sg.group == null) {
                if (userIds[i].equals(currentUserId) && sg.site.isJoinable()) {
                    try {
                        this.siteService.join(sg.site.getId());
                    }
                    catch (IdUnusedException e) {
                        throw new IllegalArgumentException("Invalid site: " + sg.site.getId() + ":" + e.getMessage(), e);
                    }
                    catch (PermissionException e) {
                        throw new SecurityException("Current user not allowed to join site: " + sg.site.getId() + ":" + e.getMessage(), e);
                    }
                } else {
                    sg.site.addMember(userIds[i], roleId, active, false);
                    this.saveSiteMembership(sg.site);
                }
            } else {
                sg.group.addMember(userIds[i], roleId, active, false);
                this.saveGroupMembership(sg.site, sg.group);
            }
            if (i != 0) continue;
            EntityMember em = new EntityMember(userIds[0], sg.locationReference, roleId, active, null);
            memberId = em.getId();
        }
        if (userIds.length > 1) {
            log.info((Object)("Batch add memberships: siteId=" + (sg.site == null ? "none" : sg.site.getId()) + ",groupId=" + (sg.group == null ? "none" : sg.group.getId()) + ",userIds=" + Search.arrayToString((Object[])userIds)));
            memberId = "batch:" + memberId;
        }
        return memberId;
    }

    public Object getSampleEntity() {
        return new EntityMember();
    }

    public void updateEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        this.createEntity(ref, entity, params);
    }

    public void deleteEntity(EntityReference ref, Map<String, Object> params) {
        String mid = ref.getId();
        String[] parts = EntityMember.parseId((String)mid);
        if (parts == null) {
            throw new IllegalArgumentException("Invalid membership id (" + mid + "), should be formed like so: 'userId::site:siteId' or 'userId::group:groupId");
        }
        String userId = parts[0];
        SiteGroup sg = this.findLocationByReference(parts[1]);
        Object[] userIds = this.checkForBatch(params, userId);
        for (int i = 0; i < userIds.length; ++i) {
            if (sg.group == null) {
                sg.site.removeMember(userIds[i]);
                this.saveSiteMembership(sg.site);
                continue;
            }
            sg.group.removeMember(userIds[i]);
            this.saveGroupMembership(sg.site, sg.group);
        }
        if (userIds.length > 1) {
            log.info((Object)("Batch remove memberships: siteId=" + (sg.site == null ? "none" : sg.site.getId()) + ",groupId=" + (sg.group == null ? "none" : sg.group.getId()) + ",userIds=" + Search.arrayToString((Object[])userIds)));
        }
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"html", "xml", "json", "form"};
    }

    public String[] getHandledInputFormats() {
        return new String[]{"html", "xml", "json"};
    }

    public EntityMember getMember(String userId, String locationReference) {
        EntityMember em = null;
        Member member = null;
        SiteGroup sg = this.findLocationByReference(locationReference);
        String currentUserId = this.developerHelperService.getCurrentUserId();
        if (!userId.equals(currentUserId)) {
            this.isAllowedAccessMembers(sg.site, sg.group);
        }
        boolean viewHidden = this.securityService.unlock("roster.viewHidden", sg.site.getReference());
        if (sg.group == null) {
            member = sg.site.getMember(userId);
        } else {
            member = sg.group.getMember(userId);
            boolean bl = viewHidden = viewHidden || this.securityService.unlock("roster.viewHidden", sg.group.getReference());
        }
        if (member != null && !this.privacyManager.findHidden(sg.site.getReference(), new HashSet<String>(Arrays.asList(userId))).contains(userId)) {
            EntityUser eu = this.userEntityProvider.getUserById(userId);
            em = new EntityMember(member, sg.locationReference, eu);
        }
        return em;
    }

    public List<EntityMember> getMembers(String locationReference) {
        SiteGroup sg;
        ArrayList<EntityMember> l = new ArrayList<EntityMember>();
        Set members = null;
        try {
            sg = this.findLocationByReference(locationReference);
        }
        catch (IllegalArgumentException e) {
            throw new EntityNotFoundException("Could not find the location based on the ref (" + locationReference + "): " + e, locationReference);
        }
        this.isAllowedAccessMembers(sg.site, sg.group);
        boolean viewHidden = this.securityService.unlock("roster.viewHidden", sg.site.getReference());
        Set hiddenUsers = new HashSet();
        if (sg.group == null) {
            members = sg.site.getMembers();
        } else {
            members = sg.group.getMembers();
            boolean bl = viewHidden = viewHidden || this.securityService.unlock("roster.viewHidden", sg.group.getReference());
        }
        if (!this.siteService.allowViewRoster(sg.site.getId()) && !viewHidden) {
            HashSet<String> memberIds = new HashSet<String>();
            for (Member member : members) {
                memberIds.add(member.getUserId());
            }
            hiddenUsers = this.privacyManager.findHidden(sg.site.getReference(), memberIds);
        }
        for (Member member : members) {
            EntityUser eu = this.userEntityProvider.getUserById(member.getUserId());
            if (eu == null || hiddenUsers.contains(member.getUserId())) continue;
            EntityMember em = new EntityMember(member, sg.locationReference, eu);
            l.add(em);
        }
        return l;
    }

    public SiteGroup findLocationByReference(String locationReference) {
        SiteGroup holder = new SiteGroup(locationReference);
        if (locationReference.contains("/group/")) {
            String groupId = EntityReference.getIdFromRefByKey((String)locationReference, (String)"group");
            if (groupId == null || "".equals(groupId)) {
                throw new IllegalArgumentException("locationReferences for groups must be structured like this: /site/siteid/group/groupId or /group/groupId, could not find group in: " + locationReference);
            }
            locationReference = "/group/" + groupId;
            Group group = this.siteService.findGroup(groupId);
            if (group == null) {
                throw new IllegalArgumentException("No group found for id: " + groupId);
            }
            Site site = group.getContainingSite();
            holder.locationReference = locationReference;
            holder.group = group;
            holder.site = site;
        } else if (locationReference.contains("/site/")) {
            Site site;
            String siteId = EntityReference.getIdFromRefByKey((String)locationReference, (String)"site");
            holder.site = site = this.getSiteById(siteId);
        } else {
            throw new IllegalArgumentException("Do not know how to handle this location reference (" + locationReference + "), only can handle site and group references");
        }
        if (holder.site == null) {
            throw new IllegalArgumentException("Could not find a site/group with the given reference: " + locationReference);
        }
        return holder;
    }

    protected String[] checkForBatch(Map<String, Object> params, String userId) {
        HashSet<String> userIds = new HashSet<String>();
        if (userId != null) {
            userIds.add(userId);
        }
        if (params != null) {
            List batchUserIds = this.getListFromValue(params.get("userIds"));
            for (String batchUserId : batchUserIds) {
                String uid = this.userEntityProvider.findAndCheckUserId(batchUserId, null);
                if (uid == null) continue;
                userIds.add(uid);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received userIds=" + userIds));
        }
        return userIds.toArray(new String[userIds.size()]);
    }

    protected List<String> getListFromValue(Object paramValue) {
        List<String> stringList = new ArrayList<String>();
        if (paramValue != null) {
            if (paramValue.getClass().isArray()) {
                stringList = Arrays.asList((String[])paramValue);
            } else if (paramValue instanceof String) {
                stringList.add((String)paramValue);
            }
        }
        return stringList;
    }

    protected String makeRoleId(String currentRoleId, Site site) {
        String roleId = currentRoleId;
        if (roleId == null || "".equals(roleId)) {
            roleId = site.getJoinerRole();
        }
        return roleId;
    }

    protected void saveGroupMembership(Site site, Group group) {
        try {
            this.siteService.saveGroupMembership(site);
        }
        catch (IdUnusedException e) {
            throw new IllegalArgumentException("Invalid site: " + site.getId() + ":" + e.getMessage(), e);
        }
        catch (PermissionException e) {
            throw new SecurityException("Current user (" + this.developerHelperService.getCurrentUserId() + ") not allowed to update site group memberships in group: " + group.getId() + " :" + e.getMessage() + ":" + e.getCause(), e);
        }
    }

    protected void saveSiteMembership(Site site) {
        this.checkSiteSecurity(site.getId());
        try {
            this.siteService.saveSiteMembership(site);
        }
        catch (IdUnusedException e) {
            throw new IllegalArgumentException("Invalid site: " + site.getId() + ":" + e.getMessage(), e);
        }
        catch (PermissionException e) {
            throw new SecurityException("Current user (" + this.developerHelperService.getCurrentUserId() + ") not allowed to update site memberships in site: " + site.getId() + " :" + e.getMessage() + ":" + e.getCause(), e);
        }
    }

    protected Site getSiteById(String siteId) {
        Site site;
        try {
            site = this.siteService.getSite(siteId);
        }
        catch (IdUnusedException e) {
            throw new IllegalArgumentException("Cannot find site by siteId: " + siteId, e);
        }
        return site;
    }

    protected boolean isAllowedAccessMembers(Site site, Group g) {
        String userReference = this.developerHelperService.getCurrentUserReference();
        if (userReference == null) {
            throw new SecurityException("Anonymous users may not view memberships in (" + site.getReference() + ")");
        }
        String siteId = site.getId();
        if (this.siteService.allowViewRoster(siteId)) {
            return true;
        }
        if (g != null && Boolean.TRUE.toString().equals(g.getProperties().getProperty("group_prop_view_members"))) {
            return true;
        }
        throw new SecurityException("Memberships in this site (" + site.getReference() + ") are not accessible for the current user: " + userReference);
    }

    protected void addUsersToGroup(Site site, Group group, List<String> userIds) {
        for (String user : userIds) {
            String userId = user.trim();
            Role role = site.getUserRole(userId);
            Member m = site.getMember(userId);
            if (group.getUserRole(userId) != null || role.getId() == null) continue;
            group.addMember(userId, role.getId(), m != null ? m.isActive() : true, false);
        }
    }

    private void checkGroupType(Group group) {
        if (group != null) {
            try {
                if (!group.getProperties().getBooleanProperty(GROUP_PROP_WSETUP_CREATED)) {
                    throw new IllegalArgumentException("This type of group (Section Info group) should not be edited by this entity provider. Only Site info groups are allowed.");
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("This type of group (Section Info group) should not be edited by this entity provider. Only Site info groups are allowed.");
            }
        }
    }

    private void checkSiteSecurity(String siteId) {
        if (!this.allowAdminSiteChanges && ADMIN_SITE_ID.equals(siteId)) {
            throw new SecurityException("Admin site membership changes are disabled for security protection against CSRF, you must use the sakai admin UI or enable changes in your sakai config file using eb.membership.admin.site.changes.allowed=true");
        }
    }
}

