/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.providers.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.azeckoski.reflectutils.annotations.ReflectIgnoreClassFields;
import org.azeckoski.reflectutils.annotations.ReflectTransient;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.Member;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.authz.api.RoleAlreadyDefinedException;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.entitybroker.DeveloperHelperService;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityFieldRequired;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityId;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityLastModified;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityOwner;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntitySummary;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityTitle;
import org.sakaiproject.entitybroker.providers.model.EntityGroup;
import org.sakaiproject.entitybroker.providers.model.EntitySitePage;
import org.sakaiproject.entitybroker.providers.model.Owner;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SitePage;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.util.Web;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@ReflectIgnoreClassFields(value={"createdBy", "modifiedBy", "properties", "propertiesEdit", "members", "orderedPages", "pages", "roles", "users", "groups", "url"})
public class EntitySite
implements Site {
    private static final long serialVersionUID = 7526472295622776147L;
    @EntityId
    private String id;
    @EntityFieldRequired
    private String title;
    private String shortDescription;
    private String htmlShortDescription;
    private String description;
    private String htmlDescription;
    private String iconUrl;
    private String iconUrlFull;
    private String infoUrl;
    private String infoUrlFull;
    private boolean joinable;
    private String joinerRole;
    private String maintainRole;
    private String skin;
    private boolean published;
    private boolean pubView;
    @EntityFieldRequired
    private String type;
    private String providerGroupId;
    private boolean customPageOrdered;
    private String owner;
    private long lastModified;
    private String[] userRoles;
    private transient List<EntityGroup> siteGroupsList;
    public Map<String, String> props;
    private transient Site site;

    public Map<String, String> getProps() {
        if (this.props == null) {
            this.props = new HashMap();
        }
        return this.props;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    public void setProperty(String key, String value) {
        if (this.props == null) {
            this.props = new HashMap();
        }
        this.props.put(key, value);
    }

    public String getProperty(String key) {
        if (this.props == null) {
            return null;
        }
        return (String)this.props.get(key);
    }

    public EntitySite() {
    }

    public EntitySite(String title, String shortDescription, String description, String iconUrl, String iconFullUrl, String infoUrl, String infoUrlFull, boolean joinable, String joinerRole, String maintainRole, String skin, boolean published, boolean pubView, String type, String providerGroupId, boolean customPageOrdered) {
        this(title, shortDescription, Web.escapeHtml((String)shortDescription), description, Web.escapeHtml((String)description), iconUrl, iconFullUrl, infoUrl, infoUrlFull, joinable, joinerRole, maintainRole, skin, published, pubView, type, providerGroupId, customPageOrdered);
    }

    public EntitySite(String title, String shortDescription, String htmlShortDescription, String description, String htmlDescription, String iconUrl, String iconFullUrl, String infoUrl, String infoUrlFull, boolean joinable, String joinerRole, String maintainRole, String skin, boolean published, boolean pubView, String type, String providerGroupId, boolean customPageOrdered) {
        this.title = title;
        this.shortDescription = shortDescription;
        this.htmlShortDescription = htmlShortDescription;
        this.description = description;
        this.htmlDescription = htmlDescription;
        this.iconUrl = iconUrl;
        this.iconUrlFull = iconFullUrl;
        this.infoUrl = infoUrl;
        this.infoUrlFull = infoUrlFull;
        this.joinable = joinable;
        this.joinerRole = joinerRole;
        this.maintainRole = maintainRole;
        this.skin = skin;
        this.published = published;
        this.pubView = pubView;
        this.type = type;
        this.providerGroupId = providerGroupId;
        this.customPageOrdered = customPageOrdered;
        this.lastModified = System.currentTimeMillis();
        this.getUserRoles();
    }

    public EntitySite(Site site, boolean includeGroups) {
        this.site = site;
        this.id = site.getId();
        this.title = site.getTitle();
        this.shortDescription = site.getShortDescription();
        this.htmlShortDescription = site.getHtmlShortDescription();
        this.description = site.getDescription();
        this.htmlDescription = site.getHtmlDescription();
        this.iconUrl = site.getIconUrl();
        this.infoUrl = site.getInfoUrl();
        this.iconUrlFull = site.getIconUrlFull();
        this.joinable = site.isJoinable();
        this.joinerRole = site.getJoinerRole();
        this.skin = site.getSkin();
        this.published = site.isPublished();
        this.pubView = site.isPubView();
        this.type = site.getType();
        this.customPageOrdered = site.isCustomPageOrdered();
        this.maintainRole = site.getMaintainRole();
        this.providerGroupId = site.getProviderGroupId();
        this.owner = site.getCreatedBy() == null ? null : site.getCreatedBy().getId();
        this.lastModified = site.getModifiedTime() == null ? System.currentTimeMillis() : site.getModifiedTime().getTime();
        this.getUserRoles();
        ResourceProperties rp = site.getProperties();
        Iterator iterator = rp.getPropertyNames();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            String value = rp.getProperty(name);
            this.setProperty(name, value);
        }
        if (includeGroups) {
            Collection groups = site.getGroups();
            this.siteGroupsList = new Vector(groups.size());
            for (Group group : groups) {
                EntityGroup eg = new EntityGroup(group);
                this.siteGroupsList.add(eg);
            }
        }
    }

    @EntityId
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @EntityOwner
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Owner getSiteOwner() {
        Owner owner = null;
        if (this.site != null) {
            User user = this.site.getCreatedBy();
            owner = new Owner(user.getId(), user.getDisplayName());
        } else {
            owner = new Owner(this.owner, this.owner);
        }
        return owner;
    }

    @EntityLastModified
    public long getLastModified() {
        if (this.site != null) {
            this.lastModified = this.site.getModifiedTime() == null ? this.lastModified : this.site.getModifiedTime().getTime();
        }
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        throw new UnsupportedOperationException("Cannot set the last modified time manually");
    }

    @EntityTitle
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getHtmlShortDescription() {
        return this.htmlShortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
        this.htmlShortDescription = Web.escapeHtml((String)shortDescription);
    }

    @EntitySummary
    public String getDescription() {
        return this.description;
    }

    public String getHtmlDescription() {
        return this.htmlDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.htmlDescription = Web.escapeHtml((String)description);
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getInfoUrl() {
        return this.infoUrl;
    }

    public void setInfoUrl(String infoUrl) {
        this.infoUrl = infoUrl;
    }

    public String getInfoUrlFull() {
        if (this.site != null) {
            return this.site.getInfoUrlFull();
        }
        return this.infoUrlFull;
    }

    public void setInfoUrlFull(String infoUrlFull) {
        this.infoUrlFull = infoUrlFull;
    }

    public boolean isJoinable() {
        return this.joinable;
    }

    public void setJoinable(boolean joinable) {
        this.joinable = joinable;
    }

    public String getJoinerRole() {
        return this.joinerRole;
    }

    public void setJoinerRole(String joinerRole) {
        this.joinerRole = joinerRole;
    }

    public String getSkin() {
        return this.skin;
    }

    public void setSkin(String skin) {
        this.skin = skin;
    }

    public boolean isPublished() {
        return this.published;
    }

    public void setPublished(boolean published) {
        this.published = published;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setIconUrlFull(String iconUrlFull) {
        this.iconUrlFull = iconUrlFull;
    }

    public String getMaintainRole() {
        return this.maintainRole;
    }

    public void setMaintainRole(String maintainRole) {
        this.maintainRole = maintainRole;
    }

    public String getProviderGroupId() {
        return this.providerGroupId;
    }

    public void setProviderGroupId(String providerGroupId) {
        this.providerGroupId = providerGroupId;
    }

    public boolean isCustomPageOrdered() {
        return this.customPageOrdered;
    }

    public void setCustomPageOrdered(boolean customPageOrdered) {
        this.customPageOrdered = customPageOrdered;
    }

    public boolean isPubView() {
        return this.pubView;
    }

    public void setPubView(boolean pubView) {
        this.pubView = pubView;
    }

    public String[] getUserRoles() {
        if (this.userRoles == null) {
            if (this.site == null) {
                this.userRoles = new String[]{this.maintainRole, this.joinerRole};
            } else {
                Set roles = this.site.getRoles();
                this.userRoles = new String[roles.size()];
                int i = 0;
                for (Role role : roles) {
                    this.userRoles[i] = role.getId();
                    ++i;
                }
            }
        }
        return this.userRoles;
    }

    public void setUserRoles(String[] userRoles) {
        this.userRoles = userRoles;
    }

    public List<EntityGroup> getSiteGroups() {
        return this.siteGroupsList;
    }

    public List<SitePage> getSitePages() {
        ArrayList<Object> rpgs = new ArrayList<SitePage>(0);
        if (this.site != null) {
            List pages = this.site.getOrderedPages();
            rpgs = new ArrayList(pages.size());
            DeveloperHelperService dhs = (DeveloperHelperService)ComponentManager.get(DeveloperHelperService.class);
            ToolManager toolManager = (ToolManager)ComponentManager.get((String)ToolManager.class.getName());
            boolean siteUpdate = false;
            if (dhs != null && dhs.getCurrentUserId() != null) {
                siteUpdate = this.site.isAllowed(dhs.getCurrentUserId(), "site.upd");
            }
            for (SitePage sitePage : pages) {
                List pTools = sitePage.getTools();
                boolean allowPage = false;
                for (ToolConfiguration tc : pTools) {
                    boolean unHidden;
                    boolean thisTool = toolManager.allowTool(this.site, (Placement)tc);
                    boolean bl = unHidden = siteUpdate || !toolManager.isHidden((Placement)tc);
                    if (!thisTool || !unHidden) continue;
                    allowPage = true;
                }
                if (!allowPage) continue;
                rpgs.add((SitePage)new EntitySitePage(sitePage));
            }
        }
        return rpgs;
    }

    public void setSiteGroupsList(List<EntityGroup> siteGroups) {
        this.siteGroupsList = siteGroups;
    }

    public Group addGroup() {
        if (this.site != null) {
            return this.site.addGroup();
        }
        throw new UnsupportedOperationException();
    }

    public SitePage addPage() {
        if (this.site != null) {
            return this.site.addPage();
        }
        throw new UnsupportedOperationException();
    }

    public List<SitePage> getPages() {
        if (this.site != null) {
            return this.site.getPages();
        }
        throw new UnsupportedOperationException();
    }

    public User getCreatedBy() {
        if (this.site != null) {
            return this.site.getCreatedBy();
        }
        throw new UnsupportedOperationException();
    }

    public Time getCreatedTime() {
        if (this.site != null) {
            return this.site.getCreatedTime();
        }
        throw new UnsupportedOperationException();
    }

    public Date getCreatedDate() {
        if (this.site != null) {
            return this.site.getCreatedDate();
        }
        throw new UnsupportedOperationException();
    }

    public Group getGroup(String arg0) {
        if (this.site != null) {
            return this.site.getGroup(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public Collection getGroups() {
        if (this.site != null) {
            return this.site.getGroups();
        }
        throw new UnsupportedOperationException();
    }

    public Collection getGroupsWithMember(String arg0) {
        if (this.site != null) {
            return this.site.getGroupsWithMember(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public Collection getGroupsWithMemberHasRole(String arg0, String arg1) {
        if (this.site != null) {
            return this.site.getGroupsWithMemberHasRole(arg0, arg1);
        }
        throw new UnsupportedOperationException();
    }

    public String getIconUrlFull() {
        if (this.site != null) {
            return this.site.getIconUrlFull();
        }
        return this.iconUrlFull;
    }

    public User getModifiedBy() {
        if (this.site != null) {
            return this.site.getModifiedBy();
        }
        throw new UnsupportedOperationException();
    }

    public Time getModifiedTime() {
        if (this.site != null) {
            return this.site.getModifiedTime();
        }
        throw new UnsupportedOperationException();
    }

    public Date getModifiedDate() {
        if (this.site != null) {
            return this.site.getModifiedDate();
        }
        throw new UnsupportedOperationException();
    }

    public List getOrderedPages() {
        if (this.site != null) {
            return this.site.getOrderedPages();
        }
        throw new UnsupportedOperationException();
    }

    public SitePage getPage(String arg0) {
        if (this.site != null) {
            return this.site.getPage(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public ToolConfiguration getTool(String arg0) {
        if (this.site != null) {
            return this.site.getTool(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public ToolConfiguration getToolForCommonId(String arg0) {
        if (this.site != null) {
            return this.site.getToolForCommonId(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public Collection getTools(String[] arg0) {
        if (this.site != null) {
            return this.site.getTools(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public Collection getTools(String arg0) {
        if (this.site != null) {
            return this.site.getTools(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public boolean hasGroups() {
        if (this.site != null) {
            return this.site.hasGroups();
        }
        throw new UnsupportedOperationException();
    }

    public boolean isType(Object arg0) {
        if (this.site != null) {
            return this.site.isType(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public void loadAll() {
        if (this.site != null) {
            this.site.loadAll();
        }
        throw new UnsupportedOperationException();
    }

    public void regenerateIds() {
        if (this.site != null) {
            this.site.regenerateIds();
        }
        throw new UnsupportedOperationException();
    }

    public void removeGroup(Group arg0) {
        if (this.site != null) {
            this.site.removeGroup(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public void removePage(SitePage arg0) {
        if (this.site != null) {
            this.site.removePage(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public ResourcePropertiesEdit getPropertiesEdit() {
        if (this.site != null) {
            return this.site.getPropertiesEdit();
        }
        throw new UnsupportedOperationException();
    }

    public boolean isActiveEdit() {
        if (this.site != null) {
            return this.site.isActiveEdit();
        }
        throw new UnsupportedOperationException();
    }

    public ResourceProperties getProperties() {
        if (this.site != null) {
            return this.site.getProperties();
        }
        throw new UnsupportedOperationException();
    }

    public String getReference() {
        return "/site/" + this.id;
    }

    public String getReference(String arg0) {
        return this.getReference();
    }

    public String getUrl() {
        if (this.site != null) {
            return this.site.getUrl();
        }
        throw new UnsupportedOperationException();
    }

    public String getUrl(String arg0) {
        if (this.site != null) {
            return this.site.getUrl(arg0);
        }
        throw new UnsupportedOperationException();
    }

    @ReflectTransient
    public Element toXml(Document arg0, Stack arg1) {
        if (this.site != null) {
            return this.site.toXml(arg0, arg1);
        }
        throw new UnsupportedOperationException();
    }

    public int compareTo(Object o) {
        if (this.site != null) {
            return this.site.compareTo(o);
        }
        throw new UnsupportedOperationException();
    }

    public void addMember(String arg0, String arg1, boolean arg2, boolean arg3) {
        if (this.site != null) {
            this.site.addMember(arg0, arg1, arg2, arg3);
        }
        throw new UnsupportedOperationException();
    }

    public Role addRole(String arg0) throws RoleAlreadyDefinedException {
        if (this.site != null) {
            return this.site.addRole(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public Role addRole(String arg0, Role arg1) throws RoleAlreadyDefinedException {
        if (this.site != null) {
            return this.site.addRole(arg0, arg1);
        }
        throw new UnsupportedOperationException();
    }

    public Member getMember(String arg0) {
        if (this.site != null) {
            return this.site.getMember(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public Set getMembers() {
        if (this.site != null) {
            return this.site.getMembers();
        }
        throw new UnsupportedOperationException();
    }

    public Role getRole(String arg0) {
        if (this.site != null) {
            return this.site.getRole(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public Set getRoles() {
        if (this.site != null) {
            return this.site.getRoles();
        }
        throw new UnsupportedOperationException();
    }

    public Set getRolesIsAllowed(String arg0) {
        if (this.site != null) {
            return this.site.getRolesIsAllowed(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public Role getUserRole(String arg0) {
        if (this.site != null) {
            return this.site.getUserRole(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public Set getUsers() {
        if (this.site != null) {
            return this.site.getUsers();
        }
        throw new UnsupportedOperationException();
    }

    public Set getUsersHasRole(String arg0) {
        if (this.site != null) {
            return this.site.getUsersHasRole(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public Set getUsersIsAllowed(String arg0) {
        if (this.site != null) {
            return this.site.getUsersIsAllowed(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public boolean hasRole(String arg0, String arg1) {
        if (this.site != null) {
            return this.site.hasRole(arg0, arg1);
        }
        throw new UnsupportedOperationException();
    }

    public boolean isAllowed(String arg0, String arg1) {
        if (this.site != null) {
            return this.site.isAllowed(arg0, arg1);
        }
        return false;
    }

    public boolean isEmpty() {
        if (this.site != null) {
            return this.site.isEmpty();
        }
        return false;
    }

    public boolean keepIntersection(AuthzGroup arg0) {
        if (this.site != null) {
            return this.site.keepIntersection(arg0);
        }
        throw new UnsupportedOperationException();
    }

    public void removeMember(String arg0) {
        if (this.site != null) {
            this.site.removeMember(arg0);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public void removeMembers() {
        if (this.site != null) {
            this.site.removeMembers();
            return;
        }
        throw new UnsupportedOperationException();
    }

    public void removeRole(String arg0) {
        if (this.site != null) {
            this.site.removeRole(arg0);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public void removeRoles() {
        if (this.site != null) {
            this.site.removeRoles();
            return;
        }
        throw new UnsupportedOperationException();
    }

    public Date getSoftlyDeletedDate() {
        if (this.site != null) {
            return this.site.getSoftlyDeletedDate();
        }
        throw new UnsupportedOperationException();
    }

    public boolean isSoftlyDeleted() {
        if (this.site != null) {
            return this.site.isSoftlyDeleted();
        }
        throw new UnsupportedOperationException();
    }

    public void setSoftlyDeleted(boolean flag) {
        if (this.site != null) {
            this.site.setSoftlyDeleted(flag);
        }
        throw new UnsupportedOperationException();
    }

    public Collection<String> getMembersInGroups(Set<String> groupIds) {
        if (this.site != null) {
            return this.site.getMembersInGroups(groupIds);
        }
        throw new UnsupportedOperationException();
    }
}

