/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.providers;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.sakaiproject.cluster.api.ClusterService;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.entityprovider.CoreEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityCustomAction;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.CollectionResolvable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Describeable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Outputable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Resolvable;
import org.sakaiproject.entitybroker.entityprovider.extension.ActionReturn;
import org.sakaiproject.entitybroker.entityprovider.extension.EntityData;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.entitybroker.providers.ServerConfigEntityProvider;
import org.sakaiproject.entitybroker.providers.model.EntityServerConfig;
import org.sakaiproject.entitybroker.util.AbstractEntityProvider;

public class ServerConfigEntityProvider
extends AbstractEntityProvider
implements CoreEntityProvider,
Outputable,
Resolvable,
CollectionResolvable,
ActionsExecutable,
Describeable {
    public String[] includedStringSettings = new String[]{"portalPath", "version.service", "version.sakai", "version.kernel", "buildTime.kernel", "locales", "force.url.secure", "skin.default", "skin.repo", "ui.institution", "ui.service"};
    public String[] includedBooleanSettings = new String[]{"auto.ddl", "display.users.present"};
    private ServerConfigurationService serverConfigurationService;
    private ClusterService clusterService;
    public static String PREFIX = "server-config";

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public String getEntityPrefix() {
        return PREFIX;
    }

    @EntityCustomAction(action="servers", viewKey="list")
    public Object getClusterServers(EntityReference ref) {
        List servers = this.clusterService.getServers();
        return new EntityData((Object)servers);
    }

    @EntityCustomAction(action="values", viewKey="list")
    public Object getAllValues() {
        TreeMap tm = new TreeMap(this.getKnownSettings());
        return new ActionReturn(tm);
    }

    @EntityCustomAction(action="names", viewKey="list")
    public Object getAllNames(EntityReference ref) {
        Map tm = this.getKnownSettings();
        ArrayList names = new ArrayList(tm.keySet());
        Collections.sort(names);
        return new ActionReturn(names);
    }

    public boolean entityExists(String id) {
        if (id == null) {
            return false;
        }
        if ("".equals(id)) {
            return true;
        }
        Object config = this.getConfig(id);
        return config != null;
    }

    public Object getEntity(EntityReference ref) {
        if (ref.getId() == null) {
            return new EntityServerConfig();
        }
        String name = ref.getId();
        Object value = this.getConfig(name);
        if (value == null) {
            throw new IllegalArgumentException("Cannot find server config setting with name: " + name);
        }
        EntityServerConfig esc = this.makeESC(name, value);
        return esc;
    }

    public List<?> getEntities(EntityReference ref, Search search) {
        ArrayList<EntityServerConfig> escs = new ArrayList<EntityServerConfig>();
        if (search != null && !search.isEmpty() && search.getRestrictionByProperty("name") != null) {
            String name = (String)search.getRestrictionByProperty((String)"name").value;
            Object value = this.getConfig(name);
            if (value != null) {
                EntityServerConfig esc = this.makeESC(name, value);
                escs.add(esc);
            }
        } else {
            Map known = this.getKnownSettings();
            for (Map.Entry entry : known.entrySet()) {
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (value == null) continue;
                EntityServerConfig esc = this.makeESC(name, value);
                escs.add(esc);
            }
        }
        Collections.sort(escs, new ESCComparator());
        return escs;
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"xml", "html", "json"};
    }

    public Object getConfig(String name) {
        Object value = null;
        Map known = this.getKnownSettings();
        if (known.containsKey(name)) {
            value = known.get(name);
        } else {
            String currentUserRef = this.developerHelperService.getCurrentUserReference();
            if (!this.developerHelperService.isUserAdmin(currentUserRef)) {
                throw new SecurityException("Only admins can access config properties outside of the basic set, user is not an admin: " + currentUserRef);
            }
            value = this.getConfigValue(name);
        }
        return value;
    }

    public Map<String, Object> getKnownSettings() {
        String name;
        int i;
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("accessPath", this.serverConfigurationService.getAccessPath());
        m.put("accessUrl", this.serverConfigurationService.getAccessUrl());
        m.put("gatewaySiteId", this.serverConfigurationService.getGatewaySiteId());
        m.put("loggedOutUrl", this.serverConfigurationService.getLoggedOutUrl());
        m.put("portalUrl", this.serverConfigurationService.getPortalUrl());
        m.put("serverId", this.serverConfigurationService.getServerId());
        m.put("serverIdInstance", this.serverConfigurationService.getServerIdInstance());
        m.put("serverInstance", this.serverConfigurationService.getServerInstance());
        m.put("serverName", this.serverConfigurationService.getServerName());
        m.put("serverUrl", this.serverConfigurationService.getServerUrl());
        m.put("toolUrl", this.serverConfigurationService.getToolUrl());
        m.put("userHomeUrl", this.serverConfigurationService.getUserHomeUrl());
        try {
            InetAddress i4 = Inet4Address.getLocalHost();
            m.put("serverHostName", i4.getHostName());
            m.put("serverHostAddress", i4.getHostAddress());
        }
        catch (UnknownHostException i4) {
            // empty catch block
        }
        Object o = this.getConfigValue("vendor@org.sakaiproject.db.api.SqlService");
        if (o != null) {
            m.put("database.vendor", o);
        }
        if ((o = this.getConfigValue("webdav.ignore")) != null) {
            m.put("webdav.ignore", o);
        }
        for (i = 0; i < this.includedStringSettings.length; ++i) {
            name = this.includedStringSettings[i];
            String value = this.serverConfigurationService.getString(name);
            if (value == null) continue;
            m.put(name, value);
        }
        for (i = 0; i < this.includedBooleanSettings.length; ++i) {
            name = this.includedBooleanSettings[i];
            boolean value = this.serverConfigurationService.getBoolean(name, false);
            m.put(name, value);
        }
        return m;
    }

    private Object getConfigValue(String name) {
        Object value;
        block7: {
            value = this.serverConfigurationService.getString(name);
            if (value == null || "".equals(value)) {
                String[] array = this.serverConfigurationService.getStrings(name);
                if (array != null && array.length > 0) {
                    value = array;
                }
            } else {
                String[] sValue = value;
                if (sValue.length() > 0) {
                    try {
                        Integer i = Integer.parseInt((String)sValue);
                        value = (int)i;
                    }
                    catch (NumberFormatException e) {
                        if (sValue.equalsIgnoreCase("true")) {
                            value = true;
                        }
                        if (!sValue.equalsIgnoreCase("false")) break block7;
                        value = false;
                    }
                }
            }
        }
        return value;
    }

    private String getConfigType(Object value) {
        String type = "null";
        if (value != null) {
            Class<?> c = value.getClass();
            if (String.class.equals(c)) {
                type = "string";
            } else if (Integer.class.equals(c)) {
                type = "int";
            } else if (Boolean.class.equals(c)) {
                type = "boolean";
            } else if (c.isArray()) {
                StringBuilder sb = new StringBuilder("array(");
                if (String.class.equals(c.getComponentType())) {
                    sb.append("string");
                } else if (Integer.class.equals(c.getComponentType())) {
                    sb.append("int");
                } else if (Boolean.class.equals(c.getComponentType())) {
                    sb.append("boolean");
                } else {
                    sb.append(c.getName());
                }
                sb.append(")");
                type = sb.toString();
            } else {
                type = c.getName();
            }
        }
        return type;
    }

    private EntityServerConfig makeESC(String name, Object value) {
        return new EntityServerConfig(name, value, this.getConfigType(value));
    }
}

