/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.entityprovider.CoreEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityCustomAction;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.CollectionResolvable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Describeable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Outputable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Resolvable;
import org.sakaiproject.entitybroker.entityprovider.extension.ActionReturn;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.entitybroker.providers.model.EntityTool;
import org.sakaiproject.entitybroker.util.AbstractEntityProvider;
import org.sakaiproject.tool.api.Tool;
import org.sakaiproject.tool.api.ToolManager;

public class ToolEntityProvider
extends AbstractEntityProvider
implements CoreEntityProvider,
Outputable,
Resolvable,
Describeable,
ActionsExecutable,
CollectionResolvable {
    public static final String ENTITY_PREFIX = "tool";
    private ToolManager toolManager;

    public String getEntityPrefix() {
        return ENTITY_PREFIX;
    }

    public Object getEntity(EntityReference ref) {
        if (ref == null || ref.getId() == null || this.getTool(ref.getId()) == null) {
            return new EntityTool();
        }
        return this.getToolEntity(this.getTool(ref.getId()));
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"xml", "html", "json"};
    }

    public boolean entityExists(String id) {
        if (id == null) {
            return false;
        }
        Tool tool = this.getTool(id);
        return tool != null;
    }

    public List<?> getEntities(EntityReference ref, Search search) {
        ArrayList<EntityTool> tools = new ArrayList<EntityTool>();
        if (search.getRestrictionByProperty("id") != null) {
            String id = search.getRestrictionByProperty("id").getStringValue();
            EntityTool entityTool = this.getToolEntity(this.getTool(id));
            if (entityTool != null) {
                tools.add(entityTool);
            }
        } else if (search.getRestrictionByProperty("keywords") != null) {
            String[] keywords = (String[])search.getRestrictionByProperty("keywords").getArrayValue();
            Set found = this.toolManager.findTools(null, new HashSet<String>(Arrays.asList(keywords)));
            for (Tool tool : found) {
                EntityTool entityTool = this.getToolEntity(tool);
                if (entityTool == null) continue;
                tools.add(entityTool);
            }
        } else if (search.getRestrictionByProperty("categories") != null) {
            String[] categories = (String[])search.getRestrictionByProperty("categories").getArrayValue();
            Set found = this.toolManager.findTools(new HashSet<String>(Arrays.asList(categories)), null);
            for (Tool tool : found) {
                EntityTool entityTool = this.getToolEntity(tool);
                if (entityTool == null) continue;
                tools.add(entityTool);
            }
        } else {
            Set found = this.toolManager.findTools(null, null);
            for (Tool tool : found) {
                EntityTool entityTool = this.getToolEntity(tool);
                if (entityTool == null) continue;
                tools.add(entityTool);
            }
        }
        Collections.sort(tools);
        return tools;
    }

    @EntityCustomAction(action="allToolIds", viewKey="list")
    public Object getAllToolIds(EntityReference ref) {
        Set tools = this.toolManager.findTools(null, null);
        ArrayList<String> toolIds = new ArrayList<String>(tools.size());
        for (Tool tool : tools) {
            toolIds.add(tool.getId());
        }
        Collections.sort(toolIds);
        return new ActionReturn(toolIds);
    }

    @EntityCustomAction(action="hiddenToolIds", viewKey="list")
    public Object getHiddenToolIds(EntityReference ref) {
        Set allTools = this.toolManager.findTools(null, null);
        Set publicTools = this.toolManager.findTools(Collections.emptySet(), null);
        ArrayList<String> allToolIds = new ArrayList<String>(allTools.size());
        ArrayList<String> publicToolIds = new ArrayList<String>(publicTools.size());
        ArrayList<String> hiddenToolIds = new ArrayList<String>(allTools.size() - publicToolIds.size());
        for (Tool tool : allTools) {
            allToolIds.add(tool.getId());
        }
        for (Tool tool : publicTools) {
            publicToolIds.add(tool.getId());
        }
        hiddenToolIds.addAll(allToolIds);
        hiddenToolIds.removeAll(publicToolIds);
        Collections.sort(hiddenToolIds);
        return new ActionReturn(hiddenToolIds);
    }

    @EntityCustomAction(action="publicToolIds", viewKey="list")
    public Object getPublicToolIds(EntityReference ref) {
        Set publicTools = this.toolManager.findTools(Collections.emptySet(), null);
        ArrayList<String> publicToolIds = new ArrayList<String>(publicTools.size());
        for (Tool tool : publicTools) {
            publicToolIds.add(tool.getId());
        }
        Collections.sort(publicToolIds);
        return new ActionReturn(publicToolIds);
    }

    public void setToolManager(ToolManager toolManager) {
        this.toolManager = toolManager;
    }

    private Tool getTool(String id) {
        if (!"".equals(id)) {
            return this.toolManager.getTool(id);
        }
        return null;
    }

    private EntityTool getToolEntity(Tool tool) {
        if (tool != null) {
            return new EntityTool(tool);
        }
        return null;
    }
}

