/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.providers.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.azeckoski.reflectutils.annotations.ReflectIgnoreClassFields;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityFieldRequired;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityId;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SitePage;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.tool.api.Tool;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@ReflectIgnoreClassFields(value={"createdBy", "modifiedBy", "containingSite", "properties", "propertiesEdit", "tools"})
public class EntitySitePage
implements SitePage {
    private static final long serialVersionUID = 7526472295622776147L;
    @EntityId
    private String id;
    @EntityFieldRequired
    private String siteId;
    @EntityFieldRequired
    private String title;
    private int position;
    private boolean titleCustom;
    public Map<String, String> props;
    private transient SitePage sitePage;

    public Map<String, String> getProps() {
        if (this.props == null) {
            this.props = new HashMap();
        }
        return this.props;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    public void setProperty(String key, String value) {
        if (this.props == null) {
            this.props = new HashMap();
        }
        this.props.put(key, value);
    }

    public String getProperty(String key) {
        if (this.props == null) {
            return null;
        }
        return (String)this.props.get(key);
    }

    public EntitySitePage(SitePage sitePage) {
        this.sitePage = sitePage;
        this.id = this.sitePage.getId();
        this.title = this.sitePage.getTitle();
        this.siteId = this.sitePage.getSiteId();
        this.position = this.sitePage.getPosition();
        this.titleCustom = this.sitePage.getTitleCustom();
        ResourceProperties rp = sitePage.getProperties();
        Iterator iterator = rp.getPropertyNames();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            String value = rp.getProperty(name);
            this.setProperty(name, value);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public void setPosition(int pos) {
        if (this.sitePage != null) {
            this.sitePage.setPosition(pos);
        }
        this.position = pos;
    }

    public int getPosition() {
        if (this.sitePage != null) {
            return this.sitePage.getPosition();
        }
        return this.position;
    }

    public void setTitle(String title) {
        if (this.sitePage != null) {
            this.sitePage.setTitle(title);
        }
        this.setTitle(title);
    }

    public void setTitleCustom(boolean custom) {
        if (this.sitePage != null) {
            this.sitePage.setTitleCustom(custom);
        }
        this.setTitleCustom(custom);
    }

    public boolean getTitleCustom() {
        return this.titleCustom;
    }

    public String getReference() {
        if (this.sitePage != null) {
            return this.sitePage.getReference();
        }
        return "/site/" + this.siteId + "/page/" + this.id;
    }

    public boolean isActiveEdit() {
        if (this.sitePage != null) {
            return this.sitePage.isActiveEdit();
        }
        throw new UnsupportedOperationException();
    }

    public ResourcePropertiesEdit getPropertiesEdit() {
        if (this.sitePage != null) {
            return this.sitePage.getPropertiesEdit();
        }
        throw new UnsupportedOperationException();
    }

    public String getUrl() {
        if (this.sitePage != null) {
            return this.sitePage.getUrl();
        }
        throw new UnsupportedOperationException();
    }

    public String getUrl(String rootProperty) {
        if (this.sitePage != null) {
            return this.sitePage.getUrl(rootProperty);
        }
        throw new UnsupportedOperationException();
    }

    public String getReference(String rootProperty) {
        if (this.sitePage != null) {
            return this.sitePage.getReference(rootProperty);
        }
        throw new UnsupportedOperationException();
    }

    public ResourceProperties getProperties() {
        if (this.sitePage != null) {
            return this.sitePage.getProperties();
        }
        throw new UnsupportedOperationException();
    }

    public Element toXml(Document doc, Stack<Element> stack) {
        if (this.sitePage != null) {
            return this.sitePage.toXml(doc, stack);
        }
        throw new UnsupportedOperationException();
    }

    public int getLayout() {
        if (this.sitePage != null) {
            return this.sitePage.getLayout();
        }
        throw new UnsupportedOperationException();
    }

    public String getLayoutTitle() {
        if (this.sitePage != null) {
            return this.sitePage.getLayoutTitle();
        }
        throw new UnsupportedOperationException();
    }

    public List<ToolConfiguration> getTools() {
        if (this.sitePage != null) {
            return this.sitePage.getTools();
        }
        throw new UnsupportedOperationException();
    }

    public List<ToolConfiguration> getTools(int col) {
        if (this.sitePage != null) {
            return this.sitePage.getTools(col);
        }
        throw new UnsupportedOperationException();
    }

    public Collection<ToolConfiguration> getTools(String[] toolIds) {
        if (this.sitePage != null) {
            return this.sitePage.getTools(toolIds);
        }
        throw new UnsupportedOperationException();
    }

    public String getSkin() {
        if (this.sitePage != null) {
            return this.sitePage.getSkin();
        }
        throw new UnsupportedOperationException();
    }

    public boolean isPopUp() {
        if (this.sitePage != null) {
            return this.sitePage.isPopUp();
        }
        return false;
    }

    public ToolConfiguration getTool(String id) {
        if (this.sitePage != null) {
            return this.sitePage.getTool(id);
        }
        throw new UnsupportedOperationException();
    }

    public Site getContainingSite() {
        if (this.sitePage != null) {
            return this.sitePage.getContainingSite();
        }
        throw new UnsupportedOperationException();
    }

    public void localizePage() {
        if (this.sitePage != null) {
            this.sitePage.localizePage();
        }
        throw new UnsupportedOperationException();
    }

    public void setLayout(int layout) {
        if (this.sitePage != null) {
            this.sitePage.setLayout(layout);
        }
        throw new UnsupportedOperationException();
    }

    public void setPopup(boolean popup) {
        if (this.sitePage != null) {
            this.sitePage.setPopup(popup);
        }
        throw new UnsupportedOperationException();
    }

    public ToolConfiguration addTool() {
        if (this.sitePage != null) {
            return this.sitePage.addTool();
        }
        throw new UnsupportedOperationException();
    }

    public ToolConfiguration addTool(Tool reg) {
        if (this.sitePage != null) {
            return this.sitePage.addTool();
        }
        throw new UnsupportedOperationException();
    }

    public ToolConfiguration addTool(String toolId) {
        if (this.sitePage != null) {
            return this.sitePage.addTool();
        }
        throw new UnsupportedOperationException();
    }

    public void removeTool(ToolConfiguration tool) {
        if (this.sitePage != null) {
            this.sitePage.removeTool(tool);
        }
        throw new UnsupportedOperationException();
    }

    public void moveUp() {
        if (this.sitePage != null) {
            this.sitePage.moveUp();
        }
        throw new UnsupportedOperationException();
    }

    public void moveDown() {
        if (this.sitePage != null) {
            this.sitePage.moveDown();
        }
        throw new UnsupportedOperationException();
    }

    public void setupPageCategory(String toolId) {
        if (this.sitePage != null) {
            this.sitePage.setupPageCategory(toolId);
        }
        throw new UnsupportedOperationException();
    }
}

