/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.entitybroker.providers.model;

import java.util.Properties;
import java.util.Set;
import org.azeckoski.reflectutils.annotations.ReflectIgnoreClassFields;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityId;
import org.sakaiproject.tool.api.Tool;

@ReflectIgnoreClassFields(value={"accessSecurity"})
public class EntityTool
implements Tool,
Comparable<Tool> {
    private static final String ACCESS_SECURITY_PORTAL = "portal";
    private static final String ACCESS_SECURITY_TOOL = "tool";
    private transient Tool tool;
    @EntityId
    private String id;
    private String home;
    private String title;
    private String description;
    private Properties registeredConfig;
    private Properties mutableConfig;
    private Properties finalConfig;
    private Set<String> keywords;
    private Set<String> categories;
    private String access;

    public EntityTool(Tool tool) {
        if (tool == null) {
            throw new UnsupportedOperationException();
        }
        this.tool = tool;
        this.id = tool.getId();
        this.home = tool.getHome();
        this.title = tool.getTitle();
        this.description = tool.getDescription();
        this.registeredConfig = tool.getRegisteredConfig();
        this.mutableConfig = tool.getMutableConfig();
        this.finalConfig = tool.getFinalConfig();
        this.keywords = tool.getKeywords();
        this.categories = tool.getCategories();
        this.access = this.getAccessSecurity() == Tool.AccessSecurity.PORTAL ? ACCESS_SECURITY_PORTAL : ACCESS_SECURITY_TOOL;
    }

    public EntityTool() {
    }

    @EntityId
    public String getId() {
        return this.id;
    }

    public String getHome() {
        return this.home;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public Properties getRegisteredConfig() {
        return this.registeredConfig;
    }

    public Properties getMutableConfig() {
        return this.mutableConfig;
    }

    public Properties getFinalConfig() {
        return this.finalConfig;
    }

    public Set<String> getKeywords() {
        return this.keywords;
    }

    public Set<String> getCategories() {
        return this.categories;
    }

    public Tool.AccessSecurity getAccessSecurity() {
        if (this.tool != null) {
            return this.tool.getAccessSecurity();
        }
        throw new UnsupportedOperationException();
    }

    public String getAccess() {
        return this.access;
    }

    @Override
    public int compareTo(Tool tool) {
        return this.getId().compareTo(tool.getId());
    }
}

