/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.hybrid.util;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Signature {
    private static final Log LOG = LogFactory.getLog(Signature.class);
    protected transient String hmacSha1Algorithm = "HmacSHA1";
    private transient Mac mac;

    public Signature() {
        this.instatiateMac();
    }

    private void instatiateMac() {
        try {
            this.mac = Mac.getInstance(this.hmacSha1Algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    protected Signature(String algorithm) {
        this.hmacSha1Algorithm = algorithm;
        this.instatiateMac();
    }

    public String calculateRFC2104HMAC(String data, String key) throws InvalidKeyException {
        return this.calculateRFC2104HMACWithEncoding(data, key, false);
    }

    public String calculateRFC2104HMACWithEncoding(String data, String key, boolean urlSafe) throws InvalidKeyException {
        if (data == null) {
            throw new IllegalArgumentException("String data == null");
        }
        if (key == null) {
            throw new IllegalArgumentException("String key == null");
        }
        String result = null;
        try {
            byte[] keyBytes = key.getBytes("UTF-8");
            SecretKeySpec signingKey = new SecretKeySpec(keyBytes, this.hmacSha1Algorithm);
            this.mac.init(signingKey);
            byte[] rawHmac = this.mac.doFinal(data.getBytes("UTF-8"));
            byte[] base64Bytes = Base64.encodeBase64((byte[])rawHmac, (boolean)false, (boolean)urlSafe);
            result = new String(base64Bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

