/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.hybrid.util;

import java.net.URI;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.sakaiproject.component.api.ComponentManager;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.hybrid.util.XSakaiToken;
import org.sakaiproject.thread_local.api.ThreadLocalManager;

public class NakamuraAuthenticationHelper {
    public static final String CONFIG_PREFIX = NakamuraAuthenticationHelper.class.getName();
    public static final String CONFIG_ANONYMOUS = CONFIG_PREFIX + ".anonymous";
    public static final String CONFIG_COOKIE_NAME = CONFIG_PREFIX + ".cookieName";
    private static final Log LOG = LogFactory.getLog(NakamuraAuthenticationHelper.class);
    protected static final String THREAD_LOCAL_CACHE_KEY = NakamuraAuthenticationHelper.class.getName() + ".AuthInfo.cache";
    private static String anonymous = "anonymous";
    private final transient String cookieName;
    protected transient String validateUrl;
    protected transient String principal;
    protected transient String hostname;
    protected transient HttpClientProvider httpClientProvider = new DefaultHttpClientProvider();
    protected transient ThreadLocalManager threadLocalManager;
    protected transient ServerConfigurationService serverConfigurationService;
    protected transient XSakaiToken xSakaiToken;

    public NakamuraAuthenticationHelper(ComponentManager componentManager, String validateUrl, String principal, String hostname) {
        if (componentManager == null) {
            throw new IllegalArgumentException("componentManager == null;");
        }
        this.threadLocalManager = (ThreadLocalManager)componentManager.get(ThreadLocalManager.class);
        if (this.threadLocalManager == null) {
            throw new IllegalStateException("threadLocalManager == null");
        }
        this.serverConfigurationService = (ServerConfigurationService)componentManager.get(ServerConfigurationService.class);
        if (this.serverConfigurationService == null) {
            throw new IllegalStateException("serverConfigurationService == null");
        }
        if (validateUrl == null || "".equals(validateUrl)) {
            throw new IllegalArgumentException("validateUrl == null OR empty");
        }
        if (principal == null || "".equals(principal)) {
            throw new IllegalArgumentException("principal == null OR empty");
        }
        if (hostname == null || "".equals(hostname)) {
            throw new IllegalArgumentException("hostname == null OR empty");
        }
        this.validateUrl = validateUrl;
        this.principal = principal;
        this.hostname = hostname;
        anonymous = this.serverConfigurationService.getString(CONFIG_ANONYMOUS, anonymous);
        this.cookieName = this.serverConfigurationService.getString(CONFIG_COOKIE_NAME, "SAKAI-TRACKING");
        this.xSakaiToken = new XSakaiToken(componentManager);
    }

    public AuthInfo getPrincipalLoggedIntoNakamura(HttpServletRequest request) {
        LOG.debug((Object)"getPrincipalLoggedIntoNakamura(HttpServletRequest request)");
        if (request == null) {
            throw new IllegalArgumentException("HttpServletRequest == null");
        }
        Object cache = this.threadLocalManager.get(THREAD_LOCAL_CACHE_KEY);
        if (cache instanceof AuthInfo) {
            LOG.debug((Object)"cache hit!");
            return (AuthInfo)cache;
        }
        AuthInfo authInfo = null;
        String secret = this.getSecret(request);
        if (secret != null) {
            HttpClient httpClient = this.httpClientProvider.getHttpClient();
            try {
                URI uri = new URI(this.validateUrl + secret);
                HttpGet httpget = new HttpGet(uri);
                String token = this.xSakaiToken.createToken(this.hostname, this.principal);
                httpget.addHeader("x-sakai-token", token);
                BasicResponseHandler responseHandler = new BasicResponseHandler();
                String responseBody = (String)httpClient.execute((HttpUriRequest)httpget, (ResponseHandler)responseHandler);
                authInfo = new AuthInfo(responseBody);
            }
            catch (HttpResponseException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("HttpResponseException: " + e.getMessage() + ": " + e.getStatusCode() + ": " + this.validateUrl + secret));
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                throw new IllegalStateException(e);
            }
            finally {
                httpClient.getConnectionManager().shutdown();
            }
        }
        this.threadLocalManager.set(THREAD_LOCAL_CACHE_KEY, authInfo);
        return authInfo;
    }

    protected String getSecret(HttpServletRequest request) {
        LOG.debug((Object)"getSecret(HttpServletRequest request)");
        if (request == null) {
            throw new IllegalArgumentException("HttpServletRequest == null");
        }
        String secret = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!this.cookieName.equals(cookie.getName())) continue;
                secret = cookie.getValue();
            }
        }
        return secret;
    }

    public static final class DefaultHttpClientProvider
    implements HttpClientProvider {
        private static final Log LOG = LogFactory.getLog(DefaultHttpClientProvider.class);

        public HttpClient getHttpClient() {
            LOG.debug((Object)"getHttpClient()");
            return new DefaultHttpClient();
        }
    }

    public static interface HttpClientProvider {
        public HttpClient getHttpClient();
    }

    public static class AuthInfo {
        private static final String FIRST_NAME = "firstName";
        private static final String LAST_NAME = "lastName";
        private static final String EMAIL = "email";
        private static final String EMPTY_STRING = "";
        private static final Log AILOG = LogFactory.getLog(AuthInfo.class);
        private final transient String principal;
        private final transient String firstName;
        private final transient String lastName;
        private final transient String emailAddress;

        protected AuthInfo(String json) {
            if (AILOG.isDebugEnabled()) {
                AILOG.debug((Object)("new AuthInfo(String " + json + ")"));
            }
            JSONObject user = JSONObject.fromObject((Object)json).getJSONObject("user");
            String principal = null;
            if (user.has("principal")) {
                principal = user.getString("principal");
            }
            this.principal = principal != null && !EMPTY_STRING.equals(principal) && !anonymous.equals(principal) ? principal : null;
            JSONObject properties = user.getJSONObject("properties");
            this.firstName = properties.has(FIRST_NAME) ? properties.getString(FIRST_NAME) : EMPTY_STRING;
            this.lastName = properties.has(LAST_NAME) ? properties.getString(LAST_NAME) : EMPTY_STRING;
            this.emailAddress = properties.has(EMAIL) ? properties.getString(EMAIL) : EMPTY_STRING;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public String getEmailAddress() {
            return this.emailAddress;
        }

        public String getPrincipal() {
            return this.principal;
        }
    }
}

