/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.hybrid.util;

import java.security.InvalidKeyException;
import java.security.SecureRandom;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.api.ComponentManager;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.hybrid.util.Signature;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.SessionManager;

public class XSakaiToken {
    private static final Log LOG = LogFactory.getLog(XSakaiToken.class);
    public static final String X_SAKAI_TOKEN_HEADER = "x-sakai-token";
    public static final String CONFIG_PREFIX = "x.sakai.token";
    public static final String CONFIG_SHARED_SECRET_SUFFIX = "sharedSecret";
    public static final String TOKEN_SEPARATOR = ";";
    protected transient Signature signature = new Signature();
    private final transient SecureRandom secureRandom = new SecureRandom();
    protected transient ComponentManager componentManager;
    protected transient ServerConfigurationService serverConfigurationService;
    protected transient SessionManager sessionManager;

    public XSakaiToken(ComponentManager componentManager) {
        LOG.debug((Object)"new XSakaiToken(ComponentManager componentManager)");
        if (componentManager == null) {
            throw new IllegalArgumentException("componentManager == null");
        }
        this.componentManager = componentManager;
        this.serverConfigurationService = (ServerConfigurationService)componentManager.get(ServerConfigurationService.class);
        if (this.serverConfigurationService == null) {
            throw new IllegalStateException("serverConfigurationService == null");
        }
        this.sessionManager = (SessionManager)componentManager.get(SessionManager.class);
        if (this.sessionManager == null) {
            throw new IllegalStateException("sessionManager == null");
        }
    }

    public String getToken(HttpServletRequest request) {
        LOG.debug((Object)"getToken(final HttpServletRequest request)");
        if (request == null) {
            throw new IllegalArgumentException("request == null");
        }
        return request.getHeader(X_SAKAI_TOKEN_HEADER);
    }

    public String getValidatedEid(HttpServletRequest request, String sharedSecret) {
        LOG.debug((Object)"getValidatedEid(final HttpServletRequest request, final String sharedSecret)");
        if (request == null) {
            throw new IllegalArgumentException("request == null");
        }
        if (sharedSecret == null || "".equals(sharedSecret)) {
            throw new IllegalArgumentException("sharedSecret == null || empty");
        }
        return this.getValidatedEid(this.getToken(request), sharedSecret);
    }

    public String getValidatedEid(String token, String sharedSecret) {
        LOG.debug((Object)"getValidatedEid(final String token, final String sharedSecret)");
        if (sharedSecret == null) {
            throw new IllegalArgumentException("sharedSecret == null");
        }
        String userId = null;
        if (token != null) {
            String[] parts = token.split(TOKEN_SEPARATOR);
            if (parts.length == 3) {
                try {
                    String hash = parts[0];
                    String user = parts[1];
                    String nonce = parts[2];
                    String message = user + TOKEN_SEPARATOR + nonce;
                    String hmac = this.signature.calculateRFC2104HMAC(message, sharedSecret);
                    if (hmac.equals(hash)) {
                        userId = user;
                    }
                }
                catch (InvalidKeyException e) {
                    LOG.error((Object)("Failed to validate server token: " + token), (Throwable)e);
                }
            } else {
                LOG.error((Object)("Illegal number of elements in trusted server token: " + token));
            }
        }
        return userId;
    }

    public String createToken(String hostname) {
        LOG.debug((Object)"String createToken(final String hostname)");
        if (hostname == null || "".equals(hostname)) {
            throw new IllegalArgumentException("hostname == null || empty");
        }
        Session session = this.sessionManager.getCurrentSession();
        if (session != null) {
            return this.createToken(hostname, session.getUserEid());
        }
        return this.createToken(hostname, "anonymous");
    }

    public String createToken(String hostname, String eid) throws Error {
        LOG.debug((Object)"createToken(final String hostname, final String eid)");
        if (hostname == null || "".equals(hostname)) {
            throw new IllegalArgumentException("hostname == null OR empty");
        }
        if (eid == null || "".equals(eid)) {
            throw new IllegalArgumentException("eid == null OR empty");
        }
        String sharedSecret = this.getSharedSecret(hostname);
        String token = this.signMessage(sharedSecret, eid);
        return token;
    }

    public String signMessage(String sharedSecret, String eid) {
        LOG.debug((Object)"signMessage(final String sharedSecret, final String eid)");
        if (sharedSecret == null || "".equals(sharedSecret)) {
            throw new IllegalArgumentException("sharedSecret == null OR empty");
        }
        if (eid == null || "".equals(eid)) {
            throw new IllegalArgumentException("eid == null OR empty");
        }
        String token = null;
        String message = eid + TOKEN_SEPARATOR + this.secureRandom.nextLong();
        try {
            String hash = this.signature.calculateRFC2104HMAC(message, sharedSecret);
            token = hash + TOKEN_SEPARATOR + message;
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
        return token;
    }

    public String getSharedSecret(String hostname) {
        LOG.debug((Object)"getSharedSecret(final String hostname)");
        if (hostname == null || "".equals(hostname)) {
            throw new IllegalArgumentException("hostname == null OR empty");
        }
        String key = "x.sakai.token." + hostname + "." + CONFIG_SHARED_SECRET_SUFFIX;
        String sharedSecret = this.serverConfigurationService.getString(key, null);
        return sharedSecret;
    }
}

