/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.hybrid.tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.site.api.Site;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MoreSiteViewImpl {
    private static final Log LOG = LogFactory.getLog(MoreSiteViewImpl.class);
    protected static final int ADDITIONAL_TERMS_CAPACITY = 6;
    protected static final String I18N_ALL_SITES = "moresite_all_sites";
    protected static final String I18N_UNKNOWN_COURSE_TERM_SITES = "moresite_unknown_term";
    protected static final String I18N_PORTFOLIO_SITES = "moresite_portfolios";
    protected static final String I18N_OTHER_SITES = "moresite_other";
    protected static final String I18N_PROJECT_SITES = "moresite_projects";
    protected static final String I18N_ADMIN_SITES = "moresite_administration";
    public static final List<String> DEFAULT_SORT_ORDER;
    protected transient ServerConfigurationService serverConfigurationService;

    public MoreSiteViewImpl(ServerConfigurationService serverConfigurationService) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("new MoreSiteViewImpl(final ServerConfigurationService " + serverConfigurationService + ")"));
        }
        if (serverConfigurationService == null) {
            throw new IllegalArgumentException("serverConfigurationService == null");
        }
        this.serverConfigurationService = serverConfigurationService;
    }

    public List<Map<String, List<Site>>> categorizeSites(List<Site> siteList) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"categorizeSites(final List<Site> siteList)");
        }
        if (siteList == null) {
            throw new IllegalArgumentException("Illegal siteList parameter!");
        }
        if (this.serverConfigurationService == null) {
            throw new IllegalStateException("serverConfigurationService == null");
        }
        String[] termOrder = this.serverConfigurationService.getStrings("portal.term.order");
        int size = -1;
        size = termOrder != null ? termOrder.length + 6 : 16;
        HashMap<String, ArrayList<Site>> terms = new HashMap<String, ArrayList<Site>>(size);
        for (Site site : siteList) {
            ArrayList<Site> termSites;
            String type = site.getType();
            String term = null;
            if ("course".equals(type)) {
                term = site.getProperties().getProperty("term");
                if (term == null) {
                    term = I18N_UNKNOWN_COURSE_TERM_SITES;
                }
            } else {
                term = "project".equals(type) ? I18N_PROJECT_SITES : ("portfolio".equals(type) ? I18N_PORTFOLIO_SITES : ("admin".equals(type) ? I18N_ADMIN_SITES : I18N_OTHER_SITES));
            }
            if ((termSites = (ArrayList<Site>)terms.get(term)) == null) {
                termSites = new ArrayList<Site>();
            }
            termSites.add(site);
            terms.put(term, termSites);
        }
        ArrayList<Map<String, List<Site>>> sortedTerms = new ArrayList<Map<String, List<Site>>>(terms.size() + 1);
        HashMap<String, List<Site>> allSites = new HashMap<String, List<Site>>(1);
        allSites.put(I18N_ALL_SITES, siteList);
        sortedTerms.add(allSites);
        if (termOrder != null) {
            for (String term : termOrder) {
                this.addSitesToTerm(term, terms, sortedTerms);
            }
        } else {
            HashSet academicTerms = new HashSet(terms.keySet());
            academicTerms.removeAll(DEFAULT_SORT_ORDER);
            TreeSet sortedAcademicTerms = new TreeSet(academicTerms);
            for (String term : sortedAcademicTerms) {
                this.addSitesToTerm(term, terms, sortedTerms);
            }
        }
        for (String category : DEFAULT_SORT_ORDER) {
            this.addSitesToTerm(category, terms, sortedTerms);
        }
        return sortedTerms;
    }

    protected void addSitesToTerm(String term, Map<String, List<Site>> terms, List<Map<String, List<Site>>> sortedTerms) {
        List<Site> sites = terms.get(term);
        if (sites != null) {
            HashMap<String, List<Site>> matches = new HashMap<String, List<Site>>(1);
            matches.put(term, sites);
            sortedTerms.add(matches);
        }
    }

    static {
        ArrayList<String> defaultSortOrder = new ArrayList<String>(5);
        defaultSortOrder.add(I18N_ALL_SITES);
        defaultSortOrder.add(I18N_UNKNOWN_COURSE_TERM_SITES);
        defaultSortOrder.add(I18N_PORTFOLIO_SITES);
        defaultSortOrder.add(I18N_PROJECT_SITES);
        defaultSortOrder.add(I18N_OTHER_SITES);
        defaultSortOrder.add(I18N_ADMIN_SITES);
        DEFAULT_SORT_ORDER = Collections.unmodifiableList(defaultSortOrder);
    }
}

