/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.hybrid.tool;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.tool.api.Placement;

@SuppressWarnings(value={"PMD.LongVariable", "PMD.CyclomaticComplexity"})
public class ToolHelperImpl {
    protected transient SecurityService securityService;
    private static final Log LOG = LogFactory.getLog(ToolHelperImpl.class);
    public static final String TOOLCONFIG_REQUIRED_PERMISSIONS = "functions.require";

    public ToolHelperImpl(SecurityService securityService) {
        if (securityService == null) {
            throw new IllegalArgumentException("SecurityService cannot be null!");
        }
        this.securityService = securityService;
    }

    @SuppressWarnings(value={"PMD.CyclomaticComplexity", "PMD.NPathComplexity", "PMD.DataflowAnomalyAnalysis", "PMD.OnlyOneReturn"})
    public boolean allowTool(Site site, Placement placement) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("allowTool(Site " + site + ", Placement " + placement + ")"));
        }
        if (placement == null || site == null) {
            return true;
        }
        String requiredPermissionsString = placement.getConfig().getProperty(TOOLCONFIG_REQUIRED_PERMISSIONS);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("requiredPermissionsString=" + requiredPermissionsString + " for " + placement.getToolId()));
        }
        if (requiredPermissionsString == null) {
            return true;
        }
        if ((requiredPermissionsString = requiredPermissionsString.trim()).length() == 0) {
            return true;
        }
        String[] allowedPermissionSets = requiredPermissionsString.split("\\|");
        for (int i = 0; i < allowedPermissionSets.length; ++i) {
            String[] requiredPermissions = allowedPermissionSets[i].split(",");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("requiredPermissions=" + Arrays.asList(requiredPermissions)));
            }
            boolean gotAllInList = true;
            for (int j = 0; j < requiredPermissions.length; ++j) {
                if (this.securityService.unlock(requiredPermissions[j].trim(), site.getReference())) continue;
                gotAllInList = false;
                break;
            }
            if (!gotAllInList) continue;
            return true;
        }
        return false;
    }
}

