/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.hybrid.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.api.ComponentManager;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.hybrid.util.Signature;
import org.sakaiproject.hybrid.util.ToolRequestWrapper;
import org.sakaiproject.hybrid.util.XSakaiToken;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;

@SuppressWarnings(value={"PMD.LongVariable", "PMD.CyclomaticComplexity"})
public class TrustedLoginFilter
implements Filter {
    private static final Log LOG = LogFactory.getLog(TrustedLoginFilter.class);
    public static final String ORG_SAKAIPROJECT_UTIL_TRUSTED_LOGIN_FILTER_SHARED_SECRET = "org.sakaiproject.hybrid.util.TrustedLoginFilter.sharedSecret";
    public static final String ORG_SAKAIPROJECT_UTIL_TRUSTED_LOGIN_FILTER_ENABLED = "org.sakaiproject.hybrid.util.TrustedLoginFilter.enabled";
    public static final String ORG_SAKAIPROJECT_UTIL_TRUSTED_LOGIN_FILTER_SAFE_HOSTS = "org.sakaiproject.hybrid.util.TrustedLoginFilter.safeHosts";
    protected transient Signature signature = new Signature();
    protected transient XSakaiToken xSakaiToken = null;
    protected transient ComponentManager componentManager;
    protected transient ServerConfigurationService serverConfigurationService;
    protected transient SessionManager sessionManager;
    protected transient UserDirectoryService userDirectoryService;
    protected transient String sharedSecret = null;
    protected transient boolean enabled = true;
    protected transient String safeHosts = "localhost;127.0.0.1;0:0:0:0:0:0:0:1%0";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"PMD.CyclomaticComplexity", "PMD.OnlyOneReturn", "PMD.AvoidDeeplyNestedIfStmts", "PMD.DataflowAnomalyAnalysis"})
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (this.enabled && req instanceof HttpServletRequest) {
            HttpServletRequest hreq = (HttpServletRequest)req;
            String host = req.getRemoteHost();
            if (this.safeHosts.indexOf(host) < 0) {
                LOG.warn((Object)("Ignoring Trusted Token request from: " + host));
                chain.doFilter(req, resp);
                return;
            }
            Session currentSession = null;
            Session requestSession = null;
            String trustedUserName = this.xSakaiToken.getValidatedEid(hreq, this.sharedSecret);
            if (trustedUserName != null && !trustedUserName.equals((currentSession = this.sessionManager.getCurrentSession()).getUserEid())) {
                User user = null;
                try {
                    user = this.userDirectoryService.getUserByEid(trustedUserName);
                }
                catch (UserNotDefinedException e) {
                    LOG.warn((Object)(trustedUserName + " not found!"));
                }
                if (user != null) {
                    requestSession = this.sessionManager.startSession();
                    requestSession.setUserEid(user.getEid());
                    requestSession.setUserId(user.getId());
                    requestSession.setActive();
                    this.sessionManager.setCurrentSession(requestSession);
                    if (!(hreq instanceof ToolRequestWrapper)) {
                        hreq = new ToolRequestWrapper(hreq, trustedUserName);
                    }
                }
            }
            try {
                chain.doFilter((ServletRequest)hreq, resp);
            }
            finally {
                if (requestSession != null) {
                    requestSession.invalidate();
                }
                if (currentSession != null) {
                    this.sessionManager.setCurrentSession(currentSession);
                }
            }
        }
        chain.doFilter(req, resp);
        return;
    }

    public void init(FilterConfig config) throws ServletException {
        if (this.componentManager == null) {
            this.componentManager = org.sakaiproject.component.cover.ComponentManager.getInstance();
        }
        this.serverConfigurationService = (ServerConfigurationService)this.componentManager.get(ServerConfigurationService.class);
        if (this.serverConfigurationService == null) {
            throw new IllegalStateException("ServerConfigurationService == null");
        }
        this.sessionManager = (SessionManager)this.componentManager.get(SessionManager.class);
        if (this.sessionManager == null) {
            throw new IllegalStateException("SessionManager == null");
        }
        this.userDirectoryService = (UserDirectoryService)this.componentManager.get(UserDirectoryService.class);
        if (this.userDirectoryService == null) {
            throw new IllegalStateException("UserDirectoryService == null");
        }
        this.xSakaiToken = new XSakaiToken(this.componentManager);
        this.enabled = this.serverConfigurationService.getBoolean(ORG_SAKAIPROJECT_UTIL_TRUSTED_LOGIN_FILTER_ENABLED, this.enabled);
        this.sharedSecret = this.serverConfigurationService.getString(ORG_SAKAIPROJECT_UTIL_TRUSTED_LOGIN_FILTER_SHARED_SECRET, this.sharedSecret);
        this.safeHosts = this.serverConfigurationService.getString(ORG_SAKAIPROJECT_UTIL_TRUSTED_LOGIN_FILTER_SAFE_HOSTS, this.safeHosts);
    }

    public void destroy() {
    }

    protected void setupTestCase(ComponentManager componentManager) {
        if (componentManager == null) {
            throw new IllegalArgumentException("componentManager == null");
        }
        this.componentManager = componentManager;
    }
}

