/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.hybrid.tool;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.component.api.ComponentManager;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.hybrid.tool.SiteVisitToolPlacementServlet;
import org.sakaiproject.hybrid.tool.ToolHelperImpl;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SitePage;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.api.Tool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressWarnings(value={"MTIA_SUSPECT_SERVLET_INSTANCE_FIELD"}, justification="dependencies only mutated only during init()")
public class SiteVisitToolPlacementServlet
extends HttpServlet {
    private static final long serialVersionUID = -1182601175544873164L;
    private static final Log LOG = LogFactory.getLog(SiteVisitToolPlacementServlet.class);
    private static final String SITE_ID = "siteId";
    private static final String MSF_MUTABLE_SERVLET_FIELD = "MSF_MUTABLE_SERVLET_FIELD";
    private static final String DEPENDENCY_ONLY_MUTATED_DURING_INIT = "dependency mutated only during init()";
    @SuppressWarnings(value={"MSF_MUTABLE_SERVLET_FIELD"}, justification="dependency mutated only during init()")
    protected transient ComponentManager componentManager;
    @SuppressWarnings(value={"MSF_MUTABLE_SERVLET_FIELD"}, justification="dependency mutated only during init()")
    private transient SessionManager sessionManager;
    @SuppressWarnings(value={"MSF_MUTABLE_SERVLET_FIELD"}, justification="dependency mutated only during init()")
    private transient SiteService siteService;
    @SuppressWarnings(value={"MSF_MUTABLE_SERVLET_FIELD"}, justification="dependency mutated only during init()")
    private transient EventTrackingService eventTrackingService;
    @SuppressWarnings(value={"MSF_MUTABLE_SERVLET_FIELD"}, justification="dependency mutated only during init()")
    private transient AuthzGroupService authzGroupService;
    @SuppressWarnings(value={"MSF_MUTABLE_SERVLET_FIELD"}, justification="dependency mutated only during init()")
    private transient SecurityService securityService;
    @SuppressWarnings(value={"MSF_MUTABLE_SERVLET_FIELD"}, justification="dependency mutated only during init()")
    protected transient ToolHelperImpl toolHelper;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String siteId;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("doGet(HttpServletRequest " + req + ", HttpServletResponse " + resp + ")"));
        }
        if ((siteId = req.getParameter(SITE_ID)) == null || "".equals(siteId)) {
            if (!resp.isCommitted()) {
                resp.sendError(400);
                return;
            }
            throw new IllegalAccessError("HttpServletResponse.SC_BAD_REQUEST");
        }
        boolean writeEvent = Boolean.parseBoolean(req.getParameter("writeEvent"));
        String principal = this.sessionManager.getCurrentSession().getUserEid();
        Site site = null;
        try {
            site = this.siteService.getSiteVisit(siteId);
        }
        catch (IdUnusedException e) {
            LOG.debug((Object)("Site not found: " + siteId), (Throwable)e);
            this.sendError(resp, 404, "HttpServletResponse.SC_NOT_FOUND: " + siteId);
            return;
        }
        catch (PermissionException e) {
            LOG.warn((Object)("Permission denied: " + principal + " could not access site " + siteId));
            this.sendError(resp, 403, "HttpServletResponse.SC_FORBIDDEN");
            return;
        }
        if (site != null) {
            JSONObject json = new JSONObject();
            json.element("principal", (Object)this.sessionManager.getCurrentSession().getUserEid());
            JSONObject siteJson = new JSONObject();
            siteJson.element("title", (Object)site.getTitle());
            siteJson.element("id", (Object)site.getId());
            siteJson.element("icon", (Object)site.getIconUrlFull());
            siteJson.element("skin", (Object)site.getSkin());
            siteJson.element("type", (Object)site.getType());
            List pages = site.getOrderedPages();
            int number = 0;
            if (pages != null && this.canAccessAtLeastOneTool(site, pages)) {
                JSONArray pagesArray = new JSONArray();
                for (SitePage page : pages) {
                    if (!this.canAccessAtLeastOneTool(site, page)) continue;
                    JSONObject pageJson = new JSONObject();
                    pageJson.element("id", (Object)page.getId());
                    pageJson.element("name", (Object)page.getTitle());
                    pageJson.element("layout", page.getLayout());
                    pageJson.element("number", ++number);
                    pageJson.element("popup", page.isPopUp());
                    List tools = page.getTools();
                    if (tools != null && !tools.isEmpty()) {
                        pageJson.element("iconclass", (Object)("icon-" + ((ToolConfiguration)tools.get(0)).getToolId().replaceAll("[.]", "-")));
                        JSONArray toolsArray = new JSONArray();
                        for (ToolConfiguration toolConfig : tools) {
                            if (!this.toolHelper.allowTool(site, (Placement)toolConfig)) continue;
                            JSONObject toolJson = new JSONObject();
                            toolJson.element("url", (Object)toolConfig.getId());
                            Tool tool = toolConfig.getTool();
                            if (tool != null && tool.getId() != null) {
                                toolJson.element("title", (Object)tool.getTitle());
                                toolJson.element("layouthint", (Object)toolConfig.getLayoutHints());
                            } else {
                                toolJson.element("title", (Object)page.getTitle());
                            }
                            toolsArray.add((Object)toolJson);
                        }
                        pageJson.element("tools", (Collection)toolsArray);
                    }
                    pagesArray.add((Object)pageJson);
                }
                siteJson.element("pages", (Collection)pagesArray);
            }
            JSONArray rolesArray = new JSONArray();
            try {
                AuthzGroup group = this.authzGroupService.getAuthzGroup("/site/" + siteId);
                Set roles = group.getRoles();
                for (Role role : roles) {
                    JSONObject roleJson = new JSONObject();
                    roleJson.element("id", (Object)role.getId());
                    roleJson.element("description", (Object)role.getDescription());
                    rolesArray.add((Object)roleJson);
                }
            }
            catch (GroupNotDefinedException e) {
                LOG.warn((Object)("No AuthzGroup found for site: " + siteId));
            }
            siteJson.element("roles", (Collection)rolesArray);
            json.element("site", (Map)siteJson);
            resp.setContentType("application/json");
            resp.setCharacterEncoding("UTF-8");
            resp.setStatus(200);
            json.write((Writer)resp.getWriter());
            if (writeEvent) {
                Event presenceBegin = this.eventTrackingService.newEvent("pres.begin", "/presence/" + siteId + "-presence", true);
                this.eventTrackingService.post(presenceBegin);
                Event siteVisit = this.eventTrackingService.newEvent("site.visit", "/site/" + siteId, true);
                this.eventTrackingService.post(siteVisit);
            }
        } else {
            this.sendError(resp, 404, "HttpServletResponse.SC_NOT_FOUND: " + siteId);
            return;
        }
    }

    protected boolean canAccessAtLeastOneTool(Site site, List<SitePage> pages) {
        if (pages != null) {
            for (SitePage page : pages) {
                List tools = page.getTools();
                if (tools == null) continue;
                for (ToolConfiguration tool : tools) {
                    if (!this.toolHelper.allowTool(site, (Placement)tool)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean canAccessAtLeastOneTool(Site site, SitePage page) {
        List tools = page.getTools();
        if (tools != null) {
            for (ToolConfiguration tool : tools) {
                if (!this.toolHelper.allowTool(site, (Placement)tool)) continue;
                return true;
            }
        }
        return false;
    }

    protected void sendError(HttpServletResponse resp, int errorCode, String message) throws IOException {
        if (!resp.isCommitted()) {
            resp.sendError(errorCode);
            return;
        }
        throw new ResponseCommittedException(message);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (this.componentManager == null) {
            this.componentManager = org.sakaiproject.component.cover.ComponentManager.getInstance();
        }
        this.sessionManager = (SessionManager)this.componentManager.get(SessionManager.class);
        if (this.sessionManager == null) {
            throw new IllegalStateException("SessionManager == null");
        }
        this.siteService = (SiteService)this.componentManager.get(SiteService.class);
        if (this.siteService == null) {
            throw new IllegalStateException("SiteService == null");
        }
        this.eventTrackingService = (EventTrackingService)this.componentManager.get(EventTrackingService.class);
        if (this.eventTrackingService == null) {
            throw new IllegalStateException("EventTrackingService == null");
        }
        this.authzGroupService = (AuthzGroupService)this.componentManager.get(AuthzGroupService.class);
        if (this.authzGroupService == null) {
            throw new IllegalStateException("AuthzGroupService == null");
        }
        this.securityService = (SecurityService)this.componentManager.get(SecurityService.class);
        if (this.securityService == null) {
            throw new IllegalStateException("SecurityService == null");
        }
        this.toolHelper = new ToolHelperImpl(this.securityService);
    }

    protected void setupTestCase(ComponentManager componentManager) {
        if (componentManager == null) {
            throw new IllegalArgumentException("componentManager == null");
        }
        this.componentManager = componentManager;
    }
}

