/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.hybrid.tool;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.app.messageforums.SynopticMsgcntrItem;
import org.sakaiproject.api.app.messageforums.SynopticMsgcntrManager;
import org.sakaiproject.component.api.ComponentManager;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.hybrid.tool.MoreSiteViewImpl;
import org.sakaiproject.hybrid.tool.SitesServlet;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.user.api.PreferencesService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressWarnings(value={"MTIA_SUSPECT_SERVLET_INSTANCE_FIELD"}, justification="dependencies only mutated only during init()")
public class SitesServlet
extends HttpServlet {
    private static final long serialVersionUID = 7907409301065984518L;
    private static final Log LOG = LogFactory.getLog(SitesServlet.class);
    public static final String CATEGORIZED = "categorized";
    public static final String UNREAD = "unread";
    public static final String LOCALE = "l";
    private static final String UNDERSCORE = "_";
    private static final char TILDE = "~".charAt(0);
    private static final String MSF_MUTABLE_SERVLET_FIELD = "MSF_MUTABLE_SERVLET_FIELD";
    private static final String DEPENDENCY_ONLY_MUTATED_DURING_INIT = "dependency mutated only during init()";
    @SuppressWarnings(value={"MSF_MUTABLE_SERVLET_FIELD"}, justification="dependency mutated only during init()")
    protected transient SessionManager sessionManager;
    @SuppressWarnings(value={"MSF_MUTABLE_SERVLET_FIELD"}, justification="dependency mutated only during init()")
    protected transient SiteService siteService;
    @SuppressWarnings(value={"MSF_MUTABLE_SERVLET_FIELD"}, justification="dependency mutated only during init()")
    protected transient ServerConfigurationService serverConfigurationService;
    @SuppressWarnings(value={"MSF_MUTABLE_SERVLET_FIELD"}, justification="dependency mutated only during init()")
    protected transient ComponentManager componentManager;
    @SuppressWarnings(value={"MSF_MUTABLE_SERVLET_FIELD"}, justification="dependency mutated only during init()")
    protected transient SynopticMsgcntrManager synopticMsgcntrManager;
    @SuppressWarnings(value={"MSF_MUTABLE_SERVLET_FIELD"}, justification="dependency mutated only during init()")
    protected transient PreferencesService preferencesService;
    protected transient MoreSiteViewImpl moreSiteViewImpl;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String uid;
        JSONObject json;
        Site myWorkSpace;
        ResourceBundle resourceBundle;
        boolean unread;
        boolean categorized;
        block20: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("doGet(HttpServletRequest " + request + ", HttpServletResponse " + response + ")"));
            }
            categorized = Boolean.parseBoolean(request.getParameter(CATEGORIZED));
            unread = Boolean.parseBoolean(request.getParameter(UNREAD));
            Locale locale = this.getLocale(request);
            resourceBundle = ResourceBundle.getBundle("sitenav", locale);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("categorized=" + categorized + "; " + UNREAD + "=" + unread + "; " + LOCALE + "=" + locale));
            }
            myWorkSpace = null;
            json = new JSONObject();
            uid = this.sessionManager.getCurrentSessionUserId();
            String eid = this.sessionManager.getCurrentSession().getUserEid();
            if (eid == null || "".equals(eid)) {
                json.element("principal", (Object)"anonymous");
            } else {
                json.element("principal", (Object)eid);
                try {
                    myWorkSpace = this.siteService.getSite(this.siteService.getUserSiteId(uid));
                }
                catch (IdUnusedException e) {
                    if (!LOG.isDebugEnabled()) break block20;
                    LOG.debug((Object)("My Workspace could not be found for user: " + eid));
                }
            }
        }
        List siteList = this.siteService.getSites(SiteService.SelectionType.ACCESS, null, null, null, SiteService.SortType.TITLE_ASC, null);
        if (siteList != null && siteList.size() > 0) {
            List synopticMsgcntrItems;
            Map<String, Integer> unreadForums;
            if (myWorkSpace != null) {
                siteList.add(0, myWorkSpace);
            }
            PortalSiteNavUserPreferences userPrefs = new PortalSiteNavUserPreferences(this.preferencesService.getPreferences(uid));
            json.element("display", (Object)userPrefs.getPrefTabs());
            Map<String, Integer> unreadMessages = unreadForums = Collections.emptyMap();
            if (unread && (synopticMsgcntrItems = this.synopticMsgcntrManager.getWorkspaceSynopticMsgcntrItems(uid)) != null) {
                int initialCapacity = synopticMsgcntrItems.size();
                unreadForums = new HashMap(initialCapacity);
                unreadMessages = new HashMap(initialCapacity);
                for (SynopticMsgcntrItem synopticMsgcntrItem : synopticMsgcntrItems) {
                    int messageCount;
                    String siteId = synopticMsgcntrItem.getSiteId();
                    int forumCount = synopticMsgcntrItem.getNewForumCount();
                    if (forumCount > 0) {
                        unreadForums.put(siteId, forumCount);
                    }
                    if ((messageCount = synopticMsgcntrItem.getNewMessagesCount()) <= 0) continue;
                    unreadMessages.put(siteId, messageCount);
                }
            }
            if (categorized) {
                List categorizedSitesList = this.moreSiteViewImpl.categorizeSites(siteList);
                JSONArray categoriesArrayJson = new JSONArray();
                for (Map map : categorizedSitesList) {
                    if (map.size() != 1) {
                        throw new IllegalStateException("The categorized maps must contain only one key per map!");
                    }
                    for (Map.Entry entry : map.entrySet()) {
                        String category = (String)entry.getKey();
                        List sortedSites = (List)entry.getValue();
                        JSONObject categoryJson = new JSONObject();
                        if (MoreSiteViewImpl.DEFAULT_SORT_ORDER.contains(category)) {
                            categoryJson.element("category", (Object)resourceBundle.getString(category));
                        } else {
                            categoryJson.element("category", (Object)category);
                        }
                        JSONArray sitesArrayJson = new JSONArray();
                        for (Site site : sortedSites) {
                            sitesArrayJson.add((Object)this.renderSiteJson(site, unreadForums, unreadMessages, resourceBundle));
                        }
                        categoryJson.element("sites", (Collection)sitesArrayJson);
                        categoriesArrayJson.add((Object)categoryJson);
                    }
                }
                json.element("categories", (Collection)categoriesArrayJson);
            } else {
                JSONArray sitesArrayJson = new JSONArray();
                for (Site site : siteList) {
                    sitesArrayJson.add((Object)this.renderSiteJson(site, unreadForums, unreadMessages, resourceBundle));
                }
                json.element("sites", (Collection)sitesArrayJson);
            }
        }
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(200);
        json.write((Writer)response.getWriter());
    }

    private JSONObject renderSiteJson(Site site, Map<String, Integer> unreadForums, Map<String, Integer> unreadMessages, ResourceBundle resourceBundle) {
        JSONObject siteJson = new JSONObject();
        String siteId = site.getId();
        if (TILDE == siteId.charAt(0)) {
            siteJson.element("title", (Object)resourceBundle.getString("sit_mywor"));
        } else {
            siteJson.element("title", (Object)site.getTitle());
        }
        siteJson.element("id", (Object)siteId);
        siteJson.element("url", (Object)site.getUrl());
        siteJson.element("description", (Object)site.getDescription());
        siteJson.element("forums", (Object)unreadForums.get(siteId));
        siteJson.element("messages", (Object)unreadMessages.get(siteId));
        return siteJson;
    }

    private Locale getLocale(HttpServletRequest request) throws IOException {
        Locale locale = null;
        String localeParam = request.getParameter(LOCALE);
        if (localeParam != null) {
            int underscore = localeParam.indexOf(UNDERSCORE);
            if (underscore > -1) {
                String[] parts = localeParam.split(UNDERSCORE);
                switch (parts.length) {
                    case 2: {
                        locale = new Locale(parts[0], parts[1]);
                        break;
                    }
                    case 3: {
                        locale = new Locale(parts[0], parts[1], parts[2]);
                        break;
                    }
                    default: {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Illegal locale request parameter: " + localeParam));
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else {
                locale = new Locale(localeParam);
            }
        }
        if (locale == null) {
            locale = request.getLocale();
        }
        return locale;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (this.componentManager == null) {
            this.componentManager = org.sakaiproject.component.cover.ComponentManager.getInstance();
        }
        this.sessionManager = (SessionManager)this.componentManager.get(SessionManager.class);
        this.siteService = (SiteService)this.componentManager.get(SiteService.class);
        if (this.siteService == null) {
            throw new IllegalStateException("SiteService == null");
        }
        if (this.sessionManager == null) {
            throw new IllegalStateException("SessionManager == null");
        }
        this.serverConfigurationService = (ServerConfigurationService)this.componentManager.get(ServerConfigurationService.class);
        if (this.serverConfigurationService == null) {
            throw new IllegalStateException("ServerConfigurationService == null");
        }
        this.synopticMsgcntrManager = (SynopticMsgcntrManager)this.componentManager.get(SynopticMsgcntrManager.class);
        if (this.synopticMsgcntrManager == null) {
            throw new IllegalStateException("SynopticMsgcntrManager == null");
        }
        this.preferencesService = (PreferencesService)this.componentManager.get(PreferencesService.class);
        if (this.preferencesService == null) {
            throw new IllegalStateException("PreferencesService == null");
        }
        this.moreSiteViewImpl = new MoreSiteViewImpl(this.serverConfigurationService);
    }

    protected void setupTestCase(ComponentManager componentManager) {
        if (componentManager == null) {
            throw new IllegalArgumentException("componentManager == null");
        }
        this.componentManager = componentManager;
    }
}

