/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.mailsender;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailsenderException
extends Exception {
    private static final long serialVersionUID = 1L;
    private List<Map<String, Object[]>> messages;

    public MailsenderException() {
    }

    public MailsenderException(String code, String value) {
        this.addMessage(code, value);
    }

    public MailsenderException(List<Map<String, Object[]>> messages) {
        this.messages = messages;
    }

    public MailsenderException(String message, Exception cause) {
        super(message, cause);
    }

    public boolean hasMessages() {
        return this.messages != null && this.messages.size() > 0;
    }

    public void addMessage(Map<String, Object[]> message) {
        if (this.messages == null) {
            this.messages = new ArrayList<Map<String, Object[]>>();
        }
        this.messages.add(message);
    }

    public MailsenderException addMessage(String code) {
        this.addMessage(code, "");
        return this;
    }

    public MailsenderException addMessage(String code, String value) {
        this.addMessage(code, new String[]{value});
        return this;
    }

    public MailsenderException addMessage(String code, Object[] value) {
        HashMap<String, Object[]> hm = new HashMap<String, Object[]>();
        hm.put(code, value);
        this.addMessage(hm);
        return this;
    }

    public List<Map<String, Object[]>> getMessages() {
        return this.messages;
    }
}

