/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.mailsender.model;

public class ConfigEntry {
    public static final ConfigEntry DEFAULT_CONFIG = new ConfigEntry(SubjectPrefixType.system.name(), false, false, false, ReplyTo.no_reply_to.name(), false, null, true);
    private String replyTo;
    private boolean displayInvalidEmails;
    private boolean sendMeACopy;
    private boolean appendRecipientList;
    private boolean addToArchive;
    private String subjectPrefixType;
    private String subjectPrefix;
    private boolean displayEmptyGroups = true;
    private boolean onlyPlainText;

    public ConfigEntry() {
        this.setReplyTo(ReplyTo.no_reply_to.name());
        this.setSubjectPrefixType(SubjectPrefixType.system.name());
    }

    public ConfigEntry(String subjectPrefixType, boolean sendMeACopy, boolean appendRecipientList, boolean addToArchive, String replyTo, boolean displayInvalidEmails, String subjectPrefix, boolean displayEmptyGroups) {
        this.setSubjectPrefixType(subjectPrefixType);
        this.setSubjectPrefix(subjectPrefix);
        this.setSendMeACopy(sendMeACopy);
        this.setAppendRecipientList(appendRecipientList);
        this.setAddToArchive(addToArchive);
        this.setReplyTo(replyTo);
        this.setDisplayInvalidEmails(displayInvalidEmails);
        this.setDisplayEmptyGroups(displayEmptyGroups);
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = "yes".equals(replyTo) ? ReplyTo.sender.name() : ("no".equals(replyTo) ? ReplyTo.no_reply_to.name() : ReplyTo.valueOf(replyTo).name());
    }

    public void setSubjectPrefixType(String subjectPrefixType) {
        this.subjectPrefixType = SubjectPrefixType.valueOf(subjectPrefixType).name();
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public boolean isDisplayInvalidEmails() {
        return this.displayInvalidEmails;
    }

    public boolean isSendMeACopy() {
        return this.sendMeACopy;
    }

    public boolean isAppendRecipientList() {
        return this.appendRecipientList;
    }

    public boolean isAddToArchive() {
        return this.addToArchive;
    }

    public String getSubjectPrefixType() {
        return this.subjectPrefixType;
    }

    public String getSubjectPrefix() {
        return this.subjectPrefix;
    }

    public boolean isDisplayEmptyGroups() {
        return this.displayEmptyGroups;
    }

    public boolean isOnlyPlainText() {
        return this.onlyPlainText;
    }

    public void setDisplayInvalidEmails(boolean displayInvalidEmails) {
        this.displayInvalidEmails = displayInvalidEmails;
    }

    public void setSendMeACopy(boolean sendMeACopy) {
        this.sendMeACopy = sendMeACopy;
    }

    public void setAppendRecipientList(boolean appendRecipientList) {
        this.appendRecipientList = appendRecipientList;
    }

    public void setAddToArchive(boolean addToArchive) {
        this.addToArchive = addToArchive;
    }

    public void setSubjectPrefix(String subjectPrefix) {
        this.subjectPrefix = subjectPrefix;
    }

    public void setDisplayEmptyGroups(boolean displayEmptyGroups) {
        this.displayEmptyGroups = displayEmptyGroups;
    }

    public void setOnlyPlainText(boolean onlyPlainText) {
        this.onlyPlainText = onlyPlainText;
    }

    public static enum ConfigParams {
        replyto,
        sendmecopy,
        appendrecipientlist,
        emailarchive,
        subjectprefix,
        displayinvalidemailaddrs,
        displayemptygroups,
        onlyplaintext;

    }

    public static enum SubjectPrefixType {
        system,
        custom;

    }

    public static enum ReplyTo {
        sender,
        no_reply_to;

    }
}

