/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.mailsender.tool.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.mailsender.AttachmentException;
import org.sakaiproject.mailsender.MailsenderException;
import org.sakaiproject.mailsender.logic.ComposeLogic;
import org.sakaiproject.mailsender.logic.ConfigLogic;
import org.sakaiproject.mailsender.logic.ExternalLogic;
import org.sakaiproject.mailsender.model.ConfigEntry;
import org.sakaiproject.mailsender.model.EmailEntry;
import org.sakaiproject.user.api.User;
import org.sakaiproject.util.StringUtil;
import org.springframework.web.multipart.MultipartFile;
import uk.org.ponder.messageutil.MessageLocator;
import uk.org.ponder.messageutil.TargettedMessage;
import uk.org.ponder.messageutil.TargettedMessageList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailBean {
    public static final String EMAIL_SENT = "emailSent";
    public static final String EMAIL_FAILED = "emailFailed";
    public static final String EMAIL_CANCELLED = "emailCancelled";
    private Map<String, MultipartFile> multipartMap;
    private final Log log = LogFactory.getLog(EmailBean.class);
    private ComposeLogic composeLogic;
    private ConfigLogic configLogic;
    private ExternalLogic externalLogic;
    private EmailEntry emailEntry;
    private TargettedMessageList messages;
    private MessageLocator messageLocator;
    private ServerConfigurationService configService;

    public EmailBean() {
    }

    public EmailBean(ComposeLogic composeLogic, ConfigLogic configLogic, ExternalLogic externalLogic, Map<String, MultipartFile> multipartMap, TargettedMessageList messages, MessageLocator messageLocator) {
        this.composeLogic = composeLogic;
        this.configLogic = configLogic;
        this.externalLogic = externalLogic;
        this.multipartMap = multipartMap;
        this.messages = messages;
        this.messageLocator = messageLocator;
    }

    public void setMultipartMap(Map<String, MultipartFile> multipartMap) {
        this.multipartMap = multipartMap;
    }

    public void setComposeLogic(ComposeLogic composeLogic) {
        this.composeLogic = composeLogic;
    }

    public void setConfigLogic(ConfigLogic configLogic) {
        this.configLogic = configLogic;
    }

    public void setExternalLogic(ExternalLogic externalLogic) {
        this.externalLogic = externalLogic;
    }

    public void setMessages(TargettedMessageList messages) {
        this.messages = messages;
    }

    public void setMessageLocator(MessageLocator messageLocator) {
        this.messageLocator = messageLocator;
    }

    public void setConfigService(ServerConfigurationService configService) {
        this.configService = configService;
    }

    public String cancelEmail() {
        return EMAIL_CANCELLED;
    }

    public EmailEntry getNewEmail() {
        if (this.emailEntry == null) {
            this.emailEntry = new EmailEntry(this.configLogic.getConfig());
        }
        return this.emailEntry;
    }

    public String sendEmail() {
        if (this.emailEntry == null || this.emailEntry.getConfig() == null) {
            this.messages.addMessage(new TargettedMessage("error.nothing.send"));
            return EMAIL_FAILED;
        }
        ConfigEntry config = this.emailEntry.getConfig();
        User curUser = this.externalLogic.getCurrentUser();
        String fromEmail = "";
        String fromDisplay = "";
        if (curUser != null) {
            fromEmail = curUser.getEmail();
            fromDisplay = curUser.getDisplayName();
        }
        if (fromEmail == null || fromEmail.trim().length() == 0) {
            this.messages.addMessage(new TargettedMessage("no.from.address"));
            return EMAIL_FAILED;
        }
        String content = this.emailEntry.getContent();
        HashMap emailusers = new HashMap();
        this.compileEmailList(fromEmail, emailusers);
        List emailOthers = this.emailEntry.getOtherRecipients();
        String[] allowedDomains = StringUtil.split((String)this.configService.getString("sakai.mailsender.other.domains"), (String)",");
        List invalids = new ArrayList<String>();
        for (String email : emailOthers) {
            if (allowedDomains != null && allowedDomains.length > 0) {
                for (String domain : allowedDomains) {
                    if (email.endsWith(domain)) {
                        emailusers.put(email, null);
                        continue;
                    }
                    invalids.add(email);
                }
                continue;
            }
            emailusers.put(email, null);
        }
        String subjectContent = this.emailEntry.getSubject();
        if (subjectContent == null || subjectContent.trim().length() == 0) {
            subjectContent = this.messageLocator.getMessage("no.subject");
        }
        String subject = (config.getSubjectPrefix() != null ? config.getSubjectPrefix() : "") + subjectContent;
        try {
            if (invalids.size() == 0) {
                invalids = this.externalLogic.sendEmail(config, fromEmail, fromDisplay, emailusers, subject, content, this.multipartMap);
            }
            String siteId = this.externalLogic.getSiteID();
            String fromString = fromDisplay + " <" + fromEmail + ">";
            this.addToArchive(config, fromString, subject, siteId);
            for (Map.Entry entry : emailusers.entrySet()) {
                String compareAddr = null;
                String addrStr = null;
                if (entry.getValue() != null && ((String)entry.getValue()).trim().length() > 0) {
                    addrStr = (String)entry.getValue();
                    compareAddr = "\"" + (String)entry.getValue() + "\" <" + (String)entry.getKey() + ">";
                } else {
                    addrStr = (String)entry.getKey();
                    compareAddr = (String)entry.getKey();
                }
                if (invalids.contains(compareAddr)) continue;
                this.messages.addMessage(new TargettedMessage("verbatim", (Object[])new String[]{addrStr}, 2));
            }
        }
        catch (MailsenderException me) {
            this.messages.clear();
            List msgs = me.getMessages();
            if (msgs != null) {
                for (Map msg : msgs) {
                    for (Map.Entry e : msg.entrySet()) {
                        this.messages.addMessage(new TargettedMessage((String)e.getKey(), (Object[])e.getValue(), 1));
                    }
                }
            } else {
                this.messages.addMessage(new TargettedMessage("verbatim", (Object[])new String[]{me.getMessage()}, 1));
            }
            return EMAIL_FAILED;
        }
        catch (AttachmentException ae) {
            this.messages.clear();
            this.messages.addMessage(new TargettedMessage("error.attachment", (Object[])new String[]{ae.getMessage()}, 1));
            return EMAIL_FAILED;
        }
        boolean showBadEmails = config.isDisplayInvalidEmails();
        if (showBadEmails && invalids != null && invalids.size() > 0) {
            String names = invalids.toString();
            this.messages.addMessage(new TargettedMessage("invalid.email.addresses", (Object[])new String[]{names.substring(1, names.length() - 1)}, 0));
        }
        return EMAIL_SENT;
    }

    private void addToArchive(ConfigEntry config, String fromString, String subject, String siteId) {
        if (this.emailEntry.getConfig().isAddToArchive()) {
            StringBuilder attachment_info = new StringBuilder("<br/>");
            int i = 1;
            for (MultipartFile file : this.multipartMap.values()) {
                if (file.getSize() <= 0L) continue;
                attachment_info.append("<br/>");
                attachment_info.append("Attachment #").append(i).append(": ").append(file.getName()).append("(").append(file.getSize()).append(" Bytes)");
                ++i;
            }
            String emailarchive = "/mailarchive/channel/" + siteId + "/main";
            String content = this.emailEntry.getContent() + attachment_info.toString();
            this.externalLogic.addToArchive(config, emailarchive, fromString, subject, content);
        }
    }

    private HashSet<String> compileEmailList(String fromEmail, HashMap<String, String> emailusers) {
        HashSet<String> badEmails = new HashSet<String>();
        if (this.emailEntry.isAllIds()) {
            try {
                this.addEmailUsers(fromEmail, emailusers, this.composeLogic.getUsers());
            }
            catch (IdUnusedException e) {
                this.log.warn((Object)e.getMessage(), (Throwable)e);
                badEmails.add(e.getMessage());
            }
        } else {
            List users;
            for (String roleId : this.emailEntry.getRoleIds().keySet()) {
                try {
                    users = this.composeLogic.getUsersByRole(roleId);
                    this.addEmailUsers(fromEmail, emailusers, users);
                }
                catch (IdUnusedException e) {
                    this.log.warn((Object)e.getMessage(), (Throwable)e);
                    badEmails.add(roleId);
                }
            }
            for (String sectionId : this.emailEntry.getSectionIds().keySet()) {
                try {
                    users = this.composeLogic.getUsersByGroup(sectionId);
                    this.addEmailUsers(fromEmail, emailusers, users);
                }
                catch (IdUnusedException e) {
                    this.log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            for (String groupId : this.emailEntry.getGroupIds().keySet()) {
                try {
                    users = this.composeLogic.getUsersByGroup(groupId);
                    this.addEmailUsers(fromEmail, emailusers, users);
                }
                catch (IdUnusedException e) {
                    this.log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            for (String userId : this.emailEntry.getUserIds().keySet()) {
                User user = this.externalLogic.getUser(userId);
                this.addEmailUser(fromEmail, emailusers, user);
            }
        }
        return badEmails;
    }

    private void addEmailUsers(String fromEmail, HashMap<String, String> emailusers, List<User> users) {
        for (User user : users) {
            this.addEmailUser(fromEmail, emailusers, user);
        }
    }

    private void addEmailUser(String fromEmail, HashMap<String, String> emailusers, User user) {
        if (!fromEmail.equals(user.getEmail())) {
            emailusers.put(user.getEmail(), user.getDisplayName());
        }
    }
}

