/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.mailsender.tool.producers;

import java.util.ArrayList;
import java.util.List;
import org.sakaiproject.mailsender.logic.ExternalLogic;
import org.sakaiproject.mailsender.tool.params.UserGroupViewParameters;
import org.sakaiproject.mailsender.tool.producers.NavBarRenderer;
import org.sakaiproject.user.api.User;
import uk.org.ponder.rsf.components.UIBoundBoolean;
import uk.org.ponder.rsf.components.UIBoundString;
import uk.org.ponder.rsf.components.UICommand;
import uk.org.ponder.rsf.components.UIContainer;
import uk.org.ponder.rsf.components.UIForm;
import uk.org.ponder.rsf.components.UIInput;
import uk.org.ponder.rsf.components.UILink;
import uk.org.ponder.rsf.components.UIMessage;
import uk.org.ponder.rsf.components.UIOutput;
import uk.org.ponder.rsf.components.decorators.UIDecorator;
import uk.org.ponder.rsf.components.decorators.UIFreeAttributeDecorator;
import uk.org.ponder.rsf.evolvers.TextInputEvolver;
import uk.org.ponder.rsf.flow.jsfnav.NavigationCase;
import uk.org.ponder.rsf.flow.jsfnav.NavigationCaseReporter;
import uk.org.ponder.rsf.view.ComponentChecker;
import uk.org.ponder.rsf.view.DefaultView;
import uk.org.ponder.rsf.view.ViewComponentProducer;
import uk.org.ponder.rsf.viewstate.AnyViewParameters;
import uk.org.ponder.rsf.viewstate.SimpleViewParameters;
import uk.org.ponder.rsf.viewstate.ViewParameters;
import uk.org.ponder.rsf.viewstate.ViewStateHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComposeProducer
implements ViewComponentProducer,
NavigationCaseReporter,
DefaultView {
    public static final String VIEW_ID = "compose";
    private ExternalLogic externalLogic;
    private NavBarRenderer navBarRenderer;
    private TextInputEvolver richTextEvolver;
    private ViewStateHandler viewStateHandler;

    public void setExternalLogic(ExternalLogic externalLogic) {
        this.externalLogic = externalLogic;
    }

    public void setNavBarRenderer(NavBarRenderer navBarRenderer) {
        this.navBarRenderer = navBarRenderer;
    }

    public void setRichTextEvolver(TextInputEvolver richTextEvolver) {
        this.richTextEvolver = richTextEvolver;
    }

    public void setViewStateHandler(ViewStateHandler viewStateHandler) {
        this.viewStateHandler = viewStateHandler;
    }

    public String getViewID() {
        return VIEW_ID;
    }

    public void fillComponents(UIContainer tofill, ViewParameters viewparams, ComponentChecker checker) {
        String emailBean = "emailBean.newEmail";
        this.navBarRenderer.makeNavBar(tofill, "navIntraTool:", VIEW_ID);
        UIForm mainForm = UIForm.make((UIContainer)tofill, (String)"mainForm");
        User curUser = this.externalLogic.getCurrentUser();
        String fromEmail = "";
        String fromDisplay = "";
        if (curUser != null) {
            fromEmail = curUser.getEmail();
            fromDisplay = curUser.getDisplayName();
        }
        String from = fromDisplay + " <" + fromEmail + ">";
        UIOutput.make((UIContainer)tofill, (String)"from", (String)from);
        UIBoundBoolean input = UIBoundBoolean.make((UIContainer)mainForm, (String)"mailsender-rcpt-all", (String)"emailBean.newEmail.allIds");
        input.decorate((UIDecorator)new UIFreeAttributeDecorator("onclick", "RcptSelect.toggleSelectAll()"));
        UIMessage msg = UIMessage.make((String)"select_rcpts_by_role");
        UserGroupViewParameters viewParams = new UserGroupViewParameters("userGroup");
        viewParams.type = "role";
        String url = this.viewStateHandler.getFullURL((ViewParameters)viewParams);
        UILink link = UILink.make((UIContainer)tofill, (String)"mailsender-rcpt-link-roles", (UIBoundString)msg, (String)url);
        UIFreeAttributeDecorator rolesDecorator = new UIFreeAttributeDecorator("onclick", "RcptSelect.showResults(this, 'mailsender-roles', true); return false;");
        link.decorate((UIDecorator)rolesDecorator);
        msg = UIMessage.make((String)"select_rcpts_by_section");
        viewParams = new UserGroupViewParameters("userGroup");
        viewParams.type = "section";
        url = this.viewStateHandler.getFullURL((ViewParameters)viewParams);
        link = UILink.make((UIContainer)tofill, (String)"mailsender-rcpt-link-sections", (UIBoundString)msg, (String)url);
        UIFreeAttributeDecorator sectionsDecorator = new UIFreeAttributeDecorator("onclick", "RcptSelect.showResults(this, 'mailsender-sections', true); return false;");
        link.decorate((UIDecorator)sectionsDecorator);
        msg = UIMessage.make((String)"select_rcpts_by_group");
        viewParams = new UserGroupViewParameters("userGroup");
        viewParams.type = "group";
        url = this.viewStateHandler.getFullURL((ViewParameters)viewParams);
        link = UILink.make((UIContainer)tofill, (String)"mailsender-rcpt-link-groups", (UIBoundString)msg, (String)url);
        UIFreeAttributeDecorator groupsDecorator = new UIFreeAttributeDecorator("onclick", "RcptSelect.showResults(this, 'mailsender-groups', true); return false;");
        link.decorate((UIDecorator)groupsDecorator);
        UIInput.make((UIContainer)mainForm, (String)"otherRecipients", (String)(emailBean + ".otherRecipients"));
        UIInput.make((UIContainer)mainForm, (String)"subject", (String)(emailBean + ".subject"));
        UIInput content = UIInput.make((UIContainer)mainForm, (String)"content-div:", (String)(emailBean + ".content"));
        this.richTextEvolver.evolveTextInput(content);
        UIBoundBoolean.make((UIContainer)mainForm, (String)"sendMeCopy", (String)(emailBean + ".config.sendMeACopy"));
        if (this.externalLogic.isEmailArchiveAddedToSite()) {
            UIOutput.make((UIContainer)mainForm, (String)"addToArchiveDiv");
            UIBoundBoolean.make((UIContainer)mainForm, (String)"addToArchive", (String)(emailBean + ".config.addToArchive"));
        }
        UICommand.make((UIContainer)mainForm, (String)"send-button", (UIBoundString)UIMessage.make((String)"send_mail_button"), (String)"emailBean.sendEmail");
        UICommand.make((UIContainer)mainForm, (String)"cancel-button", (UIBoundString)UIMessage.make((String)"cancel_mail_button"));
    }

    public List<NavigationCase> reportNavigationCases() {
        ArrayList<NavigationCase> cases = new ArrayList<NavigationCase>();
        cases.add(new NavigationCase((AnyViewParameters)new SimpleViewParameters(VIEW_ID)));
        cases.add(new NavigationCase("emailSent", (AnyViewParameters)new SimpleViewParameters("results")));
        return cases;
    }
}

