/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.mailsender.tool.beans;

import org.sakaiproject.mailsender.logic.ConfigLogic;
import org.sakaiproject.mailsender.model.ConfigEntry;
import uk.org.ponder.messageutil.TargettedMessage;
import uk.org.ponder.messageutil.TargettedMessageList;

public class ConfigBean {
    public static final String CONFIG_SAVED = "configSaved";
    public static final String CONFIG_SAVE_FAILED = "configSaveFail";
    public static final String CONFIG_CANCELLED = "configCancelled";
    private ConfigEntry entry;
    private ConfigLogic configLogic;
    private TargettedMessageList messages;

    public void setConfigLogic(ConfigLogic configLogic) {
        this.configLogic = configLogic;
    }

    public void setMessages(TargettedMessageList messageList) {
        this.messages = messageList;
    }

    public ConfigEntry getConfig() {
        if (this.entry == null) {
            this.entry = this.configLogic.getConfig();
        }
        return this.entry;
    }

    public String cancelConfig() {
        return CONFIG_CANCELLED;
    }

    public String saveConfig() {
        if (this.entry != null) {
            if (ConfigEntry.SubjectPrefixType.custom.name().equals(this.entry.getSubjectPrefixType()) && (this.entry.getSubjectPrefix() == null || this.entry.getSubjectPrefix().trim().length() == 0)) {
                this.messages.addMessage(new TargettedMessage("custom_prefix_required"));
                return CONFIG_SAVE_FAILED;
            }
            this.configLogic.saveConfig(this.entry);
            this.entry = null;
        }
        return CONFIG_SAVED;
    }
}

