/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.mailsender.tool.producers.fragments;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.mailsender.logic.ComposeLogic;
import org.sakaiproject.mailsender.logic.ConfigLogic;
import org.sakaiproject.mailsender.model.ConfigEntry;
import org.sakaiproject.mailsender.model.EmailRole;
import org.sakaiproject.mailsender.tool.params.UserGroupViewParameters;
import org.sakaiproject.mailsender.tool.params.UsersViewParameters;
import org.sakaiproject.mailsender.tool.producers.fragments.UserGroupingProducer;
import uk.org.ponder.messageutil.TargettedMessage;
import uk.org.ponder.messageutil.TargettedMessageList;
import uk.org.ponder.rsf.components.UIBoundBoolean;
import uk.org.ponder.rsf.components.UIBoundString;
import uk.org.ponder.rsf.components.UIBranchContainer;
import uk.org.ponder.rsf.components.UIContainer;
import uk.org.ponder.rsf.components.UIInternalLink;
import uk.org.ponder.rsf.components.UILink;
import uk.org.ponder.rsf.components.UIMessage;
import uk.org.ponder.rsf.components.UIOutput;
import uk.org.ponder.rsf.components.decorators.UIDecorator;
import uk.org.ponder.rsf.components.decorators.UIDisabledDecorator;
import uk.org.ponder.rsf.components.decorators.UIFreeAttributeDecorator;
import uk.org.ponder.rsf.components.decorators.UIIDStrategyDecorator;
import uk.org.ponder.rsf.content.ContentTypeReporter;
import uk.org.ponder.rsf.view.ComponentChecker;
import uk.org.ponder.rsf.view.ViewComponentProducer;
import uk.org.ponder.rsf.viewstate.ViewParameters;
import uk.org.ponder.rsf.viewstate.ViewParamsReporter;
import uk.org.ponder.rsf.viewstate.ViewStateHandler;

public class UserGroupingProducer
implements ViewComponentProducer,
ViewParamsReporter,
ContentTypeReporter {
    public static final String VIEW_ID = "userGroup";
    private final Log log = LogFactory.getLog(UserGroupingProducer.class);
    private ComposeLogic composeLogic;
    private TargettedMessageList messages;
    private ViewStateHandler viewStateHandler;
    private ConfigLogic configLogic;

    public UserGroupingProducer() {
    }

    public UserGroupingProducer(ComposeLogic composeLogic, ViewStateHandler viewStateHandler, TargettedMessageList messages) {
        this.composeLogic = composeLogic;
        this.viewStateHandler = viewStateHandler;
        this.messages = messages;
    }

    public void setComposeLogic(ComposeLogic composeLogic) {
        this.composeLogic = composeLogic;
    }

    public void setMessages(TargettedMessageList messages) {
        this.messages = messages;
    }

    public void setViewStateHandler(ViewStateHandler viewStateHandler) {
        this.viewStateHandler = viewStateHandler;
    }

    public void setConfigLogic(ConfigLogic configLogic) {
        this.configLogic = configLogic;
    }

    public void fillComponents(UIContainer tofill, ViewParameters viewparams, ComponentChecker checker) {
        try {
            UserGroupViewParameters ugParams = (UserGroupViewParameters)viewparams;
            List emailRoles = null;
            if ("group".equals(ugParams.type)) {
                emailRoles = this.composeLogic.getEmailGroups();
            } else if ("section".equals(ugParams.type)) {
                emailRoles = this.composeLogic.getEmailSections();
            } else if ("role".equals(ugParams.type)) {
                emailRoles = this.composeLogic.getEmailRoles();
            } else {
                this.messages.addMessage(new TargettedMessage("error.unknown.role.type"));
                return;
            }
            if (emailRoles.size() == 0) {
                this.messages.addMessage(new TargettedMessage("no." + ugParams.type + ".found", null, 0));
            } else {
                int totalEntriesShown = 0;
                ConfigEntry config = this.configLogic.getConfig();
                for (int i = 0; i < emailRoles.size(); ++i) {
                    EmailRole role = (EmailRole)emailRoles.get(i);
                    int numEntriesInRole = 0;
                    switch (1.$SwitchMap$org$sakaiproject$mailsender$model$EmailRole$Type[role.getType().ordinal()]) {
                        case 1: 
                        case 2: {
                            numEntriesInRole = this.composeLogic.countUsersByGroup(role.getRoleId());
                            break;
                        }
                        case 3: {
                            numEntriesInRole = this.composeLogic.countUsersByRole(role.getRoleId());
                        }
                    }
                    totalEntriesShown += numEntriesInRole;
                    String[] rolePlural = new String[]{role.getRolePlural()};
                    if (numEntriesInRole <= 0 && !config.isDisplayEmptyGroups()) continue;
                    UIBranchContainer roleBranch = UIBranchContainer.make((UIContainer)tofill, (String)"mailsender-usersGroupOption:", (String)Integer.toString(i));
                    UIBoundBoolean input = UIBoundBoolean.make((UIContainer)roleBranch, (String)"mailsender-usersGroup", (String)("emailBean.newEmail." + ugParams.type + "Ids." + role.getRoleId()));
                    input.decorate((UIDecorator)new UIIDStrategyDecorator(input.getFullID() + "-" + ugParams.type));
                    if (numEntriesInRole > 0) {
                        input.decorate((UIDecorator)new UIFreeAttributeDecorator("onclick", "RcptSelect.toggleSelectAll(this.id)"));
                    } else if (config.isDisplayEmptyGroups()) {
                        input.decorate((UIDecorator)new UIDisabledDecorator());
                    }
                    this.createToggleArea(ugParams, role, roleBranch, rolePlural);
                }
                if (!config.isDisplayEmptyGroups() && totalEntriesShown <= 0) {
                    this.messages.addMessage(new TargettedMessage("no." + ugParams.type + ".found", null, 0));
                }
            }
        }
        catch (GroupNotDefinedException gnde) {
            this.log.error((Object)gnde.getMessage(), (Throwable)gnde);
            this.messages.addMessage(new TargettedMessage("exception.generic", (Object[])new String[]{gnde.getMessage()}));
        }
        catch (IdUnusedException iue) {
            this.log.error((Object)iue.getMessage(), (Throwable)iue);
            this.messages.addMessage(new TargettedMessage("exception.generic", (Object[])new String[]{iue.getMessage()}));
        }
    }

    private void createToggleArea(UserGroupViewParameters ugParams, EmailRole role, UIBranchContainer roleBranch, String[] rolePlural) {
        UIMessage msg = UIMessage.make((String)"usersbyrole_all_prefix", (Object[])rolePlural);
        UsersViewParameters usersParams = new UsersViewParameters("users");
        usersParams.type = ugParams.type;
        usersParams.id = role.getRoleId();
        String url = this.viewStateHandler.getFullURL((ViewParameters)usersParams);
        UIOutput usersArea = UIOutput.make((UIContainer)roleBranch, (String)"mailsender-users");
        UILink selectLink = UIInternalLink.make((UIContainer)roleBranch, (String)"mailsender-usersGroupLink-select", (UIBoundString)msg, (String)url);
        UILink collapseLink = UIInternalLink.make((UIContainer)roleBranch, (String)"mailsender-usersGroupLink-collapse", (UIBoundString)msg, (String)"#");
        String usersAreaId = usersArea.getFullID() + "-" + ugParams.type;
        String selectLinkId = selectLink.getFullID() + "-" + ugParams.type;
        String collapseLinkId = collapseLink.getFullID() + "-" + ugParams.type;
        usersArea.decorate((UIDecorator)new UIIDStrategyDecorator(usersAreaId));
        selectLink.decorate((UIDecorator)new UIIDStrategyDecorator(selectLinkId));
        collapseLink.decorate((UIDecorator)new UIIDStrategyDecorator(collapseLinkId));
        String commonParams = "'" + usersAreaId + "', '" + selectLinkId + "', '" + collapseLinkId + "');return false";
        String command = "RcptSelect.showIndividuals(this, " + commonParams;
        selectLink.decorate((UIDecorator)new UIFreeAttributeDecorator("onclick", command));
        command = "RcptSelect.hideIndividuals(" + commonParams;
        collapseLink.decorate((UIDecorator)new UIFreeAttributeDecorator("onclick", command));
    }

    public String getContentType() {
        return "HTML-FRAGMENT";
    }

    public String getViewID() {
        return VIEW_ID;
    }

    public ViewParameters getViewParameters() {
        return new UserGroupViewParameters();
    }
}

