/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.mailsender.tool.producers.fragments;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.mailsender.logic.ComposeLogic;
import org.sakaiproject.mailsender.tool.params.UsersViewParameters;
import org.sakaiproject.user.api.User;
import uk.org.ponder.messageutil.TargettedMessage;
import uk.org.ponder.messageutil.TargettedMessageList;
import uk.org.ponder.rsf.components.UIBoundBoolean;
import uk.org.ponder.rsf.components.UIBranchContainer;
import uk.org.ponder.rsf.components.UIContainer;
import uk.org.ponder.rsf.components.UIVerbatim;
import uk.org.ponder.rsf.components.decorators.UIDecorator;
import uk.org.ponder.rsf.components.decorators.UIDisabledDecorator;
import uk.org.ponder.rsf.components.decorators.UIFreeAttributeDecorator;
import uk.org.ponder.rsf.components.decorators.UIStyleDecorator;
import uk.org.ponder.rsf.view.ComponentChecker;
import uk.org.ponder.rsf.view.ViewComponentProducer;
import uk.org.ponder.rsf.viewstate.ViewParameters;
import uk.org.ponder.rsf.viewstate.ViewParamsReporter;

public class UsersProducer
implements ViewComponentProducer,
ViewParamsReporter {
    public static final String VIEW_ID = "users";
    private final Log log = LogFactory.getLog(UsersProducer.class);
    private ComposeLogic composeLogic;
    private TargettedMessageList messages;

    public void setComposeLogic(ComposeLogic composeLogic) {
        this.composeLogic = composeLogic;
    }

    public void setMessages(TargettedMessageList messages) {
        this.messages = messages;
    }

    public String getViewID() {
        return VIEW_ID;
    }

    public void fillComponents(UIContainer tofill, ViewParameters viewparams, ComponentChecker checker) {
        try {
            UsersViewParameters viewParams = (UsersViewParameters)viewparams;
            List users = null;
            if (viewParams.id != null && viewParams.id.trim().length() != 0) {
                users = "section".equals(viewParams.type) || "group".equals(viewParams.type) ? this.composeLogic.getUsersByGroup(viewParams.id) : this.composeLogic.getUsersByRole(viewParams.id);
            }
            if (users == null || users.size() == 0) {
                this.messages.addMessage(new TargettedMessage("no." + viewParams.type + ".members.found", null, 0));
            } else {
                int i = 0;
                for (User user : users) {
                    UIBranchContainer cell = UIBranchContainer.make((UIContainer)tofill, (String)"mailsender-userCol:", (String)(viewParams.id + "-" + Integer.toString(i)));
                    String displayName = user.getLastName() + ", " + user.getFirstName() + " (" + user.getDisplayId() + ")";
                    UIBoundBoolean input = UIBoundBoolean.make((UIContainer)cell, (String)"mailsender-user", (String)("emailBean.newEmail.userIds." + user.getId()));
                    UIVerbatim label = UIVerbatim.make((UIContainer)cell, (String)"mailsender-userLabel", (Object)displayName);
                    if (user.getEmail() != null && user.getEmail().trim().length() != 0) {
                        input.decorate((UIDecorator)new UIFreeAttributeDecorator("onclick", "RcptSelect.toggleIndividual(this.id)"));
                    } else {
                        input.decorate((UIDecorator)new UIDisabledDecorator());
                        label.decorate((UIDecorator)new UIStyleDecorator("invalid-user"));
                    }
                    ++i;
                }
            }
        }
        catch (IdUnusedException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            this.messages.addMessage(new TargettedMessage("exception.generic", (Object[])new String[]{e.getMessage()}, 1));
        }
    }

    public ViewParameters getViewParameters() {
        return new UsersViewParameters();
    }
}

