/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.mailsender.tool.producers;

import java.util.ArrayList;
import java.util.List;
import org.sakaiproject.mailsender.logic.ConfigLogic;
import org.sakaiproject.mailsender.logic.ExternalLogic;
import org.sakaiproject.mailsender.model.ConfigEntry;
import org.sakaiproject.mailsender.tool.producers.NavBarRenderer;
import uk.org.ponder.messageutil.MessageLocator;
import uk.org.ponder.rsf.components.UIBoundBoolean;
import uk.org.ponder.rsf.components.UIBoundString;
import uk.org.ponder.rsf.components.UICommand;
import uk.org.ponder.rsf.components.UIContainer;
import uk.org.ponder.rsf.components.UIForm;
import uk.org.ponder.rsf.components.UIInput;
import uk.org.ponder.rsf.components.UIMessage;
import uk.org.ponder.rsf.components.UIOutput;
import uk.org.ponder.rsf.components.UISelect;
import uk.org.ponder.rsf.components.UISelectChoice;
import uk.org.ponder.rsf.components.UISelectLabel;
import uk.org.ponder.rsf.components.decorators.UIDecorator;
import uk.org.ponder.rsf.components.decorators.UIStyleDecorator;
import uk.org.ponder.rsf.flow.jsfnav.NavigationCase;
import uk.org.ponder.rsf.flow.jsfnav.NavigationCaseReporter;
import uk.org.ponder.rsf.view.ComponentChecker;
import uk.org.ponder.rsf.view.ViewComponentProducer;
import uk.org.ponder.rsf.viewstate.AnyViewParameters;
import uk.org.ponder.rsf.viewstate.SimpleViewParameters;
import uk.org.ponder.rsf.viewstate.ViewParameters;

public class OptionsProducer
implements ViewComponentProducer,
NavigationCaseReporter {
    public static final String VIEW_ID = "options";
    private NavBarRenderer navBarRenderer;
    private ExternalLogic externalLogic;
    private ConfigLogic configLogic;
    private MessageLocator messageLocator;

    public void setNavBarRenderer(NavBarRenderer navBarRenderer) {
        this.navBarRenderer = navBarRenderer;
    }

    public void setExternalLogic(ExternalLogic externalLogic) {
        this.externalLogic = externalLogic;
    }

    public void setConfigLogic(ConfigLogic configLogic) {
        this.configLogic = configLogic;
    }

    public void setMessageLocator(MessageLocator messageLocator) {
        this.messageLocator = messageLocator;
    }

    public String getViewID() {
        return VIEW_ID;
    }

    public void fillComponents(UIContainer tofill, ViewParameters viewparams, ComponentChecker checker) {
        this.navBarRenderer.makeNavBar(tofill, "navIntraTool:", VIEW_ID);
        UIForm optionsForm = UIForm.make((UIContainer)tofill, (String)"optionsForm");
        UIBoundBoolean.make((UIContainer)optionsForm, (String)"sendMeACopy", (String)"configBean.config.sendMeACopy");
        if (this.externalLogic.isEmailArchiveAddedToSite()) {
            UIOutput.make((UIContainer)optionsForm, (String)"addToArchiveDiv");
            UIBoundBoolean.make((UIContainer)optionsForm, (String)"addToArchive", (String)"configBean.config.addToArchive");
        }
        String[] options = new String[]{ConfigEntry.ReplyTo.sender.toString(), ConfigEntry.ReplyTo.no_reply_to.toString()};
        String[] labels = new String[]{"options_replylabel1", "options_replylabel2"};
        UISelect replyToSelect = UISelect.make((UIContainer)optionsForm, (String)"replyToSelect", (String[])options, (String[])labels, (String)"configBean.config.replyTo").setMessageKeys();
        String replyToFullId = replyToSelect.getFullID();
        UISelectChoice.make((UIContainer)optionsForm, (String)"replyToSender", (String)replyToFullId, (int)0);
        UISelectLabel.make((UIContainer)optionsForm, (String)"replyToSenderLabel", (String)replyToFullId, (int)0);
        UISelectChoice.make((UIContainer)optionsForm, (String)"replyToNone", (String)replyToFullId, (int)1);
        UISelectLabel.make((UIContainer)optionsForm, (String)"replyToNoneLabel", (String)replyToFullId, (int)1);
        options = new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()};
        labels = new String[]{"options_displayinvalidemails_yes", "options_displayinvalidemails_no"};
        UISelect invalidEmailsSelect = UISelect.make((UIContainer)optionsForm, (String)"invalidEmailsSelect", (String[])options, (String[])labels, (String)"configBean.config.displayInvalidEmails").setMessageKeys();
        String invalidEmailsFullId = invalidEmailsSelect.getFullID();
        UISelectChoice.make((UIContainer)optionsForm, (String)"invalidEmailsYes", (String)invalidEmailsFullId, (int)0);
        UISelectLabel.make((UIContainer)optionsForm, (String)"invalidEmailsYesLabel", (String)invalidEmailsFullId, (int)0);
        UISelectChoice.make((UIContainer)optionsForm, (String)"invalidEmailsNo", (String)invalidEmailsFullId, (int)1);
        UISelectLabel.make((UIContainer)optionsForm, (String)"invalidEmailsNoLabel", (String)invalidEmailsFullId, (int)1);
        options = new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()};
        labels = new String[]{"options_displayemptygroups_yes", "options_displayemptygroups_no"};
        UISelect emptyGroupsSelect = UISelect.make((UIContainer)optionsForm, (String)"emptyGroupsSelect", (String[])options, (String[])labels, (String)"configBean.config.displayEmptyGroups").setMessageKeys();
        String emptyGroupsFullId = emptyGroupsSelect.getFullID();
        UISelectChoice.make((UIContainer)optionsForm, (String)"emptyGroupsYes", (String)emptyGroupsFullId, (int)0);
        UISelectLabel.make((UIContainer)optionsForm, (String)"emptyGroupsYesLabel", (String)emptyGroupsFullId, (int)0);
        UISelectChoice.make((UIContainer)optionsForm, (String)"emptyGroupsNo", (String)emptyGroupsFullId, (int)1);
        UISelectLabel.make((UIContainer)optionsForm, (String)"emptyGroupsNoLabel", (String)emptyGroupsFullId, (int)1);
        if (this.configLogic.allowSubjectPrefixChange()) {
            UIOutput.make((UIContainer)optionsForm, (String)"subjectPrefixDiv");
            options = new String[]{ConfigEntry.SubjectPrefixType.system.toString(), ConfigEntry.SubjectPrefixType.custom.toString()};
            labels = new String[]{this.messageLocator.getMessage("options_prefixsystemdefault", (Object)this.configLogic.getDefaultSubjectPrefix()), this.messageLocator.getMessage("options_prefixcustom")};
            UISelect subjectPrefixSelect = UISelect.make((UIContainer)optionsForm, (String)"subjectPrefixSelect", (String[])options, (String[])labels, (String)"configBean.config.subjectPrefixType");
            String subjectPrefixFullId = subjectPrefixSelect.getFullID();
            UISelectChoice.make((UIContainer)optionsForm, (String)"subjectPrefixDefault", (String)subjectPrefixFullId, (int)0);
            UISelectLabel.make((UIContainer)optionsForm, (String)"subjectPrefixDefaultLabel", (String)subjectPrefixFullId, (int)0);
            UISelectChoice.make((UIContainer)optionsForm, (String)"subjectPrefixCustom", (String)subjectPrefixFullId, (int)1);
            UISelectLabel.make((UIContainer)optionsForm, (String)"subjectPrefixCustomLabel", (String)subjectPrefixFullId, (int)1);
            UIOutput customPrefix = UIOutput.make((UIContainer)optionsForm, (String)"customPrefixDiv");
            UIInput.make((UIContainer)optionsForm, (String)"subjectPrefix", (String)"configBean.config.subjectPrefix");
            if (ConfigEntry.SubjectPrefixType.system.name().equals(this.configLogic.getConfig().getSubjectPrefixType())) {
                customPrefix.decorate((UIDecorator)new UIStyleDecorator("followUp"));
            }
        }
        UICommand.make((UIContainer)optionsForm, (String)"update-button", (UIBoundString)UIMessage.make((String)"options_update_button"), (String)"configBean.saveConfig");
        UICommand.make((UIContainer)optionsForm, (String)"cancel-button", (UIBoundString)UIMessage.make((String)"options_cancel_button"));
    }

    public List<NavigationCase> reportNavigationCases() {
        ArrayList<NavigationCase> cases = new ArrayList<NavigationCase>();
        cases.add(new NavigationCase((AnyViewParameters)new SimpleViewParameters("compose")));
        cases.add(new NavigationCase("configSaveFail", (AnyViewParameters)new SimpleViewParameters(VIEW_ID)));
        return cases;
    }
}

