/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.mock.domain;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.sakaiproject.authz.api.Member;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.authz.api.RoleAlreadyDefinedException;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.user.api.User;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthzGroup
implements org.sakaiproject.authz.api.AuthzGroup {
    private static final long serialVersionUID = 1L;
    String id;
    String description;
    String providerGroupId;
    String maintainRole;
    User createdBy;
    User modifiedBy;
    Time createdTime;
    Time modifiedTime;
    Map<String, Member> members = new HashMap<String, Member>();
    Map<String, Role> roles = new HashMap<String, Role>();
    Map<String, Set<String>> rolesIsAllowed = new HashMap<String, Set<String>>();
    String reference;
    ResourcePropertiesEdit propertiesEdit;
    ResourceProperties properties;

    public void addMember(String userId, String roleId, boolean active, boolean provided) {
    }

    public Role addRole(String id) throws RoleAlreadyDefinedException {
        return null;
    }

    public Role addRole(String id, Role other) throws RoleAlreadyDefinedException {
        return null;
    }

    public Member getMember(String userId) {
        return this.members.get(userId);
    }

    public Set getMembers() {
        HashSet<Member> mbrs = new HashSet<Member>();
        Set<Map.Entry<String, Member>> entries = this.members.entrySet();
        Iterator<Map.Entry<String, Member>> iter = entries.iterator();
        while (iter.hasNext()) {
            mbrs.add(iter.next().getValue());
        }
        return mbrs;
    }

    public Role getRole(String id) {
        return this.roles.get(id);
    }

    public Set getRoles() {
        HashSet<Role> rls = new HashSet<Role>();
        Set<Map.Entry<String, Role>> entries = this.roles.entrySet();
        Iterator<Map.Entry<String, Role>> iter = entries.iterator();
        while (iter.hasNext()) {
            rls.add(iter.next().getValue());
        }
        return rls;
    }

    public Set getRolesIsAllowed(String function) {
        return this.rolesIsAllowed.get(function);
    }

    public Role getUserRole(String userId) {
        Set<Map.Entry<String, Member>> entries = this.members.entrySet();
        Iterator<Map.Entry<String, Member>> iter = entries.iterator();
        while (iter.hasNext()) {
            Member mbr = iter.next().getValue();
            if (!userId.equals(mbr.getUserId())) continue;
            return mbr.getRole();
        }
        return null;
    }

    public Set getUsers() {
        Set<Map.Entry<String, Member>> entries = this.members.entrySet();
        HashSet<String> userIds = new HashSet<String>();
        Iterator<Map.Entry<String, Member>> iter = entries.iterator();
        while (iter.hasNext()) {
            userIds.add(iter.next().getValue().getUserId());
        }
        return userIds;
    }

    public Set getUsersHasRole(String role) {
        Set<Map.Entry<String, Member>> entries = this.members.entrySet();
        HashSet<String> userIds = new HashSet<String>();
        Iterator<Map.Entry<String, Member>> iter = entries.iterator();
        while (iter.hasNext()) {
            Member member = iter.next().getValue();
            if (!member.getRole().toString().equals(role)) continue;
            userIds.add(member.getUserId());
        }
        return userIds;
    }

    public Set getUsersIsAllowed(String function) {
        Set<Map.Entry<String, Member>> entries = this.members.entrySet();
        HashSet<String> userIds = new HashSet<String>();
        Iterator<Map.Entry<String, Member>> iter = entries.iterator();
        while (iter.hasNext()) {
            Member member = iter.next().getValue();
            if (!this.rolesIsAllowed.containsKey(member.getRole().getId())) continue;
            userIds.add(member.getUserId());
        }
        return userIds;
    }

    public boolean hasRole(String userId, String role) {
        Member member = this.members.get(userId);
        if (member != null) {
            return member.getRole().getId().equals(role);
        }
        return false;
    }

    public boolean isAllowed(String userId, String function) {
        Member member = this.members.get(userId);
        Set<String> functions = this.rolesIsAllowed.get(member.getRole().getId());
        return functions != null && functions.contains(function);
    }

    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    public boolean keepIntersection(org.sakaiproject.authz.api.AuthzGroup other) {
        return false;
    }

    public void removeMember(String userId) {
        this.members.remove(userId);
    }

    public void removeMembers() {
        this.members.clear();
    }

    public void removeRole(String role) {
        this.roles.remove(role);
    }

    public void removeRoles() {
        this.roles.clear();
    }

    public boolean isActiveEdit() {
        return false;
    }

    public String getReference(String rootProperty) {
        return this.reference;
    }

    public String getUrl() {
        return null;
    }

    public String getUrl(String rootProperty) {
        return null;
    }

    public Element toXml(Document doc, Stack stack) {
        return null;
    }

    public int compareTo(Object o) {
        return 0;
    }

    public User getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public Time getCreatedTime() {
        return this.createdTime;
    }

    public Date getCreatedDate() {
        return new Date(this.createdTime.getTime());
    }

    public void setCreatedTime(Time createdTime) {
        this.createdTime = createdTime;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getMaintainRole() {
        return this.maintainRole;
    }

    public void setMaintainRole(String maintainRole) {
        this.maintainRole = maintainRole;
    }

    public User getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(User modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Time getModifiedTime() {
        return this.modifiedTime;
    }

    public Date getModifiedDate() {
        return new Date(this.modifiedTime.getTime());
    }

    public void setModifiedTime(Time modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    public ResourceProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ResourceProperties properties) {
        this.properties = properties;
    }

    public ResourcePropertiesEdit getPropertiesEdit() {
        return this.propertiesEdit;
    }

    public void setPropertiesEdit(ResourcePropertiesEdit propertiesEdit) {
        this.propertiesEdit = propertiesEdit;
    }

    public String getProviderGroupId() {
        return this.providerGroupId;
    }

    public void setProviderGroupId(String providerGroupId) {
        this.providerGroupId = providerGroupId;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Map<String, Set<String>> getRolesIsAllowed() {
        return this.rolesIsAllowed;
    }

    public void setRolesIsAllowed(Map<String, Set<String>> rolesIsAllowed) {
        this.rolesIsAllowed = rolesIsAllowed;
    }

    public void setMembers(Map<String, Member> members) {
        this.members = members;
    }

    public void setRoles(Map<String, Role> roles) {
        this.roles = roles;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

