/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.mock.domain;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sakaiproject.authz.api.Member;
import org.sakaiproject.mock.domain.AuthzGroup;
import org.sakaiproject.mock.domain.Group;
import org.sakaiproject.mock.domain.Page;
import org.sakaiproject.mock.domain.ToolConfiguration;
import org.sakaiproject.site.api.SitePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Site
extends AuthzGroup
implements org.sakaiproject.site.api.Site {
    private static final long serialVersionUID = 1L;
    List<Group> groups;
    List<Page> pages;
    List<ToolConfiguration> tools;
    String title;
    String type;
    String skin;
    String shortDescription;
    String infoUrl;
    String iconUrl;
    String joinerRole;
    boolean pubView;
    boolean joinable;
    boolean published;

    public Site() {
    }

    public Site(String id, String type) {
        this.id = id;
        this.type = type;
    }

    public org.sakaiproject.site.api.Group addGroup() {
        Group group = new Group(this);
        this.groups.add(group);
        return group;
    }

    public Page addPage() {
        Page page = new Page(this);
        this.pages.add(page);
        return page;
    }

    public org.sakaiproject.site.api.Group getGroup(String id) {
        for (org.sakaiproject.site.api.Group group : this.groups) {
            if (!group.getId().equals(id)) continue;
            return group;
        }
        return null;
    }

    public Collection getGroups() {
        return this.groups;
    }

    public Collection getGroupsWithMember(String userId) {
        HashSet<Group> groupsWithMember = new HashSet<Group>();
        for (Group group : this.groups) {
            if (group.members.get(userId) == null) continue;
            groupsWithMember.add(group);
        }
        return groupsWithMember;
    }

    public Collection getGroupsWithMemberHasRole(String userId, String role) {
        HashSet<Group> groupsWithMember = new HashSet<Group>();
        for (Group group : this.groups) {
            Member member = (Member)group.members.get(userId);
            if (member == null || !member.getRole().getId().equals(role)) continue;
            groupsWithMember.add(group);
        }
        return groupsWithMember;
    }

    public Collection<String> getMembersInGroups(Set<String> groupIds) {
        Collection siteGroups = this.getGroups();
        HashSet<String> membersInGroups = new HashSet<String>();
        for (org.sakaiproject.site.api.Group group : siteGroups) {
            if (groupIds != null && !groupIds.contains(group.getId())) continue;
            Set members = group.getMembers();
            for (Member member : members) {
                membersInGroups.add(member.getUserId());
            }
        }
        return membersInGroups;
    }

    public String getIconUrlFull() {
        return this.iconUrl;
    }

    public String getInfoUrlFull() {
        return this.infoUrl;
    }

    public List getOrderedPages() {
        return this.pages;
    }

    public SitePage getPage(String id) {
        for (Page page : this.pages) {
            if (!page.getId().equals(id)) continue;
            return page;
        }
        return null;
    }

    public List getPages() {
        return this.pages;
    }

    public org.sakaiproject.site.api.ToolConfiguration getTool(String id) {
        for (ToolConfiguration tc : this.tools) {
            if (!tc.getId().equals(id)) continue;
            return tc;
        }
        return null;
    }

    public org.sakaiproject.site.api.ToolConfiguration getToolForCommonId(String commonToolId) {
        return this.getTool(commonToolId);
    }

    public Collection getTools(String[] toolIds) {
        HashSet<String> toolSet = new HashSet<String>();
        for (ToolConfiguration tc : this.tools) {
            if (!tc.getId().equals(this.id)) continue;
            toolSet.add(this.id);
        }
        return toolSet;
    }

    public Collection getTools(String commonToolId) {
        return this.tools;
    }

    public boolean hasGroups() {
        return this.groups != null && this.groups.size() > 0;
    }

    public boolean isCustomPageOrdered() {
        return false;
    }

    public void setCustomPageOrdered(boolean custom) {
    }

    public boolean isType(Object type) {
        return type.equals(this.type);
    }

    public void loadAll() {
    }

    public void regenerateIds() {
    }

    public void removeGroup(org.sakaiproject.site.api.Group group) {
        this.groups.remove(group);
    }

    public void removePage(SitePage page) {
        this.pages.remove(page);
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getInfoUrl() {
        return this.infoUrl;
    }

    public void setInfoUrl(String infoUrl) {
        this.infoUrl = infoUrl;
    }

    public boolean isJoinable() {
        return this.joinable;
    }

    public void setJoinable(boolean joinable) {
        this.joinable = joinable;
    }

    public String getJoinerRole() {
        return this.joinerRole;
    }

    public void setJoinerRole(String joinerRole) {
        this.joinerRole = joinerRole;
    }

    public boolean isPublished() {
        return this.published;
    }

    public void setPublished(boolean published) {
        this.published = published;
    }

    public boolean isPubView() {
        return this.pubView;
    }

    public void setPubView(boolean pubView) {
        this.pubView = pubView;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getSkin() {
        return this.skin;
    }

    public void setSkin(String skin) {
        this.skin = skin;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<ToolConfiguration> getTools() {
        return this.tools;
    }

    public void setTools(List<ToolConfiguration> tools) {
        this.tools = tools;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    public void setPages(List<Page> pages) {
        this.pages = pages;
    }

    public Date getSoftlyDeletedDate() {
        return null;
    }

    public boolean isSoftlyDeleted() {
        return false;
    }

    public void setSoftlyDeleted(boolean arg0) {
    }
}

