/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.mock.domain;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Role
implements org.sakaiproject.authz.api.Role {
    private static final long serialVersionUID = 1L;
    String id;
    String description;
    Set<String> locks = new HashSet<String>();

    public Role() {
    }

    public Role(String id) {
        this();
        this.id = id;
    }

    public void allowFunction(String lock) {
        this.locks.add(lock);
    }

    public void allowFunctions(Collection functions) {
        this.locks.addAll(functions);
    }

    public boolean allowsNoFunctions() {
        return this.locks.isEmpty();
    }

    public void disallowAll() {
        this.locks.clear();
    }

    public void disallowFunction(String lock) {
        this.locks.remove(lock);
    }

    public void disallowFunctions(Collection functions) {
        this.locks.removeAll(functions);
    }

    public Set getAllowedFunctions() {
        return this.locks;
    }

    public boolean isAllowed(String function) {
        return this.locks.contains(function);
    }

    public boolean isProviderOnly() {
        return false;
    }

    public void setProviderOnly(boolean providerOnly) {
    }

    public int compareTo(Object o) {
        return this.id.compareTo((String)o);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Set<String> getLocks() {
        return this.locks;
    }

    public void setLocks(Set<String> locks) {
        this.locks = locks;
    }
}

