/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.api.app.messageforums;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.ColumnDefault;
import org.sakaiproject.api.app.messageforums.MembershipItem;

@Entity
@Table(name="MFR_DRAFT_RECIPIENT_T", indexes={@Index(name="MFR_DRAFT_REC_MSG_ID_I", columnList="DRAFT_ID")})
@NamedQuery(name="findDraftRecipientsByMessageId", query="from DraftRecipient d where d.draftId = :id")
public class DraftRecipient {
    public static final String ALL_PARTICIPANTS_ID = "all_participants";
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="draft_recipient_sequence")
    @SequenceGenerator(name="draft_recipient_sequence", sequenceName="MFR_DRAFT_RECIPIENT_S")
    private Long id;
    @Column(name="TYPE", nullable=false)
    private int type = 0;
    @Column(name="RECIPIENT_ID", nullable=false)
    private String recipientId = "";
    @Column(name="DRAFT_ID", nullable=false)
    private long draftId = -1L;
    @Column(name="BCC", nullable=false)
    @ColumnDefault(value="0")
    private boolean bcc = false;

    public static DraftRecipient from(MembershipItem item, long draftMsgId, boolean bcc) {
        int type;
        DraftRecipient dr = new DraftRecipient();
        dr.draftId = draftMsgId;
        dr.bcc = bcc;
        dr.type = type = item.getType();
        switch (type) {
            case 1: {
                dr.recipientId = ALL_PARTICIPANTS_ID;
                break;
            }
            case 2: {
                if (item.getRole() == null) break;
                dr.recipientId = item.getRole().getId();
                break;
            }
            case 3: 
            case 5: {
                if (item.getGroup() == null) break;
                dr.recipientId = item.getGroup().getId();
                break;
            }
            case 4: 
            case 7: {
                if (item.getUser() == null) break;
                dr.recipientId = item.getUser().getId();
                break;
            }
            case 6: {
                if (item.getGroup() == null || item.getRole() == null) break;
                dr.recipientId = item.getGroup().getId() + "+++" + item.getRole().getId();
            }
        }
        if (dr.recipientId.isEmpty()) {
            dr.type = 0;
        }
        return dr;
    }

    public Long getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public String getRecipientId() {
        return this.recipientId;
    }

    public long getDraftId() {
        return this.draftId;
    }

    public boolean isBcc() {
        return this.bcc;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setRecipientId(String recipientId) {
        this.recipientId = recipientId;
    }

    public void setDraftId(long draftId) {
        this.draftId = draftId;
    }

    public void setBcc(boolean bcc) {
        this.bcc = bcc;
    }
}

