/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.api.app.messageforums;

import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.UUID;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.user.api.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MembershipItem
implements Comparable<MembershipItem> {
    private static final Logger log = LoggerFactory.getLogger(MembershipItem.class);
    public static final int TYPE_NOT_SPECIFIED = 0;
    public static final int TYPE_ALL_PARTICIPANTS = 1;
    public static final int TYPE_ROLE = 2;
    public static final int TYPE_GROUP = 3;
    public static final int TYPE_USER = 4;
    public static final int TYPE_MYGROUPS = 5;
    public static final int TYPE_MYGROUPROLES = 6;
    public static final int TYPE_MYGROUPMEMBERS = 7;
    private static Collator collator = Collator.getInstance();
    public static final Comparator<MembershipItem> compareByType;
    public static final Comparator<MembershipItem> compareByName;
    private String id;
    private Group group;
    private String name;
    private Role role;
    private int type = 0;
    private User user;
    private boolean viewable = false;

    private MembershipItem() {
    }

    public static MembershipItem makeMembershipItem(String name, int type) {
        return MembershipItem.makeMembershipItem(name, type, null, null, null);
    }

    public static MembershipItem makeMembershipItem(String name, int type, Group group, Role role, User user) {
        return MembershipItem.makeMembershipItem(name, type, group, role, user, false);
    }

    public static MembershipItem makeMembershipItem(String name, int type, Group group, Role role, User user, boolean viewable) {
        MembershipItem item = new MembershipItem();
        item.id = UUID.randomUUID().toString();
        item.name = name;
        item.type = type >= 0 && type <= 7 ? type : 0;
        item.group = group;
        item.role = role;
        item.user = user;
        item.viewable = viewable;
        return item;
    }

    @Override
    public int compareTo(MembershipItem item) {
        return compareByType.thenComparing(compareByName).compare(this, item);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MembershipItem)) {
            return false;
        }
        MembershipItem other = (MembershipItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MembershipItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public String getId() {
        return this.id;
    }

    public Group getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public Role getRole() {
        return this.role;
    }

    public int getType() {
        return this.type;
    }

    public User getUser() {
        return this.user;
    }

    public boolean isViewable() {
        return this.viewable;
    }

    public void setViewable(boolean viewable) {
        this.viewable = viewable;
    }

    static {
        try {
            collator = new RuleBasedCollator(((RuleBasedCollator)Collator.getInstance()).getRules().replaceAll("<'_'", "<' '<'_'"));
        }
        catch (ParseException e) {
            log.error("Unable to create RuleBasedCollator", (Throwable)e);
        }
        compareByType = Comparator.comparingInt(MembershipItem::getType);
        compareByName = (o1, o2) -> collator.compare(o1.getName(), o2.getName());
    }
}

