/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.onedrive.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.sakaiproject.onedrive.model.OneDriveFile;
import org.sakaiproject.onedrive.model.OneDriveFolder;
import org.sakaiproject.onedrive.model.OneDriveParent;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OneDriveItem {
    @JsonProperty(value="id")
    private String oneDriveItemId;
    private String name;
    private Long size;
    @JsonProperty(value="@microsoft.graph.downloadUrl")
    private String downloadUrl;
    private OneDriveFolder folder;
    private OneDriveFile file;
    @JsonProperty(value="parentReference")
    private OneDriveParent parent;
    private int depth = 0;
    private boolean expanded = false;

    public boolean isFolder() {
        return this.folder != null;
    }

    public boolean hasChildren() {
        return this.isFolder() && this.folder.childCount != 0;
    }

    public boolean equals(Object obj) {
        boolean retVal = false;
        if (obj instanceof OneDriveItem) {
            OneDriveItem ptr = (OneDriveItem)obj;
            return this.oneDriveItemId.equals(ptr.getOneDriveItemId());
        }
        return retVal;
    }

    public String getOneDriveItemId() {
        return this.oneDriveItemId;
    }

    public String getName() {
        return this.name;
    }

    public Long getSize() {
        return this.size;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public OneDriveFolder getFolder() {
        return this.folder;
    }

    public OneDriveFile getFile() {
        return this.file;
    }

    public OneDriveParent getParent() {
        return this.parent;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    @JsonProperty(value="id")
    public void setOneDriveItemId(String oneDriveItemId) {
        this.oneDriveItemId = oneDriveItemId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    @JsonProperty(value="@microsoft.graph.downloadUrl")
    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public void setFolder(OneDriveFolder folder) {
        this.folder = folder;
    }

    public void setFile(OneDriveFile file) {
        this.file = file;
    }

    @JsonProperty(value="parentReference")
    public void setParent(OneDriveParent parent) {
        this.parent = parent;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public String toString() {
        return "OneDriveItem(oneDriveItemId=" + this.getOneDriveItemId() + ", name=" + this.getName() + ", size=" + this.getSize() + ", downloadUrl=" + this.getDownloadUrl() + ", folder=" + this.getFolder() + ", file=" + this.getFile() + ", parent=" + this.getParent() + ", depth=" + this.getDepth() + ", expanded=" + this.isExpanded() + ")";
    }
}

