/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.pasystem.api;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Errors {
    private final List<Error> errors = new ArrayList<Error>();

    public void addError(String field, String code) {
        this.errors.add(new Error(field, code));
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public Errors merge(Errors other) {
        this.errors.addAll(other.toList());
        return this;
    }

    public List<Error> toList() {
        return new ArrayList<Error>(this.errors);
    }

    public Map<String, String> toMap() {
        return this.errors.stream().collect(Collectors.toMap(Error::getField, Error::getErrorCode));
    }

    static final class Error {
        private final String field;
        private final String errorCode;

        @ConstructorProperties(value={"field", "errorCode"})
        public Error(String field, String errorCode) {
            this.field = field;
            this.errorCode = errorCode;
        }

        public String getField() {
            return this.field;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Error)) {
                return false;
            }
            Error other = (Error)o;
            String this$field = this.getField();
            String other$field = other.getField();
            if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
                return false;
            }
            String this$errorCode = this.getErrorCode();
            String other$errorCode = other.getErrorCode();
            return !(this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $field = this.getField();
            result = result * 59 + ($field == null ? 43 : $field.hashCode());
            String $errorCode = this.getErrorCode();
            result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
            return result;
        }

        public String toString() {
            return "Errors.Error(field=" + this.getField() + ", errorCode=" + this.getErrorCode() + ")";
        }
    }
}

