/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.pasystem.api;

import org.sakaiproject.pasystem.api.Errors;
import org.sakaiproject.pasystem.api.MissingUuidException;
import org.sakaiproject.pasystem.api.PASystemException;
import org.sakaiproject.pasystem.api.ValidationHelper;

public class Popup {
    private final String uuid;
    private String descriptor;
    private long startTime;
    private long endTime;
    private boolean isOpenCampaign;
    private String template;

    private Popup() {
        this.uuid = null;
    }

    private Popup(String uuid, String descriptor, long startTime, long endTime, boolean isOpenCampaign, String template) {
        this.uuid = uuid;
        this.descriptor = descriptor;
        this.startTime = startTime;
        this.endTime = endTime;
        this.template = template;
        this.isOpenCampaign = isOpenCampaign;
    }

    public static Popup createNullPopup() {
        return new Popup();
    }

    public static Popup create(String descriptor, long startTime, long endTime, boolean isOpenCampaign) {
        return Popup.create(null, descriptor, startTime, endTime, isOpenCampaign);
    }

    public static Popup create(String uuid, String descriptor, long startTime, long endTime, boolean isOpenCampaign) {
        return Popup.create(uuid, descriptor, startTime, endTime, isOpenCampaign, null);
    }

    public static Popup create(String uuid, String descriptor, long startTime, long endTime, boolean isOpenCampaign, String template) {
        return new Popup(uuid, descriptor, startTime, endTime, isOpenCampaign, template);
    }

    public String getUuid() throws MissingUuidException {
        if (this.uuid == null) {
            throw new MissingUuidException("No UUID has been set for this popup");
        }
        return this.uuid;
    }

    public boolean isActiveNow() {
        long now = System.currentTimeMillis();
        return this.uuid != null && this.startTime <= now && (this.endTime == 0L || now <= this.endTime);
    }

    public String getTemplate() {
        if (this.template == null) {
            throw new PASystemException("Template not loaded for Popup instance");
        }
        return this.template;
    }

    public Errors validate() {
        Errors errors = new Errors();
        if (!ValidationHelper.startTimeBeforeEndTime(this.startTime, this.endTime)) {
            errors.addError("start_time", "start_time_after_end_time");
            errors.addError("end_time", "start_time_after_end_time");
        }
        return errors;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public boolean isOpenCampaign() {
        return this.isOpenCampaign;
    }
}

