/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.pasystem.api;

import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import org.sakaiproject.pasystem.api.AcknowledgementType;
import org.sakaiproject.pasystem.api.Errors;
import org.sakaiproject.pasystem.api.MissingUuidException;
import org.sakaiproject.pasystem.api.ValidationHelper;

public class Banner
implements Comparable<Banner> {
    private final String uuid;
    private final String message;
    private final long startTime;
    private final long endTime;
    private final String hosts;
    private final BannerType type;
    private final boolean isActive;
    private final boolean isDismissed;

    public Banner(String message, String hosts, boolean active, long startTime, long endTime, String type) {
        this(null, message, hosts, active, startTime, endTime, type, false);
    }

    public Banner(String uuid, String message, String hosts, boolean active, long startTime, long endTime, String type) {
        this(uuid, message, hosts, active, startTime, endTime, type, false);
    }

    public Banner(String uuid, String message, String hosts, boolean active, long startTime, long endTime, String type, boolean isDismissed) {
        this.uuid = uuid;
        this.message = message;
        this.hosts = hosts;
        this.isActive = active;
        this.startTime = startTime;
        this.endTime = endTime;
        this.type = BannerType.valueOf(type.toUpperCase(Locale.ROOT));
        this.isDismissed = isDismissed;
    }

    public String getType() {
        return this.type.toString().toLowerCase(Locale.ROOT);
    }

    public AcknowledgementType calculateAcknowledgementType() {
        if (this.type.equals((Object)BannerType.MEDIUM)) {
            return AcknowledgementType.TEMPORARY;
        }
        return AcknowledgementType.PERMANENT;
    }

    @Override
    public int compareTo(Banner other) {
        return this.getSeverityScore() - other.getSeverityScore();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Banner)) {
            return false;
        }
        try {
            return this.uuid.equals(((Banner)obj).getUuid());
        }
        catch (MissingUuidException e) {
            return false;
        }
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public int getSeverityScore() {
        return this.type.ordinal();
    }

    public String getUuid() throws MissingUuidException {
        if (this.uuid == null) {
            throw new MissingUuidException("No UUID has been set for this banner");
        }
        return this.uuid;
    }

    public boolean isActiveNow() {
        if (!this.isActive()) {
            return false;
        }
        if (this.startTime == 0L && this.endTime == 0L) {
            return this.isActive();
        }
        Date now = new Date();
        return now.after(new Date(this.startTime)) && (this.endTime == 0L || now.before(new Date(this.endTime)));
    }

    public boolean isDismissible() {
        return !BannerType.HIGH.equals((Object)this.type);
    }

    public boolean isActiveForHost(String hostname) {
        if (!this.isActiveNow()) {
            return false;
        }
        if (this.hosts == null || this.hosts.isEmpty()) {
            return true;
        }
        return Arrays.asList(this.hosts.split(",")).contains(hostname);
    }

    public Errors validate() {
        Errors errors = new Errors();
        if (!ValidationHelper.startTimeBeforeEndTime(this.startTime, this.endTime)) {
            errors.addError("start_time", "start_time_after_end_time");
            errors.addError("end_time", "start_time_after_end_time");
        }
        return errors;
    }

    public String getMessage() {
        return this.message;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public String getHosts() {
        return this.hosts;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isDismissed() {
        return this.isDismissed;
    }

    static enum BannerType {
        HIGH,
        MEDIUM,
        LOW;

    }
}

